/*
 * Decompiled with CFR 0.152.
 */
package com.gams.api;

import com.gams.api.AbstractGAMSDatabase;
import com.gams.api.GAMSDatabaseDomainViolation;
import com.gams.api.GAMSDatabaseIterator;
import com.gams.api.GAMSEquation;
import com.gams.api.GAMSException;
import com.gams.api.GAMSGlobals;
import com.gams.api.GAMSParameter;
import com.gams.api.GAMSSet;
import com.gams.api.GAMSSymbol;
import com.gams.api.GAMSVariable;
import com.gams.api.GAMSWorkspace;
import com.gams.api.gmd;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GAMSDatabase
extends AbstractGAMSDatabase<GAMSSymbol<?>> {
    GAMSWorkspace dbWorkspace = null;
    private String dbName = null;
    private gmd dbGMD;
    private GAMSSet dbUniverse;
    boolean dbRecordLock = false;
    boolean dbSymbolLock = false;
    private boolean _disposed = false;
    private boolean _isAutoDomianCheckingSuppressed = false;

    GAMSDatabase(GAMSWorkspace gAMSWorkspace) {
        this(null, gAMSWorkspace, null);
    }

    GAMSDatabase(GAMSWorkspace gAMSWorkspace, String string) {
        int n;
        String string2;
        assert (gAMSWorkspace != null);
        gAMSWorkspace.debugMessage("--- Entering GAMSDatabase constructor ---", GAMSGlobals.DebugLevel.VERBOSE.value());
        if (string != null && (string2 = string.toLowerCase()).endsWith(".gdx") && (n = string.lastIndexOf(46)) >= 0) {
            string = string.substring(0, n);
        }
        this.initializeAttributes(string, gAMSWorkspace, false, false);
    }

    GAMSDatabase(String string, GAMSWorkspace gAMSWorkspace) {
        this(string, gAMSWorkspace, null);
    }

    GAMSDatabase(String string, GAMSWorkspace gAMSWorkspace, String string2) {
        this(string, gAMSWorkspace, string2, false);
    }

    GAMSDatabase(String string, GAMSWorkspace gAMSWorkspace, String string2, boolean bl) {
        this.initializeAttributes(string2, gAMSWorkspace, false, bl);
        if (string != null) {
            File file = new File(string);
            if (file.getParent() == null) {
                file = new File(this.dbWorkspace.workingDirectory(), string);
            }
            this.checkForGMDError(this.dbGMD.InitFromGDX(file.getAbsolutePath()));
        }
    }

    GAMSDatabase(GAMSWorkspace gAMSWorkspace, GAMSDatabase gAMSDatabase) {
        this(gAMSWorkspace, gAMSDatabase, null);
    }

    GAMSDatabase(GAMSWorkspace gAMSWorkspace, GAMSDatabase gAMSDatabase, String string) {
        this(gAMSWorkspace, string);
        if (gAMSDatabase._disposed) {
            throw new GAMSException("Source Database instance [" + gAMSDatabase.dbName + "] has already been disposed, resources are no longer available");
        }
        this.checkForGMDError(this.dbGMD.InitFromDB(gAMSDatabase.dbGMD.GetgmdPtr()));
    }

    private void initializeAttributes(String string, GAMSWorkspace gAMSWorkspace, boolean bl, boolean bl2) {
        this.dbWorkspace = gAMSWorkspace;
        this.dbName = this.dbWorkspace.verifyDatabaseName(string, bl2);
        this.dbGMD = this.createGMDObject(this.dbWorkspace.systemDirectory());
        this.dbRecordLock = false;
        this.dbSymbolLock = false;
        this._disposed = bl;
        this.dbUniverse = this.getSet("*");
        if (this.dbWorkspace.getDebugLevel().equals(GAMSGlobals.DebugLevel.VERBOSE)) {
            this.checkForGMDError(this.dbGMD.SetDebug(10));
        }
    }

    private gmd createGMDObject(String string) {
        gmd gmd2 = new gmd();
        String[] stringArray = new String[]{GAMSGlobals.EMPTY_STRING};
        if (gmd2.CreateD(string, stringArray) != 1) {
            throw new GAMSException("Could not load gmd library from [" + string + "]:" + stringArray[0]);
        }
        this.checkForGMDError(gmd2.SetSpecialValues(GAMSGlobals.SpecialValues.doubleValues()));
        return gmd2;
    }

    gmd GMD() {
        if (this._disposed) {
            throw new GAMSException("GAMSDatabase instance [" + this.dbName + "] has already been disposed, resources are no longer available");
        }
        return this.dbGMD;
    }

    void checkForGMDError(boolean bl) {
        if (!bl) {
            String[] stringArray = new String[]{GAMSGlobals.EMPTY_STRING};
            this.GMD().GetLastError(stringArray);
            throw new GAMSException(stringArray[0]);
        }
    }

    public String getName() {
        return this.dbName;
    }

    public void export() {
        this.export(this.dbName);
    }

    public void export(String string) {
        if (this._disposed) {
            throw new GAMSException("Trying to export GAMSDatabase instance [" + this.dbName + "], but the database has already been disposed, resources are no longer available");
        }
        if (!this._isAutoDomianCheckingSuppressed && !this.checkDomains()) {
            throw new GAMSException("Trying to export GAMSDatabase instance [" + this.dbName + "], but it contains a domain violaton");
        }
        if (string == null) {
            this.checkForGMDError(this.dbGMD.WriteGDX(this.dbWorkspace.workingDirectory() + GAMSGlobals.FILE_SEPARATOR + this.dbName + ".gdx", this._isAutoDomianCheckingSuppressed));
        } else {
            File file;
            if (!string.endsWith(".gdx")) {
                string = string + ".gdx";
            }
            if ((file = new File(string)).getParent() == null) {
                file = new File(this.dbWorkspace.workingDirectory(), string);
            }
            this.checkForGMDError(this.dbGMD.WriteGDX(file.getAbsolutePath(), this._isAutoDomianCheckingSuppressed));
        }
    }

    public GAMSEquation addEquation(String string, int n, GAMSGlobals.EquType equType) {
        return this.addEquation(string, n, equType, GAMSGlobals.EMPTY_STRING);
    }

    public GAMSEquation addEquation(String string, int n, GAMSGlobals.EquType equType, String string2) {
        if (this._disposed) {
            throw new GAMSException("GAMSDatabase instance [" + this.dbName + "] has already been disposed, resources are no longer available");
        }
        if (this.dbSymbolLock) {
            throw new GAMSException("Could not add equation symbol to symbol-locked database [" + this.dbName + "]");
        }
        return new GAMSEquation(this, string, n, equType, string2, new Object[0]);
    }

    public GAMSEquation addEquation(String string, GAMSGlobals.EquType equType, String string2, Object ... objectArray) {
        if (this._disposed) {
            throw new GAMSException("GAMSDatabase instance [" + this.dbName + "] has already been disposed, resources are no longer available");
        }
        if (this.dbSymbolLock) {
            throw new GAMSException("Could not add equation symbol to symbol-locked database [" + this.dbName + "]");
        }
        return new GAMSEquation(this, string, objectArray == null ? 0 : objectArray.length, equType, string2, objectArray);
    }

    public GAMSSet addSet(String string, int n) {
        return this.addSet(string, n, GAMSGlobals.EMPTY_STRING);
    }

    public GAMSSet addSet(String string, int n, String string2) {
        if (this._disposed) {
            throw new GAMSException("GAMSDatabase instance [" + this.dbName + "] has already been disposed, resources are no longer available");
        }
        if (this.dbSymbolLock) {
            throw new GAMSException("Could not add set symbol to symbol-locked database [" + this.dbName + "]");
        }
        return new GAMSSet(this, string, n, string2, new Object[0]);
    }

    public GAMSSet addSet(String string, String string2, Object ... objectArray) {
        if (this._disposed) {
            throw new GAMSException("GAMSDatabase instance [" + this.dbName + "] has already been disposed, resources are no longer available");
        }
        if (this.dbSymbolLock) {
            throw new GAMSException("Could not add set symbol to symbol-locked database [" + this.dbName + "]");
        }
        if (objectArray == null || objectArray.length == 0) {
            return new GAMSSet(this, string, 1, string2, this.dbUniverse);
        }
        return new GAMSSet(this, string, objectArray.length, string2, objectArray);
    }

    public GAMSParameter addParameter(String string, int n) {
        return this.addParameter(string, n, GAMSGlobals.EMPTY_STRING);
    }

    public GAMSParameter addParameter(String string, int n, String string2) {
        if (this._disposed) {
            throw new GAMSException("GAMSDatabase instance [" + this.dbName + "] has already been disposed, resources are no longer available");
        }
        if (this.dbSymbolLock) {
            throw new GAMSException("Could not add parameter symbol to symbol-locked database [" + this.dbName + "]");
        }
        return new GAMSParameter(this, string, n, string2, new Object[0]);
    }

    public GAMSParameter addParameter(String string, String string2, Object ... objectArray) {
        if (this._disposed) {
            throw new GAMSException("GAMSDatabase instance [" + this.dbName + "] has already been disposed, resources are no longer available");
        }
        if (this.dbSymbolLock) {
            throw new GAMSException("Could not add parameter symbol to symbol-locked database [" + this.dbName + "]");
        }
        return new GAMSParameter(this, string, objectArray == null ? 0 : objectArray.length, string2, objectArray);
    }

    public GAMSVariable addVariable(String string, int n, GAMSGlobals.VarType varType) {
        return this.addVariable(string, n, varType, GAMSGlobals.EMPTY_STRING);
    }

    public GAMSVariable addVariable(String string, int n, GAMSGlobals.VarType varType, String string2) {
        if (this._disposed) {
            throw new GAMSException("GAMSDatabase instance [" + this.dbName + "] has already been disposed, resources are no longer available");
        }
        if (this.dbSymbolLock) {
            throw new GAMSException("Could not add variable symbol to symbol-locked database [" + this.dbName + "]");
        }
        return new GAMSVariable(this, string, n, varType, string2, new Object[0]);
    }

    public GAMSVariable addVariable(String string, GAMSGlobals.VarType varType, String string2, Object ... objectArray) {
        if (this._disposed) {
            throw new GAMSException("GAMSDatabase instance [" + this.dbName + "] has already been disposed, resources are no longer available");
        }
        if (this.dbSymbolLock) {
            throw new GAMSException("Could not add variable symbol to symbol-locked database [" + this.dbName + "]");
        }
        return new GAMSVariable(this, string, objectArray == null ? 0 : objectArray.length, varType, string2, objectArray);
    }

    GAMSSet getUniverse() {
        return this.dbUniverse;
    }

    public GAMSSymbol<?> getSymbol(String string) {
        if (this._disposed) {
            throw new GAMSException("GAMSDatabase instance [" + this.dbName + "] has already been disposed, resources are no longer available");
        }
        if (string == null) {
            throw new GAMSException("Could not retrieve a symbol with NULL identifier");
        }
        long[] lArray = new long[]{0L};
        this.checkForGMDError(this.dbGMD.FindSymbol(string, lArray));
        if (lArray[0] == 0L) {
            throw new GAMSException("Could not retrieve symbol [" + string + "] from database [" + this.dbName + "]");
        }
        int[] nArray = new int[]{0};
        this.checkForGMDError(this.dbGMD.SymbolType(lArray[0], nArray));
        switch (GAMSGlobals.DataType.lookup(nArray[0])) {
            case EQU: {
                return this.getEquation(string);
            }
            case VAR: {
                return this.getVariable(string);
            }
            case PAR: {
                return this.getParameter(string);
            }
            case SET: {
                return this.getSet(string);
            }
            case ALIAS: {
                return this.getSet(string);
            }
        }
        throw new GAMSException("Unknown symbol type [" + nArray[0] + "] in database [" + this.dbName + "]");
    }

    public GAMSEquation getEquation(String string) {
        if (this._disposed) {
            throw new GAMSException("GAMSDatabase instance [" + this.dbName + "] has already been disposed, resources are no longer available");
        }
        if (string == null) {
            throw new GAMSException("Could not retrieve an equation with NULL identifier");
        }
        long[] lArray = new long[]{0L};
        this.checkForGMDError(this.dbGMD.FindSymbol(string, lArray));
        if (lArray[0] == 0L) {
            throw new GAMSException("Could not find equation [" + string + "] in database [" + this.dbName + "]");
        }
        int[] nArray = new int[]{0};
        this.checkForGMDError(this.dbGMD.SymbolType(lArray[0], nArray));
        if (GAMSGlobals.DataType.lookup(nArray[0]) != GAMSGlobals.DataType.EQU) {
            throw new GAMSException("GAMSDatabase: Symbol [" + string + "] is not an equation");
        }
        return new GAMSEquation(this, lArray[0]);
    }

    public GAMSParameter getParameter(String string) {
        if (this._disposed) {
            throw new GAMSException("GAMSDatabase instance [" + this.dbName + "] has already been disposed, resources are no longer available");
        }
        if (string == null) {
            throw new GAMSException("Could not retrieve a parameter with NULL identifier");
        }
        long[] lArray = new long[]{0L};
        this.checkForGMDError(this.dbGMD.FindSymbol(string, lArray));
        if (lArray[0] == 0L) {
            throw new GAMSException("Could not find parameter [" + string + "] in database [" + this.dbName + "]");
        }
        int[] nArray = new int[]{0};
        this.checkForGMDError(this.dbGMD.SymbolType(lArray[0], nArray));
        if (GAMSGlobals.DataType.lookup(nArray[0]) != GAMSGlobals.DataType.PAR) {
            throw new GAMSException("GAMSDatabase: Symbol [" + string + "] is not a parameter");
        }
        return new GAMSParameter(this, lArray[0]);
    }

    public GAMSSet getSet(String string) {
        if (this._disposed) {
            throw new GAMSException("GAMSDatabase instance [" + this.dbName + "] has already been disposed, resources are no longer available");
        }
        if (string == null) {
            throw new GAMSException("Could not retrieve a set with NULL identifier");
        }
        long[] lArray = new long[]{0L};
        this.checkForGMDError(this.dbGMD.FindSymbol(string, lArray));
        if (lArray[0] == 0L) {
            throw new GAMSException("Could not find set [" + string + "] in database [" + this.dbName + "]");
        }
        int[] nArray = new int[]{0};
        this.checkForGMDError(this.dbGMD.SymbolType(lArray[0], nArray));
        if (GAMSGlobals.DataType.lookup(nArray[0]) != GAMSGlobals.DataType.SET && GAMSGlobals.DataType.lookup(nArray[0]) != GAMSGlobals.DataType.ALIAS) {
            throw new GAMSException("GAMSDatabase: Symbol [" + string + "] is not a set");
        }
        return new GAMSSet(this, lArray[0]);
    }

    public GAMSVariable getVariable(String string) {
        if (this._disposed) {
            throw new GAMSException("GAMSDatabase instance [" + this.dbName + "] has already been disposed, resources are no longer available");
        }
        if (string == null) {
            throw new GAMSException("Could not retrieve a variable with NULL identifier");
        }
        long[] lArray = new long[]{0L};
        this.checkForGMDError(this.dbGMD.FindSymbol(string, lArray));
        if (lArray[0] == 0L) {
            throw new GAMSException("Coubld not find variable [" + string + "] in database [" + this.dbName + "]");
        }
        int[] nArray = new int[]{0};
        this.checkForGMDError(this.dbGMD.SymbolType(lArray[0], nArray));
        if (GAMSGlobals.DataType.lookup(nArray[0]) != GAMSGlobals.DataType.VAR) {
            throw new GAMSException("GAMSDatabase: Symbol [" + string + "] is not a variable");
        }
        return new GAMSVariable(this, lArray[0]);
    }

    public boolean isAutoDomainCheckingSuppressed() {
        return this._isAutoDomianCheckingSuppressed;
    }

    public void suppressAutoDomainChecking(boolean bl) {
        this._isAutoDomianCheckingSuppressed = bl;
    }

    public int getNumberOfSymbols() {
        if (this._disposed) {
            throw new GAMSException("GAMSDatabase instance [" + this.dbName + "] has already been disposed, resources are no longer available");
        }
        String[] stringArray = new String[]{GAMSGlobals.EMPTY_STRING};
        int[] nArray = new int[]{0};
        double[] dArray = new double[]{0.0};
        this.checkForGMDError(this.dbGMD.Info(0, nArray, dArray, stringArray));
        return nArray[0];
    }

    public void clear() {
        for (GAMSSymbol<?> gAMSSymbol : this) {
            if (gAMSSymbol.clear()) continue;
            throw new GAMSException("Could not clear a GAMSSymbol [" + this.getName() + "] in GAMSDatabase [" + this.dbName + "]");
        }
    }

    public boolean checkDomains() {
        boolean[] blArray = new boolean[]{false};
        this.checkForGMDError(this.GMD().CheckDBDV(blArray));
        return !blArray[0];
    }

    public List<GAMSDatabaseDomainViolation> getDatabaseDomainViolations(int n, int n2) {
        GAMSDatabaseDomainViolation gAMSDatabaseDomainViolation;
        ArrayList<GAMSDatabaseDomainViolation> arrayList = new ArrayList<GAMSDatabaseDomainViolation>();
        long[] lArray = new long[]{0L};
        boolean[] blArray = new boolean[]{false};
        this.checkForGMDError(this.GMD().GetFirstDBDV(lArray));
        if (lArray[0] != 0L) {
            blArray[0] = true;
        }
        int[] nArray = new int[]{0};
        for (int i = 0; blArray[0] && (n == 0 || i < n); i += gAMSDatabaseDomainViolation.symbolDVList.size()) {
            long[] lArray2 = new long[]{0L};
            this.checkForGMDError(this.GMD().GetDVSymbol(lArray[0], lArray2));
            this.checkForGMDError(this.GMD().SymbolType(lArray2[0], nArray));
            int n3 = n2;
            if (n != 0) {
                n3 = n3 != 0 ? Math.min(n - i, n2) : n - i;
            }
            gAMSDatabaseDomainViolation = null;
            switch (GAMSGlobals.DataType.lookup(nArray[0])) {
                case EQU: {
                    GAMSEquation gAMSEquation = new GAMSEquation(this, lArray2[0]);
                    gAMSDatabaseDomainViolation = new GAMSDatabaseDomainViolation(gAMSEquation, gAMSEquation.getSymbolDVs(true, n3));
                    arrayList.add(gAMSDatabaseDomainViolation);
                    break;
                }
                case VAR: {
                    GAMSVariable gAMSVariable = new GAMSVariable(this, lArray2[0]);
                    gAMSDatabaseDomainViolation = new GAMSDatabaseDomainViolation(gAMSVariable, gAMSVariable.getSymbolDVs(true, n3));
                    arrayList.add(gAMSDatabaseDomainViolation);
                    break;
                }
                case PAR: {
                    GAMSParameter gAMSParameter = new GAMSParameter(this, lArray2[0]);
                    gAMSDatabaseDomainViolation = new GAMSDatabaseDomainViolation(gAMSParameter, gAMSParameter.getSymbolDVs(true, n3));
                    arrayList.add(gAMSDatabaseDomainViolation);
                    break;
                }
                case SET: 
                case ALIAS: {
                    GAMSSet gAMSSet = new GAMSSet(this, lArray2[0]);
                    gAMSDatabaseDomainViolation = new GAMSDatabaseDomainViolation(gAMSSet, gAMSSet.getSymbolDVs(true, n3));
                    arrayList.add(gAMSDatabaseDomainViolation);
                    break;
                }
                default: {
                    throw new GAMSException("Unknown symbol type : " + nArray[0]);
                }
            }
            this.checkForGMDError(this.GMD().GetFirstDVInNextSymbol(lArray[0], blArray));
        }
        this.checkForGMDError(this.GMD().DomainCheckDone());
        this.checkForGMDError(this.GMD().FreeDVHandle(lArray[0]));
        return arrayList;
    }

    @Override
    public Iterator<GAMSSymbol<?>> iterator() {
        if (this._disposed) {
            throw new GAMSException("GAMSDatabase instance [" + this.dbName + "] has already been disposed, resources are no longer available");
        }
        return new GAMSDatabaseIterator(this);
    }

    GAMSSymbol<?> createGAMSSymbol(int n, long l) {
        assert (!this.isDisposed());
        if (n == GAMSGlobals.DataType.VAR.value()) {
            return new GAMSVariable(this, l);
        }
        if (n == GAMSGlobals.DataType.EQU.value()) {
            return new GAMSEquation(this, l);
        }
        if (n == GAMSGlobals.DataType.PAR.value()) {
            return new GAMSParameter(this, l);
        }
        if (n == GAMSGlobals.DataType.SET.value() || n == GAMSGlobals.DataType.ALIAS.value()) {
            return new GAMSSet(this, l);
        }
        throw new GAMSException("Unkown data type [" + (Object)((Object)GAMSGlobals.DataType.lookup(n)) + "] of a GAMSSymbol [" + this.getName() + "] in GAMSDatabase [" + this.dbName + "]");
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose(true);
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public boolean isDisposed() {
        return this._disposed;
    }

    public void dispose() {
        this.dispose(true);
    }

    private void dispose(boolean bl) {
        if (!this._disposed) {
            if (bl && this.dbGMD != null) {
                this.dbWorkspace.debugMessage("--- GAMSDatabase.dispose(true) : free GMD resources used by non-java library.", 3);
                this.dbGMD.Free();
            }
            this._disposed = true;
        }
    }
}

