/*
 * Decompiled with CFR 0.152.
 */
package com.gams.api;

import com.gams.api.GAMSDatabase;
import com.gams.api.GAMSException;
import com.gams.api.GAMSSymbol;
import com.gams.api.gmd;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GAMSDatabaseIterator
implements Iterator<GAMSSymbol<?>> {
    GAMSDatabase db;
    private int dbCurrentSymPosition = -1;
    private boolean dbSymbolRemoveable = false;

    GAMSDatabaseIterator(GAMSDatabase gAMSDatabase) {
        this.db = gAMSDatabase;
        this.dbCurrentSymPosition = -1;
        this.dbSymbolRemoveable = false;
    }

    @Override
    public boolean hasNext() {
        if (this.db.isDisposed()) {
            throw new GAMSException("GAMSDatabase [" + this.db.getName() + "] has already been disposed, resources are no longer available");
        }
        if (this.db.getNumberOfSymbols() == 0) {
            return false;
        }
        return this.dbCurrentSymPosition + 1 < this.db.getNumberOfSymbols();
    }

    @Override
    public GAMSSymbol<?> next() {
        gmd gmd2 = this.db.GMD();
        long[] lArray = new long[]{0L};
        this.checkErrorForNext(gmd2.GetSymbolByIndex(++this.dbCurrentSymPosition, lArray));
        int[] nArray = new int[]{0};
        this.checkErrorForNext(gmd2.SymbolType(lArray[0], nArray));
        this.dbSymbolRemoveable = true;
        return this.db.createGAMSSymbol(nArray[0], lArray[0]);
    }

    @Override
    public void remove() {
        if (this.db.getNumberOfSymbols() == 0) {
            throw new GAMSException("GAMSDatabase [" + this.db.getName() + "] has no symbol: could not remove a symbol");
        }
        gmd gmd2 = this.db.GMD();
        if (this.db.dbSymbolLock) {
            throw new GAMSException("Could not remove data symbol from symbol-locked GAMSDatabase [" + this.db.getName() + "]");
        }
        if (!this.dbSymbolRemoveable) {
            throw new GAMSException("Could remove symbol only once per call to next() in GAMSDatabase [" + this.db.getName() + "]");
        }
        long[] lArray = new long[]{0L};
        this.checkErrorForRemove(gmd2.GetSymbolByIndex(this.dbCurrentSymPosition, lArray));
        this.checkErrorForRemove(gmd2.ClearSymbol(lArray[0]));
    }

    private void checkErrorForNext(boolean bl) {
        if (!bl) {
            throw new GAMSException("Could not move to the next symbol of database [" + this.db.getName() + "]");
        }
    }

    private void checkErrorForRemove(boolean bl) {
        if (!bl) {
            throw new GAMSException("Could not remove all records of the last GAMSSymbol of GAMSDatabase [" + this.db.getName() + "] returned by the iterator");
        }
    }
}

