/*
 * Decompiled with CFR 0.152.
 */
package com.gams.api;

import com.gams.api.GAMSException;
import com.gams.api.GAMSGlobals;
import com.gams.api.GAMSWorkspace;
import com.gams.api.cfgm;
import com.gams.api.opt;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GAMSOptions {
    static final String API_VERSION = "24.8.3";
    private GAMSWorkspace optWorkspace = null;
    opt OPT = null;
    cfgm CFG = null;
    private List<String> selectedSolvers = null;
    private List<String> solversOptions = null;
    private boolean _disposed = false;
    private static Object optLock = new Object();
    public Map<String, String> definitions = null;
    public List<String> IDir = null;

    GAMSOptions(GAMSWorkspace gAMSWorkspace) {
        this(gAMSWorkspace, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GAMSOptions(GAMSWorkspace gAMSWorkspace, GAMSOptions gAMSOptions, String string) {
        assert (gAMSWorkspace != null);
        gAMSWorkspace.debugMessage("--- Entering GAMSOptions constructor ---", GAMSGlobals.DebugLevel.VERBOSE.value());
        this.optWorkspace = gAMSWorkspace;
        this._disposed = false;
        this.OPT = new opt();
        String[] stringArray = new String[1];
        String string2 = this.optWorkspace.systemDirectory();
        if (this.OPT.CreateD(string2, stringArray) != 1) {
            throw new GAMSException("could not load opt library from [" + string2 + "] : " + stringArray[0]);
        }
        String string3 = this.optWorkspace.systemDirectory() + GAMSGlobals.FILE_SEPARATOR + "optgams.def";
        int n = 0;
        String[] stringArray2 = optLock;
        synchronized (optLock) {
            n = this.OPT.ReadDefinition(string3);
            // ** MonitorExit[var8_8] (shouldn't be in output)
            if (n != 0) {
                if (!this.optWorkspace.getDebugLevel().isLowerThan(GAMSGlobals.DebugLevel.SHOW_LOG)) {
                    System.out.println("error processing file [" + string3 + "] : returned status=" + n);
                    int n2 = 0;
                    String[] stringArray3 = new String[1];
                    int[] nArray = new int[]{0};
                    for (n2 = 1; n2 <= this.OPT.MessageCount(); ++n2) {
                        this.OPT.GetMessage(n2, stringArray3, nArray);
                        System.out.println("error processing file [" + string3 + "] : message=" + stringArray3[0]);
                    }
                }
                throw new GAMSException("could not read definition file [" + string3 + "]");
            }
            this.CFG = new cfgm();
            stringArray2 = new String[1];
            if (this.CFG.CreateD(this.optWorkspace.systemDirectory(), stringArray2) != 1) {
                throw new GAMSException("could not load cfg library from [" + this.optWorkspace.systemDirectory() + "] : " + stringArray2[0]);
            }
            if (this.CFG.ReadConfig(this.optWorkspace.systemDirectory() + GAMSGlobals.FILE_SEPARATOR + GAMSGlobals.getGAMSCmpFile()) != 0) {
                throw new GAMSException("could not read configuration file [" + this.optWorkspace.systemDirectory() + GAMSGlobals.FILE_SEPARATOR + GAMSGlobals.getGAMSCmpFile() + "]");
            }
            this.IDir = Collections.synchronizedList(new ArrayList());
            this.definitions = Collections.synchronizedMap(new HashMap());
            this.selectedSolvers = Collections.synchronizedList(new ArrayList());
            this.solversOptions = Collections.synchronizedList(new ArrayList());
            if (gAMSOptions != null) {
                this.copyAttributes(gAMSOptions);
            } else if (string != null) {
                this.readFromOptionFile(string);
            } else {
                this.selectedSolvers.add(GAMSGlobals.EMPTY_STRING);
                for (int i = 1; i < 16; ++i) {
                    this.selectedSolvers.add(this.CFG.AlgName(this.CFG.DefaultAlg(i)));
                }
            }
            return;
        }
    }

    private void copyAttributes(GAMSOptions gAMSOptions) {
        assert (gAMSOptions != null) : "cannot copy attribute of a null object ";
        String string = this.optWorkspace.workingDirectory() + GAMSGlobals.FILE_SEPARATOR + GAMSGlobals.scratchFilePrefix + gAMSOptions.hashCode() + ".pf";
        gAMSOptions.writeParameterFile(string);
        this.OPT.ReadParameterFile(string);
        for (Map.Entry<String, String> object : gAMSOptions.getDefinitions().entrySet()) {
            this.definitions.put(object.getKey(), object.getValue());
        }
        for (String string2 : gAMSOptions.getAllSelectedSolvers()) {
            this.selectedSolvers.add(string2);
        }
        for (String string3 : gAMSOptions.getAllSelectedSolvers()) {
            this.solversOptions.add(string3);
        }
        for (String string4 : gAMSOptions.getInputDirectories()) {
            this.IDir.add(string4);
        }
        if (this.optWorkspace.getDebugLevel().isLowerThan(GAMSGlobals.DebugLevel.KEEP_FILES)) {
            try {
                File file = new File(string);
                file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void readFromOptionFile(String string) {
        int n;
        File file = new File(string);
        if (file.getParent() == null) {
            file = new File(this.optWorkspace.workingDirectory(), string);
        }
        if (!file.exists()) {
            throw new GAMSException("Problem reading parameter file, [" + file + "] does not exist");
        }
        if (0 != this.OPT.ReadParameterFile(file.getAbsolutePath())) {
            String[] stringArray = new String[]{GAMSGlobals.EMPTY_STRING};
            int[] nArray = new int[]{0};
            for (int i = 1; i <= this.OPT.MessageCount(); ++i) {
                this.OPT.GetMessage(i, stringArray, nArray);
            }
            throw new GAMSException("Problem reading parameter file [" + file + "]");
        }
        for (int i = 1; i <= 40; ++i) {
            if (!this.OPT.GetDefinedStr("InputDir" + String.valueOf(i))) continue;
            this.IDir.add(this.OPT.GetStrStr("InputDir" + String.valueOf(i)));
        }
        String[] stringArray = new String[]{GAMSGlobals.EMPTY_STRING};
        String[] stringArray2 = new String[]{GAMSGlobals.EMPTY_STRING};
        while (0 != this.OPT.GetFromAnyStrList(1, stringArray, stringArray2)) {
            if (stringArray[0].startsWith("--")) {
                stringArray[0] = stringArray[0].substring(2, stringArray[0].length());
            }
            this.definitions.put(stringArray[0], stringArray2[0]);
        }
        this.selectedSolvers.add(GAMSGlobals.EMPTY_STRING);
        for (n = 1; n < 16; ++n) {
            this.selectedSolvers.add(this.CFG.AlgName(this.CFG.DefaultAlg(n)));
        }
        for (n = 1; n < 16; ++n) {
            if (!this.OPT.GetDefinedStr(this.CFG.ModelTypeName(n))) continue;
            this.selectedSolvers.set(n, this.OPT.GetStrStr(this.CFG.ModelTypeName(n)));
        }
    }

    public void export(String string) throws IOException {
        int n;
        if (this._disposed) {
            throw new GAMSException("GAMSOptions has already been disposed, resources are no longer available");
        }
        File file = new File(string);
        this.OPT.WriteParameterFile(file.getAbsolutePath());
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file, true)));
        printWriter.println("EolOnly=1");
        if (this.IDir.size() > 0) {
            if (this.IDir.size() > 40) {
                throw new GAMSException("Cannot handle more than 40 IDirs");
            }
            for (n = 1; n <= this.IDir.size(); ++n) {
                printWriter.println("InputDir" + String.valueOf(n) + "=" + this.IDir.get(n - 1));
            }
        }
        for (n = 1; n < 16; ++n) {
            printWriter.println(this.CFG.ModelTypeName(n) + "=" + this.selectedSolvers.get(n));
        }
        if (this.definitions.size() > 0) {
            for (Map.Entry<String, String> entry : this.definitions.entrySet()) {
                printWriter.println("--" + entry.getKey() + "=" + entry.getValue());
            }
        }
        printWriter.close();
    }

    public List<String> getInputDirectories() {
        return this.IDir;
    }

    public String getSelectedSolvers(int n) {
        return this.selectedSolvers.get(n);
    }

    public List<String> getAllSelectedSolvers() {
        return this.selectedSolvers;
    }

    public void setAllSelectedSolvers(List<String> list) {
        this.selectedSolvers = list;
    }

    public List<String> getAllSolversOptions() {
        return this.solversOptions;
    }

    public void setSolversOptions(List<String> list) {
        this.solversOptions = list;
    }

    public List<String> getIDir() {
        return this.IDir;
    }

    public boolean isIDirEmpty() {
        return this.IDir.isEmpty();
    }

    public String getIDir(int n) {
        return this.definitions.get(n);
    }

    public Map<String, String> getDefinitions() {
        return this.definitions;
    }

    public boolean isDefinitionEmpty() {
        return this.definitions.isEmpty();
    }

    public String getDefinitionOf(String string) {
        return this.definitions.get(string);
    }

    public void defines(String string, String string2) {
        this.definitions.put(string, string2);
    }

    public void readFromStr(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.ReadFromStr(string);
    }

    public int writeParameterFile(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.WriteParameterFile(string);
    }

    public String getGDX() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("GDX");
    }

    public void setGDX(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        if (!string.endsWith(".gdx")) {
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            string = string + ".gdx";
        }
        this.OPT.SetStrStr("GDX", string);
    }

    String getRestart() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("Restart");
    }

    void setRestart(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("Restart", string);
    }

    String getInput() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("Input");
    }

    void setInput(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("Input", string);
    }

    public String getOutput() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("Output");
    }

    public void setOutput(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("Output", string);
    }

    String getSave() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("Save");
    }

    void setSave(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("Save", string);
    }

    public String getSymbol() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("Symbol");
    }

    public void setSymbol(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("Symbol", string);
    }

    String getXSave() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("XSave");
    }

    void setXSave(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("XSave", string);
    }

    public String getExpand() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("Expand");
    }

    public void setExpand(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("Expand", string);
    }

    public int getPageWidth() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("PageWidth");
    }

    public void setPageWidth(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("PageWidth", n);
    }

    public int getPageSize() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("PageSize");
    }

    public void setPageSize(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("PageSize", n);
    }

    public EPageContr getPageContr() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EPageContr.lookup(this.OPT.GetIntStr("PageContr"));
    }

    public void setPageContr(EPageContr ePageContr) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("PageContr", ePageContr.value());
    }

    public EAction getAction() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EAction.lookup(this.OPT.GetStrStr("Action"));
    }

    public void setAction(EAction eAction) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("Action", eAction.value());
    }

    String getSubSys() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("SubSys");
    }

    void setSubSys(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("SubSys", string);
    }

    String getErrNam() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("ErrNam");
    }

    void setErrNam(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("ErrNam", string);
    }

    String getScrDir() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("ScrDir");
    }

    void setScrDir(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("ScrDir", string);
    }

    String getScrNam() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("ScrNam");
    }

    void setScrNam(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("ScrNam", string);
    }

    String getSysDir() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("SysDir");
    }

    void setSysDir(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("SysDir", string);
    }

    String getCurDir() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("CurDir");
    }

    void setCurDir(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("CurDir", string);
    }

    String getWorkDir() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("WorkDir");
    }

    void setWorkDir(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("WorkDir", string);
    }

    public String getPutDir() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("PutDir");
    }

    public void setPutDir(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("PutDir", string);
    }

    public String getGridDir() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("GridDir");
    }

    public void setGridDir(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("GridDir", string);
    }

    String getScriptNext() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("ScriptNext");
    }

    void setScriptNext(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("ScriptNext", string);
    }

    public String getScriptExit() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("ScriptExit");
    }

    public void setScriptExit(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("ScriptExit", string);
    }

    String getScriptFrst() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("ScriptFrst");
    }

    void setScriptFrst(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("ScriptFrst", string);
    }

    public ELogLine getLogLine() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return ELogLine.lookup(this.OPT.GetIntStr("LogLine"));
    }

    public void setLogLine(ELogLine eLogLine) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("LogLine", eLogLine.value());
    }

    int getLogOption() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("LogOption");
    }

    void setLogOption(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("LogOption", n);
    }

    String getLogFile() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("LogFile");
    }

    void setLogFile(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("LogFile", string);
    }

    public String getTrace() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("Trace");
    }

    public void setTrace(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("Trace", string);
    }

    public EAppendOut getAppendOut() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EAppendOut.lookup(this.OPT.GetIntStr("AppendOut"));
    }

    public void setAppendOut(EAppendOut eAppendOut) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("AppendOut", eAppendOut.value());
    }

    int getAppendLog() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("AppendLog");
    }

    void setAppendLog(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("AppendLog", n);
    }

    public EStepSum getStepSum() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EStepSum.lookup(this.OPT.GetIntStr("StepSum"));
    }

    public void setStepSum(EStepSum eStepSum) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("StepSum", eStepSum.value());
    }

    int getMultiPass() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("MultiPass");
    }

    void setMultiPass(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("MultiPass", n);
    }

    public ESuppress getSuppress() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return ESuppress.lookup(this.OPT.GetIntStr("Suppress"));
    }

    public void setSuppress(ESuppress eSuppress) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("Suppress", eSuppress.value());
    }

    public EDFormat getDFormat() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EDFormat.lookup(this.OPT.GetIntStr("DFormat"));
    }

    public void setDFormat(EDFormat eDFormat) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("DFormat", eDFormat.value());
    }

    public ETFormat getTFormat() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return ETFormat.lookup(this.OPT.GetIntStr("TFormat"));
    }

    public void setTFormat(ETFormat eTFormat) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("TFormat", eTFormat.value());
    }

    public int getTabIn() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("TabIn");
    }

    public void setTabIn(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("TabIn", n);
    }

    String getSolverCntr() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("SolverCntr");
    }

    void setSolverCntr(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("SolverCntr", string);
    }

    String getSolverMatr() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("SolverMatr");
    }

    void setSolverMatr(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("SolverMatr", string);
    }

    String getSolverInst() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("SolverInst");
    }

    void setSolverInst(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("SolverInst", string);
    }

    String getSolverStat() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("SolverStat");
    }

    void setSolverStat(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("SolverStat", string);
    }

    String getSolverSolu() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("SolverSolu");
    }

    void setSolverSolu(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("SolverSolu", string);
    }

    String getSolverDict() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("SolverDict");
    }

    void setSolverDict(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("SolverDict", string);
    }

    public EIntVarUp getIntVarUp() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EIntVarUp.lookup(this.OPT.GetIntStr("IntVarUp"));
    }

    public void setIntVarUp(EIntVarUp eIntVarUp) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("IntVarUp", eIntVarUp.value());
    }

    public ECase getCase() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return ECase.lookup(this.OPT.GetIntStr("Case"));
    }

    public void setCase(ECase eCase) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("Case", eCase.value());
    }

    int getG205() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("G205");
    }

    void setG205(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("G205", n);
    }

    public String getLicense() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("License");
    }

    public void setLicense(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("License", string);
    }

    public EDumpParms getDumpParms() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EDumpParms.lookup(this.OPT.GetIntStr("DumpParms"));
    }

    public void setDumpParms(EDumpParms eDumpParms) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("DumpParms", eDumpParms.value());
    }

    int getNoCr() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("NoCr");
    }

    void setNoCr(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("NoCr", n);
    }

    public int getProfile() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("Profile");
    }

    public void setProfile(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("Profile", n);
    }

    String getInputDir1() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir1");
    }

    void setInputDir1(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir1", string);
    }

    String getInputDir2() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir2");
    }

    void setInputDir2(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir2", string);
    }

    String getInputDir3() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir3");
    }

    void setInputDir3(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir3", string);
    }

    String getInputDir4() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir4");
    }

    void setInputDir4(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir4", string);
    }

    String getInputDir5() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir5");
    }

    void setInputDir5(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir5", string);
    }

    String getInputDir6() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir6");
    }

    void setInputDir6(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir6", string);
    }

    String getInputDir7() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir7");
    }

    void setInputDir7(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir7", string);
    }

    String getInputDir8() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir8");
    }

    void setInputDir8(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir8", string);
    }

    String getInputDir9() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir9");
    }

    void setInputDir9(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir9", string);
    }

    String getInputDir10() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir10");
    }

    void setInputDir10(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir10", string);
    }

    String getInputDir11() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir11");
    }

    void setInputDir11(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir11", string);
    }

    String getInputDir12() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir12");
    }

    void setInputDir12(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir12", string);
    }

    String getInputDir13() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir13");
    }

    void setInputDir13(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir13", string);
    }

    String getInputDir14() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir14");
    }

    void setInputDir14(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir14", string);
    }

    String getInputDir15() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir15");
    }

    void setInputDir15(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir15", string);
    }

    String getInputDir16() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir16");
    }

    void setInputDir16(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir16", string);
    }

    String getInputDir17() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir17");
    }

    void setInputDir17(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir17", string);
    }

    String getInputDir18() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir18");
    }

    void setInputDir18(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir18", string);
    }

    String getInputDir19() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir19");
    }

    void setInputDir19(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir19", string);
    }

    String getInputDir20() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir20");
    }

    void setInputDir20(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir20", string);
    }

    String getInputDir21() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir21");
    }

    void setInputDir21(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir21", string);
    }

    String getInputDir22() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir22");
    }

    void setInputDir22(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir22", string);
    }

    String getInputDir23() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir23");
    }

    void setInputDir23(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir23", string);
    }

    String getInputDir24() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir24");
    }

    void setInputDir24(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir24", string);
    }

    String getInputDir25() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir25");
    }

    void setInputDir25(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir25", string);
    }

    String getInputDir26() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir26");
    }

    void setInputDir26(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir26", string);
    }

    String getInputDir27() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir27");
    }

    void setInputDir27(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir27", string);
    }

    String getInputDir28() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir28");
    }

    void setInputDir28(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir28", string);
    }

    String getInputDir29() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir29");
    }

    void setInputDir29(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir29", string);
    }

    String getInputDir30() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir30");
    }

    void setInputDir30(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir30", string);
    }

    String getInputDir31() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir31");
    }

    void setInputDir31(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir31", string);
    }

    String getInputDir32() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir32");
    }

    void setInputDir32(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir32", string);
    }

    String getInputDir33() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir33");
    }

    void setInputDir33(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir33", string);
    }

    String getInputDir34() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir34");
    }

    void setInputDir34(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir34", string);
    }

    String getInputDir35() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir35");
    }

    void setInputDir35(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir35", string);
    }

    String getInputDir36() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir36");
    }

    void setInputDir36(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir36", string);
    }

    String getInputDir37() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir37");
    }

    void setInputDir37(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir37", string);
    }

    String getInputDir38() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir38");
    }

    void setInputDir38(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir38", string);
    }

    String getInputDir39() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir39");
    }

    void setInputDir39(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir39", string);
    }

    String getInputDir40() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir40");
    }

    void setInputDir40(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir40", string);
    }

    String getInputDir() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("InputDir");
    }

    void setInputDir(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("InputDir", string);
    }

    public String getLibIncDir() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("LibIncDir");
    }

    public void setLibIncDir(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("LibIncDir", string);
    }

    public String getSysIncDir() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("SysIncDir");
    }

    public void setSysIncDir(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("SysIncDir", string);
    }

    public String getUser1() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("User1");
    }

    public void setUser1(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("User1", string);
    }

    public String getUser2() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("User2");
    }

    public void setUser2(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("User2", string);
    }

    public String getUser3() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("User3");
    }

    public void setUser3(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("User3", string);
    }

    public String getUser4() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("User4");
    }

    public void setUser4(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("User4", string);
    }

    public String getUser5() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("User5");
    }

    public void setUser5(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("User5", string);
    }

    public EForceWork getForceWork() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EForceWork.lookup(this.OPT.GetIntStr("ForceWork"));
    }

    public void setForceWork(EForceWork eForceWork) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("ForceWork", eForceWork.value());
    }

    public int getCErr() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("CErr");
    }

    public void setCErr(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("CErr", n);
    }

    public String getFErr() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("FErr");
    }

    public void setFErr(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("FErr", string);
    }

    public int getOptFile() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("OptFile");
    }

    public void setOptFile(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("OptFile", n);
    }

    int getFSave() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("FSave");
    }

    void setFSave(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("FSave", n);
    }

    public EDumpOpt getDumpOpt() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EDumpOpt.lookup(this.OPT.GetIntStr("DumpOpt"));
    }

    public void setDumpOpt(EDumpOpt eDumpOpt) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("DumpOpt", eDumpOpt.value());
    }

    public EErrMsg getErrMsg() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EErrMsg.lookup(this.OPT.GetIntStr("ErrMsg"));
    }

    public void setErrMsg(EErrMsg eErrMsg) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("ErrMsg", eErrMsg.value());
    }

    public int getOpt() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("Opt");
    }

    public void setOpt(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("Opt", n);
    }

    int getRelPath() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("RelPath");
    }

    void setRelPath(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("RelPath", n);
    }

    public EStringChk getStringChk() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EStringChk.lookup(this.OPT.GetIntStr("StringChk"));
    }

    public void setStringChk(EStringChk eStringChk) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("StringChk", eStringChk.value());
    }

    public String getReference() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("Reference");
    }

    public void setReference(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("Reference", string);
    }

    public String getOptDir() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("OptDir");
    }

    public void setOptDir(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("OptDir", string);
    }

    public int getExecErr() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("ExecErr");
    }

    public void setExecErr(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("ExecErr", n);
    }

    public int getErrorLog() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("ErrorLog");
    }

    public void setErrorLog(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("ErrorLog", n);
    }

    public int getLimRow() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("LimRow");
    }

    public void setLimRow(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("LimRow", n);
    }

    public int getLimCol() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("LimCol");
    }

    public void setLimCol(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("LimCol", n);
    }

    public ECharSet getCharSet() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return ECharSet.lookup(this.OPT.GetIntStr("CharSet"));
    }

    public void setCharSet(ECharSet eCharSet) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("CharSet", eCharSet.value());
    }

    public EKeep getKeep() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EKeep.lookup(this.OPT.GetIntStr("Keep"));
    }

    public void setKeep(EKeep eKeep) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("Keep", eKeep.value());
    }

    int getIDE() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("IDE");
    }

    void setIDE(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("IDE", n);
    }

    public ETraceOpt getTraceOpt() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return ETraceOpt.lookup(this.OPT.GetIntStr("TraceOpt"));
    }

    public void setTraceOpt(ETraceOpt eTraceOpt) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("TraceOpt", eTraceOpt.value());
    }

    public int getIterLim() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("IterLim");
    }

    public void setIterLim(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("IterLim", n);
    }

    public int getDomLim() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("DomLim");
    }

    public void setDomLim(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("DomLim", n);
    }

    public double getResLim() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetDblStr("ResLim");
    }

    public void setResLim(double d) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetDblStr("ResLim", d);
    }

    public double getOptCR() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetDblStr("OptCR");
    }

    public void setOptCR(double d) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetDblStr("OptCR", d);
    }

    public double getOptCA() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetDblStr("OptCA");
    }

    public void setOptCA(double d) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetDblStr("OptCA", d);
    }

    public ESysOut getSysOut() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return ESysOut.lookup(this.OPT.GetIntStr("SysOut"));
    }

    public void setSysOut(ESysOut eSysOut) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("SysOut", eSysOut.value());
    }

    public ESolPrint getSolPrint() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return ESolPrint.lookup(this.OPT.GetIntStr("SolPrint"));
    }

    public void setSolPrint(ESolPrint eSolPrint) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("SolPrint", eSolPrint.value());
    }

    public double getBratio() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetDblStr("Bratio");
    }

    public void setBratio(double d) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetDblStr("Bratio", d);
    }

    public EHoldFixed getHoldFixed() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EHoldFixed.lookup(this.OPT.GetIntStr("HoldFixed"));
    }

    public void setHoldFixed(EHoldFixed eHoldFixed) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("HoldFixed", eHoldFixed.value());
    }

    public int getNodLim() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("NodLim");
    }

    public void setNodLim(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("NodLim", n);
    }

    public double getWorkFactor() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetDblStr("WorkFactor");
    }

    public void setWorkFactor(double d) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetDblStr("WorkFactor", d);
    }

    public double getWorkSpace() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetDblStr("WorkSpace");
    }

    public void setWorkSpace(double d) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetDblStr("WorkSpace", d);
    }

    public int getForLim() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("ForLim");
    }

    public void setForLim(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("ForLim", n);
    }

    public int getSeed() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("Seed");
    }

    public void setSeed(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("Seed", n);
    }

    public EOn115 getOn115() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EOn115.lookup(this.OPT.GetIntStr("On115"));
    }

    public void setOn115(EOn115 eOn115) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("On115", eOn115.value());
    }

    public EExecMode getExecMode() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EExecMode.lookup(this.OPT.GetIntStr("ExecMode"));
    }

    public void setExecMode(EExecMode eExecMode) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("ExecMode", eExecMode.value());
    }

    public EInteractiveSolver getInteractiveSolver() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EInteractiveSolver.lookup(this.OPT.GetIntStr("InteractiveSolver"));
    }

    public void setInteractiveSolver(EInteractiveSolver eInteractiveSolver) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("InteractiveSolver", eInteractiveSolver.value());
    }

    public String getPLicense() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("PLicense");
    }

    public void setPLicense(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("PLicense", string);
    }

    public String getJobTrace() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("JobTrace");
    }

    public void setJobTrace(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("JobTrace", string);
    }

    public int getWarnings() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("Warnings");
    }

    public void setWarnings(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("Warnings", n);
    }

    public int getTraceLevel() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("TraceLevel");
    }

    public void setTraceLevel(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("TraceLevel", n);
    }

    public int getTimer() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("Timer");
    }

    public void setTimer(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("Timer", n);
    }

    public EFileCase getFileCase() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EFileCase.lookup(this.OPT.GetIntStr("FileCase"));
    }

    public void setFileCase(EFileCase eFileCase) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("FileCase", eFileCase.value());
    }

    public ESavePoint getSavePoint() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return ESavePoint.lookup(this.OPT.GetIntStr("SavePoint"));
    }

    public void setSavePoint(ESavePoint eSavePoint) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("SavePoint", eSavePoint.value());
    }

    public ESolveLink getSolveLink() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return ESolveLink.lookup(this.OPT.GetIntStr("SolveLink"));
    }

    public void setSolveLink(ESolveLink eSolveLink) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("SolveLink", eSolveLink.value());
    }

    public ESys10 getSys10() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return ESys10.lookup(this.OPT.GetIntStr("Sys10"));
    }

    public void setSys10(ESys10 eSys10) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("Sys10", eSys10.value());
    }

    public ESys11 getSys11() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return ESys11.lookup(this.OPT.GetIntStr("Sys11"));
    }

    public void setSys11(ESys11 eSys11) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("Sys11", eSys11.value());
    }

    public int getSys12() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("Sys12");
    }

    public void setSys12(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("Sys12", n);
    }

    public double getZeroRes() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetDblStr("ZeroRes");
    }

    public void setZeroRes(double d) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetDblStr("ZeroRes", d);
    }

    public EZeroResRep getZeroResRep() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EZeroResRep.lookup(this.OPT.GetIntStr("ZeroResRep"));
    }

    public void setZeroResRep(EZeroResRep eZeroResRep) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("ZeroResRep", eZeroResRep.value());
    }

    public double getHeapLimit() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetDblStr("HeapLimit");
    }

    public void setHeapLimit(double d) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetDblStr("HeapLimit", d);
    }

    String getScrExt() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("ScrExt");
    }

    void setScrExt(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("ScrExt", string);
    }

    String getProcDir() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("ProcDir");
    }

    void setProcDir(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("ProcDir", string);
    }

    public EgdxCompress getgdxCompress() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EgdxCompress.lookup(this.OPT.GetIntStr("gdxCompress"));
    }

    public void setgdxCompress(EgdxCompress egdxCompress) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("gdxCompress", egdxCompress.value());
    }

    public EgdxConvert getgdxConvert() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EgdxConvert.lookup(this.OPT.GetStrStr("gdxConvert"));
    }

    public void setgdxConvert(EgdxConvert egdxConvert) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("gdxConvert", egdxConvert.value());
    }

    public EAppendExpand getAppendExpand() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EAppendExpand.lookup(this.OPT.GetIntStr("AppendExpand"));
    }

    public void setAppendExpand(EAppendExpand eAppendExpand) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("AppendExpand", eAppendExpand.value());
    }

    public double getETLim() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetDblStr("ETLim");
    }

    public void setETLim(double d) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetDblStr("ETLim", d);
    }

    public double getProfileTol() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetDblStr("ProfileTol");
    }

    public void setProfileTol(double d) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetDblStr("ProfileTol", d);
    }

    public String getProfileFile() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("ProfileFile");
    }

    public void setProfileFile(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("ProfileFile", string);
    }

    public int getMaxProcDir() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("MaxProcDir");
    }

    public void setMaxProcDir(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("MaxProcDir", n);
    }

    public int getInteger1() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("Integer1");
    }

    public void setInteger1(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("Integer1", n);
    }

    public int getInteger2() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("Integer2");
    }

    public void setInteger2(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("Integer2", n);
    }

    public int getInteger3() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("Integer3");
    }

    public void setInteger3(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("Integer3", n);
    }

    public int getInteger4() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("Integer4");
    }

    public void setInteger4(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("Integer4", n);
    }

    public int getInteger5() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("Integer5");
    }

    public void setInteger5(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("Integer5", n);
    }

    public String getGridScript() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("GridScript");
    }

    public void setGridScript(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("GridScript", string);
    }

    public int getThreads() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("Threads");
    }

    public void setThreads(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("Threads", n);
    }

    int getUseDLL() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("UseDLL");
    }

    void setUseDLL(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("UseDLL", n);
    }

    int getDebug() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("Debug");
    }

    void setDebug(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("Debug", n);
    }

    int getPID2Error() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("PID2Error");
    }

    void setPID2Error(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("PID2Error", n);
    }

    public ENoNewVarEqu getNoNewVarEqu() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return ENoNewVarEqu.lookup(this.OPT.GetIntStr("NoNewVarEqu"));
    }

    public void setNoNewVarEqu(ENoNewVarEqu eNoNewVarEqu) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("NoNewVarEqu", eNoNewVarEqu.value());
    }

    public int getForceOptFile() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("ForceOptFile");
    }

    public void setForceOptFile(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("ForceOptFile", n);
    }

    public String getSymPrefix() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("SymPrefix");
    }

    public void setSymPrefix(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("SymPrefix", string);
    }

    int getServerRun() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("ServerRun");
    }

    void setServerRun(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("ServerRun", n);
    }

    public EgdxUels getgdxUels() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EgdxUels.lookup(this.OPT.GetStrStr("gdxUels"));
    }

    public void setgdxUels(EgdxUels egdxUels) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("gdxUels", egdxUels.value());
    }

    public String getDumpParmsLogPrefix() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("DumpParmsLogPrefix");
    }

    public void setDumpParmsLogPrefix(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("DumpParmsLogPrefix", string);
    }

    public EstrictSingleton getstrictSingleton() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EstrictSingleton.lookup(this.OPT.GetIntStr("strictSingleton"));
    }

    public void setstrictSingleton(EstrictSingleton estrictSingleton) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("strictSingleton", estrictSingleton.value());
    }

    String getSaveObfuscate() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("SaveObfuscate");
    }

    void setSaveObfuscate(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("SaveObfuscate", string);
    }

    String getXSaveObfuscate() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("XSaveObfuscate");
    }

    void setXSaveObfuscate(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("XSaveObfuscate", string);
    }

    String getRestartNamed() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("RestartNamed");
    }

    void setRestartNamed(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("RestartNamed", string);
    }

    int getSys14() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("Sys14");
    }

    void setSys14(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("Sys14", n);
    }

    public double getFDDelta() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetDblStr("FDDelta");
    }

    public void setFDDelta(double d) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetDblStr("FDDelta", d);
    }

    public EFDOpt getFDOpt() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EFDOpt.lookup(this.OPT.GetIntStr("FDOpt"));
    }

    public void setFDOpt(EFDOpt eFDOpt) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("FDOpt", eFDOpt.value());
    }

    String getSolver() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("Solver");
    }

    void setSolver(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("Solver", string);
    }

    String getDocFile() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("DocFile");
    }

    void setDocFile(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("DocFile", string);
    }

    String getSparseRun() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("SparseRun");
    }

    void setSparseRun(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("SparseRun", string);
    }

    int getSys15() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("Sys15");
    }

    void setSys15(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("Sys15", n);
    }

    int getSys16() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("Sys16");
    }

    void setSys16(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("Sys16", n);
    }

    int getSys17() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("Sys17");
    }

    void setSys17(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("Sys17", n);
    }

    public EPrefixLoadPath getPrefixLoadPath() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EPrefixLoadPath.lookup(this.OPT.GetIntStr("PrefixLoadPath"));
    }

    public void setPrefixLoadPath(EPrefixLoadPath ePrefixLoadPath) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("PrefixLoadPath", ePrefixLoadPath.value());
    }

    public int getThreadsAsync() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("ThreadsAsync");
    }

    public void setThreadsAsync(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("ThreadsAsync", n);
    }

    int getMCPRHoldfx() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetIntStr("MCPRHoldfx");
    }

    void setMCPRHoldfx(int n) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("MCPRHoldfx", n);
    }

    public EAsyncSolLst getAsyncSolLst() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return EAsyncSolLst.lookup(this.OPT.GetIntStr("AsyncSolLst"));
    }

    public void setAsyncSolLst(EAsyncSolLst eAsyncSolLst) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetIntStr("AsyncSolLst", eAsyncSolLst.value());
    }

    public String getFileStem() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.OPT.GetStrStr("FileStem");
    }

    public void setFileStem(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        this.OPT.SetStrStr("FileStem", string);
    }

    public String getLP() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.selectedSolvers.get(1);
    }

    public void setLP(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        if (this.CFG.AlgCapability(this.CFG.AlgNumber(string), 1)) {
            this.selectedSolvers.set(1, string);
        }
    }

    public String getMIP() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.selectedSolvers.get(2);
    }

    public void setMIP(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        if (this.CFG.AlgCapability(this.CFG.AlgNumber(string), 2)) {
            this.selectedSolvers.set(2, string);
        }
    }

    public String getRMIP() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.selectedSolvers.get(3);
    }

    public void setRMIP(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        if (this.CFG.AlgCapability(this.CFG.AlgNumber(string), 3)) {
            this.selectedSolvers.set(3, string);
        }
    }

    public String getNLP() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.selectedSolvers.get(4);
    }

    public void setNLP(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        if (this.CFG.AlgCapability(this.CFG.AlgNumber(string), 4)) {
            this.selectedSolvers.set(4, string);
        }
    }

    public String getMCP() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.selectedSolvers.get(5);
    }

    public void setMCP(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        if (this.CFG.AlgCapability(this.CFG.AlgNumber(string), 5)) {
            this.selectedSolvers.set(5, string);
        }
    }

    public String getMPEC() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.selectedSolvers.get(6);
    }

    public void setMPEC(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        if (this.CFG.AlgCapability(this.CFG.AlgNumber(string), 6)) {
            this.selectedSolvers.set(6, string);
        }
    }

    public String getRMPEC() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.selectedSolvers.get(7);
    }

    public void setRMPEC(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        if (this.CFG.AlgCapability(this.CFG.AlgNumber(string), 7)) {
            this.selectedSolvers.set(7, string);
        }
    }

    public String getCNS() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.selectedSolvers.get(8);
    }

    public void setCNS(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        if (this.CFG.AlgCapability(this.CFG.AlgNumber(string), 8)) {
            this.selectedSolvers.set(8, string);
        }
    }

    public String getDNLP() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.selectedSolvers.get(9);
    }

    public void setDNLP(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        if (this.CFG.AlgCapability(this.CFG.AlgNumber(string), 9)) {
            this.selectedSolvers.set(9, string);
        }
    }

    public String getRMINLP() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.selectedSolvers.get(10);
    }

    public void setRMINLP(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        if (this.CFG.AlgCapability(this.CFG.AlgNumber(string), 10)) {
            this.selectedSolvers.set(10, string);
        }
    }

    public String getMINLP() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.selectedSolvers.get(11);
    }

    public void setMINLP(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        if (this.CFG.AlgCapability(this.CFG.AlgNumber(string), 11)) {
            this.selectedSolvers.set(11, string);
        }
    }

    public String getQCP() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.selectedSolvers.get(12);
    }

    public void setQCP(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        if (this.CFG.AlgCapability(this.CFG.AlgNumber(string), 12)) {
            this.selectedSolvers.set(12, string);
        }
    }

    public String getMIQCP() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.selectedSolvers.get(13);
    }

    public void setMIQCP(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        if (this.CFG.AlgCapability(this.CFG.AlgNumber(string), 13)) {
            this.selectedSolvers.set(13, string);
        }
    }

    public String getRMIQCP() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.selectedSolvers.get(14);
    }

    public void setRMIQCP(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        if (this.CFG.AlgCapability(this.CFG.AlgNumber(string), 14)) {
            this.selectedSolvers.set(14, string);
        }
    }

    public String getEMP() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        return this.selectedSolvers.get(15);
    }

    public void setEMP(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        if (this.CFG.AlgCapability(this.CFG.AlgNumber(string), 15)) {
            this.selectedSolvers.set(15, string);
        }
    }

    public void setAllModelTypes(String string) {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        for (int i = 1; i < 16; ++i) {
            if (this.CFG.AlgCapability(this.CFG.AlgNumber(string), i)) {
                this.selectedSolvers.set(i, string);
                continue;
            }
            this.selectedSolvers.set(i, GAMSGlobals.EMPTY_STRING);
        }
    }

    public void setModelTypesForSolvers() {
        if (this._disposed) {
            throw new GAMSException("this GAMSOptions instance has already been disposed, resources are no longer available");
        }
        for (int i = 1; i < 16; ++i) {
            if (this.selectedSolvers.get(i).equals(GAMSGlobals.EMPTY_STRING)) continue;
            this.OPT.SetStrStr(this.CFG.ModelTypeName(i), this.selectedSolvers.get(i));
        }
    }

    String OptFileExtension(int n) {
        if (n == 1) {
            return ".opt";
        }
        if (n >= 2 && n <= 9) {
            return ".opt".substring(0, 3) + String.valueOf(n);
        }
        if (n >= 10 && n <= 99) {
            return ".opt".substring(0, 2) + String.valueOf(n);
        }
        if (n >= 100 && n <= 999) {
            return ".opt".substring(0, 1) + String.valueOf(n);
        }
        throw new GAMSException("Option File Exentsion : Index out of bounds");
    }

    public void ResetToDefault() {
        this.OPT.ResetAll();
        this.IDir.clear();
        this.definitions.clear();
        this.selectedSolvers.clear();
        this.selectedSolvers.add(GAMSGlobals.EMPTY_STRING);
        for (int i = 1; i < 16; ++i) {
            this.selectedSolvers.add(this.CFG.AlgName(this.CFG.DefaultAlg(i)));
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose(true);
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public void dispose() {
        this.dispose(true);
    }

    private void dispose(boolean bl) {
        if (!this._disposed) {
            if (bl) {
                if (this.OPT != null) {
                    this.optWorkspace.debugMessage("--- GAMSOptions.dispose(true) : free OPT resources used by non-java library.", 3);
                    this.OPT.Free();
                }
                if (this.CFG != null) {
                    this.optWorkspace.debugMessage("--- GAMSOptions.dispose(true) : free CFG resources used by non-java library.", 3);
                    this.CFG.Free();
                }
            }
            this._disposed = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EAsyncSolLst {
        Off,
        On,
        UndefinedAsyncSolLst;


        public static EAsyncSolLst lookup(int n) {
            if (n >= 0 && n < EAsyncSolLst.values().length - 1) {
                return EAsyncSolLst.values()[n];
            }
            return UndefinedAsyncSolLst;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EPrefixLoadPath {
        Off,
        On,
        UndefinedPrefixLoadPath;


        public static EPrefixLoadPath lookup(int n) {
            if (n >= 0 && n < EPrefixLoadPath.values().length - 1) {
                return EPrefixLoadPath.values()[n];
            }
            return UndefinedPrefixLoadPath;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EFDOpt {
        GHAnalyticHNumericGradScale,
        GHAnalyticHNumericFuncScale,
        GAnalyticFHNumericGradScale,
        GAnalyticFHNumericFuncScale,
        FGHNumericScale,
        GHAnalyticHNumericGradNoScale,
        GHAnalyticHNumericFuncNoScale,
        GAnalyticFHNumericGradNoScale,
        GAnalyticFHNumericFuncNoScale,
        FGHNumericNoScale,
        UndefinedFDOpt;


        public static EFDOpt lookup(int n) {
            if (n >= 0 && n < EFDOpt.values().length - 1) {
                return EFDOpt.values()[n];
            }
            return UndefinedFDOpt;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EstrictSingleton {
        FirstRecord,
        Error,
        UndefinedstrictSingleton;


        public static EstrictSingleton lookup(int n) {
            if (n >= 0 && n < EstrictSingleton.values().length - 1) {
                return EstrictSingleton.values()[n];
            }
            return UndefinedstrictSingleton;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EgdxUels {
        squeezed("Squeezed"),
        full("Full"),
        UndefinedgdxUels(GAMSGlobals.EMPTY_STRING);

        private final String value;

        public static EgdxUels lookup(String string) {
            EgdxUels[] egdxUelsArray = EgdxUels.values();
            EgdxUels egdxUels = UndefinedgdxUels;
            boolean bl = false;
            int n = 0;
            while (!bl && n < egdxUelsArray.length) {
                if (string.equals(egdxUelsArray[n].value())) {
                    bl = true;
                    continue;
                }
                ++n;
            }
            if (bl) {
                egdxUels = egdxUelsArray[n];
            }
            return egdxUels;
        }

        public String value() {
            return this.value;
        }

        private EgdxUels(String string2) {
            this.value = string2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ENoNewVarEqu {
        AllowNewVarEqu,
        DoNotAllowNewVarEqu,
        UndefinedNoNewVarEqu;


        public static ENoNewVarEqu lookup(int n) {
            if (n >= 0 && n < ENoNewVarEqu.values().length - 1) {
                return ENoNewVarEqu.values()[n];
            }
            return UndefinedNoNewVarEqu;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EAppendExpand {
        Reset,
        Append,
        UndefinedAppendExpand;


        public static EAppendExpand lookup(int n) {
            if (n >= 0 && n < EAppendExpand.values().length - 1) {
                return EAppendExpand.values()[n];
            }
            return UndefinedAppendExpand;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EgdxConvert {
        Version5("v5"),
        Version6("v6"),
        Version7("v7"),
        UndefinedgdxConvert(GAMSGlobals.EMPTY_STRING);

        private final String value;

        public static EgdxConvert lookup(String string) {
            EgdxConvert[] egdxConvertArray = EgdxConvert.values();
            EgdxConvert egdxConvert = UndefinedgdxConvert;
            boolean bl = false;
            int n = 0;
            while (!bl && n < egdxConvertArray.length) {
                if (string.equals(egdxConvertArray[n].value())) {
                    bl = true;
                    continue;
                }
                ++n;
            }
            if (bl) {
                egdxConvert = egdxConvertArray[n];
            }
            return egdxConvert;
        }

        public String value() {
            return this.value;
        }

        private EgdxConvert(String string2) {
            this.value = string2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EgdxCompress {
        DoNotCompressGDX,
        CompressGDX,
        UndefinedgdxCompress;


        public static EgdxCompress lookup(int n) {
            if (n >= 0 && n < EgdxCompress.values().length - 1) {
                return EgdxCompress.values()[n];
            }
            return UndefinedgdxCompress;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EZeroResRep {
        NoWarning,
        IssueWarning,
        UndefinedZeroResRep;


        public static EZeroResRep lookup(int n) {
            if (n >= 0 && n < EZeroResRep.values().length - 1) {
                return EZeroResRep.values()[n];
            }
            return UndefinedZeroResRep;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ESys11 {
        AutomaticOptimization,
        NoOptimization,
        AlwaysOptimize,
        UndefinedSys11;


        public static ESys11 lookup(int n) {
            if (n >= 0 && n < ESys11.values().length - 1) {
                return ESys11.values()[n];
            }
            return UndefinedSys11;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ESys10 {
        Disable,
        Enable,
        UndefinedSys10;


        public static ESys10 lookup(int n) {
            if (n >= 0 && n < ESys10.values().length - 1) {
                return ESys10.values()[n];
            }
            return UndefinedSys10;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ESolveLink {
        ChainScript,
        CallScript,
        CallModule,
        AsyncGrid,
        AsyncSimulate,
        LoadLibrary,
        LoadLibraryAsync,
        LoadLibraryAsyncSimulate,
        UndefinedSolveLink;


        public static ESolveLink lookup(int n) {
            if (n >= 0 && n < ESolveLink.values().length - 1) {
                return ESolveLink.values()[n];
            }
            return UndefinedSolveLink;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ESavePoint {
        NoPointFile,
        LastSolvePointFile,
        EverySolvePointFile,
        UndefinedSavePoint;


        public static ESavePoint lookup(int n) {
            if (n >= 0 && n < ESavePoint.values().length - 1) {
                return ESavePoint.values()[n];
            }
            return UndefinedSavePoint;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EFileCase {
        DefaultCase,
        UpperCase,
        LowerCase,
        UndefinedFileCase;


        public static EFileCase lookup(int n) {
            if (n >= 0 && n < EFileCase.values().length - 1) {
                return EFileCase.values()[n];
            }
            return UndefinedFileCase;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EInteractiveSolver {
        NoInteraction,
        AllowInteraction,
        UndefinedInteractiveSolver;


        public static EInteractiveSolver lookup(int n) {
            if (n >= 0 && n < EInteractiveSolver.values().length - 1) {
                return EInteractiveSolver.values()[n];
            }
            return UndefinedInteractiveSolver;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EExecMode {
        EverythingAllowed,
        InteractiveShellsProhibited,
        CallAndExecuteProhibited,
        EchoAndPutOnlyToWorkdir,
        EchoAndPutProhibited,
        UndefinedExecMode;


        public static EExecMode lookup(int n) {
            if (n >= 0 && n < EExecMode.values().length - 1) {
                return EExecMode.values()[n];
            }
            return UndefinedExecMode;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EOn115 {
        NoMessages,
        IssueMessages,
        UndefinedOn115;


        public static EOn115 lookup(int n) {
            if (n >= 0 && n < EOn115.values().length - 1) {
                return EOn115.values()[n];
            }
            return UndefinedOn115;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EHoldFixed {
        FixedVarsNotTreatedAsConstants,
        FixedVarsTreatedAsConstants,
        UndefinedHoldFixed;


        public static EHoldFixed lookup(int n) {
            if (n >= 0 && n < EHoldFixed.values().length - 1) {
                return EHoldFixed.values()[n];
            }
            return UndefinedHoldFixed;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ESolPrint {
        RemoveSolLstFollowingSolves,
        IncludeSolLstFollowingSolves,
        SuppressAllSolInfo,
        UndefinedSolPrint;


        public static ESolPrint lookup(int n) {
            if (n >= 0 && n < ESolPrint.values().length - 1) {
                return ESolPrint.values()[n];
            }
            return UndefinedSolPrint;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ESysOut {
        SuppressAdditionalSolverOutput,
        IncludeAdditionalSolverOutput,
        UndefinedSysOut;


        public static ESysOut lookup(int n) {
            if (n >= 0 && n < ESysOut.values().length - 1) {
                return ESysOut.values()[n];
            }
            return UndefinedSysOut;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ETraceOpt {
        SolverAndGAMSStepTraceWOHeaders,
        SolverAndGAMSStepTrace,
        SolverStepTraceOnly,
        TraceFileFormatGAMSPerformanceWorld,
        TraceFileFormatSupportingNLPEC,
        TraceFileWithAllAvailableTraceFields,
        UndefinedTraceOpt;


        public static ETraceOpt lookup(int n) {
            if (n >= 0 && n < ETraceOpt.values().length - 1) {
                return ETraceOpt.values()[n];
            }
            return UndefinedTraceOpt;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EKeep {
        DeleteProcDir,
        KeepProcDir,
        UndefinedKeep;


        public static EKeep lookup(int n) {
            if (n >= 0 && n < EKeep.values().length - 1) {
                return EKeep.values()[n];
            }
            return UndefinedKeep;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ECharSet {
        LimitedGAMSCharSet,
        AnyChar,
        UndefinedCharSet;


        public static ECharSet lookup(int n) {
            if (n >= 0 && n < ECharSet.values().length - 1) {
                return ECharSet.values()[n];
            }
            return UndefinedCharSet;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EStringChk {
        NoError,
        Error,
        NoErrorRemoveSymbol,
        UndefinedStringChk;


        public static EStringChk lookup(int n) {
            if (n >= 0 && n < EStringChk.values().length - 1) {
                return EStringChk.values()[n];
            }
            return UndefinedStringChk;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EErrMsg {
        EndOfCompilerListing,
        FollowingError,
        Suppress,
        UndefinedErrMsg;


        public static EErrMsg lookup(int n) {
            if (n >= 0 && n < EErrMsg.values().length - 1) {
                return EErrMsg.values()[n];
            }
            return UndefinedErrMsg;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EDumpOpt {
        No,
        RefDataOriginalSetElementNames,
        RefDataNewSetElementNames,
        RefDataNewSetElementNamesDropSymbolText,
        RefSymbol,
        Deprecated_10,
        InputFileWOComments,
        Deprecated_12,
        Deprecated_19,
        Deprecated_20,
        InputFileWithComments,
        UndefinedDumpOpt;


        public static EDumpOpt lookup(int n) {
            if (n >= 0 && n < EDumpOpt.values().length - 1) {
                return EDumpOpt.values()[n];
            }
            return UndefinedDumpOpt;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EForceWork {
        NoTranslation,
        TryTranslation,
        UndefinedForceWork;


        public static EForceWork lookup(int n) {
            if (n >= 0 && n < EForceWork.values().length - 1) {
                return EForceWork.values()[n];
            }
            return UndefinedForceWork;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EDumpParms {
        No,
        AcceptedParameters,
        FileOperationsAcceptedParameters,
        UndefinedDumpParms;


        public static EDumpParms lookup(int n) {
            if (n >= 0 && n < EDumpParms.values().length - 1) {
                return EDumpParms.values()[n];
            }
            return UndefinedDumpParms;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ECase {
        MixedCase,
        UpperCase,
        UndefinedCase;


        public static ECase lookup(int n) {
            if (n >= 0 && n < ECase.values().length - 1) {
                return ECase.values()[n];
            }
            return UndefinedCase;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EIntVarUp {
        INF,
        Pass100ToSolver,
        INFandLog,
        Pass100ToSolverAndError,
        UndefinedIntVarUp;


        public static EIntVarUp lookup(int n) {
            if (n >= 0 && n < EIntVarUp.values().length - 1) {
                return EIntVarUp.values()[n];
            }
            return UndefinedIntVarUp;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ETFormat {
        Colon,
        Dot,
        UndefinedTFormat;


        public static ETFormat lookup(int n) {
            if (n >= 0 && n < ETFormat.values().length - 1) {
                return ETFormat.values()[n];
            }
            return UndefinedTFormat;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EDFormat {
        Slash,
        Dot,
        Dash,
        UndefinedDFormat;


        public static EDFormat lookup(int n) {
            if (n >= 0 && n < EDFormat.values().length - 1) {
                return EDFormat.values()[n];
            }
            return UndefinedDFormat;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ESuppress {
        StandardCompilerListing,
        SuppressCompilerListing,
        UndefinedSuppress;


        public static ESuppress lookup(int n) {
            if (n >= 0 && n < ESuppress.values().length - 1) {
                return ESuppress.values()[n];
            }
            return UndefinedSuppress;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EStepSum {
        NoStepSummmary,
        StepSummary,
        UndefinedStepSum;


        public static EStepSum lookup(int n) {
            if (n >= 0 && n < EStepSum.values().length - 1) {
                return EStepSum.values()[n];
            }
            return UndefinedStepSum;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EAppendOut {
        Reset,
        Append,
        UndefinedAppendOut;


        public static EAppendOut lookup(int n) {
            if (n >= 0 && n < EAppendOut.values().length - 1) {
                return EAppendOut.values()[n];
            }
            return UndefinedAppendOut;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ELogLine {
        NoTracing,
        MinimumTracing,
        Automatic,
        UndefinedLogLine;


        public static ELogLine lookup(int n) {
            if (n >= 0 && n < ELogLine.values().length - 1) {
                return ELogLine.values()[n];
            }
            return UndefinedLogLine;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EAction {
        RestartAfterSolve("R"),
        CompileOnly("C"),
        ExecuteOnly("E"),
        CompileAndExecute("CE"),
        GlueCodeGeneration("G"),
        TraceReport("GT"),
        UndefinedAction(GAMSGlobals.EMPTY_STRING);

        private final String value;

        public static EAction lookup(String string) {
            EAction[] eActionArray = EAction.values();
            EAction eAction = UndefinedAction;
            boolean bl = false;
            int n = 0;
            while (!bl && n < eActionArray.length) {
                if (string.equals(eActionArray[n].value())) {
                    bl = true;
                    continue;
                }
                ++n;
            }
            if (bl) {
                eAction = eActionArray[n];
            }
            return eAction;
        }

        public String value() {
            return this.value;
        }

        private EAction(String string2) {
            this.value = string2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EPageContr {
        NoPageContrWithPadding,
        FortranStyle,
        NoPageContrNoPadding,
        FormfeedCharNewPage,
        UndefinedPageContr;


        public static EPageContr lookup(int n) {
            if (n >= 0 && n < EPageContr.values().length - 1) {
                return EPageContr.values()[n];
            }
            return UndefinedPageContr;
        }

        public int value() {
            return this.ordinal();
        }
    }
}

