/*
 * Decompiled with CFR 0.152.
 */
package com.gams.api;

import com.gams.api.GAMSDatabase;
import com.gams.api.GAMSException;
import com.gams.api.GAMSGlobals;
import com.gams.api.GAMSSet;
import com.gams.api.GAMSSymbolDomainViolation;
import com.gams.api.GAMSSymbolIterator;
import com.gams.api.GAMSSymbolRecord;
import com.gams.api.gmd;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GAMSSymbol<T extends GAMSSymbolRecord>
implements Iterable<T> {
    GAMSDatabase symDatabase = null;
    String symName = new String();
    String symText = new String();
    long symPtr = 0L;
    int symDimension = 0;
    GAMSGlobals.EquType symEquType = GAMSGlobals.EquType.UNDEFINED_TYPE;
    GAMSGlobals.VarType symVarType = GAMSGlobals.VarType.UNDEFINED_TYPE;
    List<Object> symDomains = null;
    List<String> symDomainsAsStrings = null;
    protected long currentItrPtr = 0L;

    protected GAMSSymbol(GAMSDatabase gAMSDatabase, long l) {
        double[] dArray;
        int[] nArray;
        String[] stringArray;
        assert (gAMSDatabase != null);
        gAMSDatabase.dbWorkspace.debugMessage("--- Entering GAMSSymbol constructor ---", GAMSGlobals.DebugLevel.VERBOSE.value());
        assert (!gAMSDatabase.isDisposed());
        if (l <= 0L) {
            throw new GAMSException("Could not create a GAMSSymbol, symbol does not exist");
        }
        this.setSymPtr(l);
        this.symDatabase = gAMSDatabase;
        int[] nArray2 = new int[]{0};
        this.symDatabase.checkForGMDError(this.symDatabase.GMD().SymbolType(this.getSymPtr(), nArray2));
        this.setSymVarType(GAMSGlobals.VarType.lookup(nArray2[0]));
        String[] stringArray2 = new String[]{GAMSGlobals.EMPTY_STRING};
        int[] nArray3 = new int[]{0};
        double[] dArray2 = new double[]{0.0};
        this.symDatabase.checkForGMDError(this.symDatabase.GMD().SymbolInfo(this.getSymPtr(), 0, nArray3, dArray2, stringArray2));
        this.symName = stringArray2[0];
        String[] stringArray3 = new String[]{GAMSGlobals.EMPTY_STRING};
        int[] nArray4 = new int[]{0};
        double[] dArray3 = new double[]{0.0};
        this.symDatabase.checkForGMDError(this.symDatabase.GMD().SymbolInfo(this.getSymPtr(), 1, nArray4, dArray3, stringArray3));
        this.symDimension = nArray4[0];
        GAMSGlobals.DataType dataType = GAMSGlobals.DataType.lookup(nArray2[0]);
        if (dataType == GAMSGlobals.DataType.EQU || dataType == GAMSGlobals.DataType.VAR) {
            stringArray = new String[]{GAMSGlobals.EMPTY_STRING};
            nArray = new int[]{0};
            dArray = new double[]{0.0};
            this.symDatabase.checkForGMDError(this.symDatabase.GMD().SymbolInfo(this.getSymPtr(), 4, nArray, dArray, stringArray));
            if (dataType == GAMSGlobals.DataType.EQU) {
                this.symEquType = GAMSGlobals.EquType.lookup(nArray[0]);
            } else {
                this.setSymVarType(GAMSGlobals.VarType.lookup(nArray[0]));
            }
        }
        stringArray = new String[]{GAMSGlobals.EMPTY_STRING};
        nArray = new int[]{0};
        dArray = new double[]{0.0};
        this.symDatabase.checkForGMDError(this.symDatabase.GMD().SymbolInfo(this.getSymPtr(), 5, nArray, dArray, stringArray));
        this.symText = stringArray[0];
    }

    protected GAMSSymbol(GAMSDatabase gAMSDatabase, String string, int n, String string2) {
        assert (gAMSDatabase != null);
        gAMSDatabase.dbWorkspace.debugMessage("--- Entering GAMSSymbol constructor ---", GAMSGlobals.DebugLevel.VERBOSE.value());
        assert (!gAMSDatabase.isDisposed());
        if (string == null) {
            throw new GAMSException("Could not create a symbol with NULL identifier.");
        }
        if (n < 0 || n > 20) {
            throw new GAMSException("Invalid dimension for creating a GAMSSymbol object, specified dimension is out of range [0,20]");
        }
        this.symDatabase = gAMSDatabase;
        this.symName = string;
        this.symDimension = n;
        this.symText = string2;
    }

    protected abstract T CheckAndReturnRecord(long var1);

    public T getFirstRecord() {
        long[] lArray = new long[]{0L};
        this.symDatabase.checkForGMDError(this.symDatabase.GMD().FindFirstRecord(this.symPtr, lArray));
        this.currentItrPtr = lArray[0];
        T t = this.CheckAndReturnRecord(this.currentItrPtr);
        return t;
    }

    public T getFirstRecord(String ... stringArray) {
        if (stringArray.length != this.symDimension) {
            throw new GAMSException("Could not get the first record of [" + this.symName + "] with different dimensions: [" + stringArray.length + "] and [" + this.symDimension + "]");
        }
        long[] lArray = new long[]{0L};
        this.symDatabase.checkForGMDError(this.symDatabase.GMD().FindFirstRecordSlice(this.symPtr, stringArray, lArray));
        this.currentItrPtr = lArray[0];
        T t = this.CheckAndReturnRecord(this.currentItrPtr);
        return t;
    }

    public T getLastRecord() {
        long[] lArray = new long[]{0L};
        this.symDatabase.checkForGMDError(this.symDatabase.GMD().FindLastRecord(this.symPtr, lArray));
        this.currentItrPtr = lArray[0];
        T t = this.CheckAndReturnRecord(this.currentItrPtr);
        return t;
    }

    public T getLastRecord(String ... stringArray) {
        if (stringArray.length != this.symDimension) {
            throw new GAMSException("Could not get the last record of [" + this.symName + "] with different dimensions: [" + stringArray.length + "] and [" + this.symDimension + "]");
        }
        long[] lArray = new long[]{0L};
        this.symDatabase.checkForGMDError(this.symDatabase.GMD().FindLastRecordSlice(this.symPtr, stringArray, lArray));
        this.currentItrPtr = lArray[0];
        T t = this.CheckAndReturnRecord(this.currentItrPtr);
        return t;
    }

    public T findRecord(String ... stringArray) {
        if (this.symDatabase.isDisposed()) {
            throw new GAMSException("The database of this symbol [" + this.symName + "] has already been disposed, resources are no longer available");
        }
        this.invalidateNullKeys(stringArray);
        this.currentItrPtr = this.FindSymIterationPtr(stringArray);
        if (this.currentItrPtr == 0L) {
            StringBuffer stringBuffer = new StringBuffer(GAMSGlobals.EMPTY_STRING);
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (i + 1 >= stringArray.length) continue;
                stringBuffer.append(",");
            }
            throw new GAMSException("Could not find record [" + stringBuffer.toString() + "] from symbol [" + this.symName + "]");
        }
        T t = this.CheckAndReturnRecord(this.currentItrPtr);
        return t;
    }

    long FindSymIterationPtr(String ... stringArray) {
        long[] lArray = new long[]{0L};
        this.symDatabase.checkForGMDError(this.symDatabase.GMD().FindRecord(this.getSymPtr(), stringArray, lArray));
        return lArray[0];
    }

    void invalidateNullKeys(String ... stringArray) {
        if (stringArray == null) {
            throw new GAMSException("Could not find a GAMSSymbol [" + this.symName + "] with a null reference");
        }
        if (stringArray.length != this.symDimension) {
            throw new GAMSException("Could not find a GAMSSymbol [" + this.symName + "] with different dimensions: [" + stringArray.length + "] and [" + this.symDimension + "]");
        }
        for (String string : stringArray) {
            if (string != null) continue;
            throw new GAMSException("Could not find a record of [" + this.symName + "] with a null key reference");
        }
    }

    long getSymPtr() {
        return this.symPtr;
    }

    void setSymPtr(long l) {
        this.symPtr = l;
    }

    GAMSGlobals.VarType getSymVarType() {
        return this.symVarType;
    }

    void setSymVarType(GAMSGlobals.VarType varType) {
        this.symVarType = varType;
    }

    GAMSGlobals.EquType getSymEquType() {
        return this.symEquType;
    }

    void setSymEquType(GAMSGlobals.EquType equType) {
        this.symEquType = equType;
    }

    public T addRecord(Vector<String> vector) {
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = vector.get(i);
        }
        return this.addRecord(stringArray);
    }

    public T addRecord(String ... stringArray) {
        if (this.symDatabase.dbRecordLock) {
            throw new GAMSException("Could not add data records to record-locked database");
        }
        this.invalidateNullKeys(stringArray);
        long[] lArray = new long[]{0L};
        this.symDatabase.checkForGMDError(this.symDatabase.GMD().AddRecord(this.getSymPtr(), stringArray, lArray));
        if (lArray[0] == 0L) {
            StringBuffer stringBuffer = new StringBuffer(GAMSGlobals.EMPTY_STRING);
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (i + 1 >= stringArray.length) continue;
                stringBuffer.append(",");
            }
            throw new GAMSException("Could not add record [" + stringBuffer.toString() + "] into symbol [" + this.symName + "]");
        }
        this.currentItrPtr = lArray[0];
        T t = this.CheckAndReturnRecord(this.currentItrPtr);
        return t;
    }

    public T mergeRecord(String ... stringArray) {
        this.invalidateNullKeys(stringArray);
        long[] lArray = new long[]{0L};
        this.symDatabase.GMD().FindRecord(this.getSymPtr(), stringArray, lArray);
        T t = null;
        if (lArray[0] != 0L) {
            this.currentItrPtr = lArray[0];
            t = this.CheckAndReturnRecord(this.currentItrPtr);
        } else {
            t = this.addRecord(stringArray);
        }
        return t;
    }

    public boolean deleteRecord(String ... stringArray) {
        if (this.symDatabase.dbRecordLock) {
            throw new GAMSException("Could not remove data record from record-locked database [" + this.symDatabase.getName() + "]");
        }
        this.invalidateNullKeys(stringArray);
        long[] lArray = new long[]{0L};
        this.symDatabase.GMD().FindRecord(this.symPtr, stringArray, lArray);
        if (lArray[0] == 0L) {
            return false;
        }
        this.symDatabase.checkForGMDError(this.symDatabase.GMD().DeleteRecord(lArray[0]));
        this.symDatabase.checkForGMDError(gmd.FreeSymbolIterator(lArray[0]));
        return true;
    }

    public boolean clear() {
        if (this.symDatabase.dbRecordLock) {
            throw new GAMSException("Could not remove data records from record-locked database [" + this.symDatabase.getName() + "]");
        }
        return this.symDatabase.GMD().ClearSymbol(this.symPtr);
    }

    @Deprecated
    public void compact() {
    }

    public void copySymbol(GAMSSymbol<?> gAMSSymbol) {
        if (gAMSSymbol.symDatabase.dbRecordLock) {
            throw new GAMSException("Could not copy symbol, target symbol is contained in a record-locked database [" + this.symDatabase.getName() + "]");
        }
        if (this.symDatabase.isDisposed()) {
            throw new GAMSException("Source GAMSDatabase [" + this.symDatabase.getName() + "] has already been disposed, resources are no longer available");
        }
        if (gAMSSymbol.symDatabase.isDisposed()) {
            throw new GAMSException("Target GAMSDatabase [" + gAMSSymbol.symDatabase.getName() + "] has already been disposed, resources are no longer available");
        }
        this.symDatabase.checkForGMDError(this.symDatabase.GMD().CopySymbol(gAMSSymbol.symPtr, this.symPtr));
    }

    public GAMSDatabase getDatabase() {
        return this.symDatabase;
    }

    public int getDimension() {
        return this.symDimension;
    }

    public String getName() {
        return this.symName;
    }

    public String getText() {
        return this.symText;
    }

    public int getNumberOfRecords() {
        String[] stringArray = new String[]{GAMSGlobals.EMPTY_STRING};
        int[] nArray = new int[]{0};
        double[] dArray = new double[]{0.0};
        this.symDatabase.GMD().SymbolInfo(this.getSymPtr(), 3, nArray, dArray, stringArray);
        return nArray[0];
    }

    public List<Object> getDomains() {
        if (this.symDomains == null) {
            int n;
            long[] lArray = new long[this.symDimension];
            String[] stringArray = new String[this.symDimension];
            for (n = 0; n < this.symDimension; ++n) {
                lArray[n] = 0L;
                stringArray[n] = GAMSGlobals.EMPTY_STRING;
            }
            this.symDomains = new ArrayList<Object>();
            if (this.symDimension == 0) {
                return this.symDomains;
            }
            this.symDatabase.checkForGMDError(this.symDatabase.GMD().GetDomain(this.symPtr, this.symDimension, lArray, stringArray));
            for (n = 0; n < this.symDimension; ++n) {
                if (lArray[n] != 0L) {
                    if (lArray[n] != this.symDatabase.getUniverse().getSymPtr()) {
                        this.symDomains.add(new GAMSSet(this.symDatabase, lArray[n]));
                        continue;
                    }
                    this.symDomains.add("*");
                    continue;
                }
                this.symDomains.add(stringArray[n]);
            }
        }
        return this.symDomains;
    }

    public List<String> getDomainsAsStrings() {
        if (this.symDomainsAsStrings == null) {
            int n;
            long[] lArray = new long[this.symDimension];
            String[] stringArray = new String[this.symDimension];
            for (n = 0; n < this.symDimension; ++n) {
                lArray[n] = 0L;
                stringArray[n] = GAMSGlobals.EMPTY_STRING;
            }
            this.symDomainsAsStrings = new ArrayList<String>();
            if (this.symDimension == 0) {
                return this.symDomainsAsStrings;
            }
            this.symDatabase.checkForGMDError(this.symDatabase.GMD().GetDomain(this.symPtr, this.symDimension, lArray, stringArray));
            for (n = 0; n < this.symDimension; ++n) {
                this.symDomainsAsStrings.add(stringArray[n]);
            }
        }
        return this.symDomainsAsStrings;
    }

    public boolean checkDomains() {
        boolean[] blArray = new boolean[]{false};
        this.symDatabase.checkForGMDError(this.symDatabase.GMD().CheckSymbolDV(this.symPtr, blArray));
        return !blArray[0];
    }

    public List<GAMSSymbolDomainViolation> getSymbolDomainViolations(int n) {
        return this.getSymbolDVs(false, n);
    }

    List<GAMSSymbolDomainViolation> getSymbolDVs(boolean bl, int n) {
        ArrayList<GAMSSymbolDomainViolation> arrayList = new ArrayList<GAMSSymbolDomainViolation>();
        long[] lArray = new long[]{0L};
        boolean[] blArray = new boolean[]{false};
        this.symDatabase.checkForGMDError(this.symDatabase.GMD().GetFirstDVInSymbol(this.symPtr, lArray));
        if (lArray[0] != 0L) {
            blArray[0] = true;
        }
        while (blArray[0] && (n == 0 || arrayList.size() < n)) {
            int[] nArray = new int[this.symDimension];
            boolean[] blArray2 = new boolean[this.symDimension];
            long[] lArray2 = new long[]{0L};
            this.symDatabase.checkForGMDError(this.symDatabase.GMD().GetDVSymbolRecord(lArray[0], lArray2));
            this.symDatabase.checkForGMDError(this.symDatabase.GMD().GetDVIndicator(lArray[0], nArray));
            for (int i = 0; i < this.symDimension; ++i) {
                blArray2[i] = nArray[i] != 0;
            }
            T t = this.CheckAndReturnRecord(lArray2[0]);
            arrayList.add(new GAMSSymbolDomainViolation(blArray2, (GAMSSymbolRecord)t));
            this.symDatabase.checkForGMDError(this.symDatabase.GMD().MoveNextDVInSymbol(lArray[0], blArray));
        }
        if (!bl) {
            this.symDatabase.checkForGMDError(this.symDatabase.GMD().DomainCheckDone());
            this.symDatabase.checkForGMDError(this.symDatabase.GMD().FreeDVHandle(lArray[0]));
        }
        return arrayList;
    }

    long getCurrentItrPtr() {
        return this.currentItrPtr;
    }

    void setCurrentItrPtr(long l) {
        this.currentItrPtr = l;
    }

    @Override
    public Iterator<T> iterator() {
        return new GAMSSymbolIterator(this);
    }
}

