/*
 * Decompiled with CFR 0.152.
 */
package com.gams.api;

import com.gams.api.GAMSException;
import com.gams.api.GAMSSymbol;
import com.gams.api.GAMSSymbolRecord;
import com.gams.api.gmd;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GAMSSymbolIterator<T extends GAMSSymbolRecord>
implements Iterator<T> {
    GAMSSymbol<T> symbol;
    private long symItrPtr = 0L;
    private boolean removeable = false;

    GAMSSymbolIterator(GAMSSymbol<T> gAMSSymbol) {
        this.symbol = gAMSSymbol;
        this.symItrPtr = 0L;
        this.removeable = false;
    }

    @Override
    public boolean hasNext() {
        if (this.symbol.getNumberOfRecords() == 0) {
            return false;
        }
        gmd gmd2 = this.symbol.symDatabase.GMD();
        if (this.symItrPtr <= 0L) {
            return true;
        }
        return this.symbol.symDatabase.GMD().RecordHasNext(this.symItrPtr);
    }

    @Override
    public T next() {
        long[] lArray;
        gmd gmd2 = this.symbol.symDatabase.GMD();
        if (this.symItrPtr <= 0L) {
            lArray = new long[]{0L};
            this.checkErrorForNext(gmd2.FindFirstRecord(this.symbol.symPtr, lArray));
            this.symItrPtr = lArray[0];
        } else {
            this.checkErrorForNext(gmd2.RecordMoveNext(this.symItrPtr));
        }
        lArray = new long[]{0L};
        this.checkErrorForNext(gmd2.CopySymbolIterator(this.symItrPtr, lArray));
        this.removeable = true;
        return this.symbol.CheckAndReturnRecord(lArray[0]);
    }

    @Override
    public void remove() {
        if (this.symbol.getNumberOfRecords() == 0) {
            throw new GAMSException("GAMSSymbol [" + this.symbol.getName() + "] has no record: could not remove a record");
        }
        gmd gmd2 = this.symbol.symDatabase.GMD();
        if (this.symbol.symDatabase.dbRecordLock) {
            throw new GAMSException("GAMSDatabase [" + this.symbol.symDatabase.getName() + "] has locked its records: could not remove a record");
        }
        if (!this.removeable) {
            throw new GAMSException("Removing a record from [" + this.symbol.getName() + "] is allowed only once per call to next(): could not remove a record");
        }
        this.checkErrorForRemove(gmd2.DeleteRecord(this.symItrPtr));
        this.checkErrorForRemove(gmd2.RecordMovePrev(this.symItrPtr));
        this.removeable = false;
    }

    private void checkErrorForNext(boolean bl) {
        if (!bl) {
            throw new GAMSException("Could not move to the next element of [" + this.symbol.getName() + "]  in database [" + this.symbol.symDatabase.getName() + "]");
        }
    }

    private void checkErrorForRemove(boolean bl) {
        if (!bl) {
            throw new GAMSException("Could not remove a record from [" + this.symbol.getName() + "] in database [" + this.symbol.symDatabase.getName() + "]");
        }
    }

    public void finalize() throws Throwable {
        try {
            block4: {
                if (this.symItrPtr == 0L) break block4;
                this.symbol.symDatabase.dbWorkspace.debugMessage("--- GAMSSymbolIterator.finalize() : free resources used by non-java library.", 3);
                gmd.FreeSymbolIterator(this.symItrPtr);
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }
}

