CREATE TABLE downloads (
    id          BIGINT        NOT NULL,
    filename    VARCHAR(256)  NOT NULL,
    description VARCHAR(1000) NOT NULL,
    filesize    INTEGER DEFAULT 0,
    content     BLOB,
    CONSTRAINT downloads_pk PRIMARY KEY (id),
    CONSTRAINT downloads_uk UNIQUE (filename)
);

CREATE TABLE downloads_audit (
    action    VARCHAR(256)         NOT NULL,
    timestamp DATE DEFAULT SYSDATE NOT NULL,
    username  VARCHAR(128),
    text      VARCHAR(1000)
);

CREATE SEQUENCE downloads_seq;