create sequence metadata_seq
  as bigint;

create table metadata (
  id   bigint generated by default as sequence metadata_seq,
  name varchar(256) not null,
  constraint metadata_id_pkey primary key (id)
);

create table metadata_entries (
  meta_id       bigint not null,
  idx           bigint not null,
  string_value  varchar(1000),
  numeric_value decimal(20, 10),
  boolean_value boolean,
  constraint metadata_entries_uniq unique (meta_id, idx)
);

create table run_meta (
  meta_id  bigint,
  scen_id  bigint,
  model_id bigint,
  version  bigint,
  constraint metadata_meta_id_fkey foreign key (meta_id) references metadata (id),
  constraint metadata_scen_id_fkey foreign key (scen_id) references scenario (id),
  constraint metadata_model_id_fkey foreign key (model_id) references model (id)
);