-- drop

ALTER TABLE change_log DROP CONSTRAINT change_log_annotation_log_fk;
ALTER TABLE change_log DROP CONSTRAINT change_log_run_fk;

ALTER TABLE annotation_log DROP PRIMARY KEY;
ALTER TABLE annotation_log DROP CONSTRAINT annotation_log_run_fk;

ALTER TABLE ix_set DROP CONSTRAINT set_run_fk;
ALTER TABLE ix_set_dim DROP CONSTRAINT set_dim_set_fk;
ALTER TABLE ix_set_dim DROP CONSTRAINT set_dim_idx_set_fk;
ALTER TABLE ix_set_blobstore DROP CONSTRAINT set_blobstore_set_fk;
ALTER TABLE ix_set DROP PRIMARY KEY;
ALTER TABLE ix_set_dim DROP PRIMARY KEY;
ALTER TABLE ix_set_blobstore DROP PRIMARY KEY;

ALTER TABLE ix_par DROP CONSTRAINT par_run_fk;
ALTER TABLE ix_par_dim DROP CONSTRAINT par_dim_par_fk;
ALTER TABLE ix_par_dim DROP CONSTRAINT par_dim_idxset_fk;
ALTER TABLE ix_par_blobstore DROP CONSTRAINT par_blobstore_par_fk;
ALTER TABLE ix_par DROP PRIMARY KEY;
ALTER TABLE ix_par_dim DROP PRIMARY KEY;
ALTER TABLE ix_par_blobstore DROP PRIMARY KEY;

ALTER TABLE ix_var DROP CONSTRAINT va_run_fk;
ALTER TABLE ix_var_dim DROP CONSTRAINT var_dim_var_fk;
ALTER TABLE ix_var_dim DROP CONSTRAINT var_dim_idx_set_fk;
ALTER TABLE ix_var_blobstore DROP CONSTRAINT var_blobstore_var_fk;
ALTER TABLE ix_var DROP PRIMARY KEY;
ALTER TABLE ix_var_dim DROP PRIMARY KEY;
ALTER TABLE ix_var_blobstore DROP PRIMARY KEY;

ALTER TABLE ix_equ DROP CONSTRAINT equ_run_fk;
ALTER TABLE ix_equ_dim DROP CONSTRAINT equ_dim_equ_fk;
ALTER TABLE ix_equ_dim DROP CONSTRAINT equ_dim_idxset_fk;
ALTER TABLE ix_equ_blobstore DROP CONSTRAINT equ_blobstore_equ_fk;
ALTER TABLE ix_equ DROP PRIMARY KEY;
ALTER TABLE ix_equ_dim DROP PRIMARY KEY;
ALTER TABLE ix_equ_blobstore DROP PRIMARY KEY;

ALTER TABLE ix_idxset DROP PRIMARY KEY;
ALTER TABLE ix_idxset DROP CONSTRAINT idxset_run_fk;
ALTER TABLE ix_key DROP PRIMARY KEY;
ALTER TABLE ix_key DROP CONSTRAINT key_fk;

ALTER TABLE iamc_tsdata DROP CONSTRAINT data_info_fk;
ALTER TABLE iamc_tsdata DROP PRIMARY KEY;
ALTER TABLE iamc_tsinfo DROP CONSTRAINT iamc_tsinfo_tsid_uk;
ALTER TABLE iamc_tsinfo DROP PRIMARY KEY;

-- create

ALTER TABLE annotation_log ADD CONSTRAINT annotation_log_pk PRIMARY KEY (annotationid);
ALTER TABLE annotation_log ADD CONSTRAINT annotation_log_runid_fk FOREIGN KEY (runid) REFERENCES run (id) ON DELETE CASCADE;

ALTER TABLE change_log ADD CONSTRAINT change_log_annotationid_fk FOREIGN KEY (annotationid) REFERENCES annotation_log (annotationid) ON DELETE CASCADE;
ALTER TABLE change_log ADD CONSTRAINT change_log_runid_fk FOREIGN KEY (runid) REFERENCES run (id) ON DELETE CASCADE;

ALTER TABLE ix_key ADD CONSTRAINT ix_key_pk PRIMARY KEY (runid, keyid);
ALTER TABLE ix_key ADD CONSTRAINT ix_key_runid_fk FOREIGN KEY (runid) REFERENCES run (id) ON DELETE CASCADE;

ALTER TABLE ix_idxset ADD CONSTRAINT ix_idxset_pk PRIMARY KEY (runid, name);
ALTER TABLE ix_idxset ADD CONSTRAINT ix_idxset_runid_fk FOREIGN KEY (runid) REFERENCES run (id) ON DELETE CASCADE;

ALTER TABLE ix_set ADD CONSTRAINT ix_set_pk PRIMARY KEY (runid, name);
ALTER TABLE ix_set ADD CONSTRAINT ix_set_runid_fk FOREIGN KEY (runid) REFERENCES run (id) ON DELETE CASCADE;
ALTER TABLE ix_set_dim ADD CONSTRAINT ix_set_dim_pk PRIMARY KEY (runid, name, idx);
ALTER TABLE ix_set_dim ADD CONSTRAINT ix_set_dim_runid_name_fk FOREIGN KEY (runid, name) REFERENCES ix_set (runid, name) ON DELETE CASCADE;
ALTER TABLE ix_set_dim ADD CONSTRAINT ix_set_dim_runid_idx_set_fk FOREIGN KEY (runid, idx_set) REFERENCES ix_idxset (runid, name) ON DELETE CASCADE;
ALTER TABLE ix_set_blobstore ADD CONSTRAINT ix_set_blobstore_pk PRIMARY KEY (runid, name);
ALTER TABLE ix_set_blobstore ADD CONSTRAINT ix_set_blobstore_runid_name_fk FOREIGN KEY (runid, name) REFERENCES ix_set (runid, name) ON DELETE CASCADE;

ALTER TABLE ix_par ADD CONSTRAINT ix_par_pk PRIMARY KEY (runid, name);
ALTER TABLE ix_par ADD CONSTRAINT ix_par_runid_fk FOREIGN KEY (runid) REFERENCES run (id) ON DELETE CASCADE;
ALTER TABLE ix_par_dim ADD CONSTRAINT ix_par_dim_pk PRIMARY KEY (runid, name, idx);
ALTER TABLE ix_par_dim ADD CONSTRAINT ix_par_dim_runid_name_fk FOREIGN KEY (runid, name) REFERENCES ix_par (runid, name) ON DELETE CASCADE;
ALTER TABLE ix_par_dim ADD CONSTRAINT ix_par_dim_runid_idx_set_fk FOREIGN KEY (runid, idx_set) REFERENCES ix_idxset (runid, name) ON DELETE CASCADE;
ALTER TABLE ix_par_blobstore ADD CONSTRAINT ix_par_blobstore_pk PRIMARY KEY (runid, name);
ALTER TABLE ix_par_blobstore ADD CONSTRAINT ix_par_blobstore_runid_name_fk FOREIGN KEY (runid, name) REFERENCES ix_par (runid, name) ON DELETE CASCADE;

ALTER TABLE ix_var ADD CONSTRAINT ix_var_pk PRIMARY KEY (runid, name);
ALTER TABLE ix_var ADD CONSTRAINT ix_var_runid_fk FOREIGN KEY (runid) REFERENCES run (id) ON DELETE CASCADE;
ALTER TABLE ix_var_dim ADD CONSTRAINT ix_var_dim_pk PRIMARY KEY (runid, name, idx);
ALTER TABLE ix_var_dim ADD CONSTRAINT ix_var_dim_runid_name_fk FOREIGN KEY (runid, name) REFERENCES ix_var (runid, name) ON DELETE CASCADE;
ALTER TABLE ix_var_dim ADD CONSTRAINT ix_var_dim_runid_idx_set_fk FOREIGN KEY (runid, idx_set) REFERENCES ix_idxset (runid, name) ON DELETE CASCADE;
ALTER TABLE ix_var_blobstore ADD CONSTRAINT ix_var_blobstore_pk PRIMARY KEY (runid, name);
ALTER TABLE ix_var_blobstore ADD CONSTRAINT ix_var_blobstore_runid_name_fk FOREIGN KEY (runid, name) REFERENCES ix_var (runid, name) ON DELETE CASCADE;

ALTER TABLE ix_equ ADD CONSTRAINT ix_equ_pk PRIMARY KEY (runid, name);
ALTER TABLE ix_equ ADD CONSTRAINT ix_equ_runid_fk FOREIGN KEY (runid) REFERENCES run (id) ON DELETE CASCADE;
ALTER TABLE ix_equ_dim ADD CONSTRAINT ix_equ_dim_pk PRIMARY KEY (runid, name, idx);
ALTER TABLE ix_equ_dim ADD CONSTRAINT ix_equ_dim_runid_name_fk FOREIGN KEY (runid, name) REFERENCES ix_equ (runid, name) ON DELETE CASCADE;
ALTER TABLE ix_equ_dim ADD CONSTRAINT ix_equ_dim_runid_idx_set_fk FOREIGN KEY (runid, idx_set) REFERENCES ix_idxset (runid, name) ON DELETE CASCADE;
ALTER TABLE ix_equ_blobstore ADD CONSTRAINT ix_equ_blobstore_pk PRIMARY KEY (runid, name);
ALTER TABLE ix_equ_blobstore ADD CONSTRAINT ix_equ_blobstore_runid_name_fk FOREIGN KEY (runid, name) REFERENCES ix_equ (runid, name) ON DELETE CASCADE;

ALTER TABLE iamc_tsinfo ADD CONSTRAINT iamc_tsinfo_pk UNIQUE (tsid);
ALTER TABLE iamc_tsinfo ADD CONSTRAINT iamc_tsinfo_uk1 UNIQUE (runid, node, key, time);
ALTER TABLE iamc_tsinfo ADD CONSTRAINT iamc_tsinfo_runid_fk FOREIGN KEY (runid) REFERENCES run(id) ON DELETE CASCADE;
ALTER TABLE iamc_tsinfo ADD CONSTRAINT iamc_tsinfo_key_fk FOREIGN KEY (key) REFERENCES iamc_key(keyid) ON DELETE CASCADE;
ALTER TABLE iamc_tsinfo ADD CONSTRAINT iamc_tsinfo_node_fk FOREIGN KEY (node) REFERENCES iamc_nodes(id) ON DELETE CASCADE;

ALTER TABLE iamc_tsdata ADD CONSTRAINT iamc_tsdata_pk UNIQUE (tsid,year);
ALTER TABLE iamc_tsdata ADD CONSTRAINT iamc_tsdata_tsid_fk FOREIGN KEY (tsid) REFERENCES iamc_tsinfo(tsid) ON DELETE CASCADE;