"use strict";
(self["webpackChunktvb_ext_xircuits"] = self["webpackChunktvb_ext_xircuits"] || []).push([["vendors-node_modules_projectstorm_react-diagrams-core_dist_index_js"],{

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/DiagramEngine.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/DiagramEngine.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DiagramEngine = void 0;
const NodeModel_1 = __webpack_require__(/*! ./entities/node/NodeModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node/NodeModel.js");
const geometry_1 = __webpack_require__(/*! @projectstorm/geometry */ "./node_modules/@projectstorm/geometry/dist/index.js");
const react_canvas_core_1 = __webpack_require__(/*! @projectstorm/react-canvas-core */ "webpack/sharing/consume/default/@projectstorm/react-canvas-core/@projectstorm/react-canvas-core?4a30");
/**
 * Passed as a parameter to the DiagramWidget
 */
class DiagramEngine extends react_canvas_core_1.CanvasEngine {
    constructor(options = {}) {
        super(options);
        this.maxNumberPointsPerLink = 1000;
        // create banks for the different factory types
        this.nodeFactories = new react_canvas_core_1.FactoryBank();
        this.linkFactories = new react_canvas_core_1.FactoryBank();
        this.portFactories = new react_canvas_core_1.FactoryBank();
        this.labelFactories = new react_canvas_core_1.FactoryBank();
        const setup = (factory) => {
            factory.registerListener({
                factoryAdded: (event) => {
                    event.factory.setDiagramEngine(this);
                },
                factoryRemoved: (event) => {
                    event.factory.setDiagramEngine(null);
                }
            });
        };
        setup(this.nodeFactories);
        setup(this.linkFactories);
        setup(this.portFactories);
        setup(this.labelFactories);
    }
    /**
     * Gets a model and element under the mouse cursor
     */
    getMouseElement(event) {
        var target = event.target;
        var diagramModel = this.model;
        //is it a port
        var element = react_canvas_core_1.Toolkit.closest(target, '.port[data-name]');
        if (element) {
            var nodeElement = react_canvas_core_1.Toolkit.closest(target, '.node[data-nodeid]');
            return diagramModel.getNode(nodeElement.getAttribute('data-nodeid')).getPort(element.getAttribute('data-name'));
        }
        //look for a point
        element = react_canvas_core_1.Toolkit.closest(target, '.point[data-id]');
        if (element) {
            return diagramModel.getLink(element.getAttribute('data-linkid')).getPointModel(element.getAttribute('data-id'));
        }
        //look for a link
        element = react_canvas_core_1.Toolkit.closest(target, '[data-linkid]');
        if (element) {
            return diagramModel.getLink(element.getAttribute('data-linkid'));
        }
        //look for a node
        element = react_canvas_core_1.Toolkit.closest(target, '.node[data-nodeid]');
        if (element) {
            return diagramModel.getNode(element.getAttribute('data-nodeid'));
        }
        return null;
    }
    //!-------------- FACTORIES ------------
    getNodeFactories() {
        return this.nodeFactories;
    }
    getLinkFactories() {
        return this.linkFactories;
    }
    getLabelFactories() {
        return this.labelFactories;
    }
    getPortFactories() {
        return this.portFactories;
    }
    getFactoryForNode(node) {
        if (typeof node === 'string') {
            return this.nodeFactories.getFactory(node);
        }
        return this.nodeFactories.getFactory(node.getType());
    }
    getFactoryForLink(link) {
        if (typeof link === 'string') {
            return this.linkFactories.getFactory(link);
        }
        return this.linkFactories.getFactory(link.getType());
    }
    getFactoryForLabel(label) {
        if (typeof label === 'string') {
            return this.labelFactories.getFactory(label);
        }
        return this.labelFactories.getFactory(label.getType());
    }
    getFactoryForPort(port) {
        if (typeof port === 'string') {
            return this.portFactories.getFactory(port);
        }
        return this.portFactories.getFactory(port.getType());
    }
    generateWidgetForLink(link) {
        return this.getFactoryForLink(link).generateReactWidget({ model: link });
    }
    generateWidgetForNode(node) {
        return this.getFactoryForNode(node).generateReactWidget({ model: node });
    }
    getNodeElement(node) {
        const selector = this.canvas.querySelector(`.node[data-nodeid="${node.getID()}"]`);
        if (selector === null) {
            throw new Error('Cannot find Node element with nodeID: [' + node.getID() + ']');
        }
        return selector;
    }
    getNodePortElement(port) {
        var selector = this.canvas.querySelector(`.port[data-name="${port.getName()}"][data-nodeid="${port.getParent().getID()}"]`);
        if (selector === null) {
            throw new Error('Cannot find Node Port element with nodeID: [' +
                port.getParent().getID() +
                '] and name: [' +
                port.getName() +
                ']');
        }
        return selector;
    }
    getPortCenter(port) {
        return this.getPortCoords(port).getOrigin();
    }
    /**
     * Calculate rectangular coordinates of the port passed in.
     */
    getPortCoords(port, element) {
        if (!this.canvas) {
            throw new Error('Canvas needs to be set first');
        }
        if (!element) {
            element = this.getNodePortElement(port);
        }
        const sourceRect = element.getBoundingClientRect();
        const point = this.getRelativeMousePoint({
            clientX: sourceRect.left,
            clientY: sourceRect.top
        });
        const zoom = this.model.getZoomLevel() / 100.0;
        return new geometry_1.Rectangle(point.x, point.y, sourceRect.width / zoom, sourceRect.height / zoom);
    }
    /**
     * Determine the width and height of the node passed in.
     * It currently assumes nodes have a rectangular shape, can be overriden for customised shapes.
     */
    getNodeDimensions(node) {
        if (!this.canvas) {
            return {
                width: 0,
                height: 0
            };
        }
        const nodeElement = this.getNodeElement(node);
        const nodeRect = nodeElement.getBoundingClientRect();
        return {
            width: nodeRect.width,
            height: nodeRect.height
        };
    }
    getBoundingNodesRect(nodes) {
        if (nodes) {
            if (nodes.length === 0) {
                return new geometry_1.Rectangle(0, 0, 0, 0);
            }
            return geometry_1.Polygon.boundingBoxFromPolygons(nodes.map((node) => node.getBoundingBox()));
        }
    }
    zoomToFitSelectedNodes(options) {
        const nodes = this.model
            .getSelectedEntities()
            .filter((entity) => entity instanceof NodeModel_1.NodeModel);
        this.zoomToFitNodes({
            margin: options.margin,
            maxZoom: options.maxZoom,
            nodes: nodes.length > 0 ? nodes : null
        });
    }
    zoomToFitNodes(options) {
        let margin = options || 0;
        let nodes = [];
        let maxZoom = null;
        if (!!options && typeof options == 'object') {
            margin = options.margin || 0;
            nodes = options.nodes || [];
            maxZoom = options.maxZoom || null;
        }
        // no node selected
        if (nodes.length === 0) {
            nodes = this.model.getNodes();
        }
        const nodesRect = this.getBoundingNodesRect(nodes);
        if (nodesRect) {
            // there is something we should zoom on
            let canvasRect = this.canvas.getBoundingClientRect();
            const calculate = (margin = 0) => {
                // work out zoom
                const xFactor = this.canvas.clientWidth / (nodesRect.getWidth() + margin * 2);
                const yFactor = this.canvas.clientHeight / (nodesRect.getHeight() + margin * 2);
                let zoomFactor = xFactor < yFactor ? xFactor : yFactor;
                if (maxZoom && zoomFactor > maxZoom) {
                    zoomFactor = maxZoom;
                }
                return {
                    zoom: zoomFactor,
                    x: canvasRect.width / 2 -
                        ((nodesRect.getWidth() + margin * 2) * zoomFactor) / 2 +
                        margin -
                        nodesRect.getTopLeft().x,
                    y: canvasRect.height / 2 -
                        ((nodesRect.getHeight() + margin * 2) * zoomFactor) / 2 +
                        margin -
                        nodesRect.getTopLeft().y
                };
            };
            let params = calculate(0);
            if (margin) {
                if (params.x < margin || params.y < margin) {
                    params = calculate(margin);
                }
            }
            // apply
            this.model.setZoomLevel(params.zoom * 100);
            this.model.setOffset(params.x, params.y);
            this.repaintCanvas();
        }
    }
    getMaxNumberPointsPerLink() {
        return this.maxNumberPointsPerLink;
    }
    setMaxNumberPointsPerLink(max) {
        this.maxNumberPointsPerLink = max;
    }
}
exports.DiagramEngine = DiagramEngine;
//# sourceMappingURL=DiagramEngine.js.map

/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/label/LabelModel.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/label/LabelModel.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LabelModel = void 0;
const react_canvas_core_1 = __webpack_require__(/*! @projectstorm/react-canvas-core */ "webpack/sharing/consume/default/@projectstorm/react-canvas-core/@projectstorm/react-canvas-core?4a30");
class LabelModel extends react_canvas_core_1.BaseModel {
    constructor(options) {
        super(Object.assign(Object.assign({}, options), { offsetX: options.offsetX || 0, offsetY: options.offsetY || 0 }));
    }
    deserialize(event) {
        super.deserialize(event);
        this.options.offsetX = event.data.offsetX;
        this.options.offsetY = event.data.offsetY;
    }
    serialize() {
        return Object.assign(Object.assign({}, super.serialize()), { offsetX: this.options.offsetX, offsetY: this.options.offsetY });
    }
}
exports.LabelModel = LabelModel;
//# sourceMappingURL=LabelModel.js.map

/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/label/LabelWidget.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/label/LabelWidget.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LabelWidget = void 0;
const React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
const styled_1 = __webpack_require__(/*! @emotion/styled */ "webpack/sharing/consume/default/@emotion/styled/@emotion/styled?ffb9");
var S;
(function (S) {
    S.Label = styled_1.default.div `
		display: inline-block;
		position: absolute;
	`;
    S.Foreign = styled_1.default.foreignObject `
		pointer-events: none;
		overflow: visible;
	`;
})(S || (S = {}));
class LabelWidget extends React.Component {
    constructor(props) {
        super(props);
        this.findPathAndRelativePositionToRenderLabel = (index) => {
            // an array to hold all path lengths, making sure we hit the DOM only once to fetch this information
            const link = this.props.label.getParent();
            const lengths = link.getRenderedPath().map((path) => path.getTotalLength());
            // calculate the point where we want to display the label
            let labelPosition = lengths.reduce((previousValue, currentValue) => previousValue + currentValue, 0) *
                (index / (link.getLabels().length + 1));
            // find the path where the label will be rendered and calculate the relative position
            let pathIndex = 0;
            while (pathIndex < link.getRenderedPath().length) {
                if (labelPosition - lengths[pathIndex] < 0) {
                    return {
                        path: link.getRenderedPath()[pathIndex],
                        position: labelPosition
                    };
                }
                // keep searching
                labelPosition -= lengths[pathIndex];
                pathIndex++;
            }
        };
        this.calculateLabelPosition = () => {
            const found = this.findPathAndRelativePositionToRenderLabel(this.props.index + 1);
            if (!found) {
                return;
            }
            const { path, position } = found;
            const labelDimensions = {
                width: this.ref.current.offsetWidth,
                height: this.ref.current.offsetHeight
            };
            const pathCentre = path.getPointAtLength(position);
            const labelCoordinates = {
                x: pathCentre.x - labelDimensions.width / 2 + this.props.label.getOptions().offsetX,
                y: pathCentre.y - labelDimensions.height / 2 + this.props.label.getOptions().offsetY
            };
            this.ref.current.style.transform = `translate(${labelCoordinates.x}px, ${labelCoordinates.y}px)`;
        };
        this.ref = React.createRef();
    }
    componentDidUpdate() {
        window.requestAnimationFrame(this.calculateLabelPosition);
    }
    componentDidMount() {
        window.requestAnimationFrame(this.calculateLabelPosition);
    }
    render() {
        const canvas = this.props.engine.getCanvas();
        return (React.createElement(S.Foreign, { key: this.props.label.getID(), width: canvas === null || canvas === void 0 ? void 0 : canvas.offsetWidth, height: canvas === null || canvas === void 0 ? void 0 : canvas.offsetHeight },
            React.createElement(S.Label, { ref: this.ref }, this.props.engine.getFactoryForLabel(this.props.label).generateReactWidget({ model: this.props.label }))));
    }
}
exports.LabelWidget = LabelWidget;
//# sourceMappingURL=LabelWidget.js.map

/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link-layer/LinkLayerFactory.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/link-layer/LinkLayerFactory.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LinkLayerFactory = void 0;
const React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
const react_canvas_core_1 = __webpack_require__(/*! @projectstorm/react-canvas-core */ "webpack/sharing/consume/default/@projectstorm/react-canvas-core/@projectstorm/react-canvas-core?4a30");
const LinkLayerModel_1 = __webpack_require__(/*! ./LinkLayerModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link-layer/LinkLayerModel.js");
const LinkLayerWidget_1 = __webpack_require__(/*! ./LinkLayerWidget */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link-layer/LinkLayerWidget.js");
class LinkLayerFactory extends react_canvas_core_1.AbstractReactFactory {
    constructor() {
        super('diagram-links');
    }
    generateModel(event) {
        return new LinkLayerModel_1.LinkLayerModel();
    }
    generateReactWidget(event) {
        return React.createElement(LinkLayerWidget_1.LinkLayerWidget, { layer: event.model, engine: this.engine });
    }
}
exports.LinkLayerFactory = LinkLayerFactory;
//# sourceMappingURL=LinkLayerFactory.js.map

/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link-layer/LinkLayerModel.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/link-layer/LinkLayerModel.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LinkLayerModel = void 0;
const react_canvas_core_1 = __webpack_require__(/*! @projectstorm/react-canvas-core */ "webpack/sharing/consume/default/@projectstorm/react-canvas-core/@projectstorm/react-canvas-core?4a30");
const LinkModel_1 = __webpack_require__(/*! ../link/LinkModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/LinkModel.js");
class LinkLayerModel extends react_canvas_core_1.LayerModel {
    constructor() {
        super({
            type: 'diagram-links',
            isSvg: true,
            transformed: true
        });
    }
    addModel(model) {
        if (!(model instanceof LinkModel_1.LinkModel)) {
            throw new Error('Can only add links to this layer');
        }
        model.registerListener({
            entityRemoved: () => {
                this.getParent().removeLink(model);
            }
        });
        super.addModel(model);
    }
    getLinks() {
        return this.getModels();
    }
    getChildModelFactoryBank(engine) {
        return engine.getLinkFactories();
    }
}
exports.LinkLayerModel = LinkLayerModel;
//# sourceMappingURL=LinkLayerModel.js.map

/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link-layer/LinkLayerWidget.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/link-layer/LinkLayerWidget.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LinkLayerWidget = void 0;
const React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
const styled_1 = __webpack_require__(/*! @emotion/styled */ "webpack/sharing/consume/default/@emotion/styled/@emotion/styled?ffb9");
const _ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const LinkWidget_1 = __webpack_require__(/*! ../link/LinkWidget */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/LinkWidget.js");
var S;
(function (S) {
    S.Container = styled_1.default.div ``;
})(S || (S = {}));
class LinkLayerWidget extends React.Component {
    render() {
        return (React.createElement(React.Fragment, null, 
        //only perform these actions when we have a diagram
        _.map(this.props.layer.getLinks(), (link) => {
            return React.createElement(LinkWidget_1.LinkWidget, { key: link.getID(), link: link, diagramEngine: this.props.engine });
        })));
    }
}
exports.LinkLayerWidget = LinkLayerWidget;
//# sourceMappingURL=LinkLayerWidget.js.map

/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/LinkModel.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/LinkModel.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LinkModel = void 0;
const PointModel_1 = __webpack_require__(/*! ./PointModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/PointModel.js");
const _ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const geometry_1 = __webpack_require__(/*! @projectstorm/geometry */ "./node_modules/@projectstorm/geometry/dist/index.js");
const react_canvas_core_1 = __webpack_require__(/*! @projectstorm/react-canvas-core */ "webpack/sharing/consume/default/@projectstorm/react-canvas-core/@projectstorm/react-canvas-core?4a30");
class LinkModel extends react_canvas_core_1.BaseModel {
    constructor(options) {
        super(options);
        this.points = [
            new PointModel_1.PointModel({
                link: this
            }),
            new PointModel_1.PointModel({
                link: this
            })
        ];
        this.sourcePort = null;
        this.targetPort = null;
        this.renderedPaths = [];
        this.labels = [];
    }
    getBoundingBox() {
        return geometry_1.Polygon.boundingBoxFromPoints(_.map(this.points, (point) => {
            return point.getPosition();
        }));
    }
    getSelectionEntities() {
        if (this.getTargetPort() && this.getSourcePort()) {
            return super.getSelectionEntities().concat(_.slice(this.points, 1, this.points.length - 1));
        }
        // allow selection of the first point
        if (!this.getSourcePort()) {
            return super.getSelectionEntities().concat(_.slice(this.points, 0, this.points.length - 1));
        }
        // allow selection of the last point
        if (!this.getTargetPort()) {
            return super.getSelectionEntities().concat(_.slice(this.points, 1, this.points.length));
        }
        return super.getSelectionEntities().concat(this.points);
    }
    deserialize(event) {
        super.deserialize(event);
        this.points = _.map(event.data.points || [], (point) => {
            var p = new PointModel_1.PointModel({
                link: this,
                position: new geometry_1.Point(point.x, point.y)
            });
            p.deserialize(Object.assign(Object.assign({}, event), { data: point }));
            return p;
        });
        //deserialize labels
        _.forEach(event.data.labels || [], (label) => {
            let labelOb = event.engine.getFactoryForLabel(label.type).generateModel({});
            labelOb.deserialize(Object.assign(Object.assign({}, event), { data: label }));
            this.addLabel(labelOb);
        });
        // these happen async, so we use the promises for these (they need to be done like this without the async keyword
        // because we need the deserailize method to finish for other methods while this happen
        if (event.data.target) {
            event.getModel(event.data.targetPort).then((model) => {
                this.setTargetPort(model);
            });
        }
        if (event.data.source) {
            event.getModel(event.data.sourcePort).then((model) => {
                this.setSourcePort(model);
            });
        }
    }
    getRenderedPath() {
        return this.renderedPaths;
    }
    setRenderedPaths(paths) {
        this.renderedPaths = paths;
    }
    serialize() {
        return Object.assign(Object.assign({}, super.serialize()), { source: this.sourcePort ? this.sourcePort.getParent().getID() : null, sourcePort: this.sourcePort ? this.sourcePort.getID() : null, target: this.targetPort ? this.targetPort.getParent().getID() : null, targetPort: this.targetPort ? this.targetPort.getID() : null, points: _.map(this.points, (point) => {
                return point.serialize();
            }), labels: _.map(this.labels, (label) => {
                return label.serialize();
            }) });
    }
    doClone(lookupTable = {}, clone) {
        clone.setPoints(_.map(this.getPoints(), (point) => {
            return point.clone(lookupTable);
        }));
        if (this.sourcePort) {
            clone.setSourcePort(this.sourcePort.clone(lookupTable));
        }
        if (this.targetPort) {
            clone.setTargetPort(this.targetPort.clone(lookupTable));
        }
    }
    clearPort(port) {
        if (this.sourcePort === port) {
            this.setSourcePort(null);
        }
        else if (this.targetPort === port) {
            this.setTargetPort(null);
        }
    }
    remove() {
        if (this.sourcePort) {
            this.sourcePort.removeLink(this);
        }
        if (this.targetPort) {
            this.targetPort.removeLink(this);
        }
        super.remove();
    }
    isLastPoint(point) {
        var index = this.getPointIndex(point);
        return index === this.points.length - 1;
    }
    getPointIndex(point) {
        return this.points.indexOf(point);
    }
    getPointModel(id) {
        for (var i = 0; i < this.points.length; i++) {
            if (this.points[i].getID() === id) {
                return this.points[i];
            }
        }
        return null;
    }
    getPortForPoint(point) {
        if (this.sourcePort !== null && this.getFirstPoint().getID() === point.getID()) {
            return this.sourcePort;
        }
        if (this.targetPort !== null && this.getLastPoint().getID() === point.getID()) {
            return this.targetPort;
        }
        return null;
    }
    getPointForPort(port) {
        if (this.sourcePort !== null && this.sourcePort.getID() === port.getID()) {
            return this.getFirstPoint();
        }
        if (this.targetPort !== null && this.targetPort.getID() === port.getID()) {
            return this.getLastPoint();
        }
        return null;
    }
    getFirstPoint() {
        return this.points[0];
    }
    getLastPoint() {
        return this.points[this.points.length - 1];
    }
    setSourcePort(port) {
        if (port !== null) {
            port.addLink(this);
        }
        if (this.sourcePort !== null) {
            this.sourcePort.removeLink(this);
        }
        this.sourcePort = port;
        this.fireEvent({ port }, 'sourcePortChanged');
        if (port === null || port === void 0 ? void 0 : port.reportedPosition) {
            this.getPointForPort(port).setPosition(port.getCenter());
        }
    }
    getSourcePort() {
        return this.sourcePort;
    }
    getTargetPort() {
        return this.targetPort;
    }
    setTargetPort(port) {
        if (port !== null) {
            port.addLink(this);
        }
        if (this.targetPort !== null) {
            this.targetPort.removeLink(this);
        }
        this.targetPort = port;
        this.fireEvent({ port }, 'targetPortChanged');
        if (port === null || port === void 0 ? void 0 : port.reportedPosition) {
            this.getPointForPort(port).setPosition(port.getCenter());
        }
    }
    point(x, y, index = 1) {
        return this.addPoint(this.generatePoint(x, y), index);
    }
    addLabel(label) {
        label.setParent(this);
        this.labels.push(label);
    }
    getPoints() {
        return this.points;
    }
    getLabels() {
        return this.labels;
    }
    setPoints(points) {
        _.forEach(points, (point) => {
            point.setParent(this);
        });
        this.points = points;
    }
    removePoint(pointModel) {
        this.points.splice(this.getPointIndex(pointModel), 1);
    }
    removePointsBefore(pointModel) {
        this.points.splice(0, this.getPointIndex(pointModel));
    }
    removePointsAfter(pointModel) {
        this.points.splice(this.getPointIndex(pointModel) + 1);
    }
    removeMiddlePoints() {
        if (this.points.length > 2) {
            this.points.splice(1, this.points.length - 2);
        }
    }
    addPoint(pointModel, index = 1) {
        pointModel.setParent(this);
        this.points.splice(index, 0, pointModel);
        return pointModel;
    }
    generatePoint(x = 0, y = 0) {
        return new PointModel_1.PointModel({
            link: this,
            position: new geometry_1.Point(x, y)
        });
    }
}
exports.LinkModel = LinkModel;
//# sourceMappingURL=LinkModel.js.map

/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/LinkWidget.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/LinkWidget.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LinkWidget = void 0;
const React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
const _ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const LabelWidget_1 = __webpack_require__(/*! ../label/LabelWidget */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/label/LabelWidget.js");
const react_canvas_core_1 = __webpack_require__(/*! @projectstorm/react-canvas-core */ "webpack/sharing/consume/default/@projectstorm/react-canvas-core/@projectstorm/react-canvas-core?4a30");
class LinkWidget extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            sourcePort: null,
            targetPort: null
        };
    }
    componentWillUnmount() {
        if (this.sourceListener) {
            this.sourceListener.deregister();
        }
        if (this.targetListener) {
            this.targetListener.deregister();
        }
    }
    static getDerivedStateFromProps(nextProps, prevState) {
        return {
            sourcePort: nextProps.link.getSourcePort(),
            targetPort: nextProps.link.getTargetPort()
        };
    }
    installTarget() {
        this.targetListener && this.targetListener.deregister();
        if (!this.props.link.getTargetPort())
            return;
        this.targetListener = this.props.link.getTargetPort().registerListener({
            reportInitialPosition: (event) => {
                this.forceUpdate();
            }
        });
    }
    installSource() {
        this.sourceListener && this.sourceListener.deregister();
        if (!this.props.link.getSourcePort())
            return;
        this.sourceListener = this.props.link.getSourcePort().registerListener({
            reportInitialPosition: (event) => {
                this.forceUpdate();
            }
        });
    }
    componentDidUpdate(prevProps, prevState, snapshot) {
        if (prevState.sourcePort !== this.state.sourcePort) {
            this.installSource();
        }
        if (prevState.targetPort !== this.state.targetPort) {
            this.installTarget();
        }
    }
    static generateLinePath(firstPoint, lastPoint) {
        return `M${firstPoint.getX()},${firstPoint.getY()} L ${lastPoint.getX()},${lastPoint.getY()}`;
    }
    componentDidMount() {
        if (this.props.link.getSourcePort()) {
            this.installSource();
        }
        if (this.props.link.getTargetPort()) {
            this.installTarget();
        }
    }
    render() {
        const { link } = this.props;
        // only draw the link when we have reported positions
        if (link.getSourcePort() && !link.getSourcePort().reportedPosition) {
            return null;
        }
        if (link.getTargetPort() && !link.getTargetPort().reportedPosition) {
            return null;
        }
        //generate links
        return (React.createElement(react_canvas_core_1.PeformanceWidget, { model: this.props.link, serialized: this.props.link.serialize() }, () => {
            return (React.createElement("g", { "data-linkid": this.props.link.getID() },
                this.props.diagramEngine.generateWidgetForLink(link),
                _.map(this.props.link.getLabels(), (labelModel, index) => {
                    return (React.createElement(LabelWidget_1.LabelWidget, { key: labelModel.getID(), engine: this.props.diagramEngine, label: labelModel, index: index }));
                })));
        }));
    }
}
exports.LinkWidget = LinkWidget;
//# sourceMappingURL=LinkWidget.js.map

/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/PointModel.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/PointModel.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PointModel = void 0;
const react_canvas_core_1 = __webpack_require__(/*! @projectstorm/react-canvas-core */ "webpack/sharing/consume/default/@projectstorm/react-canvas-core/@projectstorm/react-canvas-core?4a30");
class PointModel extends react_canvas_core_1.BasePositionModel {
    constructor(options) {
        super(Object.assign(Object.assign({}, options), { type: 'point' }));
        this.parent = options.link;
    }
    isConnectedToPort() {
        return this.parent.getPortForPoint(this) !== null;
    }
    getLink() {
        return this.getParent();
    }
    remove() {
        //clear references
        if (this.parent) {
            this.parent.removePoint(this);
        }
        super.remove();
    }
    isLocked() {
        return super.isLocked() || this.getParent().isLocked();
    }
}
exports.PointModel = PointModel;
//# sourceMappingURL=PointModel.js.map

/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node-layer/NodeLayerFactory.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/node-layer/NodeLayerFactory.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NodeLayerFactory = void 0;
const React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
const react_canvas_core_1 = __webpack_require__(/*! @projectstorm/react-canvas-core */ "webpack/sharing/consume/default/@projectstorm/react-canvas-core/@projectstorm/react-canvas-core?4a30");
const NodeLayerModel_1 = __webpack_require__(/*! ./NodeLayerModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node-layer/NodeLayerModel.js");
const NodeLayerWidget_1 = __webpack_require__(/*! ./NodeLayerWidget */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node-layer/NodeLayerWidget.js");
class NodeLayerFactory extends react_canvas_core_1.AbstractReactFactory {
    constructor() {
        super('diagram-nodes');
    }
    generateModel(event) {
        return new NodeLayerModel_1.NodeLayerModel();
    }
    generateReactWidget(event) {
        return React.createElement(NodeLayerWidget_1.NodeLayerWidget, { layer: event.model, engine: this.engine });
    }
}
exports.NodeLayerFactory = NodeLayerFactory;
//# sourceMappingURL=NodeLayerFactory.js.map

/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node-layer/NodeLayerModel.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/node-layer/NodeLayerModel.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NodeLayerModel = void 0;
const react_canvas_core_1 = __webpack_require__(/*! @projectstorm/react-canvas-core */ "webpack/sharing/consume/default/@projectstorm/react-canvas-core/@projectstorm/react-canvas-core?4a30");
const NodeModel_1 = __webpack_require__(/*! ../node/NodeModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node/NodeModel.js");
class NodeLayerModel extends react_canvas_core_1.LayerModel {
    constructor() {
        super({
            type: 'diagram-nodes',
            isSvg: false,
            transformed: true
        });
    }
    addModel(model) {
        if (!(model instanceof NodeModel_1.NodeModel)) {
            throw new Error('Can only add nodes to this layer');
        }
        model.registerListener({
            entityRemoved: () => {
                this.getParent().removeNode(model);
            }
        });
        super.addModel(model);
    }
    getChildModelFactoryBank(engine) {
        return engine.getNodeFactories();
    }
    getNodes() {
        return this.getModels();
    }
}
exports.NodeLayerModel = NodeLayerModel;
//# sourceMappingURL=NodeLayerModel.js.map

/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node-layer/NodeLayerWidget.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/node-layer/NodeLayerWidget.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NodeLayerWidget = void 0;
const React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
const styled_1 = __webpack_require__(/*! @emotion/styled */ "webpack/sharing/consume/default/@emotion/styled/@emotion/styled?ffb9");
const _ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const NodeWidget_1 = __webpack_require__(/*! ../node/NodeWidget */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node/NodeWidget.js");
var S;
(function (S) {
    S.Container = styled_1.default.div ``;
})(S || (S = {}));
class NodeLayerWidget extends React.Component {
    render() {
        return (React.createElement(React.Fragment, null, _.map(this.props.layer.getNodes(), (node) => {
            return React.createElement(NodeWidget_1.NodeWidget, { key: node.getID(), diagramEngine: this.props.engine, node: node });
        })));
    }
}
exports.NodeLayerWidget = NodeLayerWidget;
//# sourceMappingURL=NodeLayerWidget.js.map

/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node/NodeModel.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/node/NodeModel.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NodeModel = void 0;
const _ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const geometry_1 = __webpack_require__(/*! @projectstorm/geometry */ "./node_modules/@projectstorm/geometry/dist/index.js");
const react_canvas_core_1 = __webpack_require__(/*! @projectstorm/react-canvas-core */ "webpack/sharing/consume/default/@projectstorm/react-canvas-core/@projectstorm/react-canvas-core?4a30");
class NodeModel extends react_canvas_core_1.BasePositionModel {
    constructor(options) {
        super(options);
        this.ports = {};
        this.width = 0;
        this.height = 0;
    }
    getBoundingBox() {
        return new geometry_1.Rectangle(this.getPosition(), this.width, this.height);
    }
    setPosition(x, y) {
        let old = this.position;
        super.setPosition(x, y);
        //also update the port co-ordinates (for make glorious speed)
        _.forEach(this.ports, (port) => {
            port.setPosition(port.getX() + x - old.x, port.getY() + y - old.y);
        });
    }
    deserialize(event) {
        super.deserialize(event);
        //deserialize ports
        _.forEach(event.data.ports, (port) => {
            let portOb = event.engine.getFactoryForPort(port.type).generateModel({});
            portOb.deserialize(Object.assign(Object.assign({}, event), { data: port }));
            // the links need these
            event.registerModel(portOb);
            this.addPort(portOb);
        });
    }
    serialize() {
        return Object.assign(Object.assign({}, super.serialize()), { ports: _.map(this.ports, (port) => {
                return port.serialize();
            }) });
    }
    doClone(lookupTable = {}, clone) {
        // also clone the ports
        clone.ports = {};
        _.forEach(this.ports, (port) => {
            clone.addPort(port.clone(lookupTable));
        });
    }
    remove() {
        super.remove();
        _.forEach(this.ports, (port) => {
            _.forEach(port.getLinks(), (link) => {
                link.remove();
            });
        });
    }
    getPortFromID(id) {
        for (var i in this.ports) {
            if (this.ports[i].getID() === id) {
                return this.ports[i];
            }
        }
        return null;
    }
    getLink(id) {
        for (let portID in this.ports) {
            const links = this.ports[portID].getLinks();
            if (links[id]) {
                return links[id];
            }
        }
    }
    getPort(name) {
        return this.ports[name];
    }
    getPorts() {
        return this.ports;
    }
    removePort(port) {
        // clear the port from the links
        for (let link of _.values(port.getLinks())) {
            link.clearPort(port);
        }
        //clear the parent node reference
        if (this.ports[port.getName()]) {
            this.ports[port.getName()].setParent(null);
            delete this.ports[port.getName()];
        }
    }
    addPort(port) {
        port.setParent(this);
        this.ports[port.getName()] = port;
        return port;
    }
    updateDimensions({ width, height }) {
        this.width = width;
        this.height = height;
    }
}
exports.NodeModel = NodeModel;
//# sourceMappingURL=NodeModel.js.map

/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node/NodeWidget.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/node/NodeWidget.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NodeWidget = void 0;
const React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
const _ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const react_canvas_core_1 = __webpack_require__(/*! @projectstorm/react-canvas-core */ "webpack/sharing/consume/default/@projectstorm/react-canvas-core/@projectstorm/react-canvas-core?4a30");
const styled_1 = __webpack_require__(/*! @emotion/styled */ "webpack/sharing/consume/default/@emotion/styled/@emotion/styled?ffb9");
const resize_observer_polyfill_1 = __webpack_require__(/*! resize-observer-polyfill */ "./node_modules/resize-observer-polyfill/dist/ResizeObserver.es.js");
var S;
(function (S) {
    S.Node = styled_1.default.div `
		position: absolute;
		-webkit-touch-callout: none; /* iOS Safari */
		-webkit-user-select: none; /* Chrome/Safari/Opera */
		user-select: none;
		cursor: move;
		pointer-events: all;
	`;
})(S || (S = {}));
class NodeWidget extends React.Component {
    constructor(props) {
        super(props);
        this.ref = React.createRef();
    }
    componentWillUnmount() {
        var _a;
        this.ob.disconnect();
        this.ob = null;
        (_a = this.listener) === null || _a === void 0 ? void 0 : _a.deregister();
        this.listener = null;
    }
    componentDidUpdate(prevProps, prevState, snapshot) {
        if (this.listener && this.props.node !== prevProps.node) {
            this.listener.deregister();
            this.installSelectionListener();
        }
    }
    installSelectionListener() {
        this.listener = this.props.node.registerListener({
            selectionChanged: (event) => {
                this.forceUpdate();
            }
        });
    }
    updateSize(width, height) {
        this.props.node.updateDimensions({ width, height });
        //now mark the links as dirty
        try {
            _.forEach(this.props.node.getPorts(), (port) => {
                port.updateCoords(this.props.diagramEngine.getPortCoords(port));
            });
        }
        catch (ex) { }
    }
    componentDidMount() {
        // @ts-ignore
        this.ob = new resize_observer_polyfill_1.default((entities) => {
            const bounds = entities[0].contentRect;
            this.updateSize(bounds.width, bounds.height);
        });
        const b = this.ref.current.getBoundingClientRect();
        this.updateSize(b.width, b.height);
        this.ob.observe(this.ref.current);
        this.installSelectionListener();
    }
    render() {
        return (React.createElement(react_canvas_core_1.PeformanceWidget, { model: this.props.node, serialized: this.props.node.serialize() }, () => {
            return (React.createElement(S.Node, { className: "node", ref: this.ref, "data-nodeid": this.props.node.getID(), style: {
                    top: this.props.node.getY(),
                    left: this.props.node.getX()
                } }, this.props.diagramEngine.generateWidgetForNode(this.props.node)));
        }));
    }
}
exports.NodeWidget = NodeWidget;
//# sourceMappingURL=NodeWidget.js.map

/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/port/PortModel.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/port/PortModel.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PortModel = exports.PortModelAlignment = void 0;
const _ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const geometry_1 = __webpack_require__(/*! @projectstorm/geometry */ "./node_modules/@projectstorm/geometry/dist/index.js");
const react_canvas_core_1 = __webpack_require__(/*! @projectstorm/react-canvas-core */ "webpack/sharing/consume/default/@projectstorm/react-canvas-core/@projectstorm/react-canvas-core?4a30");
var PortModelAlignment;
(function (PortModelAlignment) {
    PortModelAlignment["TOP"] = "top";
    PortModelAlignment["LEFT"] = "left";
    PortModelAlignment["BOTTOM"] = "bottom";
    PortModelAlignment["RIGHT"] = "right";
})(PortModelAlignment = exports.PortModelAlignment || (exports.PortModelAlignment = {}));
class PortModel extends react_canvas_core_1.BasePositionModel {
    constructor(options) {
        super(options);
        this.links = {};
        this.reportedPosition = false;
    }
    deserialize(event) {
        super.deserialize(event);
        this.reportedPosition = false;
        this.options.name = event.data.name;
        this.options.alignment = event.data.alignment;
    }
    serialize() {
        return Object.assign(Object.assign({}, super.serialize()), { name: this.options.name, alignment: this.options.alignment, parentNode: this.parent.getID(), links: _.map(this.links, (link) => {
                return link.getID();
            }) });
    }
    setPosition(x, y) {
        let old = this.position;
        super.setPosition(x, y);
        _.forEach(this.getLinks(), (link) => {
            let point = link.getPointForPort(this);
            point.setPosition(point.getX() + x - old.x, point.getY() + y - old.y);
        });
    }
    doClone(lookupTable = {}, clone) {
        clone.links = {};
        clone.parent = this.getParent().clone(lookupTable);
    }
    getNode() {
        return this.getParent();
    }
    getName() {
        return this.options.name;
    }
    getMaximumLinks() {
        return this.options.maximumLinks;
    }
    setMaximumLinks(maximumLinks) {
        this.options.maximumLinks = maximumLinks;
    }
    removeLink(link) {
        delete this.links[link.getID()];
    }
    addLink(link) {
        this.links[link.getID()] = link;
    }
    getLinks() {
        return this.links;
    }
    createLinkModel() {
        if (_.isFinite(this.options.maximumLinks)) {
            var numberOfLinks = _.size(this.links);
            if (this.options.maximumLinks === 1 && numberOfLinks >= 1) {
                return _.values(this.links)[0];
            }
            else if (numberOfLinks >= this.options.maximumLinks) {
                return null;
            }
        }
        return null;
    }
    reportPosition() {
        _.forEach(this.getLinks(), (link) => {
            link.getPointForPort(this).setPosition(this.getCenter());
        });
        this.fireEvent({
            entity: this
        }, 'reportInitialPosition');
    }
    getCenter() {
        return new geometry_1.Point(this.getX() + this.width / 2, this.getY() + this.height / 2);
    }
    getBoundingBox() {
        return new geometry_1.Rectangle(this.position, this.width, this.height);
    }
    updateCoords(coords) {
        this.width = coords.getWidth();
        this.height = coords.getHeight();
        this.setPosition(coords.getTopLeft());
        this.reportedPosition = true;
        this.reportPosition();
    }
    canLinkToPort(port) {
        return true;
    }
    isLocked() {
        return super.isLocked() || this.getParent().isLocked();
    }
}
exports.PortModel = PortModel;
//# sourceMappingURL=PortModel.js.map

/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/port/PortWidget.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/port/PortWidget.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PortWidget = void 0;
const React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
const _ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const react_canvas_core_1 = __webpack_require__(/*! @projectstorm/react-canvas-core */ "webpack/sharing/consume/default/@projectstorm/react-canvas-core/@projectstorm/react-canvas-core?4a30");
class PortWidget extends React.Component {
    constructor(props) {
        super(props);
        this.ref = React.createRef();
    }
    report() {
        this.props.port.updateCoords(this.props.engine.getPortCoords(this.props.port, this.ref.current));
    }
    componentWillUnmount() {
        this.engineListenerHandle && this.engineListenerHandle.deregister();
    }
    componentDidUpdate(prevProps, prevState, snapshot) {
        if (!this.props.port.reportedPosition) {
            this.report();
        }
    }
    componentDidMount() {
        this.engineListenerHandle = this.props.engine.registerListener({
            canvasReady: () => {
                this.report();
            }
        });
        if (this.props.engine.getCanvas()) {
            this.report();
        }
    }
    getExtraProps() {
        if (react_canvas_core_1.Toolkit.TESTING) {
            const links = _.keys(this.props.port.getNode().getPort(this.props.port.getName()).links).join(',');
            return {
                'data-links': links
            };
        }
        return {};
    }
    render() {
        return (React.createElement("div", Object.assign({ style: this.props.style, ref: this.ref, className: `port ${this.props.className || ''}`, "data-name": this.props.port.getName(), "data-nodeid": this.props.port.getNode().getID() }, this.getExtraProps()), this.props.children));
    }
}
exports.PortWidget = PortWidget;
//# sourceMappingURL=PortWidget.js.map

/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/index.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/index.js ***!
  \**********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./models/DiagramModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/models/DiagramModel.js"), exports);
__exportStar(__webpack_require__(/*! ./entities/label/LabelModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/label/LabelModel.js"), exports);
__exportStar(__webpack_require__(/*! ./entities/link/LinkModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/LinkModel.js"), exports);
__exportStar(__webpack_require__(/*! ./entities/link/PointModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/PointModel.js"), exports);
__exportStar(__webpack_require__(/*! ./entities/link/LinkWidget */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/LinkWidget.js"), exports);
__exportStar(__webpack_require__(/*! ./entities/link-layer/LinkLayerModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link-layer/LinkLayerModel.js"), exports);
__exportStar(__webpack_require__(/*! ./entities/link-layer/LinkLayerWidget */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link-layer/LinkLayerWidget.js"), exports);
__exportStar(__webpack_require__(/*! ./entities/link-layer/LinkLayerFactory */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link-layer/LinkLayerFactory.js"), exports);
__exportStar(__webpack_require__(/*! ./entities/node-layer/NodeLayerModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node-layer/NodeLayerModel.js"), exports);
__exportStar(__webpack_require__(/*! ./entities/node-layer/NodeLayerWidget */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node-layer/NodeLayerWidget.js"), exports);
__exportStar(__webpack_require__(/*! ./entities/node-layer/NodeLayerFactory */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node-layer/NodeLayerFactory.js"), exports);
__exportStar(__webpack_require__(/*! ./entities/node/NodeModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node/NodeModel.js"), exports);
__exportStar(__webpack_require__(/*! ./entities/node/NodeWidget */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node/NodeWidget.js"), exports);
__exportStar(__webpack_require__(/*! ./entities/port/PortModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/port/PortModel.js"), exports);
__exportStar(__webpack_require__(/*! ./entities/port/PortWidget */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/port/PortWidget.js"), exports);
__exportStar(__webpack_require__(/*! ./states/DefaultDiagramState */ "./node_modules/@projectstorm/react-diagrams-core/dist/states/DefaultDiagramState.js"), exports);
__exportStar(__webpack_require__(/*! ./states/DragDiagramItemsState */ "./node_modules/@projectstorm/react-diagrams-core/dist/states/DragDiagramItemsState.js"), exports);
__exportStar(__webpack_require__(/*! ./states/DragNewLinkState */ "./node_modules/@projectstorm/react-diagrams-core/dist/states/DragNewLinkState.js"), exports);
__exportStar(__webpack_require__(/*! ./DiagramEngine */ "./node_modules/@projectstorm/react-diagrams-core/dist/DiagramEngine.js"), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/models/DiagramModel.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/models/DiagramModel.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DiagramModel = void 0;
const _ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const LinkModel_1 = __webpack_require__(/*! ../entities/link/LinkModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/LinkModel.js");
const NodeModel_1 = __webpack_require__(/*! ../entities/node/NodeModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node/NodeModel.js");
const react_canvas_core_1 = __webpack_require__(/*! @projectstorm/react-canvas-core */ "webpack/sharing/consume/default/@projectstorm/react-canvas-core/@projectstorm/react-canvas-core?4a30");
const NodeLayerModel_1 = __webpack_require__(/*! ../entities/node-layer/NodeLayerModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node-layer/NodeLayerModel.js");
const LinkLayerModel_1 = __webpack_require__(/*! ../entities/link-layer/LinkLayerModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link-layer/LinkLayerModel.js");
class DiagramModel extends react_canvas_core_1.CanvasModel {
    constructor(options = {}) {
        super(options);
        this.addLayer(new LinkLayerModel_1.LinkLayerModel());
        this.addLayer(new NodeLayerModel_1.NodeLayerModel());
    }
    deserialize(event) {
        this.layers = [];
        super.deserialize(event);
    }
    addLayer(layer) {
        super.addLayer(layer);
        if (layer instanceof NodeLayerModel_1.NodeLayerModel) {
            this.activeNodeLayer = layer;
        }
        if (layer instanceof LinkLayerModel_1.LinkLayerModel) {
            this.activeLinkLayer = layer;
        }
    }
    getLinkLayers() {
        return _.filter(this.layers, (layer) => {
            return layer instanceof LinkLayerModel_1.LinkLayerModel;
        });
    }
    getNodeLayers() {
        return _.filter(this.layers, (layer) => {
            return layer instanceof NodeLayerModel_1.NodeLayerModel;
        });
    }
    getActiveNodeLayer() {
        if (!this.activeNodeLayer) {
            const layers = this.getNodeLayers();
            if (layers.length === 0) {
                this.addLayer(new NodeLayerModel_1.NodeLayerModel());
            }
            else {
                this.activeNodeLayer = layers[0];
            }
        }
        return this.activeNodeLayer;
    }
    getActiveLinkLayer() {
        if (!this.activeLinkLayer) {
            const layers = this.getLinkLayers();
            if (layers.length === 0) {
                this.addLayer(new LinkLayerModel_1.LinkLayerModel());
            }
            else {
                this.activeLinkLayer = layers[0];
            }
        }
        return this.activeLinkLayer;
    }
    getNode(node) {
        for (const layer of this.getNodeLayers()) {
            const model = layer.getModel(node);
            if (model) {
                return model;
            }
        }
    }
    getLink(link) {
        for (const layer of this.getLinkLayers()) {
            const model = layer.getModel(link);
            if (model) {
                return model;
            }
        }
    }
    addAll(...models) {
        _.forEach(models, (model) => {
            if (model instanceof LinkModel_1.LinkModel) {
                this.addLink(model);
            }
            else if (model instanceof NodeModel_1.NodeModel) {
                this.addNode(model);
            }
        });
        return models;
    }
    addLink(link) {
        this.getActiveLinkLayer().addModel(link);
        this.fireEvent({
            link,
            isCreated: true
        }, 'linksUpdated');
        return link;
    }
    addNode(node) {
        this.getActiveNodeLayer().addModel(node);
        this.fireEvent({ node, isCreated: true }, 'nodesUpdated');
        return node;
    }
    removeLink(link) {
        const removed = _.some(this.getLinkLayers(), (layer) => {
            return layer.removeModel(link);
        });
        if (removed) {
            this.fireEvent({ link, isCreated: false }, 'linksUpdated');
        }
    }
    removeNode(node) {
        const removed = _.some(this.getNodeLayers(), (layer) => {
            return layer.removeModel(node);
        });
        if (removed) {
            this.fireEvent({ node, isCreated: false }, 'nodesUpdated');
        }
    }
    getLinks() {
        return _.flatMap(this.getLinkLayers(), (layer) => {
            return _.values(layer.getModels());
        });
    }
    getNodes() {
        return _.flatMap(this.getNodeLayers(), (layer) => {
            return _.values(layer.getModels());
        });
    }
}
exports.DiagramModel = DiagramModel;
//# sourceMappingURL=DiagramModel.js.map

/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/states/DefaultDiagramState.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/states/DefaultDiagramState.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DefaultDiagramState = void 0;
const react_canvas_core_1 = __webpack_require__(/*! @projectstorm/react-canvas-core */ "webpack/sharing/consume/default/@projectstorm/react-canvas-core/@projectstorm/react-canvas-core?4a30");
const PortModel_1 = __webpack_require__(/*! ../entities/port/PortModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/port/PortModel.js");
const DragNewLinkState_1 = __webpack_require__(/*! ./DragNewLinkState */ "./node_modules/@projectstorm/react-diagrams-core/dist/states/DragNewLinkState.js");
const DragDiagramItemsState_1 = __webpack_require__(/*! ./DragDiagramItemsState */ "./node_modules/@projectstorm/react-diagrams-core/dist/states/DragDiagramItemsState.js");
class DefaultDiagramState extends react_canvas_core_1.State {
    constructor() {
        super({
            name: 'default-diagrams'
        });
        this.childStates = [new react_canvas_core_1.SelectingState()];
        this.dragCanvas = new react_canvas_core_1.DragCanvasState();
        this.dragNewLink = new DragNewLinkState_1.DragNewLinkState();
        this.dragItems = new DragDiagramItemsState_1.DragDiagramItemsState();
        // determine what was clicked on
        this.registerAction(new react_canvas_core_1.Action({
            type: react_canvas_core_1.InputType.MOUSE_DOWN,
            fire: (event) => {
                const element = this.engine.getActionEventBus().getModelForEvent(event);
                // the canvas was clicked on, transition to the dragging canvas state
                if (!element) {
                    this.transitionWithEvent(this.dragCanvas, event);
                }
                // initiate dragging a new link
                else if (element instanceof PortModel_1.PortModel) {
                    this.transitionWithEvent(this.dragNewLink, event);
                }
                // move the items (and potentially link points)
                else {
                    this.transitionWithEvent(this.dragItems, event);
                }
            }
        }));
        // touch drags the canvas
        this.registerAction(new react_canvas_core_1.Action({
            type: react_canvas_core_1.InputType.TOUCH_START,
            fire: (event) => {
                this.transitionWithEvent(this.dragCanvas, event);
            }
        }));
    }
}
exports.DefaultDiagramState = DefaultDiagramState;
//# sourceMappingURL=DefaultDiagramState.js.map

/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/states/DragDiagramItemsState.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/states/DragDiagramItemsState.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DragDiagramItemsState = void 0;
const react_canvas_core_1 = __webpack_require__(/*! @projectstorm/react-canvas-core */ "webpack/sharing/consume/default/@projectstorm/react-canvas-core/@projectstorm/react-canvas-core?4a30");
const _ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const PointModel_1 = __webpack_require__(/*! ../entities/link/PointModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/PointModel.js");
const PortModel_1 = __webpack_require__(/*! ../entities/port/PortModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/port/PortModel.js");
class DragDiagramItemsState extends react_canvas_core_1.MoveItemsState {
    constructor() {
        super();
        this.registerAction(new react_canvas_core_1.Action({
            type: react_canvas_core_1.InputType.MOUSE_UP,
            fire: (event) => {
                const item = this.engine.getMouseElement(event.event);
                if (item instanceof PortModel_1.PortModel) {
                    _.forEach(this.initialPositions, (position) => {
                        if (position.item instanceof PointModel_1.PointModel) {
                            const link = position.item.getParent();
                            // only care about the last links
                            if (link.getLastPoint() !== position.item) {
                                return;
                            }
                            if (link.getSourcePort().canLinkToPort(item)) {
                                link.setTargetPort(item);
                                item.reportPosition();
                                this.engine.repaintCanvas();
                            }
                        }
                    });
                }
            }
        }));
    }
}
exports.DragDiagramItemsState = DragDiagramItemsState;
//# sourceMappingURL=DragDiagramItemsState.js.map

/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/states/DragNewLinkState.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/states/DragNewLinkState.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DragNewLinkState = void 0;
const react_canvas_core_1 = __webpack_require__(/*! @projectstorm/react-canvas-core */ "webpack/sharing/consume/default/@projectstorm/react-canvas-core/@projectstorm/react-canvas-core?4a30");
const PortModel_1 = __webpack_require__(/*! ../entities/port/PortModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/port/PortModel.js");
class DragNewLinkState extends react_canvas_core_1.AbstractDisplacementState {
    constructor(options = {}) {
        super({ name: 'drag-new-link' });
        this.config = Object.assign({ allowLooseLinks: true, allowLinksFromLockedPorts: false }, options);
        this.registerAction(new react_canvas_core_1.Action({
            type: react_canvas_core_1.InputType.MOUSE_DOWN,
            fire: (event) => {
                this.port = this.engine.getMouseElement(event.event);
                if (!this.config.allowLinksFromLockedPorts && this.port.isLocked()) {
                    this.eject();
                    return;
                }
                this.link = this.port.createLinkModel();
                // if no link is given, just eject the state
                if (!this.link) {
                    this.eject();
                    return;
                }
                this.link.setSelected(true);
                this.link.setSourcePort(this.port);
                this.engine.getModel().addLink(this.link);
                this.port.reportPosition();
            }
        }));
        this.registerAction(new react_canvas_core_1.Action({
            type: react_canvas_core_1.InputType.MOUSE_UP,
            fire: (event) => {
                const model = this.engine.getMouseElement(event.event);
                // check to see if we connected to a new port
                if (model instanceof PortModel_1.PortModel) {
                    if (this.port.canLinkToPort(model)) {
                        this.link.setTargetPort(model);
                        model.reportPosition();
                        this.engine.repaintCanvas();
                        return;
                    }
                    else {
                        this.link.remove();
                        this.engine.repaintCanvas();
                        return;
                    }
                }
                if (!this.config.allowLooseLinks) {
                    this.link.remove();
                    this.engine.repaintCanvas();
                }
            }
        }));
    }
    /**
     * Calculates the link's far-end point position on mouse move.
     * In order to be as precise as possible the mouse initialXRelative & initialYRelative are taken into account as well
     * as the possible engine offset
     */
    fireMouseMoved(event) {
        const portPos = this.port.getPosition();
        const zoomLevelPercentage = this.engine.getModel().getZoomLevel() / 100;
        const engineOffsetX = this.engine.getModel().getOffsetX() / zoomLevelPercentage;
        const engineOffsetY = this.engine.getModel().getOffsetY() / zoomLevelPercentage;
        const initialXRelative = this.initialXRelative / zoomLevelPercentage;
        const initialYRelative = this.initialYRelative / zoomLevelPercentage;
        const linkNextX = portPos.x - engineOffsetX + (initialXRelative - portPos.x) + event.virtualDisplacementX;
        const linkNextY = portPos.y - engineOffsetY + (initialYRelative - portPos.y) + event.virtualDisplacementY;
        this.link.getLastPoint().setPosition(linkNextX, linkNextY);
        this.engine.repaintCanvas();
    }
}
exports.DragNewLinkState = DragNewLinkState;
//# sourceMappingURL=DragNewLinkState.js.map

/***/ }),

/***/ "./node_modules/resize-observer-polyfill/dist/ResizeObserver.es.js":
/*!*************************************************************************!*\
  !*** ./node_modules/resize-observer-polyfill/dist/ResizeObserver.es.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * A collection of shims that provide minimal functionality of the ES6 collections.
 *
 * These implementations are not meant to be used outside of the ResizeObserver
 * modules as they cover only a limited range of use cases.
 */
/* eslint-disable require-jsdoc, valid-jsdoc */
var MapShim = (function () {
    if (typeof Map !== 'undefined') {
        return Map;
    }
    /**
     * Returns index in provided array that matches the specified key.
     *
     * @param {Array<Array>} arr
     * @param {*} key
     * @returns {number}
     */
    function getIndex(arr, key) {
        var result = -1;
        arr.some(function (entry, index) {
            if (entry[0] === key) {
                result = index;
                return true;
            }
            return false;
        });
        return result;
    }
    return /** @class */ (function () {
        function class_1() {
            this.__entries__ = [];
        }
        Object.defineProperty(class_1.prototype, "size", {
            /**
             * @returns {boolean}
             */
            get: function () {
                return this.__entries__.length;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @param {*} key
         * @returns {*}
         */
        class_1.prototype.get = function (key) {
            var index = getIndex(this.__entries__, key);
            var entry = this.__entries__[index];
            return entry && entry[1];
        };
        /**
         * @param {*} key
         * @param {*} value
         * @returns {void}
         */
        class_1.prototype.set = function (key, value) {
            var index = getIndex(this.__entries__, key);
            if (~index) {
                this.__entries__[index][1] = value;
            }
            else {
                this.__entries__.push([key, value]);
            }
        };
        /**
         * @param {*} key
         * @returns {void}
         */
        class_1.prototype.delete = function (key) {
            var entries = this.__entries__;
            var index = getIndex(entries, key);
            if (~index) {
                entries.splice(index, 1);
            }
        };
        /**
         * @param {*} key
         * @returns {void}
         */
        class_1.prototype.has = function (key) {
            return !!~getIndex(this.__entries__, key);
        };
        /**
         * @returns {void}
         */
        class_1.prototype.clear = function () {
            this.__entries__.splice(0);
        };
        /**
         * @param {Function} callback
         * @param {*} [ctx=null]
         * @returns {void}
         */
        class_1.prototype.forEach = function (callback, ctx) {
            if (ctx === void 0) { ctx = null; }
            for (var _i = 0, _a = this.__entries__; _i < _a.length; _i++) {
                var entry = _a[_i];
                callback.call(ctx, entry[1], entry[0]);
            }
        };
        return class_1;
    }());
})();

/**
 * Detects whether window and document objects are available in current environment.
 */
var isBrowser = typeof window !== 'undefined' && typeof document !== 'undefined' && window.document === document;

// Returns global object of a current environment.
var global$1 = (function () {
    if (typeof __webpack_require__.g !== 'undefined' && __webpack_require__.g.Math === Math) {
        return __webpack_require__.g;
    }
    if (typeof self !== 'undefined' && self.Math === Math) {
        return self;
    }
    if (typeof window !== 'undefined' && window.Math === Math) {
        return window;
    }
    // eslint-disable-next-line no-new-func
    return Function('return this')();
})();

/**
 * A shim for the requestAnimationFrame which falls back to the setTimeout if
 * first one is not supported.
 *
 * @returns {number} Requests' identifier.
 */
var requestAnimationFrame$1 = (function () {
    if (typeof requestAnimationFrame === 'function') {
        // It's required to use a bounded function because IE sometimes throws
        // an "Invalid calling object" error if rAF is invoked without the global
        // object on the left hand side.
        return requestAnimationFrame.bind(global$1);
    }
    return function (callback) { return setTimeout(function () { return callback(Date.now()); }, 1000 / 60); };
})();

// Defines minimum timeout before adding a trailing call.
var trailingTimeout = 2;
/**
 * Creates a wrapper function which ensures that provided callback will be
 * invoked only once during the specified delay period.
 *
 * @param {Function} callback - Function to be invoked after the delay period.
 * @param {number} delay - Delay after which to invoke callback.
 * @returns {Function}
 */
function throttle (callback, delay) {
    var leadingCall = false, trailingCall = false, lastCallTime = 0;
    /**
     * Invokes the original callback function and schedules new invocation if
     * the "proxy" was called during current request.
     *
     * @returns {void}
     */
    function resolvePending() {
        if (leadingCall) {
            leadingCall = false;
            callback();
        }
        if (trailingCall) {
            proxy();
        }
    }
    /**
     * Callback invoked after the specified delay. It will further postpone
     * invocation of the original function delegating it to the
     * requestAnimationFrame.
     *
     * @returns {void}
     */
    function timeoutCallback() {
        requestAnimationFrame$1(resolvePending);
    }
    /**
     * Schedules invocation of the original function.
     *
     * @returns {void}
     */
    function proxy() {
        var timeStamp = Date.now();
        if (leadingCall) {
            // Reject immediately following calls.
            if (timeStamp - lastCallTime < trailingTimeout) {
                return;
            }
            // Schedule new call to be in invoked when the pending one is resolved.
            // This is important for "transitions" which never actually start
            // immediately so there is a chance that we might miss one if change
            // happens amids the pending invocation.
            trailingCall = true;
        }
        else {
            leadingCall = true;
            trailingCall = false;
            setTimeout(timeoutCallback, delay);
        }
        lastCallTime = timeStamp;
    }
    return proxy;
}

// Minimum delay before invoking the update of observers.
var REFRESH_DELAY = 20;
// A list of substrings of CSS properties used to find transition events that
// might affect dimensions of observed elements.
var transitionKeys = ['top', 'right', 'bottom', 'left', 'width', 'height', 'size', 'weight'];
// Check if MutationObserver is available.
var mutationObserverSupported = typeof MutationObserver !== 'undefined';
/**
 * Singleton controller class which handles updates of ResizeObserver instances.
 */
var ResizeObserverController = /** @class */ (function () {
    /**
     * Creates a new instance of ResizeObserverController.
     *
     * @private
     */
    function ResizeObserverController() {
        /**
         * Indicates whether DOM listeners have been added.
         *
         * @private {boolean}
         */
        this.connected_ = false;
        /**
         * Tells that controller has subscribed for Mutation Events.
         *
         * @private {boolean}
         */
        this.mutationEventsAdded_ = false;
        /**
         * Keeps reference to the instance of MutationObserver.
         *
         * @private {MutationObserver}
         */
        this.mutationsObserver_ = null;
        /**
         * A list of connected observers.
         *
         * @private {Array<ResizeObserverSPI>}
         */
        this.observers_ = [];
        this.onTransitionEnd_ = this.onTransitionEnd_.bind(this);
        this.refresh = throttle(this.refresh.bind(this), REFRESH_DELAY);
    }
    /**
     * Adds observer to observers list.
     *
     * @param {ResizeObserverSPI} observer - Observer to be added.
     * @returns {void}
     */
    ResizeObserverController.prototype.addObserver = function (observer) {
        if (!~this.observers_.indexOf(observer)) {
            this.observers_.push(observer);
        }
        // Add listeners if they haven't been added yet.
        if (!this.connected_) {
            this.connect_();
        }
    };
    /**
     * Removes observer from observers list.
     *
     * @param {ResizeObserverSPI} observer - Observer to be removed.
     * @returns {void}
     */
    ResizeObserverController.prototype.removeObserver = function (observer) {
        var observers = this.observers_;
        var index = observers.indexOf(observer);
        // Remove observer if it's present in registry.
        if (~index) {
            observers.splice(index, 1);
        }
        // Remove listeners if controller has no connected observers.
        if (!observers.length && this.connected_) {
            this.disconnect_();
        }
    };
    /**
     * Invokes the update of observers. It will continue running updates insofar
     * it detects changes.
     *
     * @returns {void}
     */
    ResizeObserverController.prototype.refresh = function () {
        var changesDetected = this.updateObservers_();
        // Continue running updates if changes have been detected as there might
        // be future ones caused by CSS transitions.
        if (changesDetected) {
            this.refresh();
        }
    };
    /**
     * Updates every observer from observers list and notifies them of queued
     * entries.
     *
     * @private
     * @returns {boolean} Returns "true" if any observer has detected changes in
     *      dimensions of it's elements.
     */
    ResizeObserverController.prototype.updateObservers_ = function () {
        // Collect observers that have active observations.
        var activeObservers = this.observers_.filter(function (observer) {
            return observer.gatherActive(), observer.hasActive();
        });
        // Deliver notifications in a separate cycle in order to avoid any
        // collisions between observers, e.g. when multiple instances of
        // ResizeObserver are tracking the same element and the callback of one
        // of them changes content dimensions of the observed target. Sometimes
        // this may result in notifications being blocked for the rest of observers.
        activeObservers.forEach(function (observer) { return observer.broadcastActive(); });
        return activeObservers.length > 0;
    };
    /**
     * Initializes DOM listeners.
     *
     * @private
     * @returns {void}
     */
    ResizeObserverController.prototype.connect_ = function () {
        // Do nothing if running in a non-browser environment or if listeners
        // have been already added.
        if (!isBrowser || this.connected_) {
            return;
        }
        // Subscription to the "Transitionend" event is used as a workaround for
        // delayed transitions. This way it's possible to capture at least the
        // final state of an element.
        document.addEventListener('transitionend', this.onTransitionEnd_);
        window.addEventListener('resize', this.refresh);
        if (mutationObserverSupported) {
            this.mutationsObserver_ = new MutationObserver(this.refresh);
            this.mutationsObserver_.observe(document, {
                attributes: true,
                childList: true,
                characterData: true,
                subtree: true
            });
        }
        else {
            document.addEventListener('DOMSubtreeModified', this.refresh);
            this.mutationEventsAdded_ = true;
        }
        this.connected_ = true;
    };
    /**
     * Removes DOM listeners.
     *
     * @private
     * @returns {void}
     */
    ResizeObserverController.prototype.disconnect_ = function () {
        // Do nothing if running in a non-browser environment or if listeners
        // have been already removed.
        if (!isBrowser || !this.connected_) {
            return;
        }
        document.removeEventListener('transitionend', this.onTransitionEnd_);
        window.removeEventListener('resize', this.refresh);
        if (this.mutationsObserver_) {
            this.mutationsObserver_.disconnect();
        }
        if (this.mutationEventsAdded_) {
            document.removeEventListener('DOMSubtreeModified', this.refresh);
        }
        this.mutationsObserver_ = null;
        this.mutationEventsAdded_ = false;
        this.connected_ = false;
    };
    /**
     * "Transitionend" event handler.
     *
     * @private
     * @param {TransitionEvent} event
     * @returns {void}
     */
    ResizeObserverController.prototype.onTransitionEnd_ = function (_a) {
        var _b = _a.propertyName, propertyName = _b === void 0 ? '' : _b;
        // Detect whether transition may affect dimensions of an element.
        var isReflowProperty = transitionKeys.some(function (key) {
            return !!~propertyName.indexOf(key);
        });
        if (isReflowProperty) {
            this.refresh();
        }
    };
    /**
     * Returns instance of the ResizeObserverController.
     *
     * @returns {ResizeObserverController}
     */
    ResizeObserverController.getInstance = function () {
        if (!this.instance_) {
            this.instance_ = new ResizeObserverController();
        }
        return this.instance_;
    };
    /**
     * Holds reference to the controller's instance.
     *
     * @private {ResizeObserverController}
     */
    ResizeObserverController.instance_ = null;
    return ResizeObserverController;
}());

/**
 * Defines non-writable/enumerable properties of the provided target object.
 *
 * @param {Object} target - Object for which to define properties.
 * @param {Object} props - Properties to be defined.
 * @returns {Object} Target object.
 */
var defineConfigurable = (function (target, props) {
    for (var _i = 0, _a = Object.keys(props); _i < _a.length; _i++) {
        var key = _a[_i];
        Object.defineProperty(target, key, {
            value: props[key],
            enumerable: false,
            writable: false,
            configurable: true
        });
    }
    return target;
});

/**
 * Returns the global object associated with provided element.
 *
 * @param {Object} target
 * @returns {Object}
 */
var getWindowOf = (function (target) {
    // Assume that the element is an instance of Node, which means that it
    // has the "ownerDocument" property from which we can retrieve a
    // corresponding global object.
    var ownerGlobal = target && target.ownerDocument && target.ownerDocument.defaultView;
    // Return the local global object if it's not possible extract one from
    // provided element.
    return ownerGlobal || global$1;
});

// Placeholder of an empty content rectangle.
var emptyRect = createRectInit(0, 0, 0, 0);
/**
 * Converts provided string to a number.
 *
 * @param {number|string} value
 * @returns {number}
 */
function toFloat(value) {
    return parseFloat(value) || 0;
}
/**
 * Extracts borders size from provided styles.
 *
 * @param {CSSStyleDeclaration} styles
 * @param {...string} positions - Borders positions (top, right, ...)
 * @returns {number}
 */
function getBordersSize(styles) {
    var positions = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        positions[_i - 1] = arguments[_i];
    }
    return positions.reduce(function (size, position) {
        var value = styles['border-' + position + '-width'];
        return size + toFloat(value);
    }, 0);
}
/**
 * Extracts paddings sizes from provided styles.
 *
 * @param {CSSStyleDeclaration} styles
 * @returns {Object} Paddings box.
 */
function getPaddings(styles) {
    var positions = ['top', 'right', 'bottom', 'left'];
    var paddings = {};
    for (var _i = 0, positions_1 = positions; _i < positions_1.length; _i++) {
        var position = positions_1[_i];
        var value = styles['padding-' + position];
        paddings[position] = toFloat(value);
    }
    return paddings;
}
/**
 * Calculates content rectangle of provided SVG element.
 *
 * @param {SVGGraphicsElement} target - Element content rectangle of which needs
 *      to be calculated.
 * @returns {DOMRectInit}
 */
function getSVGContentRect(target) {
    var bbox = target.getBBox();
    return createRectInit(0, 0, bbox.width, bbox.height);
}
/**
 * Calculates content rectangle of provided HTMLElement.
 *
 * @param {HTMLElement} target - Element for which to calculate the content rectangle.
 * @returns {DOMRectInit}
 */
function getHTMLElementContentRect(target) {
    // Client width & height properties can't be
    // used exclusively as they provide rounded values.
    var clientWidth = target.clientWidth, clientHeight = target.clientHeight;
    // By this condition we can catch all non-replaced inline, hidden and
    // detached elements. Though elements with width & height properties less
    // than 0.5 will be discarded as well.
    //
    // Without it we would need to implement separate methods for each of
    // those cases and it's not possible to perform a precise and performance
    // effective test for hidden elements. E.g. even jQuery's ':visible' filter
    // gives wrong results for elements with width & height less than 0.5.
    if (!clientWidth && !clientHeight) {
        return emptyRect;
    }
    var styles = getWindowOf(target).getComputedStyle(target);
    var paddings = getPaddings(styles);
    var horizPad = paddings.left + paddings.right;
    var vertPad = paddings.top + paddings.bottom;
    // Computed styles of width & height are being used because they are the
    // only dimensions available to JS that contain non-rounded values. It could
    // be possible to utilize the getBoundingClientRect if only it's data wasn't
    // affected by CSS transformations let alone paddings, borders and scroll bars.
    var width = toFloat(styles.width), height = toFloat(styles.height);
    // Width & height include paddings and borders when the 'border-box' box
    // model is applied (except for IE).
    if (styles.boxSizing === 'border-box') {
        // Following conditions are required to handle Internet Explorer which
        // doesn't include paddings and borders to computed CSS dimensions.
        //
        // We can say that if CSS dimensions + paddings are equal to the "client"
        // properties then it's either IE, and thus we don't need to subtract
        // anything, or an element merely doesn't have paddings/borders styles.
        if (Math.round(width + horizPad) !== clientWidth) {
            width -= getBordersSize(styles, 'left', 'right') + horizPad;
        }
        if (Math.round(height + vertPad) !== clientHeight) {
            height -= getBordersSize(styles, 'top', 'bottom') + vertPad;
        }
    }
    // Following steps can't be applied to the document's root element as its
    // client[Width/Height] properties represent viewport area of the window.
    // Besides, it's as well not necessary as the <html> itself neither has
    // rendered scroll bars nor it can be clipped.
    if (!isDocumentElement(target)) {
        // In some browsers (only in Firefox, actually) CSS width & height
        // include scroll bars size which can be removed at this step as scroll
        // bars are the only difference between rounded dimensions + paddings
        // and "client" properties, though that is not always true in Chrome.
        var vertScrollbar = Math.round(width + horizPad) - clientWidth;
        var horizScrollbar = Math.round(height + vertPad) - clientHeight;
        // Chrome has a rather weird rounding of "client" properties.
        // E.g. for an element with content width of 314.2px it sometimes gives
        // the client width of 315px and for the width of 314.7px it may give
        // 314px. And it doesn't happen all the time. So just ignore this delta
        // as a non-relevant.
        if (Math.abs(vertScrollbar) !== 1) {
            width -= vertScrollbar;
        }
        if (Math.abs(horizScrollbar) !== 1) {
            height -= horizScrollbar;
        }
    }
    return createRectInit(paddings.left, paddings.top, width, height);
}
/**
 * Checks whether provided element is an instance of the SVGGraphicsElement.
 *
 * @param {Element} target - Element to be checked.
 * @returns {boolean}
 */
var isSVGGraphicsElement = (function () {
    // Some browsers, namely IE and Edge, don't have the SVGGraphicsElement
    // interface.
    if (typeof SVGGraphicsElement !== 'undefined') {
        return function (target) { return target instanceof getWindowOf(target).SVGGraphicsElement; };
    }
    // If it's so, then check that element is at least an instance of the
    // SVGElement and that it has the "getBBox" method.
    // eslint-disable-next-line no-extra-parens
    return function (target) { return (target instanceof getWindowOf(target).SVGElement &&
        typeof target.getBBox === 'function'); };
})();
/**
 * Checks whether provided element is a document element (<html>).
 *
 * @param {Element} target - Element to be checked.
 * @returns {boolean}
 */
function isDocumentElement(target) {
    return target === getWindowOf(target).document.documentElement;
}
/**
 * Calculates an appropriate content rectangle for provided html or svg element.
 *
 * @param {Element} target - Element content rectangle of which needs to be calculated.
 * @returns {DOMRectInit}
 */
function getContentRect(target) {
    if (!isBrowser) {
        return emptyRect;
    }
    if (isSVGGraphicsElement(target)) {
        return getSVGContentRect(target);
    }
    return getHTMLElementContentRect(target);
}
/**
 * Creates rectangle with an interface of the DOMRectReadOnly.
 * Spec: https://drafts.fxtf.org/geometry/#domrectreadonly
 *
 * @param {DOMRectInit} rectInit - Object with rectangle's x/y coordinates and dimensions.
 * @returns {DOMRectReadOnly}
 */
function createReadOnlyRect(_a) {
    var x = _a.x, y = _a.y, width = _a.width, height = _a.height;
    // If DOMRectReadOnly is available use it as a prototype for the rectangle.
    var Constr = typeof DOMRectReadOnly !== 'undefined' ? DOMRectReadOnly : Object;
    var rect = Object.create(Constr.prototype);
    // Rectangle's properties are not writable and non-enumerable.
    defineConfigurable(rect, {
        x: x, y: y, width: width, height: height,
        top: y,
        right: x + width,
        bottom: height + y,
        left: x
    });
    return rect;
}
/**
 * Creates DOMRectInit object based on the provided dimensions and the x/y coordinates.
 * Spec: https://drafts.fxtf.org/geometry/#dictdef-domrectinit
 *
 * @param {number} x - X coordinate.
 * @param {number} y - Y coordinate.
 * @param {number} width - Rectangle's width.
 * @param {number} height - Rectangle's height.
 * @returns {DOMRectInit}
 */
function createRectInit(x, y, width, height) {
    return { x: x, y: y, width: width, height: height };
}

/**
 * Class that is responsible for computations of the content rectangle of
 * provided DOM element and for keeping track of it's changes.
 */
var ResizeObservation = /** @class */ (function () {
    /**
     * Creates an instance of ResizeObservation.
     *
     * @param {Element} target - Element to be observed.
     */
    function ResizeObservation(target) {
        /**
         * Broadcasted width of content rectangle.
         *
         * @type {number}
         */
        this.broadcastWidth = 0;
        /**
         * Broadcasted height of content rectangle.
         *
         * @type {number}
         */
        this.broadcastHeight = 0;
        /**
         * Reference to the last observed content rectangle.
         *
         * @private {DOMRectInit}
         */
        this.contentRect_ = createRectInit(0, 0, 0, 0);
        this.target = target;
    }
    /**
     * Updates content rectangle and tells whether it's width or height properties
     * have changed since the last broadcast.
     *
     * @returns {boolean}
     */
    ResizeObservation.prototype.isActive = function () {
        var rect = getContentRect(this.target);
        this.contentRect_ = rect;
        return (rect.width !== this.broadcastWidth ||
            rect.height !== this.broadcastHeight);
    };
    /**
     * Updates 'broadcastWidth' and 'broadcastHeight' properties with a data
     * from the corresponding properties of the last observed content rectangle.
     *
     * @returns {DOMRectInit} Last observed content rectangle.
     */
    ResizeObservation.prototype.broadcastRect = function () {
        var rect = this.contentRect_;
        this.broadcastWidth = rect.width;
        this.broadcastHeight = rect.height;
        return rect;
    };
    return ResizeObservation;
}());

var ResizeObserverEntry = /** @class */ (function () {
    /**
     * Creates an instance of ResizeObserverEntry.
     *
     * @param {Element} target - Element that is being observed.
     * @param {DOMRectInit} rectInit - Data of the element's content rectangle.
     */
    function ResizeObserverEntry(target, rectInit) {
        var contentRect = createReadOnlyRect(rectInit);
        // According to the specification following properties are not writable
        // and are also not enumerable in the native implementation.
        //
        // Property accessors are not being used as they'd require to define a
        // private WeakMap storage which may cause memory leaks in browsers that
        // don't support this type of collections.
        defineConfigurable(this, { target: target, contentRect: contentRect });
    }
    return ResizeObserverEntry;
}());

var ResizeObserverSPI = /** @class */ (function () {
    /**
     * Creates a new instance of ResizeObserver.
     *
     * @param {ResizeObserverCallback} callback - Callback function that is invoked
     *      when one of the observed elements changes it's content dimensions.
     * @param {ResizeObserverController} controller - Controller instance which
     *      is responsible for the updates of observer.
     * @param {ResizeObserver} callbackCtx - Reference to the public
     *      ResizeObserver instance which will be passed to callback function.
     */
    function ResizeObserverSPI(callback, controller, callbackCtx) {
        /**
         * Collection of resize observations that have detected changes in dimensions
         * of elements.
         *
         * @private {Array<ResizeObservation>}
         */
        this.activeObservations_ = [];
        /**
         * Registry of the ResizeObservation instances.
         *
         * @private {Map<Element, ResizeObservation>}
         */
        this.observations_ = new MapShim();
        if (typeof callback !== 'function') {
            throw new TypeError('The callback provided as parameter 1 is not a function.');
        }
        this.callback_ = callback;
        this.controller_ = controller;
        this.callbackCtx_ = callbackCtx;
    }
    /**
     * Starts observing provided element.
     *
     * @param {Element} target - Element to be observed.
     * @returns {void}
     */
    ResizeObserverSPI.prototype.observe = function (target) {
        if (!arguments.length) {
            throw new TypeError('1 argument required, but only 0 present.');
        }
        // Do nothing if current environment doesn't have the Element interface.
        if (typeof Element === 'undefined' || !(Element instanceof Object)) {
            return;
        }
        if (!(target instanceof getWindowOf(target).Element)) {
            throw new TypeError('parameter 1 is not of type "Element".');
        }
        var observations = this.observations_;
        // Do nothing if element is already being observed.
        if (observations.has(target)) {
            return;
        }
        observations.set(target, new ResizeObservation(target));
        this.controller_.addObserver(this);
        // Force the update of observations.
        this.controller_.refresh();
    };
    /**
     * Stops observing provided element.
     *
     * @param {Element} target - Element to stop observing.
     * @returns {void}
     */
    ResizeObserverSPI.prototype.unobserve = function (target) {
        if (!arguments.length) {
            throw new TypeError('1 argument required, but only 0 present.');
        }
        // Do nothing if current environment doesn't have the Element interface.
        if (typeof Element === 'undefined' || !(Element instanceof Object)) {
            return;
        }
        if (!(target instanceof getWindowOf(target).Element)) {
            throw new TypeError('parameter 1 is not of type "Element".');
        }
        var observations = this.observations_;
        // Do nothing if element is not being observed.
        if (!observations.has(target)) {
            return;
        }
        observations.delete(target);
        if (!observations.size) {
            this.controller_.removeObserver(this);
        }
    };
    /**
     * Stops observing all elements.
     *
     * @returns {void}
     */
    ResizeObserverSPI.prototype.disconnect = function () {
        this.clearActive();
        this.observations_.clear();
        this.controller_.removeObserver(this);
    };
    /**
     * Collects observation instances the associated element of which has changed
     * it's content rectangle.
     *
     * @returns {void}
     */
    ResizeObserverSPI.prototype.gatherActive = function () {
        var _this = this;
        this.clearActive();
        this.observations_.forEach(function (observation) {
            if (observation.isActive()) {
                _this.activeObservations_.push(observation);
            }
        });
    };
    /**
     * Invokes initial callback function with a list of ResizeObserverEntry
     * instances collected from active resize observations.
     *
     * @returns {void}
     */
    ResizeObserverSPI.prototype.broadcastActive = function () {
        // Do nothing if observer doesn't have active observations.
        if (!this.hasActive()) {
            return;
        }
        var ctx = this.callbackCtx_;
        // Create ResizeObserverEntry instance for every active observation.
        var entries = this.activeObservations_.map(function (observation) {
            return new ResizeObserverEntry(observation.target, observation.broadcastRect());
        });
        this.callback_.call(ctx, entries, ctx);
        this.clearActive();
    };
    /**
     * Clears the collection of active observations.
     *
     * @returns {void}
     */
    ResizeObserverSPI.prototype.clearActive = function () {
        this.activeObservations_.splice(0);
    };
    /**
     * Tells whether observer has active observations.
     *
     * @returns {boolean}
     */
    ResizeObserverSPI.prototype.hasActive = function () {
        return this.activeObservations_.length > 0;
    };
    return ResizeObserverSPI;
}());

// Registry of internal observers. If WeakMap is not available use current shim
// for the Map collection as it has all required methods and because WeakMap
// can't be fully polyfilled anyway.
var observers = typeof WeakMap !== 'undefined' ? new WeakMap() : new MapShim();
/**
 * ResizeObserver API. Encapsulates the ResizeObserver SPI implementation
 * exposing only those methods and properties that are defined in the spec.
 */
var ResizeObserver = /** @class */ (function () {
    /**
     * Creates a new instance of ResizeObserver.
     *
     * @param {ResizeObserverCallback} callback - Callback that is invoked when
     *      dimensions of the observed elements change.
     */
    function ResizeObserver(callback) {
        if (!(this instanceof ResizeObserver)) {
            throw new TypeError('Cannot call a class as a function.');
        }
        if (!arguments.length) {
            throw new TypeError('1 argument required, but only 0 present.');
        }
        var controller = ResizeObserverController.getInstance();
        var observer = new ResizeObserverSPI(callback, controller, this);
        observers.set(this, observer);
    }
    return ResizeObserver;
}());
// Expose public methods of ResizeObserver.
[
    'observe',
    'unobserve',
    'disconnect'
].forEach(function (method) {
    ResizeObserver.prototype[method] = function () {
        var _a;
        return (_a = observers.get(this))[method].apply(_a, arguments);
    };
});

var index = (function () {
    // Export existing implementation if available.
    if (typeof global$1.ResizeObserver !== 'undefined') {
        return global$1.ResizeObserver;
    }
    return ResizeObserver;
})();

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (index);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_projectstorm_react-diagrams-core_dist_index_js.371669c81fb2d7445d49.js.map