from rospy.core import *
from _typeshed import Incomplete
from collections.abc import Generator
from rospy.exceptions import ROSSerializationException as ROSSerializationException, TransportTerminated as TransportTerminated
from rospy.impl.registration import Registration as Registration, get_registration_listeners as get_registration_listeners, get_topic_manager as get_topic_manager, set_topic_manager as set_topic_manager
from rospy.impl.statistics import SubscriberStatisticsLogger as SubscriberStatisticsLogger
from rospy.impl.tcpros import DEFAULT_BUFF_SIZE as DEFAULT_BUFF_SIZE, get_tcpros_handler as get_tcpros_handler
from rospy.impl.tcpros_pubsub import QueuedConnection as QueuedConnection
from rospy.msg import args_kwds_to_message as args_kwds_to_message, serialize_message as serialize_message

python3: int

def isstring(s): ...

Message: Incomplete

class Topic:
    resolved_name: Incomplete
    name: Incomplete
    data_class: Incomplete
    type: Incomplete
    md5sum: Incomplete
    reg_type: Incomplete
    impl: Incomplete
    def __init__(self, name, data_class, reg_type) -> None: ...
    def get_num_connections(self): ...
    def unregister(self) -> None: ...

class Poller:
    poller: Incomplete
    add_fd: Incomplete
    remove_fd: Incomplete
    error_iter: Incomplete
    kevents: Incomplete
    def __init__(self) -> None: ...
    def noop(self, *args) -> None: ...
    def noop_iter(self) -> Generator[Incomplete, None, None]: ...
    def add_poll(self, fd) -> None: ...
    def remove_poll(self, fd) -> None: ...
    def error_poll_iter(self) -> Generator[Incomplete, None, None]: ...
    def add_epoll(self, fd) -> None: ...
    def remove_epoll(self, fd) -> None: ...
    def error_epoll_iter(self) -> Generator[Incomplete, None, None]: ...
    def add_kqueue(self, fd) -> None: ...
    def error_kqueue_iter(self) -> Generator[Incomplete, None, None]: ...
    def remove_kqueue(self, fd) -> None: ...

class _TopicImpl:
    resolved_name: Incomplete
    name: Incomplete
    data_class: Incomplete
    type: Incomplete
    handler: Incomplete
    seq: int
    c_lock: Incomplete
    connections: Incomplete
    closed: bool
    ref_count: int
    connection_poll: Incomplete
    def __init__(self, name, data_class) -> None: ...
    def __del__(self) -> None: ...
    def close(self) -> None: ...
    def get_num_connections(self): ...
    def has_connection(self, endpoint_id): ...
    def has_connections(self): ...
    def add_connection(self, c): ...
    def check(self) -> None: ...
    def remove_connection(self, c) -> None: ...
    def get_stats_info(self): ...
    def get_stats(self) -> None: ...

class Subscriber(Topic):
    callback: Incomplete
    callback_args: Incomplete
    def __init__(self, name, data_class, callback: Incomplete | None = ..., callback_args: Incomplete | None = ..., queue_size: Incomplete | None = ..., buff_size=..., tcp_nodelay: bool = ...) -> None: ...
    def unregister(self) -> None: ...

class _SubscriberImpl(_TopicImpl):
    callbacks: Incomplete
    queue_size: Incomplete
    buff_size: Incomplete
    tcp_nodelay: bool
    statistics_logger: Incomplete
    def __init__(self, name, data_class) -> None: ...
    def close(self) -> None: ...
    def set_tcp_nodelay(self, tcp_nodelay) -> None: ...
    def set_queue_size(self, queue_size) -> None: ...
    def set_buff_size(self, buff_size) -> None: ...
    def get_stats(self): ...
    def add_callback(self, cb, cb_args) -> None: ...
    def remove_callback(self, cb, cb_args) -> None: ...
    def receive_callback(self, msgs, connection) -> None: ...

class SubscribeListener:
    def peer_subscribe(self, topic_name, topic_publish, peer_publish) -> None: ...
    def peer_unsubscribe(self, topic_name, num_peers) -> None: ...

class Publisher(Topic):
    def __init__(self, name, data_class, subscriber_listener: Incomplete | None = ..., tcp_nodelay: bool = ..., latch: bool = ..., headers: Incomplete | None = ..., queue_size: Incomplete | None = ...) -> None: ...
    def publish(self, *args, **kwds) -> None: ...

class _PublisherImpl(_TopicImpl):
    buff: Incomplete
    publock: Incomplete
    subscriber_listeners: Incomplete
    headers: Incomplete
    is_latch: bool
    latch: Incomplete
    queue_size: Incomplete
    message_data_sent: int
    def __init__(self, name, data_class) -> None: ...
    def close(self) -> None: ...
    def add_headers(self, headers) -> None: ...
    def enable_latch(self) -> None: ...
    def set_queue_size(self, queue_size) -> None: ...
    def get_stats(self): ...
    def add_subscriber_listener(self, l) -> None: ...
    def acquire(self) -> None: ...
    def release(self) -> None: ...
    def add_connection(self, c): ...
    def remove_connection(self, c) -> None: ...
    def publish(self, message, connection_override: Incomplete | None = ...): ...

class _TopicManager:
    pubs: Incomplete
    subs: Incomplete
    topics: Incomplete
    lock: Incomplete
    closed: bool
    def __init__(self) -> None: ...
    def get_pub_sub_info(self): ...
    def get_pub_sub_stats(self): ...
    def close_all(self) -> None: ...
    def check_all(self) -> None: ...
    def get_impl(self, reg_type, resolved_name): ...
    def acquire_impl(self, reg_type, resolved_name, data_class): ...
    def release_impl(self, reg_type, resolved_name) -> None: ...
    def get_publisher_impl(self, resolved_name): ...
    def get_subscriber_impl(self, resolved_name): ...
    def has_subscription(self, resolved_name): ...
    def has_publication(self, resolved_name): ...
    def get_topics(self): ...
    def get_subscriptions(self): ...
    def get_publications(self): ...
