# mypy-boto3-guardduty

[![PyPI - mypy-boto3-guardduty](https://img.shields.io/pypi/v/mypy-boto3-guardduty.svg?color=blue)](https://pypi.org/project/mypy-boto3-guardduty)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-guardduty.svg?color=blue)](https://pypi.org/project/mypy-boto3-guardduty)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.GuardDuty 1.15.13](https://boto3.amazonaws.com/v1/documentation/api/1.15.13/reference/services/guardduty.html#GuardDuty) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-guardduty](#mypy-boto3-guardduty)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `GuardDuty` service.

```bash
python -m pip install boto3-stubs[guardduty]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[guardduty]` in your environment: `python -m pip install 'boto3-stubs[guardduty]'`

Both type checking and auto-complete should work for `GuardDuty` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[guardduty]` in your environment: `python -m pip install 'boto3-stubs[guardduty]'`

Both type checking and auto-complete should work for `GuardDuty` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[guardduty]` in your environment: `python -m pip install 'boto3-stubs[guardduty]'`
- Run `mypy` as usual

Type checking should work for `GuardDuty` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[guardduty]` in your environment: `python -m pip install 'boto3-stubs[guardduty]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `GuardDuty` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`GuardDutyClient` provides annotations for `boto3.client("guardduty")`.

```python
import boto3

from mypy_boto3_guardduty import GuardDutyClient

client: GuardDutyClient = boto3.client("guardduty")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: GuardDutyClient = session.client("guardduty")
```

### Paginators annotations

`mypy_boto3_guardduty.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_guardduty import GuardDutyClient
from mypy_boto3_guardduty.paginator import (
    ListDetectorsPaginator,
    ListFiltersPaginator,
    ListFindingsPaginator,
    ListInvitationsPaginator,
    ListIPSetsPaginator,
    ListMembersPaginator,
    ListOrganizationAdminAccountsPaginator,
    ListThreatIntelSetsPaginator,
)

client: GuardDutyClient = boto3.client("guardduty")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_detectors_paginator: ListDetectorsPaginator = client.get_paginator("list_detectors")
list_filters_paginator: ListFiltersPaginator = client.get_paginator("list_filters")
list_findings_paginator: ListFindingsPaginator = client.get_paginator("list_findings")
list_ip_sets_paginator: ListIPSetsPaginator = client.get_paginator("list_ip_sets")
list_invitations_paginator: ListInvitationsPaginator = client.get_paginator("list_invitations")
list_members_paginator: ListMembersPaginator = client.get_paginator("list_members")
list_organization_admin_accounts_paginator: ListOrganizationAdminAccountsPaginator = client.get_paginator("list_organization_admin_accounts")
list_threat_intel_sets_paginator: ListThreatIntelSetsPaginator = client.get_paginator("list_threat_intel_sets")
```







### Typed dictionations

`mypy_boto3_guardduty.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_guardduty.type_defs import (
    AccessControlListTypeDef,
    AccessKeyDetailsTypeDef,
    AccountDetailTypeDef,
    AccountLevelPermissionsTypeDef,
    ActionTypeDef,
    AdminAccountTypeDef,
    AwsApiCallActionTypeDef,
    BlockPublicAccessTypeDef,
    BucketLevelPermissionsTypeDef,
    BucketPolicyTypeDef,
    CityTypeDef,
    CloudTrailConfigurationResultTypeDef,
    ConditionTypeDef,
    CountryTypeDef,
    CreateDetectorResponseTypeDef,
    CreateFilterResponseTypeDef,
    CreateIPSetResponseTypeDef,
    CreateMembersResponseTypeDef,
    CreatePublishingDestinationResponseTypeDef,
    CreateThreatIntelSetResponseTypeDef,
    DataSourceConfigurationsResultTypeDef,
    DataSourceConfigurationsTypeDef,
    DeclineInvitationsResponseTypeDef,
    DefaultServerSideEncryptionTypeDef,
    DeleteInvitationsResponseTypeDef,
    DeleteMembersResponseTypeDef,
    DescribeOrganizationConfigurationResponseTypeDef,
    DescribePublishingDestinationResponseTypeDef,
    DestinationPropertiesTypeDef,
    DestinationTypeDef,
    DisassociateMembersResponseTypeDef,
    DNSLogsConfigurationResultTypeDef,
    DnsRequestActionTypeDef,
    DomainDetailsTypeDef,
    EvidenceTypeDef,
    FindingCriteriaTypeDef,
    FindingStatisticsTypeDef,
    FindingTypeDef,
    FlowLogsConfigurationResultTypeDef,
    GeoLocationTypeDef,
    GetDetectorResponseTypeDef,
    GetFilterResponseTypeDef,
    GetFindingsResponseTypeDef,
    GetFindingsStatisticsResponseTypeDef,
    GetInvitationsCountResponseTypeDef,
    GetIPSetResponseTypeDef,
    GetMasterAccountResponseTypeDef,
    GetMemberDetectorsResponseTypeDef,
    GetMembersResponseTypeDef,
    GetThreatIntelSetResponseTypeDef,
    GetUsageStatisticsResponseTypeDef,
    IamInstanceProfileTypeDef,
    InstanceDetailsTypeDef,
    InvitationTypeDef,
    InviteMembersResponseTypeDef,
    ListDetectorsResponseTypeDef,
    ListFiltersResponseTypeDef,
    ListFindingsResponseTypeDef,
    ListInvitationsResponseTypeDef,
    ListIPSetsResponseTypeDef,
    ListMembersResponseTypeDef,
    ListOrganizationAdminAccountsResponseTypeDef,
    ListPublishingDestinationsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListThreatIntelSetsResponseTypeDef,
    LocalIpDetailsTypeDef,
    LocalPortDetailsTypeDef,
    MasterTypeDef,
    MemberDataSourceConfigurationTypeDef,
    MemberTypeDef,
    NetworkConnectionActionTypeDef,
    NetworkInterfaceTypeDef,
    OrganizationDataSourceConfigurationsResultTypeDef,
    OrganizationDataSourceConfigurationsTypeDef,
    OrganizationS3LogsConfigurationResultTypeDef,
    OrganizationS3LogsConfigurationTypeDef,
    OrganizationTypeDef,
    OwnerTypeDef,
    PaginatorConfigTypeDef,
    PermissionConfigurationTypeDef,
    PortProbeActionTypeDef,
    PortProbeDetailTypeDef,
    PrivateIpAddressDetailsTypeDef,
    ProductCodeTypeDef,
    PublicAccessTypeDef,
    RemoteIpDetailsTypeDef,
    RemotePortDetailsTypeDef,
    ResourceTypeDef,
    S3BucketDetailTypeDef,
    S3LogsConfigurationResultTypeDef,
    S3LogsConfigurationTypeDef,
    SecurityGroupTypeDef,
    ServiceTypeDef,
    SortCriteriaTypeDef,
    StartMonitoringMembersResponseTypeDef,
    StopMonitoringMembersResponseTypeDef,
    TagTypeDef,
    ThreatIntelligenceDetailTypeDef,
    TotalTypeDef,
    UnprocessedAccountTypeDef,
    UpdateFilterResponseTypeDef,
    UpdateMemberDetectorsResponseTypeDef,
    UsageAccountResultTypeDef,
    UsageCriteriaTypeDef,
    UsageDataSourceResultTypeDef,
    UsageResourceResultTypeDef,
    UsageStatisticsTypeDef,
)

def get_structure() -> AccessControlListTypeDef:
    return {
      ...
    }
```
