r"""
Copyright &copy; 2023 NetApp Inc.
All rights reserved.

This file has been automatically generated based on the ONTAP REST API documentation.

## Overview
A POST request allows a standalone application to log its events on the ONTAP system as EMS events and optionally generate AutoSupports. This event information is encapsulated in an app.log.x event, or callhome.client.app.x event in case AutoSupport generation is required, based on the event's severity.</br>
####
Note: This API only supports POST. Generated events can be retrieved using the /api/support/ems/events API.
## Examples
### Creating a new app.log.* event
The following example generates an app.log.error event.
```python
from netapp_ontap import HostConnection
from netapp_ontap.resources import EmsApplicationLog

with HostConnection("<mgmt-ip>", username="admin", password="password", verify=False):
    resource = EmsApplicationLog()
    resource.computer_name = "W12-R2-DC"
    resource.event_source = "SnapCenter Software"
    resource.app_version = "3.0.0.2373"
    resource.event_id = 10001
    resource.category = "error"
    resource.event_description = "Clone split job failed"
    resource.severity = "error"
    resource.autosupport_required = False
    resource.post(hydrate=True)
    print(resource)

```

---
### Retrieving a list of events generated by this API
The following example retrieves all app.log.* events.
```python
from netapp_ontap import HostConnection
from netapp_ontap.resources import EmsEvent

with HostConnection("<mgmt-ip>", username="admin", password="password", verify=False):
    print(list(EmsEvent.get_collection(**{"message.name": "app.log.*"})))

```
<div class="try_it_out">
<input id="example1_try_it_out" type="checkbox", class="try_it_out_check">
<label for="example1_try_it_out" class="try_it_out_button">Try it out</label>
<div id="example1_result" class="try_it_out_content">
```
[
    EmsEvent(
        {
            "_links": {"self": {"href": "/api/support/ems/events/node1/7865"}},
            "node": {
                "_links": {
                    "self": {
                        "href": "/api/cluster/nodes/d96d5d8d-118a-11ec-aad8-005056bb974c"
                    }
                },
                "name": "node1",
                "uuid": "d96d5d8d-118a-11ec-aad8-005056bb974c",
            },
            "message": {"severity": "emergency", "name": "app.log.emerg"},
            "log_message": "app.log.emerg: iMac: iPad ipad3: (10001) handheld: TestLine1",
            "time": "2021-09-17T09:36:28-04:00",
            "index": 7865,
        }
    )
]

```
</div>
</div>
"""

import asyncio
from datetime import datetime
import inspect
from typing import Callable, Iterable, List, Optional, Union

try:
    RECLINE_INSTALLED = False
    import recline
    from recline.arg_types.choices import Choices
    from recline.commands import ReclineCommandError
    from netapp_ontap.resource_table import ResourceTable
    RECLINE_INSTALLED = True
except ImportError:
    pass

from marshmallow import fields, EXCLUDE  # type: ignore

import netapp_ontap
from netapp_ontap.resource import Resource, ResourceSchema, ResourceSchemaMeta, ImpreciseDateTime, Size
from netapp_ontap import NetAppResponse, HostConnection
from netapp_ontap.validations import enum_validation, len_validation, integer_validation
from netapp_ontap.error import NetAppRestError


__all__ = ["EmsApplicationLog", "EmsApplicationLogSchema"]
__pdoc__ = {
    "EmsApplicationLogSchema.resource": False,
    "EmsApplicationLogSchema.opts": False,
    "EmsApplicationLog.ems_application_log_show": False,
    "EmsApplicationLog.ems_application_log_create": False,
    "EmsApplicationLog.ems_application_log_modify": False,
    "EmsApplicationLog.ems_application_log_delete": False,
}


class EmsApplicationLogSchema(ResourceSchema, metaclass=ResourceSchemaMeta):
    """The fields of the EmsApplicationLog object"""

    app_version = fields.Str(
        data_key="app_version",
    )
    r""" Client application version.

Example: 3.0.0.2373"""

    autosupport_required = fields.Boolean(
        data_key="autosupport_required",
    )
    r""" Indicates whether AutoSupport generation is required.

Example: false"""

    category = fields.Str(
        data_key="category",
    )
    r""" Event category.

Example: Error"""

    computer_name = fields.Str(
        data_key="computer_name",
    )
    r""" Client computer connected to the cluster.

Example: W12-R2-DC"""

    event_description = fields.Str(
        data_key="event_description",
    )
    r""" Event description, which corresponds to the subject parameter in the generated event.

Example: Clone split job failed"""

    event_id = Size(
        data_key="event_id",
    )
    r""" Application eventID.

Example: 10001"""

    event_source = fields.Str(
        data_key="event_source",
    )
    r""" Client application that generated this event.

Example: SnapCenter Software"""

    severity = fields.Str(
        data_key="severity",
        validate=enum_validation(['emergency', 'alert', 'error', 'notice']),
    )
    r""" Severity

Valid choices:

* emergency
* alert
* error
* notice"""

    @property
    def resource(self):
        return EmsApplicationLog

    gettable_fields = [
    ]
    """"""

    patchable_fields = [
    ]
    """"""

    postable_fields = [
        "app_version",
        "autosupport_required",
        "category",
        "computer_name",
        "event_description",
        "event_id",
        "event_source",
        "severity",
    ]
    """app_version,autosupport_required,category,computer_name,event_description,event_id,event_source,severity,"""

def _get_field_list(field: str) -> Callable[[], List]:
    def getter():
        return [getattr(r, field) for r in EmsApplicationLog.get_collection(fields=field)]
    return getter

async def _wait_for_job(response: NetAppResponse) -> None:
    """Examine the given response. If it is a job, asynchronously wait for it to
    complete. While polling, prints the current status message of the job.
    """

    if not response.is_job:
        return
    from netapp_ontap.resources import Job
    job = Job(**response.http_response.json()["job"])
    while True:
        job.get(fields="state,message")
        if hasattr(job, "message"):
            print("[%s]: %s" % (job.state, job.message))
        if job.state == "failure":
            raise NetAppRestError("EmsApplicationLog modify job failed")
        if job.state == "success":
            break
        await asyncio.sleep(1)

class EmsApplicationLog(Resource):
    r""" Input for generation of app.log.x and callhome.client.app.x events. """

    _schema = EmsApplicationLogSchema
    _path = "/api/support/ems/application-logs"



    @classmethod
    def post_collection(
        cls,
        records: Iterable["EmsApplicationLog"],
        *args,
        hydrate: bool = False,
        poll: bool = True,
        poll_interval: Optional[int] = None,
        poll_timeout: Optional[int] = None,
        connection: HostConnection = None,
        **kwargs
    ) -> Union[List["EmsApplicationLog"], NetAppResponse]:
        r"""Creates an app.log.* event. Setting the "autosupport_required" flag causes callhome.client.app.* events also to be generated, which in turn triggers AutoSupports.
### Required properties
* `computer_name` - Client computer connected to the cluster.
* `event_source` - Client application that generated this event.
* `app_version` - Client application version.
* `event_id` - Application eventID.
* `category` - Event category.
* `event_description` - Event description.
* `severity` - Severity of the event.
* `autosupport_required` - Indicates whether AutoSupport generation is required.

### Learn more
* [`DOC /support/ems/application-logs`](#docs-support-support_ems_application-logs)"""
        return super()._post_collection(
            records, *args, hydrate=hydrate, poll=poll, poll_interval=poll_interval,
            poll_timeout=poll_timeout, connection=connection, **kwargs
        )

    post_collection.__func__.__doc__ += "\n\n---\n" + inspect.cleandoc(Resource._post_collection.__doc__)




    def post(
        self,
        hydrate: bool = False,
        poll: bool = True,
        poll_interval: Optional[int] = None,
        poll_timeout: Optional[int] = None,
        **kwargs
    ) -> NetAppResponse:
        r"""Creates an app.log.* event. Setting the "autosupport_required" flag causes callhome.client.app.* events also to be generated, which in turn triggers AutoSupports.
### Required properties
* `computer_name` - Client computer connected to the cluster.
* `event_source` - Client application that generated this event.
* `app_version` - Client application version.
* `event_id` - Application eventID.
* `category` - Event category.
* `event_description` - Event description.
* `severity` - Severity of the event.
* `autosupport_required` - Indicates whether AutoSupport generation is required.

### Learn more
* [`DOC /support/ems/application-logs`](#docs-support-support_ems_application-logs)"""
        return super()._post(
            hydrate=hydrate, poll=poll, poll_interval=poll_interval,
            poll_timeout=poll_timeout, **kwargs
        )

    post.__doc__ += "\n\n---\n" + inspect.cleandoc(Resource._post.__doc__)

    if RECLINE_INSTALLED:
        @recline.command(name="ems application log create")
        async def ems_application_log_create(
        ) -> ResourceTable:
            """Create an instance of a EmsApplicationLog resource

            Args:
                app_version: Client application version.
                autosupport_required: Indicates whether AutoSupport generation is required.
                category: Event category.
                computer_name: Client computer connected to the cluster.
                event_description: Event description, which corresponds to the subject parameter in the generated event.
                event_id: Application eventID.
                event_source: Client application that generated this event.
                severity: Severity
            """

            kwargs = {}
            if app_version is not None:
                kwargs["app_version"] = app_version
            if autosupport_required is not None:
                kwargs["autosupport_required"] = autosupport_required
            if category is not None:
                kwargs["category"] = category
            if computer_name is not None:
                kwargs["computer_name"] = computer_name
            if event_description is not None:
                kwargs["event_description"] = event_description
            if event_id is not None:
                kwargs["event_id"] = event_id
            if event_source is not None:
                kwargs["event_source"] = event_source
            if severity is not None:
                kwargs["severity"] = severity

            resource = EmsApplicationLog(
                **kwargs
            )
            try:
                response = resource.post(hydrate=True, poll=False)
                await _wait_for_job(response)
                resource.get()
            except NetAppRestError as err:
                raise ReclineCommandError("Unable to create EmsApplicationLog: %s" % err)
            return [resource]




