# coding: utf-8

"""
    SnapTrade

    Connect brokerage accounts to your app for live positions and trading

    The version of the OpenAPI document: 1.0.0
    Contact: api@snaptrade.com
    Created by: https://snaptrade.com/
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from snaptrade_client import schemas  # noqa: F401


class Account(
    schemas.DictSchema
):
    """
    This class is auto generated by Konfig (https://konfigthis.com)

    A single account at a brokerage.
    """


    class MetaOapg:
        required = {
            "number",
            "balance",
            "brokerage_authorization",
            "name",
            "sync_status",
            "created_date",
            "id",
            "institution_name",
        }
        
        class properties:
            
            
            class id(
                schemas.ComposedSchema,
            ):
            
            
                class MetaOapg:
                    all_of_0 = schemas.UUIDSchema
                    
                    @classmethod
                    @functools.lru_cache()
                    def all_of(cls):
                        # we need this here to make our import statements work
                        # we must store _composed_schemas in here so the code is only run
                        # when we invoke this method. If we kept this at the class
                        # level we would get an error because the class level
                        # code would be run when this module is imported, and these composed
                        # classes don't exist yet because their module has not finished
                        # loading
                        return [
                            cls.all_of_0,
                        ]
            
            
                def __new__(
                    cls,
                    *args: typing.Union[dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                    **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
                ) -> 'id':
                    return super().__new__(
                        cls,
                        *args,
                        _configuration=_configuration,
                        **kwargs,
                    )
            brokerage_authorization = schemas.UUIDSchema
            
            
            class name(
                schemas.StrBase,
                schemas.NoneBase,
                schemas.Schema,
                schemas.NoneStrMixin
            ):
            
            
                def __new__(
                    cls,
                    *args: typing.Union[None, str, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'name':
                    return super().__new__(
                        cls,
                        *args,
                        _configuration=_configuration,
                    )
            number = schemas.StrSchema
            institution_name = schemas.StrSchema
            created_date = schemas.DateTimeSchema
        
            @staticmethod
            def sync_status() -> typing.Type['AccountSyncStatus']:
                return AccountSyncStatus
        
            @staticmethod
            def balance() -> typing.Type['AccountBalance']:
                return AccountBalance
        
            @staticmethod
            def meta() -> typing.Type['AccountMeta']:
                return AccountMeta
            portfolio_group = schemas.UUIDSchema
        
            @staticmethod
            def cash_restrictions() -> typing.Type['AccountCashRestrictions']:
                return AccountCashRestrictions
            
            
            class raw_type(
                schemas.StrBase,
                schemas.NoneBase,
                schemas.Schema,
                schemas.NoneStrMixin
            ):
            
            
                def __new__(
                    cls,
                    *args: typing.Union[None, str, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'raw_type':
                    return super().__new__(
                        cls,
                        *args,
                        _configuration=_configuration,
                    )
            __annotations__ = {
                "id": id,
                "brokerage_authorization": brokerage_authorization,
                "name": name,
                "number": number,
                "institution_name": institution_name,
                "created_date": created_date,
                "sync_status": sync_status,
                "balance": balance,
                "meta": meta,
                "portfolio_group": portfolio_group,
                "cash_restrictions": cash_restrictions,
                "raw_type": raw_type,
            }
        additional_properties = schemas.AnyTypeSchema
    
    number: MetaOapg.properties.number
    balance: 'AccountBalance'
    brokerage_authorization: MetaOapg.properties.brokerage_authorization
    name: MetaOapg.properties.name
    sync_status: 'AccountSyncStatus'
    created_date: MetaOapg.properties.created_date
    id: MetaOapg.properties.id
    institution_name: MetaOapg.properties.institution_name
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["number"]) -> MetaOapg.properties.number: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["balance"]) -> 'AccountBalance': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["brokerage_authorization"]) -> MetaOapg.properties.brokerage_authorization: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["name"]) -> MetaOapg.properties.name: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["sync_status"]) -> 'AccountSyncStatus': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["created_date"]) -> MetaOapg.properties.created_date: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["institution_name"]) -> MetaOapg.properties.institution_name: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["meta"]) -> 'AccountMeta': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["portfolio_group"]) -> MetaOapg.properties.portfolio_group: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["cash_restrictions"]) -> 'AccountCashRestrictions': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["raw_type"]) -> MetaOapg.properties.raw_type: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> MetaOapg.additional_properties: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["number"], typing_extensions.Literal["balance"], typing_extensions.Literal["brokerage_authorization"], typing_extensions.Literal["name"], typing_extensions.Literal["sync_status"], typing_extensions.Literal["created_date"], typing_extensions.Literal["id"], typing_extensions.Literal["institution_name"], typing_extensions.Literal["meta"], typing_extensions.Literal["portfolio_group"], typing_extensions.Literal["cash_restrictions"], typing_extensions.Literal["raw_type"], str, ]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["number"]) -> MetaOapg.properties.number: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["balance"]) -> 'AccountBalance': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["brokerage_authorization"]) -> MetaOapg.properties.brokerage_authorization: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["name"]) -> MetaOapg.properties.name: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["sync_status"]) -> 'AccountSyncStatus': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["created_date"]) -> MetaOapg.properties.created_date: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["institution_name"]) -> MetaOapg.properties.institution_name: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["meta"]) -> typing.Union['AccountMeta', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["portfolio_group"]) -> typing.Union[MetaOapg.properties.portfolio_group, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["cash_restrictions"]) -> typing.Union['AccountCashRestrictions', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["raw_type"]) -> typing.Union[MetaOapg.properties.raw_type, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[MetaOapg.additional_properties, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["number"], typing_extensions.Literal["balance"], typing_extensions.Literal["brokerage_authorization"], typing_extensions.Literal["name"], typing_extensions.Literal["sync_status"], typing_extensions.Literal["created_date"], typing_extensions.Literal["id"], typing_extensions.Literal["institution_name"], typing_extensions.Literal["meta"], typing_extensions.Literal["portfolio_group"], typing_extensions.Literal["cash_restrictions"], typing_extensions.Literal["raw_type"], str, ]):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        number: typing.Union[MetaOapg.properties.number, str, ],
        balance: 'AccountBalance',
        brokerage_authorization: typing.Union[MetaOapg.properties.brokerage_authorization, str, uuid.UUID, ],
        name: typing.Union[MetaOapg.properties.name, None, str, ],
        sync_status: 'AccountSyncStatus',
        created_date: typing.Union[MetaOapg.properties.created_date, str, datetime, ],
        id: typing.Union[MetaOapg.properties.id, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ],
        institution_name: typing.Union[MetaOapg.properties.institution_name, str, ],
        meta: typing.Union['AccountMeta', schemas.Unset] = schemas.unset,
        portfolio_group: typing.Union[MetaOapg.properties.portfolio_group, str, uuid.UUID, schemas.Unset] = schemas.unset,
        cash_restrictions: typing.Union['AccountCashRestrictions', schemas.Unset] = schemas.unset,
        raw_type: typing.Union[MetaOapg.properties.raw_type, None, str, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[MetaOapg.additional_properties, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ],
    ) -> 'Account':
        return super().__new__(
            cls,
            *args,
            number=number,
            balance=balance,
            brokerage_authorization=brokerage_authorization,
            name=name,
            sync_status=sync_status,
            created_date=created_date,
            id=id,
            institution_name=institution_name,
            meta=meta,
            portfolio_group=portfolio_group,
            cash_restrictions=cash_restrictions,
            raw_type=raw_type,
            _configuration=_configuration,
            **kwargs,
        )

from snaptrade_client.model.account_balance import AccountBalance
from snaptrade_client.model.account_cash_restrictions import AccountCashRestrictions
from snaptrade_client.model.account_meta import AccountMeta
from snaptrade_client.model.account_sync_status import AccountSyncStatus
