"""
Binance Derivatives Trading USDS Futures REST API

OpenAPI Specification for the Binance Derivatives Trading USDS Futures REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from typing import Optional, Union
from requests import Session
from binance_common.configuration import ConfigurationRestAPI
from binance_common.errors import RequiredError
from binance_common.models import ApiResponse
from binance_common.signature import Signers
from binance_common.utils import send_request

from ..models import AccountInformationV2Response
from ..models import AccountInformationV3Response
from ..models import FuturesAccountBalanceV2Response
from ..models import FuturesAccountBalanceV3Response
from ..models import FuturesAccountConfigurationResponse
from ..models import FuturesTradingQuantitativeRulesIndicatorsResponse
from ..models import GetBnbBurnStatusResponse
from ..models import GetCurrentMultiAssetsModeResponse
from ..models import GetCurrentPositionModeResponse
from ..models import GetDownloadIdForFuturesOrderHistoryResponse
from ..models import GetDownloadIdForFuturesTradeHistoryResponse
from ..models import GetDownloadIdForFuturesTransactionHistoryResponse
from ..models import GetFuturesOrderHistoryDownloadLinkByIdResponse
from ..models import GetFuturesTradeDownloadLinkByIdResponse
from ..models import GetFuturesTransactionHistoryDownloadLinkByIdResponse
from ..models import GetIncomeHistoryResponse
from ..models import NotionalAndLeverageBracketsResponse
from ..models import QueryUserRateLimitResponse
from ..models import SymbolConfigurationResponse
from ..models import ToggleBnbBurnOnFuturesTradeResponse
from ..models import UserCommissionRateResponse


class AccountApi:
    """API Client for AccountApi endpoints."""

    def __init__(
        self,
        configuration: ConfigurationRestAPI = None,
        session: Session = None,
        signer: Signers = None,
    ) -> None:
        self._configuration = configuration
        self._session = session
        self._signer = signer

    def account_information_v2(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[AccountInformationV2Response]:
        """
                Account Information V2(USER_DATA)
                GET /fapi/v2/account
                https://developers.binance.com/docs/derivatives/usds-margined-futures/account/rest-api/Account-Information-V2

                Get current account information. User in single-asset/ multi-assets mode will see different value, see comments in response section for detail.

        Weight: 5

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[AccountInformationV2Response]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v2/account",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=AccountInformationV2Response,
            is_signed=True,
            signer=self._signer,
        )

    def account_information_v3(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[AccountInformationV3Response]:
        """
                Account Information V3(USER_DATA)
                GET /fapi/v3/account
                https://developers.binance.com/docs/derivatives/usds-margined-futures/account/rest-api/Account-Information-V3

                Get current account information. User in single-asset/ multi-assets mode will see different value, see comments in response section for detail.

        Weight: 5

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[AccountInformationV3Response]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v3/account",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=AccountInformationV3Response,
            is_signed=True,
            signer=self._signer,
        )

    def futures_account_balance_v2(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[FuturesAccountBalanceV2Response]:
        """
                Futures Account Balance V2 (USER_DATA)
                GET /fapi/v2/balance
                https://developers.binance.com/docs/derivatives/usds-margined-futures/account/rest-api/Futures-Account-Balance-V2

                Query account balance info

        Weight: 5

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[FuturesAccountBalanceV2Response]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v2/balance",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=FuturesAccountBalanceV2Response,
            is_signed=True,
            signer=self._signer,
        )

    def futures_account_balance_v3(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[FuturesAccountBalanceV3Response]:
        """
                Futures Account Balance V3 (USER_DATA)
                GET /fapi/v3/balance
                https://developers.binance.com/docs/derivatives/usds-margined-futures/account/rest-api/Futures-Account-Balance-V3

                Query account balance info

        Weight: 5

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[FuturesAccountBalanceV3Response]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v3/balance",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=FuturesAccountBalanceV3Response,
            is_signed=True,
            signer=self._signer,
        )

    def futures_account_configuration(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[FuturesAccountConfigurationResponse]:
        """
                Futures Account Configuration(USER_DATA)
                GET /fapi/v1/accountConfig
                https://developers.binance.com/docs/derivatives/usds-margined-futures/account/rest-api/Account-Config

                Query account configuration

        Weight: 5

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[FuturesAccountConfigurationResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/accountConfig",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=FuturesAccountConfigurationResponse,
            is_signed=True,
            signer=self._signer,
        )

    def futures_trading_quantitative_rules_indicators(
        self,
        symbol: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[FuturesTradingQuantitativeRulesIndicatorsResponse]:
        """
                Futures Trading Quantitative Rules Indicators (USER_DATA)
                GET /fapi/v1/apiTradingStatus
                https://developers.binance.com/docs/derivatives/usds-margined-futures/account/rest-api/Futures-Trading-Quantitative-Rules-Indicators

                Futures trading quantitative rules indicators, for more information on this, please refer to the [Futures Trading Quantitative Rules](https://www.binance.com/en/support/faq/4f462ebe6ff445d4a170be7d9e897272)

        Weight: - 1 for a single symbol
        - 10 when the symbol parameter is omitted

                Args:
                    symbol (Optional[str] = None):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[FuturesTradingQuantitativeRulesIndicatorsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"symbol": symbol, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/apiTradingStatus",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=FuturesTradingQuantitativeRulesIndicatorsResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_bnb_burn_status(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetBnbBurnStatusResponse]:
        """
                Get BNB Burn Status (USER_DATA)
                GET /fapi/v1/feeBurn
                https://developers.binance.com/docs/derivatives/usds-margined-futures/account/rest-api/Get-BNB-Burn-Status

                Get user's BNB Fee Discount (Fee Discount On or Fee Discount Off )

        Weight: 30

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetBnbBurnStatusResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/feeBurn",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetBnbBurnStatusResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_current_multi_assets_mode(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetCurrentMultiAssetsModeResponse]:
        """
                Get Current Multi-Assets Mode (USER_DATA)
                GET /fapi/v1/multiAssetsMargin
                https://developers.binance.com/docs/derivatives/usds-margined-futures/account/rest-api/Get-Current-Multi-Assets-Mode

                Get user's Multi-Assets mode (Multi-Assets Mode or Single-Asset Mode) on ***Every symbol***

        Weight: 30

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetCurrentMultiAssetsModeResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/multiAssetsMargin",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetCurrentMultiAssetsModeResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_current_position_mode(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetCurrentPositionModeResponse]:
        """
                Get Current Position Mode(USER_DATA)
                GET /fapi/v1/positionSide/dual
                https://developers.binance.com/docs/derivatives/usds-margined-futures/account/rest-api/Get-Current-Position-Mode

                Get user's position mode (Hedge Mode or One-way Mode ) on ***EVERY symbol***

        Weight: 30

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetCurrentPositionModeResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/positionSide/dual",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetCurrentPositionModeResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_download_id_for_futures_order_history(
        self,
        start_time: Union[int, None],
        end_time: Union[int, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetDownloadIdForFuturesOrderHistoryResponse]:
        """
                Get Download Id For Futures Order History (USER_DATA)
                GET /fapi/v1/order/asyn
                https://developers.binance.com/docs/derivatives/usds-margined-futures/account/rest-api/Get-Download-Id-For-Futures-Order-History

                Get Download Id For Futures Order History

        * Request Limitation is 10 times per month, shared by front end download page and rest api
        * The time between `startTime` and `endTime` can not be longer than 1 year

        Weight: 1000

                Args:
                    start_time (Union[int, None]): Timestamp in ms
                    end_time (Union[int, None]): Timestamp in ms
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetDownloadIdForFuturesOrderHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if start_time is None:
            raise RequiredError(
                field="start_time",
                error_message="Missing required parameter 'start_time'",
            )
        if end_time is None:
            raise RequiredError(
                field="end_time", error_message="Missing required parameter 'end_time'"
            )

        payload = {
            "start_time": start_time,
            "end_time": end_time,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/order/asyn",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetDownloadIdForFuturesOrderHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_download_id_for_futures_trade_history(
        self,
        start_time: Union[int, None],
        end_time: Union[int, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetDownloadIdForFuturesTradeHistoryResponse]:
        """
                Get Download Id For Futures Trade History (USER_DATA)
                GET /fapi/v1/trade/asyn
                https://developers.binance.com/docs/derivatives/usds-margined-futures/account/rest-api/Get-Download-Id-For-Futures-Trade-History

                Get download id for futures trade history

        * Request Limitation is 5 times per month, shared by front end download page and rest api
        * The time between `startTime` and `endTime` can not be longer than 1 year

        Weight: 1000

                Args:
                    start_time (Union[int, None]): Timestamp in ms
                    end_time (Union[int, None]): Timestamp in ms
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetDownloadIdForFuturesTradeHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if start_time is None:
            raise RequiredError(
                field="start_time",
                error_message="Missing required parameter 'start_time'",
            )
        if end_time is None:
            raise RequiredError(
                field="end_time", error_message="Missing required parameter 'end_time'"
            )

        payload = {
            "start_time": start_time,
            "end_time": end_time,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/trade/asyn",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetDownloadIdForFuturesTradeHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_download_id_for_futures_transaction_history(
        self,
        start_time: Union[int, None],
        end_time: Union[int, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetDownloadIdForFuturesTransactionHistoryResponse]:
        """
                Get Download Id For Futures Transaction History(USER_DATA)
                GET /fapi/v1/income/asyn
                https://developers.binance.com/docs/derivatives/usds-margined-futures/account/rest-api/Get-Download-Id-For-Futures-Transaction-History

                Get download id for futures transaction history

        * Request Limitation is 5 times per month, shared by front end download page and rest api
        * The time between `startTime` and `endTime` can not be longer than 1 year

        Weight: 1000

                Args:
                    start_time (Union[int, None]): Timestamp in ms
                    end_time (Union[int, None]): Timestamp in ms
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetDownloadIdForFuturesTransactionHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if start_time is None:
            raise RequiredError(
                field="start_time",
                error_message="Missing required parameter 'start_time'",
            )
        if end_time is None:
            raise RequiredError(
                field="end_time", error_message="Missing required parameter 'end_time'"
            )

        payload = {
            "start_time": start_time,
            "end_time": end_time,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/income/asyn",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetDownloadIdForFuturesTransactionHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_futures_order_history_download_link_by_id(
        self,
        download_id: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFuturesOrderHistoryDownloadLinkByIdResponse]:
        """
                Get Futures Order History Download Link by Id (USER_DATA)
                GET /fapi/v1/order/asyn/id
                https://developers.binance.com/docs/derivatives/usds-margined-futures/account/rest-api/Get-Futures-Order-History-Download-Link-by-Id

                Get futures order history download link by Id

        * Download link expiration: 24h

        Weight: 10

                Args:
                    download_id (Union[str, None]): get by download id api
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetFuturesOrderHistoryDownloadLinkByIdResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if download_id is None:
            raise RequiredError(
                field="download_id",
                error_message="Missing required parameter 'download_id'",
            )

        payload = {"download_id": download_id, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/order/asyn/id",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetFuturesOrderHistoryDownloadLinkByIdResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_futures_trade_download_link_by_id(
        self,
        download_id: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFuturesTradeDownloadLinkByIdResponse]:
        """
                Get Futures Trade Download Link by Id(USER_DATA)
                GET /fapi/v1/trade/asyn/id
                https://developers.binance.com/docs/derivatives/usds-margined-futures/account/rest-api/Get-Futures-Trade-Download-Link-by-Id

                Get futures trade download link by Id

        * Download link expiration: 24h

        Weight: 10

                Args:
                    download_id (Union[str, None]): get by download id api
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetFuturesTradeDownloadLinkByIdResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if download_id is None:
            raise RequiredError(
                field="download_id",
                error_message="Missing required parameter 'download_id'",
            )

        payload = {"download_id": download_id, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/trade/asyn/id",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetFuturesTradeDownloadLinkByIdResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_futures_transaction_history_download_link_by_id(
        self,
        download_id: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFuturesTransactionHistoryDownloadLinkByIdResponse]:
        """
                Get Futures Transaction History Download Link by Id (USER_DATA)
                GET /fapi/v1/income/asyn/id
                https://developers.binance.com/docs/derivatives/usds-margined-futures/account/rest-api/Get-Futures-Transaction-History-Download-Link-by-Id

                Get futures transaction history download link by Id

        * Download link expiration: 24h

        Weight: 10

                Args:
                    download_id (Union[str, None]): get by download id api
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetFuturesTransactionHistoryDownloadLinkByIdResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if download_id is None:
            raise RequiredError(
                field="download_id",
                error_message="Missing required parameter 'download_id'",
            )

        payload = {"download_id": download_id, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/income/asyn/id",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetFuturesTransactionHistoryDownloadLinkByIdResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_income_history(
        self,
        symbol: Optional[str] = None,
        income_type: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        page: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetIncomeHistoryResponse]:
        """
                Get Income History (USER_DATA)
                GET /fapi/v1/income
                https://developers.binance.com/docs/derivatives/usds-margined-futures/account/rest-api/Get-Income-History

                Query income history

        * If neither `startTime` nor `endTime` is sent, the recent 7-day data will be returned.
        * If `incomeType ` is not sent, all kinds of flow will be returned
        * "trandId" is unique in the same incomeType for a user
        * Income history only contains data for the last three months

        Weight: 30

                Args:
                    symbol (Optional[str] = None):
                    income_type (Optional[str] = None): TRANSFER, WELCOME_BONUS, REALIZED_PNL, FUNDING_FEE, COMMISSION, INSURANCE_CLEAR, REFERRAL_KICKBACK, COMMISSION_REBATE, API_REBATE, CONTEST_REWARD, CROSS_COLLATERAL_TRANSFER, OPTIONS_PREMIUM_FEE, OPTIONS_SETTLE_PROFIT, INTERNAL_TRANSFER, AUTO_EXCHANGE, DELIVERED_SETTELMENT, COIN_SWAP_DEPOSIT, COIN_SWAP_WITHDRAW, POSITION_LIMIT_INCREASE_FEE, STRATEGY_UMFUTURES_TRANSFER，FEE_RETURN，BFUSD_REWARD
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    page (Optional[int] = None):
                    limit (Optional[int] = None): Default 100; max 1000
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetIncomeHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "symbol": symbol,
            "income_type": income_type,
            "start_time": start_time,
            "end_time": end_time,
            "page": page,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/income",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetIncomeHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def notional_and_leverage_brackets(
        self,
        symbol: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[NotionalAndLeverageBracketsResponse]:
        """
                Notional and Leverage Brackets (USER_DATA)
                GET /fapi/v1/leverageBracket
                https://developers.binance.com/docs/derivatives/usds-margined-futures/account/rest-api/Notional-and-Leverage-Brackets

                Query user notional and leverage bracket on speicfic symbol

        Weight: 1

                Args:
                    symbol (Optional[str] = None):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[NotionalAndLeverageBracketsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"symbol": symbol, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/leverageBracket",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=NotionalAndLeverageBracketsResponse,
            is_signed=True,
            signer=self._signer,
        )

    def query_user_rate_limit(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QueryUserRateLimitResponse]:
        """
                Query User Rate Limit (USER_DATA)
                GET /fapi/v1/rateLimit/order
                https://developers.binance.com/docs/derivatives/usds-margined-futures/account/rest-api/Query-Rate-Limit

                Query User Rate Limit

        Weight: 1

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QueryUserRateLimitResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/rateLimit/order",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QueryUserRateLimitResponse,
            is_signed=True,
            signer=self._signer,
        )

    def symbol_configuration(
        self,
        symbol: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SymbolConfigurationResponse]:
        """
                Symbol Configuration(USER_DATA)
                GET /fapi/v1/symbolConfig
                https://developers.binance.com/docs/derivatives/usds-margined-futures/account/rest-api/Symbol-Config

                Get current account symbol configuration.

        Weight: 5

                Args:
                    symbol (Optional[str] = None):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[SymbolConfigurationResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"symbol": symbol, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/symbolConfig",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=SymbolConfigurationResponse,
            is_signed=True,
            signer=self._signer,
        )

    def toggle_bnb_burn_on_futures_trade(
        self,
        fee_burn: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[ToggleBnbBurnOnFuturesTradeResponse]:
        """
                Toggle BNB Burn On Futures Trade (TRADE)
                POST /fapi/v1/feeBurn
                https://developers.binance.com/docs/derivatives/usds-margined-futures/account/rest-api/Toggle-BNB-Burn-On-Futures-Trade

                Change user's BNB Fee Discount (Fee Discount On or Fee Discount Off ) on ***EVERY symbol***

        Weight: 1

                Args:
                    fee_burn (Union[str, None]): "true": Fee Discount On; "false": Fee Discount Off
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[ToggleBnbBurnOnFuturesTradeResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if fee_burn is None:
            raise RequiredError(
                field="fee_burn", error_message="Missing required parameter 'fee_burn'"
            )

        payload = {"fee_burn": fee_burn, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/fapi/v1/feeBurn",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=ToggleBnbBurnOnFuturesTradeResponse,
            is_signed=True,
            signer=self._signer,
        )

    def user_commission_rate(
        self,
        symbol: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[UserCommissionRateResponse]:
        """
                User Commission Rate (USER_DATA)
                GET /fapi/v1/commissionRate
                https://developers.binance.com/docs/derivatives/usds-margined-futures/account/rest-api/User-Commission-Rate

                Get User Commission Rate

        Weight: 20

                Args:
                    symbol (Union[str, None]):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[UserCommissionRateResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        payload = {"symbol": symbol, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/commissionRate",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=UserCommissionRateResponse,
            is_signed=True,
            signer=self._signer,
        )
