"""
Binance Derivatives Trading USDS Futures REST API

OpenAPI Specification for the Binance Derivatives Trading USDS Futures REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from typing import Optional, Union
from requests import Session
from binance_common.configuration import ConfigurationRestAPI
from binance_common.errors import RequiredError
from binance_common.models import ApiResponse
from binance_common.signature import Signers
from binance_common.utils import send_request

from ..models import AcceptTheOfferedQuoteResponse
from ..models import ListAllConvertPairsResponse
from ..models import OrderStatusResponse
from ..models import SendQuoteRequestResponse


class ConvertApi:
    """API Client for ConvertApi endpoints."""

    def __init__(
        self,
        configuration: ConfigurationRestAPI = None,
        session: Session = None,
        signer: Signers = None,
    ) -> None:
        self._configuration = configuration
        self._session = session
        self._signer = signer

    def accept_the_offered_quote(
        self,
        quote_id: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[AcceptTheOfferedQuoteResponse]:
        """
                Accept the offered quote (USER_DATA)
                POST /fapi/v1/convert/acceptQuote
                https://developers.binance.com/docs/derivatives/usds-margined-futures/convert/Accept-Quote

                Accept the offered quote by quote ID.

        Weight: 200(IP)

                Args:
                    quote_id (Union[str, None]):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[AcceptTheOfferedQuoteResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if quote_id is None:
            raise RequiredError(
                field="quote_id", error_message="Missing required parameter 'quote_id'"
            )

        payload = {"quote_id": quote_id, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/fapi/v1/convert/acceptQuote",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=AcceptTheOfferedQuoteResponse,
            is_signed=True,
            signer=self._signer,
        )

    def list_all_convert_pairs(
        self,
        from_asset: Optional[str] = None,
        to_asset: Optional[str] = None,
    ) -> ApiResponse[ListAllConvertPairsResponse]:
        """
                List All Convert Pairs
                GET /fapi/v1/convert/exchangeInfo
                https://developers.binance.com/docs/derivatives/usds-margined-futures/convert/

                Query for all convertible token pairs and the tokens’ respective upper/lower limits

        * User needs to supply either or both of the input parameter
        * If not defined for both fromAsset and toAsset, only partial token pairs will be returned
        * Asset BNFCR is only available to convert for MICA region users.

        Weight: 20(IP)

                Args:
                    from_asset (Optional[str] = None): User spends coin
                    to_asset (Optional[str] = None): User receives coin

                Returns:
                    ApiResponse[ListAllConvertPairsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"from_asset": from_asset, "to_asset": to_asset}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/convert/exchangeInfo",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=ListAllConvertPairsResponse,
        )

    def order_status(
        self,
        order_id: Optional[str] = None,
        quote_id: Optional[str] = None,
    ) -> ApiResponse[OrderStatusResponse]:
        """
                Order status(USER_DATA)
                GET /fapi/v1/convert/orderStatus
                https://developers.binance.com/docs/derivatives/usds-margined-futures/convert/Order-Status

                Query order status by order ID.

        Weight: 50(IP)

                Args:
                    order_id (Optional[str] = None): Either orderId or quoteId is required
                    quote_id (Optional[str] = None): Either orderId or quoteId is required

                Returns:
                    ApiResponse[OrderStatusResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"order_id": order_id, "quote_id": quote_id}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/convert/orderStatus",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=OrderStatusResponse,
            is_signed=True,
            signer=self._signer,
        )

    def send_quote_request(
        self,
        from_asset: Union[str, None],
        to_asset: Union[str, None],
        from_amount: Optional[float] = None,
        to_amount: Optional[float] = None,
        valid_time: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SendQuoteRequestResponse]:
        """
                Send Quote Request(USER_DATA)
                POST /fapi/v1/convert/getQuote
                https://developers.binance.com/docs/derivatives/usds-margined-futures/convert/Send-quote-request

                Request a quote for the requested token pairs

        * Either fromAmount or toAmount should be sent
        * `quoteId` will be returned only if you have enough funds to convert

        Weight: 50(IP)

                Args:
                    from_asset (Union[str, None]):
                    to_asset (Union[str, None]):
                    from_amount (Optional[float] = None): When specified, it is the amount you will be debited after the conversion
                    to_amount (Optional[float] = None): When specified, it is the amount you will be credited after the conversion
                    valid_time (Optional[str] = None): 10s, default 10s
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[SendQuoteRequestResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if from_asset is None:
            raise RequiredError(
                field="from_asset",
                error_message="Missing required parameter 'from_asset'",
            )
        if to_asset is None:
            raise RequiredError(
                field="to_asset", error_message="Missing required parameter 'to_asset'"
            )

        payload = {
            "from_asset": from_asset,
            "to_asset": to_asset,
            "from_amount": from_amount,
            "to_amount": to_amount,
            "valid_time": valid_time,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/fapi/v1/convert/getQuote",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=SendQuoteRequestResponse,
            is_signed=True,
            signer=self._signer,
        )
