"""
Binance Derivatives Trading USDS Futures REST API

OpenAPI Specification for the Binance Derivatives Trading USDS Futures REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from typing import Optional, Union
from requests import Session
from binance_common.configuration import ConfigurationRestAPI
from binance_common.errors import RequiredError
from binance_common.models import ApiResponse
from binance_common.signature import Signers
from binance_common.utils import send_request

from ..models import BasisResponse
from ..models import CheckServerTimeResponse
from ..models import CompositeIndexSymbolInformationResponse
from ..models import CompressedAggregateTradesListResponse
from ..models import ContinuousContractKlineCandlestickDataResponse
from ..models import ExchangeInformationResponse
from ..models import GetFundingRateHistoryResponse
from ..models import GetFundingRateInfoResponse
from ..models import IndexPriceKlineCandlestickDataResponse
from ..models import KlineCandlestickDataResponse
from ..models import LongShortRatioResponse
from ..models import MarkPriceResponse
from ..models import MarkPriceKlineCandlestickDataResponse
from ..models import MultiAssetsModeAssetIndexResponse
from ..models import OldTradesLookupResponse
from ..models import OpenInterestResponse
from ..models import OpenInterestStatisticsResponse
from ..models import OrderBookResponse
from ..models import PremiumIndexKlineDataResponse
from ..models import QuarterlyContractSettlementPriceResponse
from ..models import QueryIndexPriceConstituentsResponse
from ..models import QueryInsuranceFundBalanceSnapshotResponse
from ..models import RecentTradesListResponse
from ..models import SymbolOrderBookTickerResponse
from ..models import SymbolPriceTickerResponse
from ..models import SymbolPriceTickerV2Response
from ..models import TakerBuySellVolumeResponse

from ..models import Ticker24hrPriceChangeStatisticsResponse
from ..models import TopTraderLongShortRatioAccountsResponse
from ..models import TopTraderLongShortRatioPositionsResponse


from ..models import BasisContractTypeEnum
from ..models import BasisPeriodEnum
from ..models import ContinuousContractKlineCandlestickDataContractTypeEnum
from ..models import ContinuousContractKlineCandlestickDataIntervalEnum
from ..models import IndexPriceKlineCandlestickDataIntervalEnum
from ..models import KlineCandlestickDataIntervalEnum
from ..models import LongShortRatioPeriodEnum
from ..models import MarkPriceKlineCandlestickDataIntervalEnum
from ..models import OpenInterestStatisticsPeriodEnum
from ..models import PremiumIndexKlineDataIntervalEnum
from ..models import TakerBuySellVolumePeriodEnum
from ..models import TopTraderLongShortRatioAccountsPeriodEnum
from ..models import TopTraderLongShortRatioPositionsPeriodEnum


class MarketDataApi:
    """API Client for MarketDataApi endpoints."""

    def __init__(
        self,
        configuration: ConfigurationRestAPI = None,
        session: Session = None,
        signer: Signers = None,
    ) -> None:
        self._configuration = configuration
        self._session = session
        self._signer = signer

    def basis(
        self,
        pair: Union[str, None],
        contract_type: Union[BasisContractTypeEnum, None],
        period: Union[BasisPeriodEnum, None],
        limit: Union[int, None],
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
    ) -> ApiResponse[BasisResponse]:
        """
                Basis
                GET /futures/data/basis
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Basis

                Query future basis

        * If startTime and endTime are not sent, the most recent data is returned.
        * Only the data of the latest 30 days is available.

        Weight: 0

                Args:
                    pair (Union[str, None]):
                    contract_type (Union[BasisContractTypeEnum, None]):
                    period (Union[BasisPeriodEnum, None]): "5m","15m","30m","1h","2h","4h","6h","12h","1d"
                    limit (Union[int, None]): Default 30,Max 500
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):

                Returns:
                    ApiResponse[BasisResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if pair is None:
            raise RequiredError(
                field="pair", error_message="Missing required parameter 'pair'"
            )
        if contract_type is None:
            raise RequiredError(
                field="contract_type",
                error_message="Missing required parameter 'contract_type'",
            )
        if period is None:
            raise RequiredError(
                field="period", error_message="Missing required parameter 'period'"
            )
        if limit is None:
            raise RequiredError(
                field="limit", error_message="Missing required parameter 'limit'"
            )

        payload = {
            "pair": pair,
            "contract_type": contract_type,
            "period": period,
            "limit": limit,
            "start_time": start_time,
            "end_time": end_time,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/futures/data/basis",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=BasisResponse,
        )

    def check_server_time(
        self,
    ) -> ApiResponse[CheckServerTimeResponse]:
        """
                Check Server Time
                GET /fapi/v1/time
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Check-Server-Time

                Test connectivity to the Rest API and get the current server time.

        Weight: 1

                Args:

                Returns:
                    ApiResponse[CheckServerTimeResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = None

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/time",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=CheckServerTimeResponse,
        )

    def composite_index_symbol_information(
        self,
        symbol: Optional[str] = None,
    ) -> ApiResponse[CompositeIndexSymbolInformationResponse]:
        """
                Composite Index Symbol Information
                GET /fapi/v1/indexInfo
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Composite-Index-Symbol-Information

                Query composite index symbol information

        * Only for composite index symbols

        Weight: 1

                Args:
                    symbol (Optional[str] = None):

                Returns:
                    ApiResponse[CompositeIndexSymbolInformationResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"symbol": symbol}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/indexInfo",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=CompositeIndexSymbolInformationResponse,
        )

    def compressed_aggregate_trades_list(
        self,
        symbol: Union[str, None],
        from_id: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
    ) -> ApiResponse[CompressedAggregateTradesListResponse]:
        """
                Compressed/Aggregate Trades List
                GET /fapi/v1/aggTrades
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Compressed-Aggregate-Trades-List

                Get compressed, aggregate market trades. Market trades that fill in 100ms with the same price and the same taking side will have the quantity aggregated.


        * support querying futures trade histories that are not older than one year
        * If both `startTime` and `endTime` are sent, time between `startTime` and `endTime` must be less than 1 hour.
        * If `fromId`, `startTime`, and `endTime` are not sent, the most recent aggregate trades will be returned.
        * Only market trades will be aggregated and returned, which means the insurance fund trades and ADL trades won't be aggregated.
        * Sending both `startTime`/`endTime` and `fromId` might cause response timeout, please send either `fromId` or `startTime`/`endTime`

        Weight: 20

                Args:
                    symbol (Union[str, None]):
                    from_id (Optional[int] = None): ID to get aggregate trades from INCLUSIVE.
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default 100; max 1000

                Returns:
                    ApiResponse[CompressedAggregateTradesListResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        payload = {
            "symbol": symbol,
            "from_id": from_id,
            "start_time": start_time,
            "end_time": end_time,
            "limit": limit,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/aggTrades",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=CompressedAggregateTradesListResponse,
        )

    def continuous_contract_kline_candlestick_data(
        self,
        pair: Union[str, None],
        contract_type: Union[
            ContinuousContractKlineCandlestickDataContractTypeEnum, None
        ],
        interval: Union[ContinuousContractKlineCandlestickDataIntervalEnum, None],
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
    ) -> ApiResponse[ContinuousContractKlineCandlestickDataResponse]:
        """
                Continuous Contract Kline/Candlestick Data
                GET /fapi/v1/continuousKlines
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Continuous-Contract-Kline-Candlestick-Data

                Kline/candlestick bars for a specific contract type.
        Klines are uniquely identified by their open time.

        * If startTime and endTime are not sent, the most recent klines are returned.
        * Contract type:
        * PERPETUAL
        * CURRENT_QUARTER
        * NEXT_QUARTER

        Weight: based on parameter LIMIT
        | LIMIT       | weight |
        | ----------- | ------ |
        | [1,100)     | 1      |
        | [100, 500)  | 2      |
        | [500, 1000] | 5      |
        | > 1000      | 10     |

                Args:
                    pair (Union[str, None]):
                    contract_type (Union[ContinuousContractKlineCandlestickDataContractTypeEnum, None]):
                    interval (Union[ContinuousContractKlineCandlestickDataIntervalEnum, None]):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default 100; max 1000

                Returns:
                    ApiResponse[ContinuousContractKlineCandlestickDataResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if pair is None:
            raise RequiredError(
                field="pair", error_message="Missing required parameter 'pair'"
            )
        if contract_type is None:
            raise RequiredError(
                field="contract_type",
                error_message="Missing required parameter 'contract_type'",
            )
        if interval is None:
            raise RequiredError(
                field="interval", error_message="Missing required parameter 'interval'"
            )

        payload = {
            "pair": pair,
            "contract_type": contract_type,
            "interval": interval,
            "start_time": start_time,
            "end_time": end_time,
            "limit": limit,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/continuousKlines",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=ContinuousContractKlineCandlestickDataResponse,
        )

    def exchange_information(
        self,
    ) -> ApiResponse[ExchangeInformationResponse]:
        """
                Exchange Information
                GET /fapi/v1/exchangeInfo
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Exchange-Information

                Current exchange trading rules and symbol information

        Weight: 1

                Args:

                Returns:
                    ApiResponse[ExchangeInformationResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = None

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/exchangeInfo",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=ExchangeInformationResponse,
        )

    def get_funding_rate_history(
        self,
        symbol: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
    ) -> ApiResponse[GetFundingRateHistoryResponse]:
        """
                Get Funding Rate History
                GET /fapi/v1/fundingRate
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Get-Funding-Rate-History

                Get Funding Rate History


        * If `startTime` and `endTime` are not sent, the most recent 200 records are returned.
        * If the number of data between `startTime` and `endTime` is larger than `limit`, return as `startTime` + `limit`.
        * In ascending order.

        Weight: share 500/5min/IP rate limit with GET /fapi/v1/fundingInfo

                Args:
                    symbol (Optional[str] = None):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default 100; max 1000

                Returns:
                    ApiResponse[GetFundingRateHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "symbol": symbol,
            "start_time": start_time,
            "end_time": end_time,
            "limit": limit,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/fundingRate",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetFundingRateHistoryResponse,
        )

    def get_funding_rate_info(
        self,
    ) -> ApiResponse[GetFundingRateInfoResponse]:
        """
                Get Funding Rate Info
                GET /fapi/v1/fundingInfo
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Get-Funding-Rate-Info

                Query funding rate info for symbols that had FundingRateCap/ FundingRateFloor / fundingIntervalHours adjustment

        Weight: 0
        share 500/5min/IP rate limit with GET /fapi/v1/fundingInfo

                Args:

                Returns:
                    ApiResponse[GetFundingRateInfoResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = None

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/fundingInfo",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetFundingRateInfoResponse,
        )

    def index_price_kline_candlestick_data(
        self,
        pair: Union[str, None],
        interval: Union[IndexPriceKlineCandlestickDataIntervalEnum, None],
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
    ) -> ApiResponse[IndexPriceKlineCandlestickDataResponse]:
        """
                Index Price Kline/Candlestick Data
                GET /fapi/v1/indexPriceKlines
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Index-Price-Kline-Candlestick-Data

                Kline/candlestick bars for the index price of a pair.
        Klines are uniquely identified by their open time.


        * If startTime and endTime are not sent, the most recent klines are returned.

        Weight: based on parameter LIMIT
        | LIMIT       | weight |
        | ----------- | ------ |
        | [1,100)     | 1      |
        | [100, 500)  | 2      |
        | [500, 1000] | 5      |
        | > 1000      | 10     |

                Args:
                    pair (Union[str, None]):
                    interval (Union[IndexPriceKlineCandlestickDataIntervalEnum, None]):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default 100; max 1000

                Returns:
                    ApiResponse[IndexPriceKlineCandlestickDataResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if pair is None:
            raise RequiredError(
                field="pair", error_message="Missing required parameter 'pair'"
            )
        if interval is None:
            raise RequiredError(
                field="interval", error_message="Missing required parameter 'interval'"
            )

        payload = {
            "pair": pair,
            "interval": interval,
            "start_time": start_time,
            "end_time": end_time,
            "limit": limit,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/indexPriceKlines",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=IndexPriceKlineCandlestickDataResponse,
        )

    def kline_candlestick_data(
        self,
        symbol: Union[str, None],
        interval: Union[KlineCandlestickDataIntervalEnum, None],
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
    ) -> ApiResponse[KlineCandlestickDataResponse]:
        """
                Kline/Candlestick Data
                GET /fapi/v1/klines
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Kline-Candlestick-Data

                Kline/candlestick bars for a symbol.
        Klines are uniquely identified by their open time.

        * If startTime and endTime are not sent, the most recent klines are returned.

        Weight: based on parameter LIMIT
        | LIMIT       | weight |
        | ----------- | ------ |
        | [1,100)     | 1      |
        | [100, 500)  | 2      |
        | [500, 1000] | 5      |
        | > 1000      | 10     |

                Args:
                    symbol (Union[str, None]):
                    interval (Union[KlineCandlestickDataIntervalEnum, None]):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default 100; max 1000

                Returns:
                    ApiResponse[KlineCandlestickDataResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )
        if interval is None:
            raise RequiredError(
                field="interval", error_message="Missing required parameter 'interval'"
            )

        payload = {
            "symbol": symbol,
            "interval": interval,
            "start_time": start_time,
            "end_time": end_time,
            "limit": limit,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/klines",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=KlineCandlestickDataResponse,
        )

    def long_short_ratio(
        self,
        symbol: Union[str, None],
        period: Union[LongShortRatioPeriodEnum, None],
        limit: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
    ) -> ApiResponse[LongShortRatioResponse]:
        """
                Long/Short Ratio
                GET /futures/data/globalLongShortAccountRatio
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Long-Short-Ratio

                Query symbol Long/Short Ratio

        * If startTime and endTime are not sent, the most recent data is returned.
        * Only the data of the latest 30 days is available.
        * IP rate limit 1000 requests/5min

        Weight: 0

                Args:
                    symbol (Union[str, None]):
                    period (Union[LongShortRatioPeriodEnum, None]): "5m","15m","30m","1h","2h","4h","6h","12h","1d"
                    limit (Optional[int] = None): Default 100; max 1000
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):

                Returns:
                    ApiResponse[LongShortRatioResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )
        if period is None:
            raise RequiredError(
                field="period", error_message="Missing required parameter 'period'"
            )

        payload = {
            "symbol": symbol,
            "period": period,
            "limit": limit,
            "start_time": start_time,
            "end_time": end_time,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/futures/data/globalLongShortAccountRatio",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=LongShortRatioResponse,
        )

    def mark_price(
        self,
        symbol: Optional[str] = None,
    ) -> ApiResponse[MarkPriceResponse]:
        """
                Mark Price
                GET /fapi/v1/premiumIndex
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Mark-Price

                Mark Price and Funding Rate

        Weight: 1

                Args:
                    symbol (Optional[str] = None):

                Returns:
                    ApiResponse[MarkPriceResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"symbol": symbol}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/premiumIndex",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=MarkPriceResponse,
        )

    def mark_price_kline_candlestick_data(
        self,
        symbol: Union[str, None],
        interval: Union[MarkPriceKlineCandlestickDataIntervalEnum, None],
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
    ) -> ApiResponse[MarkPriceKlineCandlestickDataResponse]:
        """
                Mark Price Kline/Candlestick Data
                GET /fapi/v1/markPriceKlines
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Mark-Price-Kline-Candlestick-Data

                Kline/candlestick bars for the mark price of a symbol.
        Klines are uniquely identified by their open time.

        * If startTime and endTime are not sent, the most recent klines are returned.

        Weight: based on parameter LIMIT
        | LIMIT       | weight |
        | ----------- | ------ |
        | [1,100)     | 1      |
        | [100, 500)  | 2      |
        | [500, 1000] | 5      |
        | > 1000      | 10     |

                Args:
                    symbol (Union[str, None]):
                    interval (Union[MarkPriceKlineCandlestickDataIntervalEnum, None]):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default 100; max 1000

                Returns:
                    ApiResponse[MarkPriceKlineCandlestickDataResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )
        if interval is None:
            raise RequiredError(
                field="interval", error_message="Missing required parameter 'interval'"
            )

        payload = {
            "symbol": symbol,
            "interval": interval,
            "start_time": start_time,
            "end_time": end_time,
            "limit": limit,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/markPriceKlines",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=MarkPriceKlineCandlestickDataResponse,
        )

    def multi_assets_mode_asset_index(
        self,
        symbol: Optional[str] = None,
    ) -> ApiResponse[MultiAssetsModeAssetIndexResponse]:
        """
                Multi-Assets Mode Asset Index
                GET /fapi/v1/assetIndex
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Multi-Assets-Mode-Asset-Index

                asset index for Multi-Assets mode

        Weight: 1 for a single symbol; 10 when the symbol parameter is omitted

                Args:
                    symbol (Optional[str] = None):

                Returns:
                    ApiResponse[MultiAssetsModeAssetIndexResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"symbol": symbol}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/assetIndex",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=MultiAssetsModeAssetIndexResponse,
        )

    def old_trades_lookup(
        self,
        symbol: Union[str, None],
        limit: Optional[int] = None,
        from_id: Optional[int] = None,
    ) -> ApiResponse[OldTradesLookupResponse]:
        """
                Old Trades Lookup (MARKET_DATA)
                GET /fapi/v1/historicalTrades
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Old-Trades-Lookup

                Get older market historical trades.

        * Market trades means trades filled in the order book. Only market trades will be returned, which means the insurance fund trades and ADL trades won't be returned.
        * Only supports data from within the last three months

        Weight: 20

                Args:
                    symbol (Union[str, None]):
                    limit (Optional[int] = None): Default 100; max 1000
                    from_id (Optional[int] = None): ID to get aggregate trades from INCLUSIVE.

                Returns:
                    ApiResponse[OldTradesLookupResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        payload = {"symbol": symbol, "limit": limit, "from_id": from_id}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/historicalTrades",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=OldTradesLookupResponse,
        )

    def open_interest(
        self,
        symbol: Union[str, None],
    ) -> ApiResponse[OpenInterestResponse]:
        """
                Open Interest
                GET /fapi/v1/openInterest
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Open-Interest

                Get present open interest of a specific symbol.

        Weight: 1

                Args:
                    symbol (Union[str, None]):

                Returns:
                    ApiResponse[OpenInterestResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        payload = {"symbol": symbol}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/openInterest",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=OpenInterestResponse,
        )

    def open_interest_statistics(
        self,
        symbol: Union[str, None],
        period: Union[OpenInterestStatisticsPeriodEnum, None],
        limit: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
    ) -> ApiResponse[OpenInterestStatisticsResponse]:
        """
                Open Interest Statistics
                GET /futures/data/openInterestHist
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Open-Interest-Statistics

                Open Interest Statistics

        * If startTime and endTime are not sent, the most recent data is returned.
        * Only the data of the latest 1 month is available.
        * IP rate limit 1000 requests/5min

        Weight: 0

                Args:
                    symbol (Union[str, None]):
                    period (Union[OpenInterestStatisticsPeriodEnum, None]): "5m","15m","30m","1h","2h","4h","6h","12h","1d"
                    limit (Optional[int] = None): Default 100; max 1000
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):

                Returns:
                    ApiResponse[OpenInterestStatisticsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )
        if period is None:
            raise RequiredError(
                field="period", error_message="Missing required parameter 'period'"
            )

        payload = {
            "symbol": symbol,
            "period": period,
            "limit": limit,
            "start_time": start_time,
            "end_time": end_time,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/futures/data/openInterestHist",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=OpenInterestStatisticsResponse,
        )

    def order_book(
        self,
        symbol: Union[str, None],
        limit: Optional[int] = None,
    ) -> ApiResponse[OrderBookResponse]:
        """
                Order Book
                GET /fapi/v1/depth
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Order-Book

                Query symbol orderbook

        Weight: Adjusted based on the limit:
        | Limit         | Weight |
        | ------------- | ------ |
        | 5, 10, 20, 50 | 2      |
        | 100           | 5      |
        | 500           | 10     |
        | 1000          | 20     |

                Args:
                    symbol (Union[str, None]):
                    limit (Optional[int] = None): Default 100; max 1000

                Returns:
                    ApiResponse[OrderBookResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        payload = {"symbol": symbol, "limit": limit}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/depth",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=OrderBookResponse,
        )

    def premium_index_kline_data(
        self,
        symbol: Union[str, None],
        interval: Union[PremiumIndexKlineDataIntervalEnum, None],
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
    ) -> ApiResponse[PremiumIndexKlineDataResponse]:
        """
                Premium index Kline Data
                GET /fapi/v1/premiumIndexKlines
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Premium-index-Kline-Data

                Premium index kline bars of a symbol. Klines are uniquely identified by their open time.


        * If startTime and endTime are not sent, the most recent klines are returned.

        Weight: based on parameter LIMIT
        | LIMIT       | weight |
        | ----------- | ------ |
        | [1,100)     | 1      |
        | [100, 500)  | 2      |
        | [500, 1000] | 5      |
        | > 1000      | 10     |

                Args:
                    symbol (Union[str, None]):
                    interval (Union[PremiumIndexKlineDataIntervalEnum, None]):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default 100; max 1000

                Returns:
                    ApiResponse[PremiumIndexKlineDataResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )
        if interval is None:
            raise RequiredError(
                field="interval", error_message="Missing required parameter 'interval'"
            )

        payload = {
            "symbol": symbol,
            "interval": interval,
            "start_time": start_time,
            "end_time": end_time,
            "limit": limit,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/premiumIndexKlines",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=PremiumIndexKlineDataResponse,
        )

    def quarterly_contract_settlement_price(
        self,
        pair: Union[str, None],
    ) -> ApiResponse[QuarterlyContractSettlementPriceResponse]:
        """
                Quarterly Contract Settlement Price
                GET /futures/data/delivery-price
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Delivery-Price

                Latest price for a symbol or symbols.

        Weight: 0

                Args:
                    pair (Union[str, None]):

                Returns:
                    ApiResponse[QuarterlyContractSettlementPriceResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if pair is None:
            raise RequiredError(
                field="pair", error_message="Missing required parameter 'pair'"
            )

        payload = {"pair": pair}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/futures/data/delivery-price",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QuarterlyContractSettlementPriceResponse,
        )

    def query_index_price_constituents(
        self,
        symbol: Union[str, None],
    ) -> ApiResponse[QueryIndexPriceConstituentsResponse]:
        """
                Query Index Price Constituents
                GET /fapi/v1/constituents
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Index-Constituents

                Query index price constituents

        Weight: 2

                Args:
                    symbol (Union[str, None]):

                Returns:
                    ApiResponse[QueryIndexPriceConstituentsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        payload = {"symbol": symbol}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/constituents",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QueryIndexPriceConstituentsResponse,
        )

    def query_insurance_fund_balance_snapshot(
        self,
        symbol: Optional[str] = None,
    ) -> ApiResponse[QueryInsuranceFundBalanceSnapshotResponse]:
        """
                Query Insurance Fund Balance Snapshot
                GET /fapi/v1/insuranceBalance
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Query-Insurance-Fund-Balance-Snapshot

                Query Insurance Fund Balance Snapshot

        Weight: 1

                Args:
                    symbol (Optional[str] = None):

                Returns:
                    ApiResponse[QueryInsuranceFundBalanceSnapshotResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"symbol": symbol}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/insuranceBalance",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QueryInsuranceFundBalanceSnapshotResponse,
        )

    def recent_trades_list(
        self,
        symbol: Union[str, None],
        limit: Optional[int] = None,
    ) -> ApiResponse[RecentTradesListResponse]:
        """
                Recent Trades List
                GET /fapi/v1/trades
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Recent-Trades-List

                Get recent market trades

        * Market trades means trades filled in the order book. Only market trades will be returned, which means the insurance fund trades and ADL trades won't be returned.

        Weight: 5

                Args:
                    symbol (Union[str, None]):
                    limit (Optional[int] = None): Default 100; max 1000

                Returns:
                    ApiResponse[RecentTradesListResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        payload = {"symbol": symbol, "limit": limit}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/trades",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=RecentTradesListResponse,
        )

    def symbol_order_book_ticker(
        self,
        symbol: Optional[str] = None,
    ) -> ApiResponse[SymbolOrderBookTickerResponse]:
        """
                Symbol Order Book Ticker
                GET /fapi/v1/ticker/bookTicker
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Symbol-Order-Book-Ticker

                Best price/qty on the order book for a symbol or symbols.

        * If the symbol is not sent, bookTickers for all symbols will be returned in an array.
        * The field `X-MBX-USED-WEIGHT-1M` in response header is not accurate from this endpoint, please ignore.

        Weight: 2 for a single symbol;
        5 when the symbol parameter is omitted

                Args:
                    symbol (Optional[str] = None):

                Returns:
                    ApiResponse[SymbolOrderBookTickerResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"symbol": symbol}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/ticker/bookTicker",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=SymbolOrderBookTickerResponse,
        )

    def symbol_price_ticker(
        self,
        symbol: Optional[str] = None,
    ) -> ApiResponse[SymbolPriceTickerResponse]:
        """
                Symbol Price Ticker(Deprecated)
                GET /fapi/v1/ticker/price
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Symbol-Price-Ticker

                Latest price for a symbol or symbols.

        * If the symbol is not sent, prices for all symbols will be returned in an array.

        Weight: 1 for a single symbol;
        2 when the symbol parameter is omitted

                Args:
                    symbol (Optional[str] = None):

                Returns:
                    ApiResponse[SymbolPriceTickerResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"symbol": symbol}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/ticker/price",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=SymbolPriceTickerResponse,
        )

    def symbol_price_ticker_v2(
        self,
        symbol: Optional[str] = None,
    ) -> ApiResponse[SymbolPriceTickerV2Response]:
        """
                Symbol Price Ticker V2
                GET /fapi/v2/ticker/price
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Symbol-Price-Ticker-V2

                Latest price for a symbol or symbols.

        * If the symbol is not sent, prices for all symbols will be returned in an array.
        * The field `X-MBX-USED-WEIGHT-1M` in response header is not accurate from this endpoint, please ignore.

        Weight: 1 for a single symbol;
        2 when the symbol parameter is omitted

                Args:
                    symbol (Optional[str] = None):

                Returns:
                    ApiResponse[SymbolPriceTickerV2Response]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"symbol": symbol}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v2/ticker/price",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=SymbolPriceTickerV2Response,
        )

    def taker_buy_sell_volume(
        self,
        symbol: Union[str, None],
        period: Union[TakerBuySellVolumePeriodEnum, None],
        limit: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
    ) -> ApiResponse[TakerBuySellVolumeResponse]:
        """
                Taker Buy/Sell Volume
                GET /futures/data/takerlongshortRatio
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Taker-BuySell-Volume

                Taker Buy/Sell Volume

        * If startTime and endTime are not sent, the most recent data is returned.
        * Only the data of the latest 30 days is available.
        * IP rate limit 1000 requests/5min

        Weight: 0

                Args:
                    symbol (Union[str, None]):
                    period (Union[TakerBuySellVolumePeriodEnum, None]): "5m","15m","30m","1h","2h","4h","6h","12h","1d"
                    limit (Optional[int] = None): Default 100; max 1000
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):

                Returns:
                    ApiResponse[TakerBuySellVolumeResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )
        if period is None:
            raise RequiredError(
                field="period", error_message="Missing required parameter 'period'"
            )

        payload = {
            "symbol": symbol,
            "period": period,
            "limit": limit,
            "start_time": start_time,
            "end_time": end_time,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/futures/data/takerlongshortRatio",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=TakerBuySellVolumeResponse,
        )

    def test_connectivity(
        self,
    ) -> ApiResponse[None]:
        """
                Test Connectivity
                GET /fapi/v1/ping
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Test-Connectivity

                Test connectivity to the Rest API.

        Weight: 1

                Args:

                Returns:
                    ApiResponse[None]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = None

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/ping",
            payload=payload,
            time_unit=self._configuration.time_unit,
        )

    def ticker24hr_price_change_statistics(
        self,
        symbol: Optional[str] = None,
    ) -> ApiResponse[Ticker24hrPriceChangeStatisticsResponse]:
        """
                24hr Ticker Price Change Statistics
                GET /fapi/v1/ticker/24hr
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/24hr-Ticker-Price-Change-Statistics

                24 hour rolling window price change statistics.
        **Careful** when accessing this with no symbol.

        * If the symbol is not sent, tickers for all symbols will be returned in an array.

        Weight: 1 for a single symbol;
        40 when the symbol parameter is omitted

                Args:
                    symbol (Optional[str] = None):

                Returns:
                    ApiResponse[Ticker24hrPriceChangeStatisticsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"symbol": symbol}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/ticker/24hr",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=Ticker24hrPriceChangeStatisticsResponse,
        )

    def top_trader_long_short_ratio_accounts(
        self,
        symbol: Union[str, None],
        period: Union[TopTraderLongShortRatioAccountsPeriodEnum, None],
        limit: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
    ) -> ApiResponse[TopTraderLongShortRatioAccountsResponse]:
        """
                Top Trader Long/Short Ratio (Accounts)
                GET /futures/data/topLongShortAccountRatio
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Top-Long-Short-Account-Ratio

                The proportion of net long and net short accounts to total accounts of the top 20% users with the highest margin balance. Each account is counted once only.
        Long Account % = Accounts of top traders with net long positions / Total accounts of top traders with open positions
        Short Account % = Accounts of top traders with net short positions / Total accounts of top traders with open positions
        Long/Short Ratio (Accounts) = Long Account % / Short Account %

        * If startTime and endTime are not sent, the most recent data is returned.
        * Only the data of the latest 30 days is available.
        * IP rate limit 1000 requests/5min

        Weight: 0

                Args:
                    symbol (Union[str, None]):
                    period (Union[TopTraderLongShortRatioAccountsPeriodEnum, None]): "5m","15m","30m","1h","2h","4h","6h","12h","1d"
                    limit (Optional[int] = None): Default 100; max 1000
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):

                Returns:
                    ApiResponse[TopTraderLongShortRatioAccountsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )
        if period is None:
            raise RequiredError(
                field="period", error_message="Missing required parameter 'period'"
            )

        payload = {
            "symbol": symbol,
            "period": period,
            "limit": limit,
            "start_time": start_time,
            "end_time": end_time,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/futures/data/topLongShortAccountRatio",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=TopTraderLongShortRatioAccountsResponse,
        )

    def top_trader_long_short_ratio_positions(
        self,
        symbol: Union[str, None],
        period: Union[TopTraderLongShortRatioPositionsPeriodEnum, None],
        limit: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
    ) -> ApiResponse[TopTraderLongShortRatioPositionsResponse]:
        """
                Top Trader Long/Short Ratio (Positions)
                GET /futures/data/topLongShortPositionRatio
                https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/rest-api/Top-Trader-Long-Short-Ratio

                The proportion of net long and net short positions to total open positions of the top 20% users with the highest margin balance.
        Long Position % = Long positions of top traders / Total open positions of top traders
        Short Position % = Short positions of top traders / Total open positions of top traders
        Long/Short Ratio (Positions) = Long Position % / Short Position %

        * If startTime and endTime are not sent, the most recent data is returned.
        * Only the data of the latest 30 days is available.
        * IP rate limit 1000 requests/5min

        Weight: 0

                Args:
                    symbol (Union[str, None]):
                    period (Union[TopTraderLongShortRatioPositionsPeriodEnum, None]): "5m","15m","30m","1h","2h","4h","6h","12h","1d"
                    limit (Optional[int] = None): Default 100; max 1000
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):

                Returns:
                    ApiResponse[TopTraderLongShortRatioPositionsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )
        if period is None:
            raise RequiredError(
                field="period", error_message="Missing required parameter 'period'"
            )

        payload = {
            "symbol": symbol,
            "period": period,
            "limit": limit,
            "start_time": start_time,
            "end_time": end_time,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/futures/data/topLongShortPositionRatio",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=TopTraderLongShortRatioPositionsResponse,
        )
