# coding: utf-8

"""
Binance Derivatives Trading USDS Futures REST API

OpenAPI Specification for the Binance Derivatives Trading USDS Futures REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from binance_sdk_derivatives_trading_usds_futures.rest_api.models.exchange_information_response_symbols_inner_filters_inner import (
    ExchangeInformationResponseSymbolsInnerFiltersInner,
)
from typing import Set
from typing_extensions import Self


class ExchangeInformationResponseSymbolsInner(BaseModel):
    """
    ExchangeInformationResponseSymbolsInner
    """  # noqa: E501

    symbol: Optional[StrictStr] = None
    pair: Optional[StrictStr] = None
    contract_type: Optional[StrictStr] = Field(default=None, alias="contractType")
    delivery_date: Optional[StrictInt] = Field(default=None, alias="deliveryDate")
    onboard_date: Optional[StrictInt] = Field(default=None, alias="onboardDate")
    status: Optional[StrictStr] = None
    maint_margin_percent: Optional[StrictStr] = Field(
        default=None, alias="maintMarginPercent"
    )
    required_margin_percent: Optional[StrictStr] = Field(
        default=None, alias="requiredMarginPercent"
    )
    base_asset: Optional[StrictStr] = Field(default=None, alias="baseAsset")
    quote_asset: Optional[StrictStr] = Field(default=None, alias="quoteAsset")
    margin_asset: Optional[StrictStr] = Field(default=None, alias="marginAsset")
    price_precision: Optional[StrictInt] = Field(default=None, alias="pricePrecision")
    quantity_precision: Optional[StrictInt] = Field(
        default=None, alias="quantityPrecision"
    )
    base_asset_precision: Optional[StrictInt] = Field(
        default=None, alias="baseAssetPrecision"
    )
    quote_precision: Optional[StrictInt] = Field(default=None, alias="quotePrecision")
    underlying_type: Optional[StrictStr] = Field(default=None, alias="underlyingType")
    underlying_sub_type: Optional[List[StrictStr]] = Field(
        default=None, alias="underlyingSubType"
    )
    settle_plan: Optional[StrictInt] = Field(default=None, alias="settlePlan")
    trigger_protect: Optional[StrictStr] = Field(default=None, alias="triggerProtect")
    filters: Optional[List[ExchangeInformationResponseSymbolsInnerFiltersInner]] = None
    order_type: Optional[List[StrictStr]] = Field(default=None, alias="OrderType")
    time_in_force: Optional[List[StrictStr]] = Field(default=None, alias="timeInForce")
    liquidation_fee: Optional[StrictStr] = Field(default=None, alias="liquidationFee")
    market_take_bound: Optional[StrictStr] = Field(
        default=None, alias="marketTakeBound"
    )
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "symbol",
        "pair",
        "contractType",
        "deliveryDate",
        "onboardDate",
        "status",
        "maintMarginPercent",
        "requiredMarginPercent",
        "baseAsset",
        "quoteAsset",
        "marginAsset",
        "pricePrecision",
        "quantityPrecision",
        "baseAssetPrecision",
        "quotePrecision",
        "underlyingType",
        "underlyingSubType",
        "settlePlan",
        "triggerProtect",
        "filters",
        "OrderType",
        "timeInForce",
        "liquidationFee",
        "marketTakeBound",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def is_array(cls) -> bool:
        return False

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExchangeInformationResponseSymbolsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in filters (list)
        _items = []
        if self.filters:
            for _item_filters in self.filters:
                if _item_filters:
                    _items.append(_item_filters.to_dict())
            _dict["filters"] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExchangeInformationResponseSymbolsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "symbol": obj.get("symbol"),
                "pair": obj.get("pair"),
                "contractType": obj.get("contractType"),
                "deliveryDate": obj.get("deliveryDate"),
                "onboardDate": obj.get("onboardDate"),
                "status": obj.get("status"),
                "maintMarginPercent": obj.get("maintMarginPercent"),
                "requiredMarginPercent": obj.get("requiredMarginPercent"),
                "baseAsset": obj.get("baseAsset"),
                "quoteAsset": obj.get("quoteAsset"),
                "marginAsset": obj.get("marginAsset"),
                "pricePrecision": obj.get("pricePrecision"),
                "quantityPrecision": obj.get("quantityPrecision"),
                "baseAssetPrecision": obj.get("baseAssetPrecision"),
                "quotePrecision": obj.get("quotePrecision"),
                "underlyingType": obj.get("underlyingType"),
                "underlyingSubType": obj.get("underlyingSubType"),
                "settlePlan": obj.get("settlePlan"),
                "triggerProtect": obj.get("triggerProtect"),
                "filters": (
                    [
                        ExchangeInformationResponseSymbolsInnerFiltersInner.from_dict(
                            _item
                        )
                        for _item in obj["filters"]
                    ]
                    if obj.get("filters") is not None
                    else None
                ),
                "OrderType": obj.get("OrderType"),
                "timeInForce": obj.get("timeInForce"),
                "liquidationFee": obj.get("liquidationFee"),
                "marketTakeBound": obj.get("marketTakeBound"),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
