# coding: utf-8

"""
Binance Derivatives Trading USDS Futures REST API

OpenAPI Specification for the Binance Derivatives Trading USDS Futures REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import (
    BaseModel,
    ConfigDict,
    Field,
    StrictFloat,
    StrictInt,
    StrictStr,
    field_validator,
)
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Set
from typing_extensions import Self


class PlaceMultipleOrdersBatchOrdersParameterInner(BaseModel):
    """
    PlaceMultipleOrdersBatchOrdersParameterInner
    """  # noqa: E501

    symbol: Optional[StrictStr] = None
    side: Optional[StrictStr] = None
    position_side: Optional[StrictStr] = Field(default=None, alias="positionSide")
    type: Optional[StrictStr] = None
    time_in_force: Optional[StrictStr] = Field(default=None, alias="timeInForce")
    quantity: Optional[Union[StrictFloat, StrictInt]] = None
    reduce_only: Optional[StrictStr] = Field(default=None, alias="reduceOnly")
    price: Optional[Union[StrictFloat, StrictInt]] = None
    new_client_order_id: Optional[StrictStr] = Field(
        default=None, alias="newClientOrderId"
    )
    stop_price: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, alias="stopPrice"
    )
    activation_price: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, alias="activationPrice"
    )
    callback_rate: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, alias="callbackRate"
    )
    working_type: Optional[StrictStr] = Field(default=None, alias="workingType")
    price_protect: Optional[StrictStr] = Field(default=None, alias="priceProtect")
    new_order_resp_type: Optional[StrictStr] = Field(
        default=None, alias="newOrderRespType"
    )
    price_match: Optional[StrictStr] = Field(default=None, alias="priceMatch")
    self_trade_prevention_mode: Optional[StrictStr] = Field(
        default=None, alias="selfTradePreventionMode"
    )
    good_till_date: Optional[StrictInt] = Field(default=None, alias="goodTillDate")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "symbol",
        "side",
        "positionSide",
        "type",
        "timeInForce",
        "quantity",
        "reduceOnly",
        "price",
        "newClientOrderId",
        "stopPrice",
        "activationPrice",
        "callbackRate",
        "workingType",
        "priceProtect",
        "newOrderRespType",
        "priceMatch",
        "selfTradePreventionMode",
        "goodTillDate",
    ]

    @field_validator("side")
    def side_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["BUY", "SELL"]):
            raise ValueError("must be one of enum values ('BUY', 'SELL')")
        return value

    @field_validator("position_side")
    def position_side_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["BOTH", "LONG", "SHORT"]):
            raise ValueError("must be one of enum values ('BOTH', 'LONG', 'SHORT')")
        return value

    @field_validator("time_in_force")
    def time_in_force_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["GTC", "IOC", "FOK", "GTX", "GTD"]):
            raise ValueError(
                "must be one of enum values ('GTC', 'IOC', 'FOK', 'GTX', 'GTD')"
            )
        return value

    @field_validator("working_type")
    def working_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["MARK_PRICE", "CONTRACT_PRICE"]):
            raise ValueError(
                "must be one of enum values ('MARK_PRICE', 'CONTRACT_PRICE')"
            )
        return value

    @field_validator("new_order_resp_type")
    def new_order_resp_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["ACK", "RESULT"]):
            raise ValueError("must be one of enum values ('ACK', 'RESULT')")
        return value

    @field_validator("price_match")
    def price_match_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(
            [
                "NONE",
                "OPPONENT",
                "OPPONENT_5",
                "OPPONENT_10",
                "OPPONENT_20",
                "QUEUE",
                "QUEUE_5",
                "QUEUE_10",
                "QUEUE_20",
            ]
        ):
            raise ValueError(
                "must be one of enum values ('NONE', 'OPPONENT', 'OPPONENT_5', 'OPPONENT_10', 'OPPONENT_20', 'QUEUE', 'QUEUE_5', 'QUEUE_10', 'QUEUE_20')"
            )
        return value

    @field_validator("self_trade_prevention_mode")
    def self_trade_prevention_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["EXPIRE_TAKER", "EXPIRE_BOTH", "EXPIRE_MAKER"]):
            raise ValueError(
                "must be one of enum values ('EXPIRE_TAKER', 'EXPIRE_BOTH', 'EXPIRE_MAKER')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def is_array(cls) -> bool:
        return False

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PlaceMultipleOrdersBatchOrdersParameterInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PlaceMultipleOrdersBatchOrdersParameterInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "symbol": obj.get("symbol"),
                "side": obj.get("side"),
                "positionSide": obj.get("positionSide"),
                "type": obj.get("type"),
                "timeInForce": obj.get("timeInForce"),
                "quantity": obj.get("quantity"),
                "reduceOnly": obj.get("reduceOnly"),
                "price": obj.get("price"),
                "newClientOrderId": obj.get("newClientOrderId"),
                "stopPrice": obj.get("stopPrice"),
                "activationPrice": obj.get("activationPrice"),
                "callbackRate": obj.get("callbackRate"),
                "workingType": obj.get("workingType"),
                "priceProtect": obj.get("priceProtect"),
                "newOrderRespType": obj.get("newOrderRespType"),
                "priceMatch": obj.get("priceMatch"),
                "selfTradePreventionMode": obj.get("selfTradePreventionMode"),
                "goodTillDate": obj.get("goodTillDate"),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
