# coding: utf-8

"""
Binance Derivatives Trading USDS Futures REST API

OpenAPI Specification for the Binance Derivatives Trading USDS Futures REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Set
from typing_extensions import Self


class QueryOrderResponse(BaseModel):
    """
    QueryOrderResponse
    """  # noqa: E501

    avg_price: Optional[StrictStr] = Field(default=None, alias="avgPrice")
    client_order_id: Optional[StrictStr] = Field(default=None, alias="clientOrderId")
    cum_quote: Optional[StrictStr] = Field(default=None, alias="cumQuote")
    executed_qty: Optional[StrictStr] = Field(default=None, alias="executedQty")
    order_id: Optional[StrictInt] = Field(default=None, alias="orderId")
    orig_qty: Optional[StrictStr] = Field(default=None, alias="origQty")
    orig_type: Optional[StrictStr] = Field(default=None, alias="origType")
    price: Optional[StrictStr] = None
    reduce_only: Optional[StrictBool] = Field(default=None, alias="reduceOnly")
    side: Optional[StrictStr] = None
    position_side: Optional[StrictStr] = Field(default=None, alias="positionSide")
    status: Optional[StrictStr] = None
    stop_price: Optional[StrictStr] = Field(default=None, alias="stopPrice")
    close_position: Optional[StrictBool] = Field(default=None, alias="closePosition")
    symbol: Optional[StrictStr] = None
    time: Optional[StrictInt] = None
    time_in_force: Optional[StrictStr] = Field(default=None, alias="timeInForce")
    type: Optional[StrictStr] = None
    activate_price: Optional[StrictStr] = Field(default=None, alias="activatePrice")
    price_rate: Optional[StrictStr] = Field(default=None, alias="priceRate")
    update_time: Optional[StrictInt] = Field(default=None, alias="updateTime")
    working_type: Optional[StrictStr] = Field(default=None, alias="workingType")
    price_protect: Optional[StrictBool] = Field(default=None, alias="priceProtect")
    price_match: Optional[StrictStr] = Field(default=None, alias="priceMatch")
    self_trade_prevention_mode: Optional[StrictStr] = Field(
        default=None, alias="selfTradePreventionMode"
    )
    good_till_date: Optional[StrictInt] = Field(default=None, alias="goodTillDate")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "avgPrice",
        "clientOrderId",
        "cumQuote",
        "executedQty",
        "orderId",
        "origQty",
        "origType",
        "price",
        "reduceOnly",
        "side",
        "positionSide",
        "status",
        "stopPrice",
        "closePosition",
        "symbol",
        "time",
        "timeInForce",
        "type",
        "activatePrice",
        "priceRate",
        "updateTime",
        "workingType",
        "priceProtect",
        "priceMatch",
        "selfTradePreventionMode",
        "goodTillDate",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def is_array(cls) -> bool:
        return False

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of QueryOrderResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of QueryOrderResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "avgPrice": obj.get("avgPrice"),
                "clientOrderId": obj.get("clientOrderId"),
                "cumQuote": obj.get("cumQuote"),
                "executedQty": obj.get("executedQty"),
                "orderId": obj.get("orderId"),
                "origQty": obj.get("origQty"),
                "origType": obj.get("origType"),
                "price": obj.get("price"),
                "reduceOnly": obj.get("reduceOnly"),
                "side": obj.get("side"),
                "positionSide": obj.get("positionSide"),
                "status": obj.get("status"),
                "stopPrice": obj.get("stopPrice"),
                "closePosition": obj.get("closePosition"),
                "symbol": obj.get("symbol"),
                "time": obj.get("time"),
                "timeInForce": obj.get("timeInForce"),
                "type": obj.get("type"),
                "activatePrice": obj.get("activatePrice"),
                "priceRate": obj.get("priceRate"),
                "updateTime": obj.get("updateTime"),
                "workingType": obj.get("workingType"),
                "priceProtect": obj.get("priceProtect"),
                "priceMatch": obj.get("priceMatch"),
                "selfTradePreventionMode": obj.get("selfTradePreventionMode"),
                "goodTillDate": obj.get("goodTillDate"),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
