"""
Binance Derivatives Trading USDS Futures REST API

OpenAPI Specification for the Binance Derivatives Trading USDS Futures REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

import requests
from typing import Optional, List, TypeVar, Union
from binance_common.configuration import ConfigurationRestAPI
from binance_common.models import ApiResponse
from binance_common.signature import Signers
from binance_common.utils import send_request
from .api.account_api import AccountApi
from .api.convert_api import ConvertApi
from .api.market_data_api import MarketDataApi
from .api.portfolio_margin_endpoints_api import PortfolioMarginEndpointsApi
from .api.trade_api import TradeApi
from .api.user_data_streams_api import UserDataStreamsApi

from .models import AccountInformationV2Response
from .models import AccountInformationV3Response
from .models import FuturesAccountBalanceV2Response
from .models import FuturesAccountBalanceV3Response
from .models import FuturesAccountConfigurationResponse
from .models import FuturesTradingQuantitativeRulesIndicatorsResponse
from .models import GetBnbBurnStatusResponse
from .models import GetCurrentMultiAssetsModeResponse
from .models import GetCurrentPositionModeResponse
from .models import GetDownloadIdForFuturesOrderHistoryResponse
from .models import GetDownloadIdForFuturesTradeHistoryResponse
from .models import GetDownloadIdForFuturesTransactionHistoryResponse
from .models import GetFuturesOrderHistoryDownloadLinkByIdResponse
from .models import GetFuturesTradeDownloadLinkByIdResponse
from .models import GetFuturesTransactionHistoryDownloadLinkByIdResponse
from .models import GetIncomeHistoryResponse
from .models import NotionalAndLeverageBracketsResponse
from .models import QueryUserRateLimitResponse
from .models import SymbolConfigurationResponse
from .models import ToggleBnbBurnOnFuturesTradeResponse
from .models import UserCommissionRateResponse
from .models import AcceptTheOfferedQuoteResponse
from .models import ListAllConvertPairsResponse
from .models import OrderStatusResponse
from .models import SendQuoteRequestResponse
from .models import BasisResponse
from .models import CheckServerTimeResponse
from .models import CompositeIndexSymbolInformationResponse
from .models import CompressedAggregateTradesListResponse
from .models import ContinuousContractKlineCandlestickDataResponse
from .models import ExchangeInformationResponse
from .models import GetFundingRateHistoryResponse
from .models import GetFundingRateInfoResponse
from .models import IndexPriceKlineCandlestickDataResponse
from .models import KlineCandlestickDataResponse
from .models import LongShortRatioResponse
from .models import MarkPriceResponse
from .models import MarkPriceKlineCandlestickDataResponse
from .models import MultiAssetsModeAssetIndexResponse
from .models import OldTradesLookupResponse
from .models import OpenInterestResponse
from .models import OpenInterestStatisticsResponse
from .models import OrderBookResponse
from .models import PremiumIndexKlineDataResponse
from .models import QuarterlyContractSettlementPriceResponse
from .models import QueryIndexPriceConstituentsResponse
from .models import QueryInsuranceFundBalanceSnapshotResponse
from .models import RecentTradesListResponse
from .models import SymbolOrderBookTickerResponse
from .models import SymbolPriceTickerResponse
from .models import SymbolPriceTickerV2Response
from .models import TakerBuySellVolumeResponse

from .models import Ticker24hrPriceChangeStatisticsResponse
from .models import TopTraderLongShortRatioAccountsResponse
from .models import TopTraderLongShortRatioPositionsResponse
from .models import ClassicPortfolioMarginAccountInformationResponse
from .models import AccountTradeListResponse
from .models import AllOrdersResponse
from .models import AutoCancelAllOpenOrdersResponse
from .models import CancelAllOpenOrdersResponse
from .models import CancelMultipleOrdersResponse
from .models import CancelOrderResponse
from .models import ChangeInitialLeverageResponse
from .models import ChangeMarginTypeResponse
from .models import ChangeMultiAssetsModeResponse
from .models import ChangePositionModeResponse
from .models import CurrentAllOpenOrdersResponse
from .models import GetOrderModifyHistoryResponse
from .models import GetPositionMarginChangeHistoryResponse
from .models import ModifyIsolatedPositionMarginResponse
from .models import ModifyMultipleOrdersResponse
from .models import ModifyOrderResponse
from .models import NewOrderResponse
from .models import PlaceMultipleOrdersResponse
from .models import PositionAdlQuantileEstimationResponse
from .models import PositionInformationV2Response
from .models import PositionInformationV3Response
from .models import QueryCurrentOpenOrderResponse
from .models import QueryOrderResponse
from .models import TestOrderResponse
from .models import UsersForceOrdersResponse

from .models import KeepaliveUserDataStreamResponse
from .models import StartUserDataStreamResponse


from .models import BasisContractTypeEnum
from .models import BasisPeriodEnum
from .models import ContinuousContractKlineCandlestickDataContractTypeEnum
from .models import ContinuousContractKlineCandlestickDataIntervalEnum
from .models import IndexPriceKlineCandlestickDataIntervalEnum
from .models import KlineCandlestickDataIntervalEnum
from .models import LongShortRatioPeriodEnum
from .models import MarkPriceKlineCandlestickDataIntervalEnum
from .models import OpenInterestStatisticsPeriodEnum
from .models import PremiumIndexKlineDataIntervalEnum
from .models import TakerBuySellVolumePeriodEnum
from .models import TopTraderLongShortRatioAccountsPeriodEnum
from .models import TopTraderLongShortRatioPositionsPeriodEnum
from .models import ChangeMarginTypeMarginTypeEnum
from .models import ModifyIsolatedPositionMarginPositionSideEnum
from .models import ModifyOrderSideEnum
from .models import ModifyOrderPriceMatchEnum
from .models import NewOrderSideEnum
from .models import NewOrderPositionSideEnum
from .models import NewOrderTimeInForceEnum
from .models import NewOrderWorkingTypeEnum
from .models import NewOrderNewOrderRespTypeEnum
from .models import NewOrderPriceMatchEnum
from .models import NewOrderSelfTradePreventionModeEnum
from .models import TestOrderSideEnum
from .models import TestOrderPositionSideEnum
from .models import TestOrderTimeInForceEnum
from .models import TestOrderWorkingTypeEnum
from .models import TestOrderNewOrderRespTypeEnum
from .models import TestOrderPriceMatchEnum
from .models import TestOrderSelfTradePreventionModeEnum
from .models import UsersForceOrdersAutoCloseTypeEnum


from .models import ModifyMultipleOrdersBatchOrdersParameterInner
from .models import PlaceMultipleOrdersBatchOrdersParameterInner

T = TypeVar("T")


class DerivativesTradingUsdsFuturesRestAPI:
    def __init__(
        self,
        configuration: ConfigurationRestAPI,
    ) -> None:
        self.configuration = configuration
        self._session = requests.Session()
        self._signer = (
            Signers.get_signer(
                configuration.private_key, configuration.private_key_passphrase
            )
            if configuration.private_key is not None
            else None
        )

        self._accountApi = AccountApi(self.configuration, self._session, self._signer)
        self._convertApi = ConvertApi(self.configuration, self._session, self._signer)
        self._marketDataApi = MarketDataApi(
            self.configuration, self._session, self._signer
        )
        self._portfolioMarginEndpointsApi = PortfolioMarginEndpointsApi(
            self.configuration, self._session, self._signer
        )
        self._tradeApi = TradeApi(self.configuration, self._session, self._signer)
        self._userDataStreamsApi = UserDataStreamsApi(
            self.configuration, self._session, self._signer
        )

    def send_request(
        self, endpoint: str, method: str, params: Optional[dict] = None
    ) -> ApiResponse[T]:
        """
        Sends an request to the Binance REST API.

        Args:
            endpoint (str): The API endpoint path to send the request to.
            method (str): The HTTP method to use for the request (e.g. "GET", "POST", "PUT", "DELETE").
            params (Optional[dict]): The request payload as a dictionary, or None if no payload is required.

        Returns:
            ApiResponse[T]: The API response, where T is the expected response type.
        """
        return send_request[T](
            self._session, self.configuration, method, endpoint, params
        )

    def send_signed_request(
        self, endpoint: str, method: str, params: Optional[dict] = None
    ) -> ApiResponse[T]:
        """
        Sends a signed request to the Binance REST API.

        Args:
            endpoint (str): The API endpoint path to send the request to.
            method (str): The HTTP method to use for the request (e.g. "GET", "POST", "PUT", "DELETE").
            params (Optional[dict]): The request payload as a dictionary, or None if no payload is required.

        Returns:
            ApiResponse[T]: The API response, where T is the expected response type.
        """
        return send_request[T](
            self._session,
            self.configuration,
            method,
            endpoint,
            params,
            is_signed=True,
            signer=self._signer,
        )

    def account_information_v2(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[AccountInformationV2Response]:
        """
                Account Information V2(USER_DATA)

                Get current account information. User in single-asset/ multi-assets mode will see different value, see comments in response section for detail.

        Weight: 5

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[AccountInformationV2Response]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.account_information_v2(recv_window)

    def account_information_v3(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[AccountInformationV3Response]:
        """
                Account Information V3(USER_DATA)

                Get current account information. User in single-asset/ multi-assets mode will see different value, see comments in response section for detail.

        Weight: 5

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[AccountInformationV3Response]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.account_information_v3(recv_window)

    def futures_account_balance_v2(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[FuturesAccountBalanceV2Response]:
        """
                Futures Account Balance V2 (USER_DATA)

                Query account balance info

        Weight: 5

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[FuturesAccountBalanceV2Response]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.futures_account_balance_v2(recv_window)

    def futures_account_balance_v3(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[FuturesAccountBalanceV3Response]:
        """
                Futures Account Balance V3 (USER_DATA)

                Query account balance info

        Weight: 5

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[FuturesAccountBalanceV3Response]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.futures_account_balance_v3(recv_window)

    def futures_account_configuration(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[FuturesAccountConfigurationResponse]:
        """
                Futures Account Configuration(USER_DATA)

                Query account configuration

        Weight: 5

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[FuturesAccountConfigurationResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.futures_account_configuration(recv_window)

    def futures_trading_quantitative_rules_indicators(
        self,
        symbol: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[FuturesTradingQuantitativeRulesIndicatorsResponse]:
        """
                Futures Trading Quantitative Rules Indicators (USER_DATA)

                Futures trading quantitative rules indicators, for more information on this, please refer to the [Futures Trading Quantitative Rules](https://www.binance.com/en/support/faq/4f462ebe6ff445d4a170be7d9e897272)

        Weight: - 1 for a single symbol
        - 10 when the symbol parameter is omitted

                Args:
                    symbol (Optional[str] = None):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[FuturesTradingQuantitativeRulesIndicatorsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.futures_trading_quantitative_rules_indicators(
            symbol, recv_window
        )

    def get_bnb_burn_status(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetBnbBurnStatusResponse]:
        """
                Get BNB Burn Status (USER_DATA)

                Get user's BNB Fee Discount (Fee Discount On or Fee Discount Off )

        Weight: 30

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetBnbBurnStatusResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.get_bnb_burn_status(recv_window)

    def get_current_multi_assets_mode(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetCurrentMultiAssetsModeResponse]:
        """
                Get Current Multi-Assets Mode (USER_DATA)

                Get user's Multi-Assets mode (Multi-Assets Mode or Single-Asset Mode) on ***Every symbol***

        Weight: 30

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetCurrentMultiAssetsModeResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.get_current_multi_assets_mode(recv_window)

    def get_current_position_mode(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetCurrentPositionModeResponse]:
        """
                Get Current Position Mode(USER_DATA)

                Get user's position mode (Hedge Mode or One-way Mode ) on ***EVERY symbol***

        Weight: 30

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetCurrentPositionModeResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.get_current_position_mode(recv_window)

    def get_download_id_for_futures_order_history(
        self,
        start_time: Union[int, None],
        end_time: Union[int, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetDownloadIdForFuturesOrderHistoryResponse]:
        """
                Get Download Id For Futures Order History (USER_DATA)

                Get Download Id For Futures Order History

        * Request Limitation is 10 times per month, shared by front end download page and rest api
        * The time between `startTime` and `endTime` can not be longer than 1 year

        Weight: 1000

                Args:
                    start_time (Union[int, None]): Timestamp in ms
                    end_time (Union[int, None]): Timestamp in ms
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetDownloadIdForFuturesOrderHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.get_download_id_for_futures_order_history(
            start_time, end_time, recv_window
        )

    def get_download_id_for_futures_trade_history(
        self,
        start_time: Union[int, None],
        end_time: Union[int, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetDownloadIdForFuturesTradeHistoryResponse]:
        """
                Get Download Id For Futures Trade History (USER_DATA)

                Get download id for futures trade history

        * Request Limitation is 5 times per month, shared by front end download page and rest api
        * The time between `startTime` and `endTime` can not be longer than 1 year

        Weight: 1000

                Args:
                    start_time (Union[int, None]): Timestamp in ms
                    end_time (Union[int, None]): Timestamp in ms
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetDownloadIdForFuturesTradeHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.get_download_id_for_futures_trade_history(
            start_time, end_time, recv_window
        )

    def get_download_id_for_futures_transaction_history(
        self,
        start_time: Union[int, None],
        end_time: Union[int, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetDownloadIdForFuturesTransactionHistoryResponse]:
        """
                Get Download Id For Futures Transaction History(USER_DATA)

                Get download id for futures transaction history

        * Request Limitation is 5 times per month, shared by front end download page and rest api
        * The time between `startTime` and `endTime` can not be longer than 1 year

        Weight: 1000

                Args:
                    start_time (Union[int, None]): Timestamp in ms
                    end_time (Union[int, None]): Timestamp in ms
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetDownloadIdForFuturesTransactionHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.get_download_id_for_futures_transaction_history(
            start_time, end_time, recv_window
        )

    def get_futures_order_history_download_link_by_id(
        self,
        download_id: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFuturesOrderHistoryDownloadLinkByIdResponse]:
        """
                Get Futures Order History Download Link by Id (USER_DATA)

                Get futures order history download link by Id

        * Download link expiration: 24h

        Weight: 10

                Args:
                    download_id (Union[str, None]): get by download id api
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetFuturesOrderHistoryDownloadLinkByIdResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.get_futures_order_history_download_link_by_id(
            download_id, recv_window
        )

    def get_futures_trade_download_link_by_id(
        self,
        download_id: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFuturesTradeDownloadLinkByIdResponse]:
        """
                Get Futures Trade Download Link by Id(USER_DATA)

                Get futures trade download link by Id

        * Download link expiration: 24h

        Weight: 10

                Args:
                    download_id (Union[str, None]): get by download id api
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetFuturesTradeDownloadLinkByIdResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.get_futures_trade_download_link_by_id(
            download_id, recv_window
        )

    def get_futures_transaction_history_download_link_by_id(
        self,
        download_id: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFuturesTransactionHistoryDownloadLinkByIdResponse]:
        """
                Get Futures Transaction History Download Link by Id (USER_DATA)

                Get futures transaction history download link by Id

        * Download link expiration: 24h

        Weight: 10

                Args:
                    download_id (Union[str, None]): get by download id api
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetFuturesTransactionHistoryDownloadLinkByIdResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.get_futures_transaction_history_download_link_by_id(
            download_id, recv_window
        )

    def get_income_history(
        self,
        symbol: Optional[str] = None,
        income_type: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        page: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetIncomeHistoryResponse]:
        """
                Get Income History (USER_DATA)

                Query income history

        * If neither `startTime` nor `endTime` is sent, the recent 7-day data will be returned.
        * If `incomeType ` is not sent, all kinds of flow will be returned
        * "trandId" is unique in the same incomeType for a user
        * Income history only contains data for the last three months

        Weight: 30

                Args:
                    symbol (Optional[str] = None):
                    income_type (Optional[str] = None): TRANSFER, WELCOME_BONUS, REALIZED_PNL, FUNDING_FEE, COMMISSION, INSURANCE_CLEAR, REFERRAL_KICKBACK, COMMISSION_REBATE, API_REBATE, CONTEST_REWARD, CROSS_COLLATERAL_TRANSFER, OPTIONS_PREMIUM_FEE, OPTIONS_SETTLE_PROFIT, INTERNAL_TRANSFER, AUTO_EXCHANGE, DELIVERED_SETTELMENT, COIN_SWAP_DEPOSIT, COIN_SWAP_WITHDRAW, POSITION_LIMIT_INCREASE_FEE, STRATEGY_UMFUTURES_TRANSFER，FEE_RETURN，BFUSD_REWARD
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    page (Optional[int] = None):
                    limit (Optional[int] = None): Default 100; max 1000
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetIncomeHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.get_income_history(
            symbol, income_type, start_time, end_time, page, limit, recv_window
        )

    def notional_and_leverage_brackets(
        self,
        symbol: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[NotionalAndLeverageBracketsResponse]:
        """
                Notional and Leverage Brackets (USER_DATA)

                Query user notional and leverage bracket on speicfic symbol

        Weight: 1

                Args:
                    symbol (Optional[str] = None):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[NotionalAndLeverageBracketsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.notional_and_leverage_brackets(symbol, recv_window)

    def query_user_rate_limit(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QueryUserRateLimitResponse]:
        """
                Query User Rate Limit (USER_DATA)

                Query User Rate Limit

        Weight: 1

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QueryUserRateLimitResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.query_user_rate_limit(recv_window)

    def symbol_configuration(
        self,
        symbol: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SymbolConfigurationResponse]:
        """
                Symbol Configuration(USER_DATA)

                Get current account symbol configuration.

        Weight: 5

                Args:
                    symbol (Optional[str] = None):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[SymbolConfigurationResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.symbol_configuration(symbol, recv_window)

    def toggle_bnb_burn_on_futures_trade(
        self,
        fee_burn: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[ToggleBnbBurnOnFuturesTradeResponse]:
        """
                Toggle BNB Burn On Futures Trade (TRADE)

                Change user's BNB Fee Discount (Fee Discount On or Fee Discount Off ) on ***EVERY symbol***

        Weight: 1

                Args:
                    fee_burn (Union[str, None]): "true": Fee Discount On; "false": Fee Discount Off
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[ToggleBnbBurnOnFuturesTradeResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.toggle_bnb_burn_on_futures_trade(fee_burn, recv_window)

    def user_commission_rate(
        self,
        symbol: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[UserCommissionRateResponse]:
        """
                User Commission Rate (USER_DATA)

                Get User Commission Rate

        Weight: 20

                Args:
                    symbol (Union[str, None]):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[UserCommissionRateResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.user_commission_rate(symbol, recv_window)

    def accept_the_offered_quote(
        self,
        quote_id: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[AcceptTheOfferedQuoteResponse]:
        """
                Accept the offered quote (USER_DATA)

                Accept the offered quote by quote ID.

        Weight: 200(IP)

                Args:
                    quote_id (Union[str, None]):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[AcceptTheOfferedQuoteResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._convertApi.accept_the_offered_quote(quote_id, recv_window)

    def list_all_convert_pairs(
        self,
        from_asset: Optional[str] = None,
        to_asset: Optional[str] = None,
    ) -> ApiResponse[ListAllConvertPairsResponse]:
        """
                List All Convert Pairs

                Query for all convertible token pairs and the tokens’ respective upper/lower limits

        * User needs to supply either or both of the input parameter
        * If not defined for both fromAsset and toAsset, only partial token pairs will be returned
        * Asset BNFCR is only available to convert for MICA region users.

        Weight: 20(IP)

                Args:
                    from_asset (Optional[str] = None): User spends coin
                    to_asset (Optional[str] = None): User receives coin

                Returns:
                    ApiResponse[ListAllConvertPairsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._convertApi.list_all_convert_pairs(from_asset, to_asset)

    def order_status(
        self,
        order_id: Optional[str] = None,
        quote_id: Optional[str] = None,
    ) -> ApiResponse[OrderStatusResponse]:
        """
                Order status(USER_DATA)

                Query order status by order ID.

        Weight: 50(IP)

                Args:
                    order_id (Optional[str] = None): Either orderId or quoteId is required
                    quote_id (Optional[str] = None): Either orderId or quoteId is required

                Returns:
                    ApiResponse[OrderStatusResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._convertApi.order_status(order_id, quote_id)

    def send_quote_request(
        self,
        from_asset: Union[str, None],
        to_asset: Union[str, None],
        from_amount: Optional[float] = None,
        to_amount: Optional[float] = None,
        valid_time: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SendQuoteRequestResponse]:
        """
                Send Quote Request(USER_DATA)

                Request a quote for the requested token pairs

        * Either fromAmount or toAmount should be sent
        * `quoteId` will be returned only if you have enough funds to convert

        Weight: 50(IP)

                Args:
                    from_asset (Union[str, None]):
                    to_asset (Union[str, None]):
                    from_amount (Optional[float] = None): When specified, it is the amount you will be debited after the conversion
                    to_amount (Optional[float] = None): When specified, it is the amount you will be credited after the conversion
                    valid_time (Optional[str] = None): 10s, default 10s
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[SendQuoteRequestResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._convertApi.send_quote_request(
            from_asset, to_asset, from_amount, to_amount, valid_time, recv_window
        )

    def basis(
        self,
        pair: Union[str, None],
        contract_type: Union[BasisContractTypeEnum, None],
        period: Union[BasisPeriodEnum, None],
        limit: Union[int, None],
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
    ) -> ApiResponse[BasisResponse]:
        """
                Basis

                Query future basis

        * If startTime and endTime are not sent, the most recent data is returned.
        * Only the data of the latest 30 days is available.

        Weight: 0

                Args:
                    pair (Union[str, None]):
                    contract_type (Union[BasisContractTypeEnum, None]):
                    period (Union[BasisPeriodEnum, None]): "5m","15m","30m","1h","2h","4h","6h","12h","1d"
                    limit (Union[int, None]): Default 30,Max 500
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):

                Returns:
                    ApiResponse[BasisResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.basis(
            pair, contract_type, period, limit, start_time, end_time
        )

    def check_server_time(
        self,
    ) -> ApiResponse[CheckServerTimeResponse]:
        """
                Check Server Time

                Test connectivity to the Rest API and get the current server time.

        Weight: 1

                Args:

                Returns:
                    ApiResponse[CheckServerTimeResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.check_server_time()

    def composite_index_symbol_information(
        self,
        symbol: Optional[str] = None,
    ) -> ApiResponse[CompositeIndexSymbolInformationResponse]:
        """
                Composite Index Symbol Information

                Query composite index symbol information

        * Only for composite index symbols

        Weight: 1

                Args:
                    symbol (Optional[str] = None):

                Returns:
                    ApiResponse[CompositeIndexSymbolInformationResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.composite_index_symbol_information(symbol)

    def compressed_aggregate_trades_list(
        self,
        symbol: Union[str, None],
        from_id: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
    ) -> ApiResponse[CompressedAggregateTradesListResponse]:
        """
                Compressed/Aggregate Trades List

                Get compressed, aggregate market trades. Market trades that fill in 100ms with the same price and the same taking side will have the quantity aggregated.


        * support querying futures trade histories that are not older than one year
        * If both `startTime` and `endTime` are sent, time between `startTime` and `endTime` must be less than 1 hour.
        * If `fromId`, `startTime`, and `endTime` are not sent, the most recent aggregate trades will be returned.
        * Only market trades will be aggregated and returned, which means the insurance fund trades and ADL trades won't be aggregated.
        * Sending both `startTime`/`endTime` and `fromId` might cause response timeout, please send either `fromId` or `startTime`/`endTime`

        Weight: 20

                Args:
                    symbol (Union[str, None]):
                    from_id (Optional[int] = None): ID to get aggregate trades from INCLUSIVE.
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default 100; max 1000

                Returns:
                    ApiResponse[CompressedAggregateTradesListResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.compressed_aggregate_trades_list(
            symbol, from_id, start_time, end_time, limit
        )

    def continuous_contract_kline_candlestick_data(
        self,
        pair: Union[str, None],
        contract_type: Union[
            ContinuousContractKlineCandlestickDataContractTypeEnum, None
        ],
        interval: Union[ContinuousContractKlineCandlestickDataIntervalEnum, None],
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
    ) -> ApiResponse[ContinuousContractKlineCandlestickDataResponse]:
        """
                Continuous Contract Kline/Candlestick Data

                Kline/candlestick bars for a specific contract type.
        Klines are uniquely identified by their open time.

        * If startTime and endTime are not sent, the most recent klines are returned.
        * Contract type:
        * PERPETUAL
        * CURRENT_QUARTER
        * NEXT_QUARTER

        Weight: based on parameter LIMIT
        | LIMIT       | weight |
        | ----------- | ------ |
        | [1,100)     | 1      |
        | [100, 500)  | 2      |
        | [500, 1000] | 5      |
        | > 1000      | 10     |

                Args:
                    pair (Union[str, None]):
                    contract_type (Union[ContinuousContractKlineCandlestickDataContractTypeEnum, None]):
                    interval (Union[ContinuousContractKlineCandlestickDataIntervalEnum, None]):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default 100; max 1000

                Returns:
                    ApiResponse[ContinuousContractKlineCandlestickDataResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.continuous_contract_kline_candlestick_data(
            pair, contract_type, interval, start_time, end_time, limit
        )

    def exchange_information(
        self,
    ) -> ApiResponse[ExchangeInformationResponse]:
        """
                Exchange Information

                Current exchange trading rules and symbol information

        Weight: 1

                Args:

                Returns:
                    ApiResponse[ExchangeInformationResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.exchange_information()

    def get_funding_rate_history(
        self,
        symbol: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
    ) -> ApiResponse[GetFundingRateHistoryResponse]:
        """
                Get Funding Rate History

                Get Funding Rate History


        * If `startTime` and `endTime` are not sent, the most recent 200 records are returned.
        * If the number of data between `startTime` and `endTime` is larger than `limit`, return as `startTime` + `limit`.
        * In ascending order.

        Weight: share 500/5min/IP rate limit with GET /fapi/v1/fundingInfo

                Args:
                    symbol (Optional[str] = None):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default 100; max 1000

                Returns:
                    ApiResponse[GetFundingRateHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.get_funding_rate_history(
            symbol, start_time, end_time, limit
        )

    def get_funding_rate_info(
        self,
    ) -> ApiResponse[GetFundingRateInfoResponse]:
        """
                Get Funding Rate Info

                Query funding rate info for symbols that had FundingRateCap/ FundingRateFloor / fundingIntervalHours adjustment

        Weight: 0
        share 500/5min/IP rate limit with GET /fapi/v1/fundingInfo

                Args:

                Returns:
                    ApiResponse[GetFundingRateInfoResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.get_funding_rate_info()

    def index_price_kline_candlestick_data(
        self,
        pair: Union[str, None],
        interval: Union[IndexPriceKlineCandlestickDataIntervalEnum, None],
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
    ) -> ApiResponse[IndexPriceKlineCandlestickDataResponse]:
        """
                Index Price Kline/Candlestick Data

                Kline/candlestick bars for the index price of a pair.
        Klines are uniquely identified by their open time.


        * If startTime and endTime are not sent, the most recent klines are returned.

        Weight: based on parameter LIMIT
        | LIMIT       | weight |
        | ----------- | ------ |
        | [1,100)     | 1      |
        | [100, 500)  | 2      |
        | [500, 1000] | 5      |
        | > 1000      | 10     |

                Args:
                    pair (Union[str, None]):
                    interval (Union[IndexPriceKlineCandlestickDataIntervalEnum, None]):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default 100; max 1000

                Returns:
                    ApiResponse[IndexPriceKlineCandlestickDataResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.index_price_kline_candlestick_data(
            pair, interval, start_time, end_time, limit
        )

    def kline_candlestick_data(
        self,
        symbol: Union[str, None],
        interval: Union[KlineCandlestickDataIntervalEnum, None],
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
    ) -> ApiResponse[KlineCandlestickDataResponse]:
        """
                Kline/Candlestick Data

                Kline/candlestick bars for a symbol.
        Klines are uniquely identified by their open time.

        * If startTime and endTime are not sent, the most recent klines are returned.

        Weight: based on parameter LIMIT
        | LIMIT       | weight |
        | ----------- | ------ |
        | [1,100)     | 1      |
        | [100, 500)  | 2      |
        | [500, 1000] | 5      |
        | > 1000      | 10     |

                Args:
                    symbol (Union[str, None]):
                    interval (Union[KlineCandlestickDataIntervalEnum, None]):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default 100; max 1000

                Returns:
                    ApiResponse[KlineCandlestickDataResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.kline_candlestick_data(
            symbol, interval, start_time, end_time, limit
        )

    def long_short_ratio(
        self,
        symbol: Union[str, None],
        period: Union[LongShortRatioPeriodEnum, None],
        limit: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
    ) -> ApiResponse[LongShortRatioResponse]:
        """
                Long/Short Ratio

                Query symbol Long/Short Ratio

        * If startTime and endTime are not sent, the most recent data is returned.
        * Only the data of the latest 30 days is available.
        * IP rate limit 1000 requests/5min

        Weight: 0

                Args:
                    symbol (Union[str, None]):
                    period (Union[LongShortRatioPeriodEnum, None]): "5m","15m","30m","1h","2h","4h","6h","12h","1d"
                    limit (Optional[int] = None): Default 100; max 1000
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):

                Returns:
                    ApiResponse[LongShortRatioResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.long_short_ratio(
            symbol, period, limit, start_time, end_time
        )

    def mark_price(
        self,
        symbol: Optional[str] = None,
    ) -> ApiResponse[MarkPriceResponse]:
        """
                Mark Price

                Mark Price and Funding Rate

        Weight: 1

                Args:
                    symbol (Optional[str] = None):

                Returns:
                    ApiResponse[MarkPriceResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.mark_price(symbol)

    def mark_price_kline_candlestick_data(
        self,
        symbol: Union[str, None],
        interval: Union[MarkPriceKlineCandlestickDataIntervalEnum, None],
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
    ) -> ApiResponse[MarkPriceKlineCandlestickDataResponse]:
        """
                Mark Price Kline/Candlestick Data

                Kline/candlestick bars for the mark price of a symbol.
        Klines are uniquely identified by their open time.

        * If startTime and endTime are not sent, the most recent klines are returned.

        Weight: based on parameter LIMIT
        | LIMIT       | weight |
        | ----------- | ------ |
        | [1,100)     | 1      |
        | [100, 500)  | 2      |
        | [500, 1000] | 5      |
        | > 1000      | 10     |

                Args:
                    symbol (Union[str, None]):
                    interval (Union[MarkPriceKlineCandlestickDataIntervalEnum, None]):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default 100; max 1000

                Returns:
                    ApiResponse[MarkPriceKlineCandlestickDataResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.mark_price_kline_candlestick_data(
            symbol, interval, start_time, end_time, limit
        )

    def multi_assets_mode_asset_index(
        self,
        symbol: Optional[str] = None,
    ) -> ApiResponse[MultiAssetsModeAssetIndexResponse]:
        """
                Multi-Assets Mode Asset Index

                asset index for Multi-Assets mode

        Weight: 1 for a single symbol; 10 when the symbol parameter is omitted

                Args:
                    symbol (Optional[str] = None):

                Returns:
                    ApiResponse[MultiAssetsModeAssetIndexResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.multi_assets_mode_asset_index(symbol)

    def old_trades_lookup(
        self,
        symbol: Union[str, None],
        limit: Optional[int] = None,
        from_id: Optional[int] = None,
    ) -> ApiResponse[OldTradesLookupResponse]:
        """
                Old Trades Lookup (MARKET_DATA)

                Get older market historical trades.

        * Market trades means trades filled in the order book. Only market trades will be returned, which means the insurance fund trades and ADL trades won't be returned.
        * Only supports data from within the last three months

        Weight: 20

                Args:
                    symbol (Union[str, None]):
                    limit (Optional[int] = None): Default 100; max 1000
                    from_id (Optional[int] = None): ID to get aggregate trades from INCLUSIVE.

                Returns:
                    ApiResponse[OldTradesLookupResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.old_trades_lookup(symbol, limit, from_id)

    def open_interest(
        self,
        symbol: Union[str, None],
    ) -> ApiResponse[OpenInterestResponse]:
        """
                Open Interest

                Get present open interest of a specific symbol.

        Weight: 1

                Args:
                    symbol (Union[str, None]):

                Returns:
                    ApiResponse[OpenInterestResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.open_interest(symbol)

    def open_interest_statistics(
        self,
        symbol: Union[str, None],
        period: Union[OpenInterestStatisticsPeriodEnum, None],
        limit: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
    ) -> ApiResponse[OpenInterestStatisticsResponse]:
        """
                Open Interest Statistics

                Open Interest Statistics

        * If startTime and endTime are not sent, the most recent data is returned.
        * Only the data of the latest 1 month is available.
        * IP rate limit 1000 requests/5min

        Weight: 0

                Args:
                    symbol (Union[str, None]):
                    period (Union[OpenInterestStatisticsPeriodEnum, None]): "5m","15m","30m","1h","2h","4h","6h","12h","1d"
                    limit (Optional[int] = None): Default 100; max 1000
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):

                Returns:
                    ApiResponse[OpenInterestStatisticsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.open_interest_statistics(
            symbol, period, limit, start_time, end_time
        )

    def order_book(
        self,
        symbol: Union[str, None],
        limit: Optional[int] = None,
    ) -> ApiResponse[OrderBookResponse]:
        """
                Order Book

                Query symbol orderbook

        Weight: Adjusted based on the limit:
        | Limit         | Weight |
        | ------------- | ------ |
        | 5, 10, 20, 50 | 2      |
        | 100           | 5      |
        | 500           | 10     |
        | 1000          | 20     |

                Args:
                    symbol (Union[str, None]):
                    limit (Optional[int] = None): Default 100; max 1000

                Returns:
                    ApiResponse[OrderBookResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.order_book(symbol, limit)

    def premium_index_kline_data(
        self,
        symbol: Union[str, None],
        interval: Union[PremiumIndexKlineDataIntervalEnum, None],
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
    ) -> ApiResponse[PremiumIndexKlineDataResponse]:
        """
                Premium index Kline Data

                Premium index kline bars of a symbol. Klines are uniquely identified by their open time.


        * If startTime and endTime are not sent, the most recent klines are returned.

        Weight: based on parameter LIMIT
        | LIMIT       | weight |
        | ----------- | ------ |
        | [1,100)     | 1      |
        | [100, 500)  | 2      |
        | [500, 1000] | 5      |
        | > 1000      | 10     |

                Args:
                    symbol (Union[str, None]):
                    interval (Union[PremiumIndexKlineDataIntervalEnum, None]):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default 100; max 1000

                Returns:
                    ApiResponse[PremiumIndexKlineDataResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.premium_index_kline_data(
            symbol, interval, start_time, end_time, limit
        )

    def quarterly_contract_settlement_price(
        self,
        pair: Union[str, None],
    ) -> ApiResponse[QuarterlyContractSettlementPriceResponse]:
        """
                Quarterly Contract Settlement Price

                Latest price for a symbol or symbols.

        Weight: 0

                Args:
                    pair (Union[str, None]):

                Returns:
                    ApiResponse[QuarterlyContractSettlementPriceResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.quarterly_contract_settlement_price(pair)

    def query_index_price_constituents(
        self,
        symbol: Union[str, None],
    ) -> ApiResponse[QueryIndexPriceConstituentsResponse]:
        """
                Query Index Price Constituents

                Query index price constituents

        Weight: 2

                Args:
                    symbol (Union[str, None]):

                Returns:
                    ApiResponse[QueryIndexPriceConstituentsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.query_index_price_constituents(symbol)

    def query_insurance_fund_balance_snapshot(
        self,
        symbol: Optional[str] = None,
    ) -> ApiResponse[QueryInsuranceFundBalanceSnapshotResponse]:
        """
                Query Insurance Fund Balance Snapshot

                Query Insurance Fund Balance Snapshot

        Weight: 1

                Args:
                    symbol (Optional[str] = None):

                Returns:
                    ApiResponse[QueryInsuranceFundBalanceSnapshotResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.query_insurance_fund_balance_snapshot(symbol)

    def recent_trades_list(
        self,
        symbol: Union[str, None],
        limit: Optional[int] = None,
    ) -> ApiResponse[RecentTradesListResponse]:
        """
                Recent Trades List

                Get recent market trades

        * Market trades means trades filled in the order book. Only market trades will be returned, which means the insurance fund trades and ADL trades won't be returned.

        Weight: 5

                Args:
                    symbol (Union[str, None]):
                    limit (Optional[int] = None): Default 100; max 1000

                Returns:
                    ApiResponse[RecentTradesListResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.recent_trades_list(symbol, limit)

    def symbol_order_book_ticker(
        self,
        symbol: Optional[str] = None,
    ) -> ApiResponse[SymbolOrderBookTickerResponse]:
        """
                Symbol Order Book Ticker

                Best price/qty on the order book for a symbol or symbols.

        * If the symbol is not sent, bookTickers for all symbols will be returned in an array.
        * The field `X-MBX-USED-WEIGHT-1M` in response header is not accurate from this endpoint, please ignore.

        Weight: 2 for a single symbol;
        5 when the symbol parameter is omitted

                Args:
                    symbol (Optional[str] = None):

                Returns:
                    ApiResponse[SymbolOrderBookTickerResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.symbol_order_book_ticker(symbol)

    def symbol_price_ticker(
        self,
        symbol: Optional[str] = None,
    ) -> ApiResponse[SymbolPriceTickerResponse]:
        """
                Symbol Price Ticker(Deprecated)

                Latest price for a symbol or symbols.

        * If the symbol is not sent, prices for all symbols will be returned in an array.

        Weight: 1 for a single symbol;
        2 when the symbol parameter is omitted

                Args:
                    symbol (Optional[str] = None):

                Returns:
                    ApiResponse[SymbolPriceTickerResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.symbol_price_ticker(symbol)

    def symbol_price_ticker_v2(
        self,
        symbol: Optional[str] = None,
    ) -> ApiResponse[SymbolPriceTickerV2Response]:
        """
                Symbol Price Ticker V2

                Latest price for a symbol or symbols.

        * If the symbol is not sent, prices for all symbols will be returned in an array.
        * The field `X-MBX-USED-WEIGHT-1M` in response header is not accurate from this endpoint, please ignore.

        Weight: 1 for a single symbol;
        2 when the symbol parameter is omitted

                Args:
                    symbol (Optional[str] = None):

                Returns:
                    ApiResponse[SymbolPriceTickerV2Response]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.symbol_price_ticker_v2(symbol)

    def taker_buy_sell_volume(
        self,
        symbol: Union[str, None],
        period: Union[TakerBuySellVolumePeriodEnum, None],
        limit: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
    ) -> ApiResponse[TakerBuySellVolumeResponse]:
        """
                Taker Buy/Sell Volume

                Taker Buy/Sell Volume

        * If startTime and endTime are not sent, the most recent data is returned.
        * Only the data of the latest 30 days is available.
        * IP rate limit 1000 requests/5min

        Weight: 0

                Args:
                    symbol (Union[str, None]):
                    period (Union[TakerBuySellVolumePeriodEnum, None]): "5m","15m","30m","1h","2h","4h","6h","12h","1d"
                    limit (Optional[int] = None): Default 100; max 1000
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):

                Returns:
                    ApiResponse[TakerBuySellVolumeResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.taker_buy_sell_volume(
            symbol, period, limit, start_time, end_time
        )

    def test_connectivity(
        self,
    ) -> ApiResponse[None]:
        """
                Test Connectivity

                Test connectivity to the Rest API.

        Weight: 1

                Args:

                Returns:
                    ApiResponse[None]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.test_connectivity()

    def ticker24hr_price_change_statistics(
        self,
        symbol: Optional[str] = None,
    ) -> ApiResponse[Ticker24hrPriceChangeStatisticsResponse]:
        """
                24hr Ticker Price Change Statistics

                24 hour rolling window price change statistics.
        **Careful** when accessing this with no symbol.

        * If the symbol is not sent, tickers for all symbols will be returned in an array.

        Weight: 1 for a single symbol;
        40 when the symbol parameter is omitted

                Args:
                    symbol (Optional[str] = None):

                Returns:
                    ApiResponse[Ticker24hrPriceChangeStatisticsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.ticker24hr_price_change_statistics(symbol)

    def top_trader_long_short_ratio_accounts(
        self,
        symbol: Union[str, None],
        period: Union[TopTraderLongShortRatioAccountsPeriodEnum, None],
        limit: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
    ) -> ApiResponse[TopTraderLongShortRatioAccountsResponse]:
        """
                Top Trader Long/Short Ratio (Accounts)

                The proportion of net long and net short accounts to total accounts of the top 20% users with the highest margin balance. Each account is counted once only.
        Long Account % = Accounts of top traders with net long positions / Total accounts of top traders with open positions
        Short Account % = Accounts of top traders with net short positions / Total accounts of top traders with open positions
        Long/Short Ratio (Accounts) = Long Account % / Short Account %

        * If startTime and endTime are not sent, the most recent data is returned.
        * Only the data of the latest 30 days is available.
        * IP rate limit 1000 requests/5min

        Weight: 0

                Args:
                    symbol (Union[str, None]):
                    period (Union[TopTraderLongShortRatioAccountsPeriodEnum, None]): "5m","15m","30m","1h","2h","4h","6h","12h","1d"
                    limit (Optional[int] = None): Default 100; max 1000
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):

                Returns:
                    ApiResponse[TopTraderLongShortRatioAccountsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.top_trader_long_short_ratio_accounts(
            symbol, period, limit, start_time, end_time
        )

    def top_trader_long_short_ratio_positions(
        self,
        symbol: Union[str, None],
        period: Union[TopTraderLongShortRatioPositionsPeriodEnum, None],
        limit: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
    ) -> ApiResponse[TopTraderLongShortRatioPositionsResponse]:
        """
                Top Trader Long/Short Ratio (Positions)

                The proportion of net long and net short positions to total open positions of the top 20% users with the highest margin balance.
        Long Position % = Long positions of top traders / Total open positions of top traders
        Short Position % = Short positions of top traders / Total open positions of top traders
        Long/Short Ratio (Positions) = Long Position % / Short Position %

        * If startTime and endTime are not sent, the most recent data is returned.
        * Only the data of the latest 30 days is available.
        * IP rate limit 1000 requests/5min

        Weight: 0

                Args:
                    symbol (Union[str, None]):
                    period (Union[TopTraderLongShortRatioPositionsPeriodEnum, None]): "5m","15m","30m","1h","2h","4h","6h","12h","1d"
                    limit (Optional[int] = None): Default 100; max 1000
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):

                Returns:
                    ApiResponse[TopTraderLongShortRatioPositionsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.top_trader_long_short_ratio_positions(
            symbol, period, limit, start_time, end_time
        )

    def classic_portfolio_margin_account_information(
        self,
        asset: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[ClassicPortfolioMarginAccountInformationResponse]:
        """
                Classic Portfolio Margin Account Information (USER_DATA)

                Get Classic Portfolio Margin current account information.


        * maxWithdrawAmount is for asset transfer out to the spot wallet.

        Weight: 5

                Args:
                    asset (Union[str, None]):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[ClassicPortfolioMarginAccountInformationResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._portfolioMarginEndpointsApi.classic_portfolio_margin_account_information(
            asset, recv_window
        )

    def account_trade_list(
        self,
        symbol: Union[str, None],
        order_id: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        from_id: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[AccountTradeListResponse]:
        """
                Account Trade List (USER_DATA)

                Get trades for a specific account and symbol.

        * If `startTime` and `endTime` are both not sent, then the last 7 days' data will be returned.
        * The time between `startTime` and `endTime` cannot be longer than 7 days.
        * The parameter `fromId` cannot be sent with `startTime` or `endTime`.
        * Only support querying trade in the past 6 months

        Weight: 5

                Args:
                    symbol (Union[str, None]):
                    order_id (Optional[int] = None):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    from_id (Optional[int] = None): ID to get aggregate trades from INCLUSIVE.
                    limit (Optional[int] = None): Default 100; max 1000
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[AccountTradeListResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.account_trade_list(
            symbol, order_id, start_time, end_time, from_id, limit, recv_window
        )

    def all_orders(
        self,
        symbol: Union[str, None],
        order_id: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[AllOrdersResponse]:
        """
                All Orders (USER_DATA)

                Get all account orders; active, canceled, or filled.

        * These orders will not be found:
        * order status is `CANCELED` or `EXPIRED` **AND** order has NO filled trade **AND** created time + 3 days < current time
        * order create time + 90 days < current time

        * If `orderId` is set, it will get orders >= that `orderId`. Otherwise most recent orders are returned.
        * The query time period must be less then 7 days( default as the recent 7 days).

        Weight: 5

                Args:
                    symbol (Union[str, None]):
                    order_id (Optional[int] = None):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default 100; max 1000
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[AllOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.all_orders(
            symbol, order_id, start_time, end_time, limit, recv_window
        )

    def auto_cancel_all_open_orders(
        self,
        symbol: Union[str, None],
        countdown_time: Union[int, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[AutoCancelAllOpenOrdersResponse]:
        """
                Auto-Cancel All Open Orders (TRADE)

                Cancel all open orders of the specified symbol at the end of the specified countdown.
        The endpoint should be called repeatedly as heartbeats so that the existing countdown time can be canceled and replaced by a new one.

        * Example usage:
        Call this endpoint at 30s intervals with an countdownTime of 120000 (120s).
        If this endpoint is not called within 120 seconds, all your orders of the specified symbol will be automatically canceled.
        If this endpoint is called with an countdownTime of 0, the countdown timer will be stopped.

        The system will check all countdowns **approximately every 10 milliseconds**, so please note that sufficient redundancy should be considered when using this function. We do not recommend setting the countdown time to be too precise or too small.

        Weight: 10

                Args:
                    symbol (Union[str, None]):
                    countdown_time (Union[int, None]): countdown time, 1000 for 1 second. 0 to cancel the timer
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[AutoCancelAllOpenOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.auto_cancel_all_open_orders(
            symbol, countdown_time, recv_window
        )

    def cancel_all_open_orders(
        self,
        symbol: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[CancelAllOpenOrdersResponse]:
        """
                Cancel All Open Orders (TRADE)

                Cancel All Open Orders

        Weight: 1

                Args:
                    symbol (Union[str, None]):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[CancelAllOpenOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.cancel_all_open_orders(symbol, recv_window)

    def cancel_multiple_orders(
        self,
        symbol: Union[str, None],
        order_id_list: Optional[List[int]] = None,
        orig_client_order_id_list: Optional[List[str]] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[CancelMultipleOrdersResponse]:
        """
                Cancel Multiple Orders (TRADE)

                Cancel Multiple Orders

        * Either `orderIdList` or `origClientOrderIdList ` must be sent.

        Weight: 1

                Args:
                    symbol (Union[str, None]):
                    order_id_list (Optional[List[int]] = None): max length 10 <br /> e.g. [1234567,2345678]
                    orig_client_order_id_list (Optional[List[str]] = None): max length 10<br /> e.g. ["my_id_1","my_id_2"], encode the double quotes. No space after comma.
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[CancelMultipleOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.cancel_multiple_orders(
            symbol, order_id_list, orig_client_order_id_list, recv_window
        )

    def cancel_order(
        self,
        symbol: Union[str, None],
        order_id: Optional[int] = None,
        orig_client_order_id: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[CancelOrderResponse]:
        """
                Cancel Order (TRADE)

                Cancel an active order.

        * Either `orderId` or `origClientOrderId` must be sent.

        Weight: 1

                Args:
                    symbol (Union[str, None]):
                    order_id (Optional[int] = None):
                    orig_client_order_id (Optional[str] = None):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[CancelOrderResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.cancel_order(
            symbol, order_id, orig_client_order_id, recv_window
        )

    def change_initial_leverage(
        self,
        symbol: Union[str, None],
        leverage: Union[int, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[ChangeInitialLeverageResponse]:
        """
                Change Initial Leverage(TRADE)

                Change user's initial leverage of specific symbol market.

        Weight: 1

                Args:
                    symbol (Union[str, None]):
                    leverage (Union[int, None]): target initial leverage: int from 1 to 125
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[ChangeInitialLeverageResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.change_initial_leverage(symbol, leverage, recv_window)

    def change_margin_type(
        self,
        symbol: Union[str, None],
        margin_type: Union[ChangeMarginTypeMarginTypeEnum, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[ChangeMarginTypeResponse]:
        """
                Change Margin Type(TRADE)

                Change symbol level margin type

        Weight: 1

                Args:
                    symbol (Union[str, None]):
                    margin_type (Union[ChangeMarginTypeMarginTypeEnum, None]): ISOLATED, CROSSED
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[ChangeMarginTypeResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.change_margin_type(symbol, margin_type, recv_window)

    def change_multi_assets_mode(
        self,
        multi_assets_margin: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[ChangeMultiAssetsModeResponse]:
        """
                Change Multi-Assets Mode (TRADE)

                Change user's Multi-Assets mode (Multi-Assets Mode or Single-Asset Mode) on ***Every symbol***

        Weight: 1

                Args:
                    multi_assets_margin (Union[str, None]): "true": Multi-Assets Mode; "false": Single-Asset Mode
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[ChangeMultiAssetsModeResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.change_multi_assets_mode(multi_assets_margin, recv_window)

    def change_position_mode(
        self,
        dual_side_position: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[ChangePositionModeResponse]:
        """
                Change Position Mode(TRADE)

                Change user's position mode (Hedge Mode or One-way Mode ) on ***EVERY symbol***

        Weight: 1

                Args:
                    dual_side_position (Union[str, None]): "true": Hedge Mode; "false": One-way Mode
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[ChangePositionModeResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.change_position_mode(dual_side_position, recv_window)

    def current_all_open_orders(
        self,
        symbol: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[CurrentAllOpenOrdersResponse]:
        """
                Current All Open Orders (USER_DATA)

                Get all open orders on a symbol.

        * If the symbol is not sent, orders for all symbols will be returned in an array.

        Weight: 1 for a single symbol; 40 when the symbol parameter is omitted
        Careful when accessing this with no symbol.

                Args:
                    symbol (Optional[str] = None):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[CurrentAllOpenOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.current_all_open_orders(symbol, recv_window)

    def get_order_modify_history(
        self,
        symbol: Union[str, None],
        order_id: Optional[int] = None,
        orig_client_order_id: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetOrderModifyHistoryResponse]:
        """
                Get Order Modify History (USER_DATA)

                Get order modification history

        * Either `orderId` or `origClientOrderId` must be sent, and the `orderId` will prevail if both are sent.
        * Order modify history longer than 3 month is not avaliable

        Weight: 1

                Args:
                    symbol (Union[str, None]):
                    order_id (Optional[int] = None):
                    orig_client_order_id (Optional[str] = None):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default 100; max 1000
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetOrderModifyHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.get_order_modify_history(
            symbol,
            order_id,
            orig_client_order_id,
            start_time,
            end_time,
            limit,
            recv_window,
        )

    def get_position_margin_change_history(
        self,
        symbol: Union[str, None],
        type: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetPositionMarginChangeHistoryResponse]:
        """
                Get Position Margin Change History (TRADE)

                Get Position Margin Change History

        * Support querying future histories that are not older than 30 days
        * The time between `startTime` and `endTime`can't be more than 30 days

        Weight: 1

                Args:
                    symbol (Union[str, None]):
                    type (Optional[int] = None): 1: Add position margin，2: Reduce position margin
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default 100; max 1000
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetPositionMarginChangeHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.get_position_margin_change_history(
            symbol, type, start_time, end_time, limit, recv_window
        )

    def modify_isolated_position_margin(
        self,
        symbol: Union[str, None],
        amount: Union[float, None],
        type: Union[str, None],
        position_side: Optional[ModifyIsolatedPositionMarginPositionSideEnum] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[ModifyIsolatedPositionMarginResponse]:
        """
                Modify Isolated Position Margin(TRADE)

                Modify Isolated Position Margin


        * Only for isolated symbol

        Weight: 1

                Args:
                    symbol (Union[str, None]):
                    amount (Union[float, None]):
                    type (Union[str, None]):
                    position_side (Optional[ModifyIsolatedPositionMarginPositionSideEnum] = None): Default `BOTH` for One-way Mode ; `LONG` or `SHORT` for Hedge Mode. It must be sent with Hedge Mode.
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[ModifyIsolatedPositionMarginResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.modify_isolated_position_margin(
            symbol, amount, type, position_side, recv_window
        )

    def modify_multiple_orders(
        self,
        batch_orders: Union[List[ModifyMultipleOrdersBatchOrdersParameterInner], None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[ModifyMultipleOrdersResponse]:
        """
                Modify Multiple Orders(TRADE)

                Modify Multiple Orders (TRADE)

        * Parameter rules are same with `Modify Order`
        * Batch modify orders are processed concurrently, and the order of matching is not guaranteed.
        * The order of returned contents for batch modify orders is the same as the order of the order list.
        * One order can only be modfied for less than 10000 times

        Weight: 5 on 10s order rate limit(X-MBX-ORDER-COUNT-10S);
        1 on 1min order rate limit(X-MBX-ORDER-COUNT-1M);
        5 on IP rate limit(x-mbx-used-weight-1m);

                Args:
                    batch_orders (Union[List[ModifyMultipleOrdersBatchOrdersParameterInner], None]): order list. Max 5 orders
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[ModifyMultipleOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.modify_multiple_orders(batch_orders, recv_window)

    def modify_order(
        self,
        symbol: Union[str, None],
        side: Union[ModifyOrderSideEnum, None],
        quantity: Union[float, None],
        price: Union[float, None],
        order_id: Optional[int] = None,
        orig_client_order_id: Optional[str] = None,
        price_match: Optional[ModifyOrderPriceMatchEnum] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[ModifyOrderResponse]:
        """
                Modify Order (TRADE)

                Order modify function, currently only LIMIT order modification is supported, modified orders will be reordered in the match queue


        * Either `orderId` or `origClientOrderId` must be sent, and the `orderId` will prevail if both are sent.
        * Both `quantity` and `price` must be sent, which is different from dapi modify order endpoint.
        * When the new `quantity` or `price` doesn't satisfy PRICE_FILTER / PERCENT_FILTER / LOT_SIZE, amendment will be rejected and the order will stay as it is.
        * However the order will be cancelled by the amendment in the following situations:
        * when the order is in partially filled status and the new `quantity` <= `executedQty`
        * When the order is `GTX` and the new price will cause it to be executed immediately
        * One order can only be modfied for less than 10000 times

        Weight: 1 on 10s order rate limit(X-MBX-ORDER-COUNT-10S);
        1 on 1min order rate limit(X-MBX-ORDER-COUNT-1M);
        1 on IP rate limit(x-mbx-used-weight-1m)

                Args:
                    symbol (Union[str, None]):
                    side (Union[ModifyOrderSideEnum, None]): `SELL`, `BUY`
                    quantity (Union[float, None]): Order quantity, cannot be sent with `closePosition=true`
                    price (Union[float, None]):
                    order_id (Optional[int] = None):
                    orig_client_order_id (Optional[str] = None):
                    price_match (Optional[ModifyOrderPriceMatchEnum] = None): only avaliable for `LIMIT`/`STOP`/`TAKE_PROFIT` order; can be set to `OPPONENT`/ `OPPONENT_5`/ `OPPONENT_10`/ `OPPONENT_20`: /`QUEUE`/ `QUEUE_5`/ `QUEUE_10`/ `QUEUE_20`; Can't be passed together with `price`
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[ModifyOrderResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.modify_order(
            symbol,
            side,
            quantity,
            price,
            order_id,
            orig_client_order_id,
            price_match,
            recv_window,
        )

    def new_order(
        self,
        symbol: Union[str, None],
        side: Union[NewOrderSideEnum, None],
        type: Union[str, None],
        position_side: Optional[NewOrderPositionSideEnum] = None,
        time_in_force: Optional[NewOrderTimeInForceEnum] = None,
        quantity: Optional[float] = None,
        reduce_only: Optional[str] = None,
        price: Optional[float] = None,
        new_client_order_id: Optional[str] = None,
        stop_price: Optional[float] = None,
        close_position: Optional[str] = None,
        activation_price: Optional[float] = None,
        callback_rate: Optional[float] = None,
        working_type: Optional[NewOrderWorkingTypeEnum] = None,
        price_protect: Optional[str] = None,
        new_order_resp_type: Optional[NewOrderNewOrderRespTypeEnum] = None,
        price_match: Optional[NewOrderPriceMatchEnum] = None,
        self_trade_prevention_mode: Optional[
            NewOrderSelfTradePreventionModeEnum
        ] = None,
        good_till_date: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[NewOrderResponse]:
        """
                New Order(TRADE)

                Send in a new order.

        * Order with type `STOP`,  parameter `timeInForce` can be sent ( default `GTC`).
        * Order with type `TAKE_PROFIT`,  parameter `timeInForce` can be sent ( default `GTC`).
        * Condition orders will be triggered when:

        * If parameter`priceProtect`is sent as true:
        * when price reaches the `stopPrice` ，the difference rate between "MARK_PRICE" and "CONTRACT_PRICE" cannot be larger than the "triggerProtect" of the symbol
        * "triggerProtect" of a symbol can be got from `GET /fapi/v1/exchangeInfo`

        * `STOP`, `STOP_MARKET`:
        * BUY: latest price ("MARK_PRICE" or "CONTRACT_PRICE") >= `stopPrice`
        * SELL: latest price ("MARK_PRICE" or "CONTRACT_PRICE") <= `stopPrice`
        * `TAKE_PROFIT`, `TAKE_PROFIT_MARKET`:
        * BUY: latest price ("MARK_PRICE" or "CONTRACT_PRICE") <= `stopPrice`
        * SELL: latest price ("MARK_PRICE" or "CONTRACT_PRICE") >= `stopPrice`
        * `TRAILING_STOP_MARKET`:
        * BUY: the lowest price after order placed `<= `activationPrice`, and the latest price >`= the lowest price * (1 + `callbackRate`)
        * SELL: the highest price after order placed >= `activationPrice`, and the latest price <= the highest price * (1 - `callbackRate`)

        * For `TRAILING_STOP_MARKET`, if you got such error code.
        ``{"code": -2021, "msg": "Order would immediately trigger."}``
        means that the parameters you send do not meet the following requirements:
        * BUY: `activationPrice` should be smaller than latest price.
        * SELL: `activationPrice` should be larger than latest price.

        * If `newOrderRespType ` is sent as `RESULT` :
        * `MARKET` order: the final FILLED result of the order will be return directly.
        * `LIMIT` order with special `timeInForce`: the final status result of the order(FILLED or EXPIRED) will be returned directly.

        * `STOP_MARKET`, `TAKE_PROFIT_MARKET` with `closePosition`=`true`:
        * Follow the same rules for condition orders.
        * If triggered，**close all** current long position( if `SELL`) or current short position( if `BUY`).
        * Cannot be used with `quantity` paremeter
        * Cannot be used with `reduceOnly` parameter
        * In Hedge Mode,cannot be used with `BUY` orders in `LONG` position side. and cannot be used with `SELL` orders in `SHORT` position side
        * `selfTradePreventionMode` is only effective when `timeInForce` set to `IOC` or `GTC` or `GTD`.
        * In extreme market conditions, timeInForce `GTD` order auto cancel time might be delayed comparing to `goodTillDate`

        Weight: 1 on 10s order rate limit(X-MBX-ORDER-COUNT-10S);
        1 on 1min order rate limit(X-MBX-ORDER-COUNT-1M);
        0 on IP rate limit(x-mbx-used-weight-1m)

                Args:
                    symbol (Union[str, None]):
                    side (Union[NewOrderSideEnum, None]): `SELL`, `BUY`
                    type (Union[str, None]):
                    position_side (Optional[NewOrderPositionSideEnum] = None): Default `BOTH` for One-way Mode ; `LONG` or `SHORT` for Hedge Mode. It must be sent with Hedge Mode.
                    time_in_force (Optional[NewOrderTimeInForceEnum] = None):
                    quantity (Optional[float] = None): Cannot be sent with `closePosition`=`true`(Close-All)
                    reduce_only (Optional[str] = None): "true" or "false". default "false". Cannot be sent in Hedge Mode; cannot be sent with `closePosition`=`true`
                    price (Optional[float] = None):
                    new_client_order_id (Optional[str] = None): A unique id among open orders. Automatically generated if not sent. Can only be string following the rule: `^[.A-Z:/a-z0-9_-]{1,36}$`
                    stop_price (Optional[float] = None): Used with `STOP/STOP_MARKET` or `TAKE_PROFIT/TAKE_PROFIT_MARKET` orders.
                    close_position (Optional[str] = None): `true`, `false`；Close-All，used with `STOP_MARKET` or `TAKE_PROFIT_MARKET`.
                    activation_price (Optional[float] = None): Used with `TRAILING_STOP_MARKET` orders, default as the latest price(supporting different `workingType`)
                    callback_rate (Optional[float] = None): Used with `TRAILING_STOP_MARKET` orders, min 0.1, max 10 where 1 for 1%
                    working_type (Optional[NewOrderWorkingTypeEnum] = None): stopPrice triggered by: "MARK_PRICE", "CONTRACT_PRICE". Default "CONTRACT_PRICE"
                    price_protect (Optional[str] = None): "TRUE" or "FALSE", default "FALSE". Used with `STOP/STOP_MARKET` or `TAKE_PROFIT/TAKE_PROFIT_MARKET` orders.
                    new_order_resp_type (Optional[NewOrderNewOrderRespTypeEnum] = None): "ACK", "RESULT", default "ACK"
                    price_match (Optional[NewOrderPriceMatchEnum] = None): only avaliable for `LIMIT`/`STOP`/`TAKE_PROFIT` order; can be set to `OPPONENT`/ `OPPONENT_5`/ `OPPONENT_10`/ `OPPONENT_20`: /`QUEUE`/ `QUEUE_5`/ `QUEUE_10`/ `QUEUE_20`; Can't be passed together with `price`
                    self_trade_prevention_mode (Optional[NewOrderSelfTradePreventionModeEnum] = None): `NONE`:No STP / `EXPIRE_TAKER`:expire taker order when STP triggers/ `EXPIRE_MAKER`:expire taker order when STP triggers/ `EXPIRE_BOTH`:expire both orders when STP triggers; default `NONE`
                    good_till_date (Optional[int] = None): order cancel time for timeInForce `GTD`, mandatory when `timeInforce` set to `GTD`; order the timestamp only retains second-level precision, ms part will be ignored; The goodTillDate timestamp must be greater than the current time plus 600 seconds and smaller than 253402300799000
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[NewOrderResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.new_order(
            symbol,
            side,
            type,
            position_side,
            time_in_force,
            quantity,
            reduce_only,
            price,
            new_client_order_id,
            stop_price,
            close_position,
            activation_price,
            callback_rate,
            working_type,
            price_protect,
            new_order_resp_type,
            price_match,
            self_trade_prevention_mode,
            good_till_date,
            recv_window,
        )

    def place_multiple_orders(
        self,
        batch_orders: Union[List[PlaceMultipleOrdersBatchOrdersParameterInner], None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[PlaceMultipleOrdersResponse]:
        """
                Place Multiple Orders(TRADE)

                Place Multiple Orders

        * Paremeter rules are same with `New Order`
        * Batch orders are processed concurrently, and the order of matching is not guaranteed.
        * The order of returned contents for batch orders is the same as the order of the order list.

        Weight: 5 on 10s order rate limit(X-MBX-ORDER-COUNT-10S);
        1 on 1min order rate limit(X-MBX-ORDER-COUNT-1M);
        5 on IP rate limit(x-mbx-used-weight-1m);

                Args:
                    batch_orders (Union[List[PlaceMultipleOrdersBatchOrdersParameterInner], None]): order list. Max 5 orders
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[PlaceMultipleOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.place_multiple_orders(batch_orders, recv_window)

    def position_adl_quantile_estimation(
        self,
        symbol: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[PositionAdlQuantileEstimationResponse]:
        """
                Position ADL Quantile Estimation(USER_DATA)

                Position ADL Quantile Estimation

        * Values update every 30s.
        * Values 0, 1, 2, 3, 4 shows the queue position and possibility of ADL from low to high.
        * For positions of the symbol are in One-way Mode or isolated margined in Hedge Mode, "LONG", "SHORT", and "BOTH" will be returned to show the positions' adl quantiles of different position sides.
        * If the positions of the symbol are crossed margined in Hedge Mode:
        * "HEDGE" as a sign will be returned instead of "BOTH";
        * A same value caculated on unrealized pnls on long and short sides' positions will be shown for "LONG" and "SHORT" when there are positions in both of long and short sides.

        Weight: 5

                Args:
                    symbol (Optional[str] = None):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[PositionAdlQuantileEstimationResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.position_adl_quantile_estimation(symbol, recv_window)

    def position_information_v2(
        self,
        symbol: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[PositionInformationV2Response]:
        """
                Position Information V2 (USER_DATA)

                Get current position information.

        Please use with user data stream `ACCOUNT_UPDATE` to meet your timeliness and accuracy needs.

        Weight: 5

                Args:
                    symbol (Optional[str] = None):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[PositionInformationV2Response]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.position_information_v2(symbol, recv_window)

    def position_information_v3(
        self,
        symbol: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[PositionInformationV3Response]:
        """
                Position Information V3 (USER_DATA)

                Get current position information(only symbol that has position or open orders will be returned).

        Please use with user data stream `ACCOUNT_UPDATE` to meet your timeliness and accuracy needs.

        Weight: 5

                Args:
                    symbol (Optional[str] = None):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[PositionInformationV3Response]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.position_information_v3(symbol, recv_window)

    def query_current_open_order(
        self,
        symbol: Union[str, None],
        order_id: Optional[int] = None,
        orig_client_order_id: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QueryCurrentOpenOrderResponse]:
        """
                Query Current Open Order (USER_DATA)

                Query open order


        * Either`orderId` or `origClientOrderId` must be sent
        * If the queried order has been filled or cancelled, the error message "Order does not exist" will be returned.

        Weight: 1

                Args:
                    symbol (Union[str, None]):
                    order_id (Optional[int] = None):
                    orig_client_order_id (Optional[str] = None):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QueryCurrentOpenOrderResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.query_current_open_order(
            symbol, order_id, orig_client_order_id, recv_window
        )

    def query_order(
        self,
        symbol: Union[str, None],
        order_id: Optional[int] = None,
        orig_client_order_id: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QueryOrderResponse]:
        """
                Query Order (USER_DATA)

                Check an order's status.

        * These orders will not be found:
        * order status is `CANCELED` or `EXPIRED` **AND** order has NO filled trade **AND** created time + 3 days < current time
        * order create time + 90 days < current time

        * Either `orderId` or `origClientOrderId` must be sent.
        * `orderId` is self-increment for each specific `symbol`

        Weight: 1

                Args:
                    symbol (Union[str, None]):
                    order_id (Optional[int] = None):
                    orig_client_order_id (Optional[str] = None):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QueryOrderResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.query_order(
            symbol, order_id, orig_client_order_id, recv_window
        )

    def test_order(
        self,
        symbol: Union[str, None],
        side: Union[TestOrderSideEnum, None],
        type: Union[str, None],
        position_side: Optional[TestOrderPositionSideEnum] = None,
        time_in_force: Optional[TestOrderTimeInForceEnum] = None,
        quantity: Optional[float] = None,
        reduce_only: Optional[str] = None,
        price: Optional[float] = None,
        new_client_order_id: Optional[str] = None,
        stop_price: Optional[float] = None,
        close_position: Optional[str] = None,
        activation_price: Optional[float] = None,
        callback_rate: Optional[float] = None,
        working_type: Optional[TestOrderWorkingTypeEnum] = None,
        price_protect: Optional[str] = None,
        new_order_resp_type: Optional[TestOrderNewOrderRespTypeEnum] = None,
        price_match: Optional[TestOrderPriceMatchEnum] = None,
        self_trade_prevention_mode: Optional[
            TestOrderSelfTradePreventionModeEnum
        ] = None,
        good_till_date: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[TestOrderResponse]:
        """
                Test Order(TRADE)

                Testing order request, this order will not be submitted to matching engine

        * Order with type `STOP`,  parameter `timeInForce` can be sent ( default `GTC`).
        * Order with type `TAKE_PROFIT`,  parameter `timeInForce` can be sent ( default `GTC`).
        * Condition orders will be triggered when:

        * If parameter`priceProtect`is sent as true:
        * when price reaches the `stopPrice` ，the difference rate between "MARK_PRICE" and "CONTRACT_PRICE" cannot be larger than the "triggerProtect" of the symbol
        * "triggerProtect" of a symbol can be got from `GET /fapi/v1/exchangeInfo`

        * `STOP`, `STOP_MARKET`:
        * BUY: latest price ("MARK_PRICE" or "CONTRACT_PRICE") >= `stopPrice`
        * SELL: latest price ("MARK_PRICE" or "CONTRACT_PRICE") <= `stopPrice`
        * `TAKE_PROFIT`, `TAKE_PROFIT_MARKET`:
        * BUY: latest price ("MARK_PRICE" or "CONTRACT_PRICE") <= `stopPrice`
        * SELL: latest price ("MARK_PRICE" or "CONTRACT_PRICE") >= `stopPrice`
        * `TRAILING_STOP_MARKET`:
        * BUY: the lowest price after order placed `<= `activationPrice`, and the latest price >`= the lowest price * (1 + `callbackRate`)
        * SELL: the highest price after order placed >= `activationPrice`, and the latest price <= the highest price * (1 - `callbackRate`)

        * For `TRAILING_STOP_MARKET`, if you got such error code.
        ``{"code": -2021, "msg": "Order would immediately trigger."}``
        means that the parameters you send do not meet the following requirements:
        * BUY: `activationPrice` should be smaller than latest price.
        * SELL: `activationPrice` should be larger than latest price.

        * If `newOrderRespType ` is sent as `RESULT` :
        * `MARKET` order: the final FILLED result of the order will be return directly.
        * `LIMIT` order with special `timeInForce`: the final status result of the order(FILLED or EXPIRED) will be returned directly.

        * `STOP_MARKET`, `TAKE_PROFIT_MARKET` with `closePosition`=`true`:
        * Follow the same rules for condition orders.
        * If triggered，**close all** current long position( if `SELL`) or current short position( if `BUY`).
        * Cannot be used with `quantity` paremeter
        * Cannot be used with `reduceOnly` parameter
        * In Hedge Mode,cannot be used with `BUY` orders in `LONG` position side. and cannot be used with `SELL` orders in `SHORT` position side
        * `selfTradePreventionMode` is only effective when `timeInForce` set to `IOC` or `GTC` or `GTD`.
        * In extreme market conditions, timeInForce `GTD` order auto cancel time might be delayed comparing to `goodTillDate`

        Weight: 0

                Args:
                    symbol (Union[str, None]):
                    side (Union[TestOrderSideEnum, None]): `SELL`, `BUY`
                    type (Union[str, None]):
                    position_side (Optional[TestOrderPositionSideEnum] = None): Default `BOTH` for One-way Mode ; `LONG` or `SHORT` for Hedge Mode. It must be sent with Hedge Mode.
                    time_in_force (Optional[TestOrderTimeInForceEnum] = None):
                    quantity (Optional[float] = None): Cannot be sent with `closePosition`=`true`(Close-All)
                    reduce_only (Optional[str] = None): "true" or "false". default "false". Cannot be sent in Hedge Mode; cannot be sent with `closePosition`=`true`
                    price (Optional[float] = None):
                    new_client_order_id (Optional[str] = None): A unique id among open orders. Automatically generated if not sent. Can only be string following the rule: `^[.A-Z:/a-z0-9_-]{1,36}$`
                    stop_price (Optional[float] = None): Used with `STOP/STOP_MARKET` or `TAKE_PROFIT/TAKE_PROFIT_MARKET` orders.
                    close_position (Optional[str] = None): `true`, `false`；Close-All，used with `STOP_MARKET` or `TAKE_PROFIT_MARKET`.
                    activation_price (Optional[float] = None): Used with `TRAILING_STOP_MARKET` orders, default as the latest price(supporting different `workingType`)
                    callback_rate (Optional[float] = None): Used with `TRAILING_STOP_MARKET` orders, min 0.1, max 10 where 1 for 1%
                    working_type (Optional[TestOrderWorkingTypeEnum] = None): stopPrice triggered by: "MARK_PRICE", "CONTRACT_PRICE". Default "CONTRACT_PRICE"
                    price_protect (Optional[str] = None): "TRUE" or "FALSE", default "FALSE". Used with `STOP/STOP_MARKET` or `TAKE_PROFIT/TAKE_PROFIT_MARKET` orders.
                    new_order_resp_type (Optional[TestOrderNewOrderRespTypeEnum] = None): "ACK", "RESULT", default "ACK"
                    price_match (Optional[TestOrderPriceMatchEnum] = None): only avaliable for `LIMIT`/`STOP`/`TAKE_PROFIT` order; can be set to `OPPONENT`/ `OPPONENT_5`/ `OPPONENT_10`/ `OPPONENT_20`: /`QUEUE`/ `QUEUE_5`/ `QUEUE_10`/ `QUEUE_20`; Can't be passed together with `price`
                    self_trade_prevention_mode (Optional[TestOrderSelfTradePreventionModeEnum] = None): `NONE`:No STP / `EXPIRE_TAKER`:expire taker order when STP triggers/ `EXPIRE_MAKER`:expire taker order when STP triggers/ `EXPIRE_BOTH`:expire both orders when STP triggers; default `NONE`
                    good_till_date (Optional[int] = None): order cancel time for timeInForce `GTD`, mandatory when `timeInforce` set to `GTD`; order the timestamp only retains second-level precision, ms part will be ignored; The goodTillDate timestamp must be greater than the current time plus 600 seconds and smaller than 253402300799000
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[TestOrderResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.test_order(
            symbol,
            side,
            type,
            position_side,
            time_in_force,
            quantity,
            reduce_only,
            price,
            new_client_order_id,
            stop_price,
            close_position,
            activation_price,
            callback_rate,
            working_type,
            price_protect,
            new_order_resp_type,
            price_match,
            self_trade_prevention_mode,
            good_till_date,
            recv_window,
        )

    def users_force_orders(
        self,
        symbol: Optional[str] = None,
        auto_close_type: Optional[UsersForceOrdersAutoCloseTypeEnum] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[UsersForceOrdersResponse]:
        """
                User's Force Orders (USER_DATA)

                Query user's Force Orders

        * If "autoCloseType" is not sent, orders with both of the types will be returned
        * If "startTime" is not sent, data within 7 days before "endTime" can be queried

        Weight: 20 with symbol, 50 without symbol

                Args:
                    symbol (Optional[str] = None):
                    auto_close_type (Optional[UsersForceOrdersAutoCloseTypeEnum] = None): "LIQUIDATION" for liquidation orders, "ADL" for ADL orders.
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default 100; max 1000
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[UsersForceOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.users_force_orders(
            symbol, auto_close_type, start_time, end_time, limit, recv_window
        )

    def close_user_data_stream(
        self,
    ) -> ApiResponse[None]:
        """
                Close User Data Stream (USER_STREAM)

                Close out a user data stream.

        Weight: 1

                Args:

                Returns:
                    ApiResponse[None]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._userDataStreamsApi.close_user_data_stream()

    def keepalive_user_data_stream(
        self,
    ) -> ApiResponse[KeepaliveUserDataStreamResponse]:
        """
                Keepalive User Data Stream (USER_STREAM)

                Keepalive a user data stream to prevent a time out. User data streams will close after 60 minutes. It's recommended to send a ping about every 60 minutes.

        Weight: 1

                Args:

                Returns:
                    ApiResponse[KeepaliveUserDataStreamResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._userDataStreamsApi.keepalive_user_data_stream()

    def start_user_data_stream(
        self,
    ) -> ApiResponse[StartUserDataStreamResponse]:
        """
                Start User Data Stream (USER_STREAM)

                Start a new user data stream. The stream will close after 60 minutes unless a keepalive is sent. If the account has an active `listenKey`, that `listenKey` will be returned and its validity will be extended for 60 minutes.

        Weight: 1

                Args:

                Returns:
                    ApiResponse[StartUserDataStreamResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._userDataStreamsApi.start_user_data_stream()
