"""
Binance Derivatives Trading USDS Futures WebSocket API

OpenAPI Specification for the Binance Derivatives Trading USDS Futures WebSocket API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from binance_common.errors import RequiredError
from binance_common.models import WebsocketApiResponse
from binance_common.signature import Signers
from binance_common.websocket import WebSocketAPIBase

from ..models import OrderBookResponse
from ..models import SymbolOrderBookTickerResponse
from ..models import SymbolPriceTickerResponse


from typing import Optional, Union


class MarketDataApi:
    """API Client for MarketDataApi endpoints."""

    def __init__(
        self,
        websocket_api: WebSocketAPIBase,
        signer: Signers = None,
    ) -> None:
        self.websocket_api = websocket_api
        self.signer = signer

    async def order_book(
        self,
        symbol: Union[str, None],
        id: Optional[str] = None,
        limit: Optional[int] = None,
    ) -> WebsocketApiResponse[OrderBookResponse]:
        """
            Order Book
            /depth
            https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/websocket-api/Order-Book

            Get current order book. Note that this request returns limited market depth.
        If you need to continuously monitor order book updates, please consider using Websocket Market Streams:
        * `<symbol>@depth<levels>`
        * `<symbol>@depth`

        You can use `depth` request together with `<symbol>@depth` streams to maintain a local order book.

        Weight: Adjusted based on the limit:
        | Limit         | Weight |
        | ------------- | ------ |
        | 5, 10, 20, 50 | 2      |
        | 100           | 5      |
        | 500           | 10     |
        | 1000          | 20     |

            Args:
                    symbol (Union[str, None]):
                    id (Optional[str] = None): Unique WebSocket request ID.
                    limit (Optional[int] = None): Default 500; Valid limits:[5, 10, 20, 50, 100, 500, 1000]

            Returns:
                WebsocketApiResponse[OrderBookResponse]

            Raises:
                RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        params = {
            "symbol": symbol,
            **({"id": id} if id is not None else {}),
            **({"limit": limit} if limit is not None else {}),
        }

        payload = {
            "method": "/depth".replace("/", ""),
            "params": params,
        }

        return await self.websocket_api.send_message(
            payload=payload, response_model=OrderBookResponse
        )

    async def symbol_order_book_ticker(
        self,
        id: Optional[str] = None,
        symbol: Optional[str] = None,
    ) -> WebsocketApiResponse[SymbolOrderBookTickerResponse]:
        """
            Symbol Order Book Ticker
            /ticker.book
            https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/websocket-api/Symbol-Order-Book-Ticker

            Best price/qty on the order book for a symbol or symbols.

        * If the symbol is not sent, bookTickers for all symbols will be returned in an array.
        * The field `X-MBX-USED-WEIGHT-1M` in response header is not accurate from this endpoint, please ignore.

        Weight: 2 for a single symbol;
        5 when the symbol parameter is omitted

            Args:
                    id (Optional[str] = None): Unique WebSocket request ID.
                    symbol (Optional[str] = None):

            Returns:
                WebsocketApiResponse[SymbolOrderBookTickerResponse]

            Raises:
                RequiredError: If a required parameter is missing.

        """

        params = {
            **({"id": id} if id is not None else {}),
            **({"symbol": symbol} if symbol is not None else {}),
        }

        payload = {
            "method": "/ticker.book".replace("/", ""),
            "params": params,
        }

        return await self.websocket_api.send_message(
            payload=payload, response_model=SymbolOrderBookTickerResponse
        )

    async def symbol_price_ticker(
        self,
        id: Optional[str] = None,
        symbol: Optional[str] = None,
    ) -> WebsocketApiResponse[SymbolPriceTickerResponse]:
        """
            Symbol Price Ticker
            /ticker.price
            https://developers.binance.com/docs/derivatives/usds-margined-futures/market-data/websocket-api/Symbol-Price-Ticker

            Latest price for a symbol or symbols.

        * If the symbol is not sent, prices for all symbols will be returned in an array.

        Weight: 1 for a single symbol;
        2 when the symbol parameter is omitted

            Args:
                    id (Optional[str] = None): Unique WebSocket request ID.
                    symbol (Optional[str] = None):

            Returns:
                WebsocketApiResponse[SymbolPriceTickerResponse]

            Raises:
                RequiredError: If a required parameter is missing.

        """

        params = {
            **({"id": id} if id is not None else {}),
            **({"symbol": symbol} if symbol is not None else {}),
        }

        payload = {
            "method": "/ticker.price".replace("/", ""),
            "params": params,
        }

        return await self.websocket_api.send_message(
            payload=payload, response_model=SymbolPriceTickerResponse
        )
