# coding: utf-8

"""
Binance Derivatives Trading USDS Futures WebSocket API

OpenAPI Specification for the Binance Derivatives Trading USDS Futures WebSocket API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from binance_sdk_derivatives_trading_usds_futures.websocket_api.models.account_information_v2_response_result_assets_inner import (
    AccountInformationV2ResponseResultAssetsInner,
)
from binance_sdk_derivatives_trading_usds_futures.websocket_api.models.account_information_v2_response_result_positions_inner import (
    AccountInformationV2ResponseResultPositionsInner,
)
from typing import Set
from typing_extensions import Self


class AccountInformationV2ResponseResult(BaseModel):
    """
    AccountInformationV2ResponseResult
    """  # noqa: E501

    total_initial_margin: Optional[StrictStr] = Field(
        default=None, alias="totalInitialMargin"
    )
    total_maint_margin: Optional[StrictStr] = Field(
        default=None, alias="totalMaintMargin"
    )
    total_wallet_balance: Optional[StrictStr] = Field(
        default=None, alias="totalWalletBalance"
    )
    total_unrealized_profit: Optional[StrictStr] = Field(
        default=None, alias="totalUnrealizedProfit"
    )
    total_margin_balance: Optional[StrictStr] = Field(
        default=None, alias="totalMarginBalance"
    )
    total_position_initial_margin: Optional[StrictStr] = Field(
        default=None, alias="totalPositionInitialMargin"
    )
    total_open_order_initial_margin: Optional[StrictStr] = Field(
        default=None, alias="totalOpenOrderInitialMargin"
    )
    total_cross_wallet_balance: Optional[StrictStr] = Field(
        default=None, alias="totalCrossWalletBalance"
    )
    total_cross_un_pnl: Optional[StrictStr] = Field(
        default=None, alias="totalCrossUnPnl"
    )
    available_balance: Optional[StrictStr] = Field(
        default=None, alias="availableBalance"
    )
    max_withdraw_amount: Optional[StrictStr] = Field(
        default=None, alias="maxWithdrawAmount"
    )
    assets: Optional[List[AccountInformationV2ResponseResultAssetsInner]] = Field(
        default=None, alias="assets"
    )

    positions: Optional[List[AccountInformationV2ResponseResultPositionsInner]] = Field(
        default=None, alias="positions"
    )

    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "totalInitialMargin",
        "totalMaintMargin",
        "totalWalletBalance",
        "totalUnrealizedProfit",
        "totalMarginBalance",
        "totalPositionInitialMargin",
        "totalOpenOrderInitialMargin",
        "totalCrossWalletBalance",
        "totalCrossUnPnl",
        "availableBalance",
        "maxWithdrawAmount",
        "assets",
        "positions",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def is_array(cls) -> bool:
        return False

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AccountInformationV2ResponseResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in assets (list)
        _items = []
        if self.assets:
            for _item_assets in self.assets:
                if _item_assets:
                    _items.append(_item_assets.to_dict())
            _dict["assets"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in positions (list)
        _items = []
        if self.positions:
            for _item_positions in self.positions:
                if _item_positions:
                    _items.append(_item_positions.to_dict())
            _dict["positions"] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AccountInformationV2ResponseResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "totalInitialMargin": obj.get("totalInitialMargin"),
                "totalMaintMargin": obj.get("totalMaintMargin"),
                "totalWalletBalance": obj.get("totalWalletBalance"),
                "totalUnrealizedProfit": obj.get("totalUnrealizedProfit"),
                "totalMarginBalance": obj.get("totalMarginBalance"),
                "totalPositionInitialMargin": obj.get("totalPositionInitialMargin"),
                "totalOpenOrderInitialMargin": obj.get("totalOpenOrderInitialMargin"),
                "totalCrossWalletBalance": obj.get("totalCrossWalletBalance"),
                "totalCrossUnPnl": obj.get("totalCrossUnPnl"),
                "availableBalance": obj.get("availableBalance"),
                "maxWithdrawAmount": obj.get("maxWithdrawAmount"),
                "assets": (
                    [
                        AccountInformationV2ResponseResultAssetsInner.from_dict(_item)
                        for _item in obj["assets"]
                    ]
                    if obj.get("assets") is not None
                    else None
                ),
                "positions": (
                    [
                        AccountInformationV2ResponseResultPositionsInner.from_dict(
                            _item
                        )
                        for _item in obj["positions"]
                    ]
                    if obj.get("positions") is not None
                    else None
                ),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
