# coding: utf-8

"""
Binance Derivatives Trading USDS Futures WebSocket API

OpenAPI Specification for the Binance Derivatives Trading USDS Futures WebSocket API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Set
from typing_extensions import Self


class ModifyOrderResponseResult(BaseModel):
    """
    ModifyOrderResponseResult
    """  # noqa: E501

    order_id: Optional[StrictInt] = Field(default=None, alias="orderId")
    symbol: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    client_order_id: Optional[StrictStr] = Field(default=None, alias="clientOrderId")
    price: Optional[StrictStr] = None
    avg_price: Optional[StrictStr] = Field(default=None, alias="avgPrice")
    orig_qty: Optional[StrictStr] = Field(default=None, alias="origQty")
    executed_qty: Optional[StrictStr] = Field(default=None, alias="executedQty")
    cum_qty: Optional[StrictStr] = Field(default=None, alias="cumQty")
    cum_quote: Optional[StrictStr] = Field(default=None, alias="cumQuote")
    time_in_force: Optional[StrictStr] = Field(default=None, alias="timeInForce")
    type: Optional[StrictStr] = None
    reduce_only: Optional[StrictBool] = Field(default=None, alias="reduceOnly")
    close_position: Optional[StrictBool] = Field(default=None, alias="closePosition")
    side: Optional[StrictStr] = None
    position_side: Optional[StrictStr] = Field(default=None, alias="positionSide")
    stop_price: Optional[StrictStr] = Field(default=None, alias="stopPrice")
    working_type: Optional[StrictStr] = Field(default=None, alias="workingType")
    price_protect: Optional[StrictBool] = Field(default=None, alias="priceProtect")
    orig_type: Optional[StrictStr] = Field(default=None, alias="origType")
    price_match: Optional[StrictStr] = Field(default=None, alias="priceMatch")
    self_trade_prevention_mode: Optional[StrictStr] = Field(
        default=None, alias="selfTradePreventionMode"
    )
    good_till_date: Optional[StrictInt] = Field(default=None, alias="goodTillDate")
    update_time: Optional[StrictInt] = Field(default=None, alias="updateTime")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "orderId",
        "symbol",
        "status",
        "clientOrderId",
        "price",
        "avgPrice",
        "origQty",
        "executedQty",
        "cumQty",
        "cumQuote",
        "timeInForce",
        "type",
        "reduceOnly",
        "closePosition",
        "side",
        "positionSide",
        "stopPrice",
        "workingType",
        "priceProtect",
        "origType",
        "priceMatch",
        "selfTradePreventionMode",
        "goodTillDate",
        "updateTime",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def is_array(cls) -> bool:
        return False

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ModifyOrderResponseResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ModifyOrderResponseResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "orderId": obj.get("orderId"),
                "symbol": obj.get("symbol"),
                "status": obj.get("status"),
                "clientOrderId": obj.get("clientOrderId"),
                "price": obj.get("price"),
                "avgPrice": obj.get("avgPrice"),
                "origQty": obj.get("origQty"),
                "executedQty": obj.get("executedQty"),
                "cumQty": obj.get("cumQty"),
                "cumQuote": obj.get("cumQuote"),
                "timeInForce": obj.get("timeInForce"),
                "type": obj.get("type"),
                "reduceOnly": obj.get("reduceOnly"),
                "closePosition": obj.get("closePosition"),
                "side": obj.get("side"),
                "positionSide": obj.get("positionSide"),
                "stopPrice": obj.get("stopPrice"),
                "workingType": obj.get("workingType"),
                "priceProtect": obj.get("priceProtect"),
                "origType": obj.get("origType"),
                "priceMatch": obj.get("priceMatch"),
                "selfTradePreventionMode": obj.get("selfTradePreventionMode"),
                "goodTillDate": obj.get("goodTillDate"),
                "updateTime": obj.get("updateTime"),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
