"""
Binance Derivatives Trading USDS Futures WebSocket Market Streams

OpenAPI Specification for the Binance Derivatives Trading USDS Futures WebSocket Market Streams
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from binance_common.errors import RequiredError
from binance_common.utils import ws_streams_placeholder
from binance_common.websocket import (
    WebSocketStreamBase,
    RequestStream,
    RequestStreamHandle,
)

from ..models import AggregateTradeStreamsResponse
from ..models import AllBookTickersStreamResponse
from ..models import AllMarketLiquidationOrderStreamsResponse
from ..models import AllMarketMiniTickersStreamResponse
from ..models import AllMarketTickersStreamsResponse
from ..models import CompositeIndexSymbolInformationStreamsResponse
from ..models import ContinuousContractKlineCandlestickStreamsResponse
from ..models import ContractInfoStreamResponse
from ..models import DiffBookDepthStreamsResponse
from ..models import IndividualSymbolBookTickerStreamsResponse
from ..models import IndividualSymbolMiniTickerStreamResponse
from ..models import IndividualSymbolTickerStreamsResponse
from ..models import KlineCandlestickStreamsResponse
from ..models import LiquidationOrderStreamsResponse
from ..models import MarkPriceStreamResponse
from ..models import MarkPriceStreamForAllMarketResponse
from ..models import MultiAssetsModeAssetIndexResponse
from ..models import PartialBookDepthStreamsResponse


from typing import Optional, Union


class WebsocketMarketStreamsApi:
    """Client for WebsocketMarketStreamsApi endpoints."""

    def __init__(self, websocket_base: WebSocketStreamBase) -> None:
        self.websocket_base = websocket_base

    async def aggregate_trade_streams(
        self,
        symbol: Union[str, None],
        id: Optional[str] = None,
    ) -> RequestStreamHandle:
        r"""
            Aggregate Trade Streams
            /<symbol>@aggTrade
            https://developers.binance.com/docs/derivatives/usds-margined-futures/websocket-market-streams/Aggregate-Trade-Streams

            The Aggregate Trade Streams push market trade information that is aggregated for fills with same price and taking side every 100 milliseconds. Only market trades will be aggregated, which means the insurance fund trades and ADL trades won't be aggregated.

        Update Speed: 100ms

            Args:
                    symbol (Union[str, None]): The symbol parameter
                    id (Optional[str] = None): Unique WebSocket request ID.

            Returns:
                RequestStreamHandle

            Raises:
                RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        stream = ws_streams_placeholder(
            "/<symbol>@aggTrade".replace("/", ""),
            {
                "symbol": symbol,
                "id": id,
            },
        )

        return await RequestStream(
            self.websocket_base,
            stream=stream,
            response_model=AggregateTradeStreamsResponse,
        )

    async def all_book_tickers_stream(
        self,
        id: Optional[str] = None,
    ) -> RequestStreamHandle:
        r"""
            All Book Tickers Stream
            /!bookTicker
            https://developers.binance.com/docs/derivatives/usds-margined-futures/websocket-market-streams/All-Book-Tickers-Stream

            Pushes any update to the best bid or ask's price or quantity in real-time for all symbols.

        Update Speed: 5s

            Args:
                    id (Optional[str] = None): Unique WebSocket request ID.

            Returns:
                RequestStreamHandle

            Raises:
                RequiredError: If a required parameter is missing.

        """

        stream = ws_streams_placeholder(
            "/!bookTicker".replace("/", ""),
            {
                "id": id,
            },
        )

        return await RequestStream(
            self.websocket_base,
            stream=stream,
            response_model=AllBookTickersStreamResponse,
        )

    async def all_market_liquidation_order_streams(
        self,
        id: Optional[str] = None,
    ) -> RequestStreamHandle:
        r"""
            All Market Liquidation Order Streams
            /!forceOrder@arr
            https://developers.binance.com/docs/derivatives/usds-margined-futures/websocket-market-streams/All-Market-Liquidation-Order-Streams

            The All Liquidation Order Snapshot Streams push force liquidation order information for all symbols in the market.
        For each symbol，only the latest one liquidation order within 1000ms will be pushed as the snapshot. If no liquidation happens in the interval of 1000ms, no stream will be pushed.

        Update Speed: 1000ms

            Args:
                    id (Optional[str] = None): Unique WebSocket request ID.

            Returns:
                RequestStreamHandle

            Raises:
                RequiredError: If a required parameter is missing.

        """

        stream = ws_streams_placeholder(
            "/!forceOrder@arr".replace("/", ""),
            {
                "id": id,
            },
        )

        return await RequestStream(
            self.websocket_base,
            stream=stream,
            response_model=AllMarketLiquidationOrderStreamsResponse,
        )

    async def all_market_mini_tickers_stream(
        self,
        id: Optional[str] = None,
    ) -> RequestStreamHandle:
        r"""
            All Market Mini Tickers Stream
            /!miniTicker@arr
            https://developers.binance.com/docs/derivatives/usds-margined-futures/websocket-market-streams/All-Market-Mini-Tickers-Stream

            24hr rolling window mini-ticker statistics for all symbols. These are NOT the statistics of the UTC day, but a 24hr rolling window from requestTime to 24hrs before. Note that only tickers that have changed will be present in the array.

        Update Speed: 1000ms

            Args:
                    id (Optional[str] = None): Unique WebSocket request ID.

            Returns:
                RequestStreamHandle

            Raises:
                RequiredError: If a required parameter is missing.

        """

        stream = ws_streams_placeholder(
            "/!miniTicker@arr".replace("/", ""),
            {
                "id": id,
            },
        )

        return await RequestStream(
            self.websocket_base,
            stream=stream,
            response_model=AllMarketMiniTickersStreamResponse,
        )

    async def all_market_tickers_streams(
        self,
        id: Optional[str] = None,
    ) -> RequestStreamHandle:
        r"""
            All Market Tickers Streams
            /!ticker@arr
            https://developers.binance.com/docs/derivatives/usds-margined-futures/websocket-market-streams/All-Market-Tickers-Streams

            24hr rolling window ticker statistics for all symbols. These are NOT the statistics of the UTC day, but a 24hr rolling window from requestTime to 24hrs before. Note that only tickers that have changed will be present in the array.

        Update Speed: 1000ms

            Args:
                    id (Optional[str] = None): Unique WebSocket request ID.

            Returns:
                RequestStreamHandle

            Raises:
                RequiredError: If a required parameter is missing.

        """

        stream = ws_streams_placeholder(
            "/!ticker@arr".replace("/", ""),
            {
                "id": id,
            },
        )

        return await RequestStream(
            self.websocket_base,
            stream=stream,
            response_model=AllMarketTickersStreamsResponse,
        )

    async def composite_index_symbol_information_streams(
        self,
        symbol: Union[str, None],
        id: Optional[str] = None,
    ) -> RequestStreamHandle:
        r"""
            Composite Index Symbol Information Streams
            /<symbol>@compositeIndex
            https://developers.binance.com/docs/derivatives/usds-margined-futures/websocket-market-streams/Composite-Index-Symbol-Information-Streams

            Composite index information for index symbols pushed every second.

        Update Speed: 1000ms

            Args:
                    symbol (Union[str, None]): The symbol parameter
                    id (Optional[str] = None): Unique WebSocket request ID.

            Returns:
                RequestStreamHandle

            Raises:
                RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        stream = ws_streams_placeholder(
            "/<symbol>@compositeIndex".replace("/", ""),
            {
                "symbol": symbol,
                "id": id,
            },
        )

        return await RequestStream(
            self.websocket_base,
            stream=stream,
            response_model=CompositeIndexSymbolInformationStreamsResponse,
        )

    async def continuous_contract_kline_candlestick_streams(
        self,
        pair: Union[str, None],
        contract_type: Union[str, None],
        interval: Union[str, None],
        id: Optional[str] = None,
    ) -> RequestStreamHandle:
        r"""
            Continuous Contract Kline/Candlestick Streams
            /<pair>_<contractType>@continuousKline_<interval>
            https://developers.binance.com/docs/derivatives/usds-margined-futures/websocket-market-streams/Continuous-Contract-Kline-Candlestick-Streams


        Update Speed: 250ms

            Args:
                    pair (Union[str, None]): The pair parameter
                    contract_type (Union[str, None]): The contractType parameter
                    interval (Union[str, None]): The interval parameter
                    id (Optional[str] = None): Unique WebSocket request ID.

            Returns:
                RequestStreamHandle

            Raises:
                RequiredError: If a required parameter is missing.

        """

        if pair is None:
            raise RequiredError(
                field="pair", error_message="Missing required parameter 'pair'"
            )
        if contract_type is None:
            raise RequiredError(
                field="contract_type",
                error_message="Missing required parameter 'contract_type'",
            )
        if interval is None:
            raise RequiredError(
                field="interval", error_message="Missing required parameter 'interval'"
            )

        stream = ws_streams_placeholder(
            "/<pair>_<contractType>@continuousKline_<interval>".replace("/", ""),
            {
                "pair": pair,
                "contract_type": contract_type,
                "interval": interval,
                "id": id,
            },
        )

        return await RequestStream(
            self.websocket_base,
            stream=stream,
            response_model=ContinuousContractKlineCandlestickStreamsResponse,
        )

    async def contract_info_stream(
        self,
        id: Optional[str] = None,
    ) -> RequestStreamHandle:
        r"""
            Contract Info Stream
            /!contractInfo
            https://developers.binance.com/docs/derivatives/usds-margined-futures/websocket-market-streams/Contract-Info-Stream

            ContractInfo stream pushes when contract info updates(listing/settlement/contract bracket update). `bks` field only shows up when bracket gets updated.

        Update Speed: Real-time

            Args:
                    id (Optional[str] = None): Unique WebSocket request ID.

            Returns:
                RequestStreamHandle

            Raises:
                RequiredError: If a required parameter is missing.

        """

        stream = ws_streams_placeholder(
            "/!contractInfo".replace("/", ""),
            {
                "id": id,
            },
        )

        return await RequestStream(
            self.websocket_base,
            stream=stream,
            response_model=ContractInfoStreamResponse,
        )

    async def diff_book_depth_streams(
        self,
        symbol: Union[str, None],
        id: Optional[str] = None,
        update_speed: Optional[str] = None,
    ) -> RequestStreamHandle:
        r"""
            Diff. Book Depth Streams
            /<symbol>@depth@<updateSpeed>
            https://developers.binance.com/docs/derivatives/usds-margined-futures/websocket-market-streams/Diff-Book-Depth-Streams

            Bids and asks, pushed every 250 milliseconds, 500 milliseconds, 100 milliseconds (if existing)

        Update Speed: 250ms, 500ms, 100ms

            Args:
                    symbol (Union[str, None]): The symbol parameter
                    id (Optional[str] = None): Unique WebSocket request ID.
                    update_speed (Optional[str] = None): WebSocket stream update speed

            Returns:
                RequestStreamHandle

            Raises:
                RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        stream = ws_streams_placeholder(
            "/<symbol>@depth@<updateSpeed>".replace("/", ""),
            {
                "symbol": symbol,
                "id": id,
                "update_speed": update_speed,
            },
        )

        return await RequestStream(
            self.websocket_base,
            stream=stream,
            response_model=DiffBookDepthStreamsResponse,
        )

    async def individual_symbol_book_ticker_streams(
        self,
        symbol: Union[str, None],
        id: Optional[str] = None,
    ) -> RequestStreamHandle:
        r"""
            Individual Symbol Book Ticker Streams
            /<symbol>@bookTicker
            https://developers.binance.com/docs/derivatives/usds-margined-futures/websocket-market-streams/Individual-Symbol-Book-Ticker-Streams

            Pushes any update to the best bid or ask's price or quantity in real-time for a specified symbol.

        Update Speed: Real-time

            Args:
                    symbol (Union[str, None]): The symbol parameter
                    id (Optional[str] = None): Unique WebSocket request ID.

            Returns:
                RequestStreamHandle

            Raises:
                RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        stream = ws_streams_placeholder(
            "/<symbol>@bookTicker".replace("/", ""),
            {
                "symbol": symbol,
                "id": id,
            },
        )

        return await RequestStream(
            self.websocket_base,
            stream=stream,
            response_model=IndividualSymbolBookTickerStreamsResponse,
        )

    async def individual_symbol_mini_ticker_stream(
        self,
        symbol: Union[str, None],
        id: Optional[str] = None,
    ) -> RequestStreamHandle:
        r"""
            Individual Symbol Mini Ticker Stream
            /<symbol>@miniTicker
            https://developers.binance.com/docs/derivatives/usds-margined-futures/websocket-market-streams/Individual-Symbol-Mini-Ticker-Stream

            24hr rolling window mini-ticker statistics for a single symbol. These are NOT the statistics of the UTC day, but a 24hr rolling window from requestTime to 24hrs before.

        Update Speed: 2s

            Args:
                    symbol (Union[str, None]): The symbol parameter
                    id (Optional[str] = None): Unique WebSocket request ID.

            Returns:
                RequestStreamHandle

            Raises:
                RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        stream = ws_streams_placeholder(
            "/<symbol>@miniTicker".replace("/", ""),
            {
                "symbol": symbol,
                "id": id,
            },
        )

        return await RequestStream(
            self.websocket_base,
            stream=stream,
            response_model=IndividualSymbolMiniTickerStreamResponse,
        )

    async def individual_symbol_ticker_streams(
        self,
        symbol: Union[str, None],
        id: Optional[str] = None,
    ) -> RequestStreamHandle:
        r"""
            Individual Symbol Ticker Streams
            /<symbol>@ticker
            https://developers.binance.com/docs/derivatives/usds-margined-futures/websocket-market-streams/Individual-Symbol-Ticker-Streams

            24hr rolling window ticker statistics for a single symbol. These are NOT the statistics of the UTC day, but a 24hr rolling window from requestTime to 24hrs before.

        Update Speed: 2000ms

            Args:
                    symbol (Union[str, None]): The symbol parameter
                    id (Optional[str] = None): Unique WebSocket request ID.

            Returns:
                RequestStreamHandle

            Raises:
                RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        stream = ws_streams_placeholder(
            "/<symbol>@ticker".replace("/", ""),
            {
                "symbol": symbol,
                "id": id,
            },
        )

        return await RequestStream(
            self.websocket_base,
            stream=stream,
            response_model=IndividualSymbolTickerStreamsResponse,
        )

    async def kline_candlestick_streams(
        self,
        symbol: Union[str, None],
        interval: Union[str, None],
        id: Optional[str] = None,
    ) -> RequestStreamHandle:
        r"""
            Kline/Candlestick Streams
            /<symbol>@kline_<interval>
            https://developers.binance.com/docs/derivatives/usds-margined-futures/websocket-market-streams/Kline-Candlestick-Streams

            The Kline/Candlestick Stream push updates to the current klines/candlestick every 250 milliseconds (if existing).

        Update Speed: 250ms

            Args:
                    symbol (Union[str, None]): The symbol parameter
                    interval (Union[str, None]): The interval parameter
                    id (Optional[str] = None): Unique WebSocket request ID.

            Returns:
                RequestStreamHandle

            Raises:
                RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )
        if interval is None:
            raise RequiredError(
                field="interval", error_message="Missing required parameter 'interval'"
            )

        stream = ws_streams_placeholder(
            "/<symbol>@kline_<interval>".replace("/", ""),
            {
                "symbol": symbol,
                "interval": interval,
                "id": id,
            },
        )

        return await RequestStream(
            self.websocket_base,
            stream=stream,
            response_model=KlineCandlestickStreamsResponse,
        )

    async def liquidation_order_streams(
        self,
        symbol: Union[str, None],
        id: Optional[str] = None,
    ) -> RequestStreamHandle:
        r"""
            Liquidation Order Streams
            /<symbol>@forceOrder
            https://developers.binance.com/docs/derivatives/usds-margined-futures/websocket-market-streams/Liquidation-Order-Streams

            The Liquidation Order Snapshot Streams push force liquidation order information for specific symbol.
        For each symbol，only the latest one liquidation order within 1000ms will be pushed as the snapshot. If no liquidation happens in the interval of 1000ms, no stream will be pushed.

        Update Speed: 1000ms

            Args:
                    symbol (Union[str, None]): The symbol parameter
                    id (Optional[str] = None): Unique WebSocket request ID.

            Returns:
                RequestStreamHandle

            Raises:
                RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        stream = ws_streams_placeholder(
            "/<symbol>@forceOrder".replace("/", ""),
            {
                "symbol": symbol,
                "id": id,
            },
        )

        return await RequestStream(
            self.websocket_base,
            stream=stream,
            response_model=LiquidationOrderStreamsResponse,
        )

    async def mark_price_stream(
        self,
        symbol: Union[str, None],
        id: Optional[str] = None,
        update_speed: Optional[str] = None,
    ) -> RequestStreamHandle:
        r"""
            Mark Price Stream
            /<symbol>@markPrice@<updateSpeed>
            https://developers.binance.com/docs/derivatives/usds-margined-futures/websocket-market-streams/Mark-Price-Stream

            Mark price and funding rate for a single symbol pushed every 3 seconds or every second.

        Update Speed: 3000ms or 1000ms

            Args:
                    symbol (Union[str, None]): The symbol parameter
                    id (Optional[str] = None): Unique WebSocket request ID.
                    update_speed (Optional[str] = None): WebSocket stream update speed

            Returns:
                RequestStreamHandle

            Raises:
                RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        stream = ws_streams_placeholder(
            "/<symbol>@markPrice@<updateSpeed>".replace("/", ""),
            {
                "symbol": symbol,
                "id": id,
                "update_speed": update_speed,
            },
        )

        return await RequestStream(
            self.websocket_base, stream=stream, response_model=MarkPriceStreamResponse
        )

    async def mark_price_stream_for_all_market(
        self,
        id: Optional[str] = None,
        update_speed: Optional[str] = None,
    ) -> RequestStreamHandle:
        r"""
            Mark Price Stream for All market
            /!markPrice@arr@<updateSpeed>
            https://developers.binance.com/docs/derivatives/usds-margined-futures/websocket-market-streams/Mark-Price-Stream-for-All-market

            Mark price and funding rate for all symbols pushed every 3 seconds or every second.

        Update Speed: 3000ms or 1000ms

            Args:
                    id (Optional[str] = None): Unique WebSocket request ID.
                    update_speed (Optional[str] = None): WebSocket stream update speed

            Returns:
                RequestStreamHandle

            Raises:
                RequiredError: If a required parameter is missing.

        """

        stream = ws_streams_placeholder(
            "/!markPrice@arr@<updateSpeed>".replace("/", ""),
            {
                "id": id,
                "update_speed": update_speed,
            },
        )

        return await RequestStream(
            self.websocket_base,
            stream=stream,
            response_model=MarkPriceStreamForAllMarketResponse,
        )

    async def multi_assets_mode_asset_index(
        self,
        id: Optional[str] = None,
    ) -> RequestStreamHandle:
        r"""
            Multi-Assets Mode Asset Index
            /!assetIndex@arr
            https://developers.binance.com/docs/derivatives/usds-margined-futures/websocket-market-streams/Multi-Assets-Mode-Asset-Index

            Asset index for multi-assets mode user

        Update Speed: 1s

            Args:
                    id (Optional[str] = None): Unique WebSocket request ID.

            Returns:
                RequestStreamHandle

            Raises:
                RequiredError: If a required parameter is missing.

        """

        stream = ws_streams_placeholder(
            "/!assetIndex@arr".replace("/", ""),
            {
                "id": id,
            },
        )

        return await RequestStream(
            self.websocket_base,
            stream=stream,
            response_model=MultiAssetsModeAssetIndexResponse,
        )

    async def partial_book_depth_streams(
        self,
        symbol: Union[str, None],
        levels: Union[int, None],
        id: Optional[str] = None,
        update_speed: Optional[str] = None,
    ) -> RequestStreamHandle:
        r"""
            Partial Book Depth Streams
            /<symbol>@depth<levels>@<updateSpeed>
            https://developers.binance.com/docs/derivatives/usds-margined-futures/websocket-market-streams/Partial-Book-Depth-Streams

            Top **<levels\>** bids and asks, Valid **<levels\>** are 5, 10, or 20.

        Update Speed: 250ms, 500ms or 100ms

            Args:
                    symbol (Union[str, None]): The symbol parameter
                    levels (Union[int, None]): The levels parameter
                    id (Optional[str] = None): Unique WebSocket request ID.
                    update_speed (Optional[str] = None): WebSocket stream update speed

            Returns:
                RequestStreamHandle

            Raises:
                RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )
        if levels is None:
            raise RequiredError(
                field="levels", error_message="Missing required parameter 'levels'"
            )

        stream = ws_streams_placeholder(
            "/<symbol>@depth<levels>@<updateSpeed>".replace("/", ""),
            {
                "symbol": symbol,
                "levels": levels,
                "id": id,
                "update_speed": update_speed,
            },
        )

        return await RequestStream(
            self.websocket_base,
            stream=stream,
            response_model=PartialBookDepthStreamsResponse,
        )
