/*
 * Decompiled with CFR 0.152.
 */
package Zevac.SurvivalFlight;

import Zevac.SurvivalFlight.Proxy.ClientProxy;
import Zevac.SurvivalFlight.SurvivalFlight;
import java.text.DecimalFormat;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="zevac.survivalflight")
public class ModConfig {
    @Config.Comment(value={"Save last flight status (and speed) or not (works since 1.11.2)"})
    public static boolean SaveFlightStatus = true;
    @Config.Comment(value={"Last flight status, DONT CHANGE IN MOD CONFIG MENU IN-GAME"})
    public static boolean LastFlightStatus = true;
    @Config.Comment(value={"Last flight speed, DONT CHANGE IN MOD CONFIG MENU IN-GAME"})
    public static String LastFlightSpeed = new DecimalFormat("#.###").format(0.05);
    @Config.Comment(value={"Key mappings settings"})
    public static final Keys keys = new Keys();
    @Config.Comment(value={"Rendition settings (how the text is shown onscreen)"})
    public static final Rendition rendition = new Rendition();

    public static void readConfig() {
        Configuration configuration = ClientProxy.config;
        try {
            configuration.load();
            ClientProxy.tmpAllowFlight = true;
            ClientProxy.tmpFlightSpeed = Float.valueOf(Float.parseFloat(LastFlightSpeed + "F"));
        }
        catch (Exception exception) {
            SurvivalFlight.LOGGER.error("Problem loading config file!", (Throwable)exception);
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    public static void saveConfig() {
        if (SaveFlightStatus) {
            LastFlightStatus = ClientProxy.tmpAllowFlight;
            LastFlightSpeed = new DecimalFormat("#.###").format(ClientProxy.tmpFlightSpeed);
            SurvivalFlight.LOGGER.info("ModConfig.changed, Last flight status/speed saved.");
        }
    }

    @Mod.EventBusSubscriber(modid="zevac.survivalflight")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent onConfigChangedEvent) {
            if (onConfigChangedEvent.getModID().equals("zevac.survivalflight")) {
                ModConfig.saveConfig();
            }
        }
    }

    public static class Rendition {
        @Config.Comment(value={"Show status (and speed when flying) or not"})
        public boolean ShowStatusText = true;
        @Config.Comment(value={"Automatically hide Status Text when Debug screen is shown"})
        public boolean AutoHideStatusInDebugScreen = true;
        @Config.Comment(value={"The HEX code for the text color, https://minecraft.gamepedia.com/Formatting_codes#Color_codes"})
        public String StatusTextColor = "FFAA00";
        @Config.Comment(value={"X position (column) on screen for Status text"})
        public int StatusTextPosX = 1;
        @Config.Comment(value={"Y position (line) on screen for Status text"})
        public int StatusTextPosY = 1;
    }

    public static class Keys {
        @Config.Comment(value={"Key mapping for Toggle Flight, use Options/Controls menu to change"})
        public int ToggleFlight = 211;
        @Config.Comment(value={"Key mapping for Flying Faster, use Options/Controls menu to change"})
        public int FlyFaster = 78;
        @Config.Comment(value={"Key mapping for Flying Slower, use Options/Controls menu to change"})
        public int FlySlower = 74;
    }
}

