"""
Utilities for generating OpenAPI specifications

WORK-IN-PROGRESS, DON'T USE!
"""

from collections import defaultdict
from dataclasses import dataclass, field
from typing import TypeAlias

from . import builder
from .config import OpenAPIConfig
from .open_api_util import OpenAPIType

MODIFY_NOTICE = "# DO NOT MODIFY -- This file is generated by type_spec"

GlobalContextInfo: TypeAlias = dict[str, str | dict[str, str]]
TagGroupToNamedTags: TypeAlias = dict[str, str | list[str]]
TagPathsToRef: TypeAlias = dict[str, dict[str, str]]


@dataclass
class EmitOpenAPITag:
    name: str
    description: str

    def __hash__(self) -> int:
        return hash(self.name)

    def __eq__(self, other: object) -> bool:
        if not isinstance(other, EmitOpenAPITag):
            return False
        return self.name == other.name


@dataclass
class EmitOpenAPIPath:
    path: str
    ref: str


@dataclass
class EmitOpenAPIServer:
    url: str


@dataclass
class EmitOpenAPIGlobalContext:
    version: str
    info: GlobalContextInfo
    servers: list[EmitOpenAPIServer]

    tags: set[EmitOpenAPITag] = field(default_factory=set)
    tag_groups: defaultdict[str, set[str]] = field(
        default_factory=lambda: defaultdict(set)
    )
    paths: list[EmitOpenAPIPath] = field(default_factory=list)


@dataclass
class EmitOpenAPIEndpoint:
    method: str
    tags: list[str]
    summary: str
    description: str


@dataclass
class EmitOpenAPIContext:
    namespace: builder.SpecNamespace
    namespaces: set[builder.SpecNamespace] = field(default_factory=set)

    endpoint: EmitOpenAPIEndpoint | None = None
    types: dict[str, OpenAPIType] = field(default_factory=dict)


def resolve_namespace_ref(
    ctx: EmitOpenAPIContext,
    namespace: builder.SpecNamespace,
    *,
    config: OpenAPIConfig,
) -> str:
    # TODO: Handle namespaces not in root directory
    if len(ctx.namespace.path) == 1:
        return f"{namespace.name}.yaml#/components/schema"
    return f"{config.static_url_path}/common/{namespace.name}.yaml#/components/schema"
