# DO NOT MODIFY -- This file is generated by type_spec
# flake8: noqa: F821
# ruff: noqa: E402
# fmt: off
# isort: skip_file
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from dataclasses import dataclass
from pkgs.serialization import serial_class
from ... import base as base_t

__all__: list[str] = [
    "Arguments",
    "ConditionParameterValue",
    "Data",
    "ENDPOINT_METHOD",
    "ENDPOINT_PATH",
    "Recipe",
    "RecipeInput",
    "RecipeMetadata",
    "RecipeOutput",
    "RecipeStep",
    "RecipeStepGroup",
    "RecipeStepRelationship",
    "RecipeWorkflowStep",
    "SimpleExperimentGroup",
    "SimpleInput",
    "SimpleOutput",
    "SimpleOutputCondition",
    "SimpleRecipeMetadataField",
    "SimpleRecipeTag",
    "SimpleUnit",
    "SimpleUser",
    "SimpleWorkflow",
    "SimpleWorkflowStep",
]

ENDPOINT_METHOD = "GET"
ENDPOINT_PATH = "api/external/recipes/external_get_recipes_data"


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class Arguments:
    recipe_ids: typing.Optional[list[int]]
    project_id: typing.Optional[int]
    offset: typing.Optional[int]
    limit: typing.Optional[int]


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class SimpleRecipeMetadataField:
    metadata_id: int
    name: str
    quantity_type: str


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    unconverted_values={"quantity_json"},
    to_string_values={"quantity_dec"},
)
@dataclass(kw_only=True)
class RecipeMetadata:
    metadata_id: int
    quantity_dec: Decimal
    quantity_json: base_t.JsonValue


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class SimpleRecipeTag:
    recipe_tag_id: int
    name: str


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class SimpleExperimentGroup:
    experiment_group_id: int
    name: str


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class SimpleUnit:
    unit_id: int
    name: str


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    unconverted_values={"quantity_json"},
    to_string_values={"quantity_dec"},
)
@dataclass(kw_only=True)
class RecipeOutput:
    id: int
    output_id: int
    replicate_num: int
    quantity_dec: Decimal
    quantity_json: base_t.JsonValue
    curve_id: int
    output_condition_id: int


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class SimpleOutput:
    output_id: int
    name: str
    unit: typing.Optional[SimpleUnit]
    quantity_type: str


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    unconverted_values={"quantity_json"},
    to_string_values={"quantity_dec"},
)
@dataclass(kw_only=True)
class ConditionParameterValue:
    condition_parameter_id: int
    condition_parameter_name: str
    quantity_dec: Decimal
    quantity_json: base_t.JsonValue


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class SimpleOutputCondition:
    output_condition_id: int
    condition_parameter_values: list[ConditionParameterValue]


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class SimpleWorkflowStep:
    workflow_step_id: int
    name: str


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class SimpleWorkflow:
    workflow_id: int
    name: str
    workflow_steps: list[SimpleWorkflowStep]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    unconverted_values={"actual_quantity_json", "quantity_json"},
    to_string_values={"actual_quantity_dec", "quantity_dec"},
)
@dataclass(kw_only=True)
class RecipeInput:
    input_id: int
    input_lot_recipe_id: typing.Optional[int]
    recipe_step_id: int
    quantity_dec: Decimal
    quantity_json: base_t.JsonValue
    actual_quantity_dec: Decimal
    actual_quantity_json: base_t.JsonValue
    input_type: str
    behavior: str


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class SimpleInput:
    input_id: int
    quantity_type: str
    name: str
    is_parameter: bool
    intermediate_recipe_id: typing.Optional[int]


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class RecipeStep:
    name: typing.Optional[str]
    recipe_step_id: int
    recipe_step_number: int
    instructions: typing.Optional[str] = None


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class RecipeStepGroup:
    name: typing.Optional[str]
    recipe_steps: list[RecipeStep]


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class RecipeWorkflowStep:
    recipe_workflow_step_id: int
    workflow_step_id: int
    recipe_step_groups: list[RecipeStepGroup]


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class SimpleUser:
    user_id: int
    display_name: str
    email: str


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    to_string_values={"actual_quantity_dec", "quantity_dec"},
)
@dataclass(kw_only=True)
class RecipeStepRelationship:
    step_relationship_id: base_t.ObjectId
    name: typing.Optional[str]
    source_recipe_workflow_step_id: base_t.ObjectId
    target_recipe_step_id: base_t.ObjectId
    quantity_dec: typing.Optional[Decimal] = None
    actual_quantity_dec: typing.Optional[Decimal] = None


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class Recipe:
    recipe_id: int
    create_datetime: str
    last_modified_datetime: str
    name: str
    notes: typing.Optional[str]
    workflow_id: int
    metadata: list[RecipeMetadata]
    inputs: list[RecipeInput]
    outputs: list[RecipeOutput]
    workflow_steps: list[RecipeWorkflowStep]
    tag_ids: list[int]
    experiment_group_ids: list[int]
    step_relationships: list[RecipeStepRelationship]
    creating_user_id: typing.Optional[int] = None
    barcode_value: typing.Optional[str] = None


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class Data:
    recipes: list[Recipe]
    workflows: list[SimpleWorkflow]
    metadata: list[SimpleRecipeMetadataField]
    inputs: list[SimpleInput]
    outputs: list[SimpleOutput]
    output_conditions: list[SimpleOutputCondition]
    users: list[SimpleUser]
    recipe_tags: list[SimpleRecipeTag]
    experiment_groups: list[SimpleExperimentGroup]
# DO NOT MODIFY -- This file is generated by type_spec
