# DO NOT MODIFY -- This file is generated by type_spec
# flake8: noqa: F821
# ruff: noqa: E402
# fmt: off
# isort: skip_file
# ruff: noqa: PLR0904
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from pkgs.serialization import OpaqueKey
from . import base as base_t
import uncountable.types.api.entity.create_entities as create_entities_t
import uncountable.types.api.entity.create_entity as create_entity_t
import uncountable.types.api.inputs.create_inputs as create_inputs_t
import uncountable.types.api.recipes.create_recipes as create_recipes_t
from . import entity as entity_t
import uncountable.types.api.batch.execute_batch as execute_batch_t
from . import field_values as field_values_t
import uncountable.types.api.recipes.get_curve as get_curve_t
import uncountable.types.api.entity.get_entities_data as get_entities_data_t
import uncountable.types.api.inputs.get_input_data as get_input_data_t
import uncountable.types.api.input_groups.get_input_group_names as get_input_group_names_t
import uncountable.types.api.inputs.get_input_names as get_input_names_t
import uncountable.types.api.inputs.get_inputs_data as get_inputs_data_t
import uncountable.types.api.outputs.get_output_data as get_output_data_t
import uncountable.types.api.outputs.get_output_names as get_output_names_t
import uncountable.types.api.project.get_projects as get_projects_t
import uncountable.types.api.project.get_projects_data as get_projects_data_t
import uncountable.types.api.recipes.get_recipe_calculations as get_recipe_calculations_t
import uncountable.types.api.recipes.get_recipe_links as get_recipe_links_t
import uncountable.types.api.recipe_metadata.get_recipe_metadata_data as get_recipe_metadata_data_t
import uncountable.types.api.recipes.get_recipe_names as get_recipe_names_t
import uncountable.types.api.recipes.get_recipe_output_metadata as get_recipe_output_metadata_t
import uncountable.types.api.recipes.get_recipes_data as get_recipes_data_t
import uncountable.types.api.entity.list_entities as list_entities_t
from . import recipe_links as recipe_links_t
import uncountable.types.api.entity.resolve_entity_ids as resolve_entity_ids_t
import uncountable.types.api.outputs.resolve_output_conditions as resolve_output_conditions_t
import uncountable.types.api.inputs.set_input_attribute_values as set_input_attribute_values_t
import uncountable.types.api.recipes.set_recipe_inputs as set_recipe_inputs_t
import uncountable.types.api.recipes.set_recipe_outputs as set_recipe_outputs_t
import uncountable.types.api.entity.set_values as set_values_t
from abc import ABC, abstractmethod
from dataclasses import dataclass

DT = typing.TypeVar("DT")


@dataclass(kw_only=True)
class APIRequest:
    method: str
    endpoint: str
    args: typing.Any


class ClientMethods(ABC):

    @abstractmethod
    def do_request(self, *, api_request: APIRequest, return_type: type[DT]) -> DT:
        ...


    def create_entities(
        self,
        *,
        definition_id: int,
        entity_type: typing.Union[typing.Literal[entity_t.EntityType.LAB_REQUEST], typing.Literal[entity_t.EntityType.APPROVAL], typing.Literal[entity_t.EntityType.CUSTOM_ENTITY], typing.Literal[entity_t.EntityType.TASK], typing.Literal[entity_t.EntityType.PROJECT]],
        entities_to_create: list[create_entities_t.EntityToCreate],
    ) -> create_entities_t.Data:
        args = create_entities_t.Arguments(
            definition_id=definition_id,
            entity_type=entity_type,
            entities_to_create=entities_to_create,
        )
        api_request = APIRequest(
            method=create_entities_t.ENDPOINT_METHOD,
            endpoint=create_entities_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=create_entities_t.Data)


    def create_entity(
        self,
        *,
        definition_id: int,
        entity_type: typing.Union[typing.Literal[entity_t.EntityType.LAB_REQUEST], typing.Literal[entity_t.EntityType.APPROVAL], typing.Literal[entity_t.EntityType.CUSTOM_ENTITY], typing.Literal[entity_t.EntityType.TASK], typing.Literal[entity_t.EntityType.PROJECT]],
        field_values: typing.Optional[typing.Optional[list[field_values_t.FieldRefNameValue]]] = None,
    ) -> create_entity_t.Data:
        args = create_entity_t.Arguments(
            definition_id=definition_id,
            entity_type=entity_type,
            field_values=field_values,
        )
        api_request = APIRequest(
            method=create_entity_t.ENDPOINT_METHOD,
            endpoint=create_entity_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=create_entity_t.Data)


    def external_create_inputs(
        self,
        *,
        inputs_to_create: list[create_inputs_t.InputToCreate],
    ) -> create_inputs_t.Data:
        args = create_inputs_t.Arguments(
            inputs_to_create=inputs_to_create,
        )
        api_request = APIRequest(
            method=create_inputs_t.ENDPOINT_METHOD,
            endpoint=create_inputs_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=create_inputs_t.Data)


    def create_recipes(
        self,
        *,
        material_family_id: int,
        recipe_definitions: list[create_recipes_t.CreateRecipeDefinition],
        project_id: typing.Optional[int] = None,
    ) -> create_recipes_t.Data:
        args = create_recipes_t.Arguments(
            material_family_id=material_family_id,
            project_id=project_id,
            recipe_definitions=recipe_definitions,
        )
        api_request = APIRequest(
            method=create_recipes_t.ENDPOINT_METHOD,
            endpoint=create_recipes_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=create_recipes_t.Data)


    def execute_batch(
        self,
        *,
        requests: list[execute_batch_t.BatchRequest],
    ) -> execute_batch_t.Data:
        args = execute_batch_t.Arguments(
            requests=requests,
        )
        api_request = APIRequest(
            method=execute_batch_t.ENDPOINT_METHOD,
            endpoint=execute_batch_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=execute_batch_t.Data)


    def get_curve(
        self,
        *,
        recipe_output_id: int,
    ) -> get_curve_t.Data:
        args = get_curve_t.Arguments(
            recipe_output_id=recipe_output_id,
        )
        api_request = APIRequest(
            method=get_curve_t.ENDPOINT_METHOD,
            endpoint=get_curve_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_curve_t.Data)


    def get_entities_data(
        self,
        *,
        entity_ids: list[int],
        entity_type: str,
    ) -> get_entities_data_t.Data:
        args = get_entities_data_t.Arguments(
            entity_ids=entity_ids,
            entity_type=entity_type,
        )
        api_request = APIRequest(
            method=get_entities_data_t.ENDPOINT_METHOD,
            endpoint=get_entities_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_entities_data_t.Data)


    def get_input_data(
        self,
        *,
        material_family_id: int,
        input_ids: typing.Optional[list[int]],
        offset: typing.Optional[int],
        is_parameter: typing.Optional[bool],
        limit: typing.Optional[int],
    ) -> get_input_data_t.Data:
        args = get_input_data_t.Arguments(
            material_family_id=material_family_id,
            input_ids=input_ids,
            offset=offset,
            is_parameter=is_parameter,
            limit=limit,
        )
        api_request = APIRequest(
            method=get_input_data_t.ENDPOINT_METHOD,
            endpoint=get_input_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_input_data_t.Data)


    def get_input_group_names(
        self,
        *,
        material_family_id: int,
    ) -> get_input_group_names_t.Data:
        args = get_input_group_names_t.Arguments(
            material_family_id=material_family_id,
        )
        api_request = APIRequest(
            method=get_input_group_names_t.ENDPOINT_METHOD,
            endpoint=get_input_group_names_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_input_group_names_t.Data)


    def get_input_names(
        self,
        *,
        material_family_id: int,
        offset: typing.Optional[int],
        is_parameter: typing.Optional[bool],
        limit: typing.Optional[int],
    ) -> get_input_names_t.Data:
        args = get_input_names_t.Arguments(
            material_family_id=material_family_id,
            offset=offset,
            is_parameter=is_parameter,
            limit=limit,
        )
        api_request = APIRequest(
            method=get_input_names_t.ENDPOINT_METHOD,
            endpoint=get_input_names_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_input_names_t.Data)


    def get_inputs_data(
        self,
        *,
        input_ids: list[int],
    ) -> get_inputs_data_t.Data:
        args = get_inputs_data_t.Arguments(
            input_ids=input_ids,
        )
        api_request = APIRequest(
            method=get_inputs_data_t.ENDPOINT_METHOD,
            endpoint=get_inputs_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_inputs_data_t.Data)


    def get_output_data(
        self,
        *,
        material_family_id: int,
        output_ids: typing.Optional[list[int]] = None,
        offset: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
    ) -> get_output_data_t.Data:
        args = get_output_data_t.Arguments(
            material_family_id=material_family_id,
            output_ids=output_ids,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=get_output_data_t.ENDPOINT_METHOD,
            endpoint=get_output_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_output_data_t.Data)


    def get_output_names(
        self,
        *,
        material_family_id: int,
        offset: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
    ) -> get_output_names_t.Data:
        args = get_output_names_t.Arguments(
            material_family_id=material_family_id,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=get_output_names_t.ENDPOINT_METHOD,
            endpoint=get_output_names_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_output_names_t.Data)


    def get_projects(
        self,
        *,
        all_material_families: bool,
        material_family_id: typing.Optional[int],
    ) -> get_projects_t.Data:
        args = get_projects_t.Arguments(
            all_material_families=all_material_families,
            material_family_id=material_family_id,
        )
        api_request = APIRequest(
            method=get_projects_t.ENDPOINT_METHOD,
            endpoint=get_projects_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_projects_t.Data)


    def get_projects_data(
        self,
        *,
        project_ids: list[int],
        offset: typing.Optional[int],
        limit: typing.Optional[int],
    ) -> get_projects_data_t.Data:
        args = get_projects_data_t.Arguments(
            project_ids=project_ids,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=get_projects_data_t.ENDPOINT_METHOD,
            endpoint=get_projects_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_projects_data_t.Data)


    def get_recipe_calculations(
        self,
        *,
        recipe_ids: list[int],
        calculation_ids: typing.Optional[list[int]] = None,
    ) -> get_recipe_calculations_t.Data:
        args = get_recipe_calculations_t.Arguments(
            recipe_ids=recipe_ids,
            calculation_ids=calculation_ids,
        )
        api_request = APIRequest(
            method=get_recipe_calculations_t.ENDPOINT_METHOD,
            endpoint=get_recipe_calculations_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_recipe_calculations_t.Data)


    def get_recipe_links(
        self,
        *,
        recipe_ids: list[int],
        depth: int = 1,
        link_types: typing.Optional[list[recipe_links_t.RecipeLinkType]],
    ) -> get_recipe_links_t.Data:
        args = get_recipe_links_t.Arguments(
            recipe_ids=recipe_ids,
            depth=depth,
            link_types=link_types,
        )
        api_request = APIRequest(
            method=get_recipe_links_t.ENDPOINT_METHOD,
            endpoint=get_recipe_links_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_recipe_links_t.Data)


    def get_recipe_metadata_data(
        self,
        *,
        material_family_id: int,
        recipe_metadata_ids: typing.Optional[list[int]],
        offset: typing.Optional[int],
        limit: typing.Optional[int],
    ) -> get_recipe_metadata_data_t.Data:
        args = get_recipe_metadata_data_t.Arguments(
            material_family_id=material_family_id,
            recipe_metadata_ids=recipe_metadata_ids,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=get_recipe_metadata_data_t.ENDPOINT_METHOD,
            endpoint=get_recipe_metadata_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_recipe_metadata_data_t.Data)


    def get_recipe_names(
        self,
        *,
        project_id: int,
    ) -> get_recipe_names_t.Data:
        args = get_recipe_names_t.Arguments(
            project_id=project_id,
        )
        api_request = APIRequest(
            method=get_recipe_names_t.ENDPOINT_METHOD,
            endpoint=get_recipe_names_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_recipe_names_t.Data)


    def get_recipe_output_metadata(
        self,
        *,
        recipe_output_ids: list[int],
    ) -> get_recipe_output_metadata_t.Data:
        args = get_recipe_output_metadata_t.Arguments(
            recipe_output_ids=recipe_output_ids,
        )
        api_request = APIRequest(
            method=get_recipe_output_metadata_t.ENDPOINT_METHOD,
            endpoint=get_recipe_output_metadata_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_recipe_output_metadata_t.Data)


    def get_recipes_data(
        self,
        *,
        recipe_ids: typing.Optional[list[int]],
        project_id: typing.Optional[int],
        offset: typing.Optional[int],
        limit: typing.Optional[int],
    ) -> get_recipes_data_t.Data:
        args = get_recipes_data_t.Arguments(
            recipe_ids=recipe_ids,
            project_id=project_id,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=get_recipes_data_t.ENDPOINT_METHOD,
            endpoint=get_recipes_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_recipes_data_t.Data)


    def list_entities(
        self,
        *,
        entity_type: str,
        config_reference: str,
        offset: typing.Optional[int],
        limit: typing.Optional[int],
        attributes: typing.Optional[dict[OpaqueKey, base_t.JsonValue]] = None,
    ) -> list_entities_t.Data:
        args = list_entities_t.Arguments(
            entity_type=entity_type,
            config_reference=config_reference,
            attributes=attributes,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=list_entities_t.ENDPOINT_METHOD,
            endpoint=list_entities_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=list_entities_t.Data)


    def resolve_entity_ids(
        self,
        *,
        entity_ids: list[typing.Union[str, int]],
        entity_type: str,
    ) -> resolve_entity_ids_t.Data:
        args = resolve_entity_ids_t.Arguments(
            entity_ids=entity_ids,
            entity_type=entity_type,
        )
        api_request = APIRequest(
            method=resolve_entity_ids_t.ENDPOINT_METHOD,
            endpoint=resolve_entity_ids_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=resolve_entity_ids_t.Data)


    def resolve_output_conditions(
        self,
        *,
        requested_conditions: list[resolve_output_conditions_t.ConditionRequest],
    ) -> resolve_output_conditions_t.Data:
        args = resolve_output_conditions_t.Arguments(
            requested_conditions=requested_conditions,
        )
        api_request = APIRequest(
            method=resolve_output_conditions_t.ENDPOINT_METHOD,
            endpoint=resolve_output_conditions_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=resolve_output_conditions_t.Data)


    def set_input_attribute_values(
        self,
        *,
        attribute_values: list[set_input_attribute_values_t.InputAttributeValue],
    ) -> set_input_attribute_values_t.Data:
        args = set_input_attribute_values_t.Arguments(
            attribute_values=attribute_values,
        )
        api_request = APIRequest(
            method=set_input_attribute_values_t.ENDPOINT_METHOD,
            endpoint=set_input_attribute_values_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=set_input_attribute_values_t.Data)


    def set_recipe_inputs(
        self,
        *,
        input_data: list[set_recipe_inputs_t.RecipeInputValue],
    ) -> set_recipe_inputs_t.Data:
        args = set_recipe_inputs_t.Arguments(
            input_data=input_data,
        )
        api_request = APIRequest(
            method=set_recipe_inputs_t.ENDPOINT_METHOD,
            endpoint=set_recipe_inputs_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=set_recipe_inputs_t.Data)


    def set_recipe_outputs(
        self,
        *,
        output_data: list[set_recipe_outputs_t.RecipeOutputValue],
    ) -> set_recipe_outputs_t.Data:
        args = set_recipe_outputs_t.Arguments(
            output_data=output_data,
        )
        api_request = APIRequest(
            method=set_recipe_outputs_t.ENDPOINT_METHOD,
            endpoint=set_recipe_outputs_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=set_recipe_outputs_t.Data)


    def set_values(
        self,
        *,
        entity: set_values_t.Entity,
        values: list[set_values_t.EntityFieldValues],
    ) -> set_values_t.Data:
        args = set_values_t.Arguments(
            entity=entity,
            values=values,
        )
        api_request = APIRequest(
            method=set_values_t.ENDPOINT_METHOD,
            endpoint=set_values_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=set_values_t.Data)
