# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CameraWirelessProfilesArgs', 'CameraWirelessProfiles']

@pulumi.input_type
class CameraWirelessProfilesArgs:
    def __init__(__self__, *,
                 serial: pulumi.Input[builtins.str],
                 ids: Optional[pulumi.Input['CameraWirelessProfilesIdsArgs']] = None):
        """
        The set of arguments for constructing a CameraWirelessProfiles resource.
        :param pulumi.Input[builtins.str] serial: serial path parameter.
        :param pulumi.Input['CameraWirelessProfilesIdsArgs'] ids: The ids of the wireless profile to assign to the given camera
        """
        pulumi.set(__self__, "serial", serial)
        if ids is not None:
            pulumi.set(__self__, "ids", ids)

    @property
    @pulumi.getter
    def serial(self) -> pulumi.Input[builtins.str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "serial", value)

    @property
    @pulumi.getter
    def ids(self) -> Optional[pulumi.Input['CameraWirelessProfilesIdsArgs']]:
        """
        The ids of the wireless profile to assign to the given camera
        """
        return pulumi.get(self, "ids")

    @ids.setter
    def ids(self, value: Optional[pulumi.Input['CameraWirelessProfilesIdsArgs']]):
        pulumi.set(self, "ids", value)


@pulumi.input_type
class _CameraWirelessProfilesState:
    def __init__(__self__, *,
                 ids: Optional[pulumi.Input['CameraWirelessProfilesIdsArgs']] = None,
                 serial: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CameraWirelessProfiles resources.
        :param pulumi.Input['CameraWirelessProfilesIdsArgs'] ids: The ids of the wireless profile to assign to the given camera
        :param pulumi.Input[builtins.str] serial: serial path parameter.
        """
        if ids is not None:
            pulumi.set(__self__, "ids", ids)
        if serial is not None:
            pulumi.set(__self__, "serial", serial)

    @property
    @pulumi.getter
    def ids(self) -> Optional[pulumi.Input['CameraWirelessProfilesIdsArgs']]:
        """
        The ids of the wireless profile to assign to the given camera
        """
        return pulumi.get(self, "ids")

    @ids.setter
    def ids(self, value: Optional[pulumi.Input['CameraWirelessProfilesIdsArgs']]):
        pulumi.set(self, "ids", value)

    @property
    @pulumi.getter
    def serial(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "serial", value)


@pulumi.type_token("meraki:devices/cameraWirelessProfiles:CameraWirelessProfiles")
class CameraWirelessProfiles(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ids: Optional[pulumi.Input[Union['CameraWirelessProfilesIdsArgs', 'CameraWirelessProfilesIdsArgsDict']]] = None,
                 serial: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.devices.CameraWirelessProfiles("example",
            ids={
                "backup": "1",
                "primary": "3",
                "secondary": "2",
            },
            serial="string")
        pulumi.export("merakiDevicesCameraWirelessProfilesExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:devices/cameraWirelessProfiles:CameraWirelessProfiles example "serial"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CameraWirelessProfilesIdsArgs', 'CameraWirelessProfilesIdsArgsDict']] ids: The ids of the wireless profile to assign to the given camera
        :param pulumi.Input[builtins.str] serial: serial path parameter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CameraWirelessProfilesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.devices.CameraWirelessProfiles("example",
            ids={
                "backup": "1",
                "primary": "3",
                "secondary": "2",
            },
            serial="string")
        pulumi.export("merakiDevicesCameraWirelessProfilesExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:devices/cameraWirelessProfiles:CameraWirelessProfiles example "serial"
        ```

        :param str resource_name: The name of the resource.
        :param CameraWirelessProfilesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CameraWirelessProfilesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ids: Optional[pulumi.Input[Union['CameraWirelessProfilesIdsArgs', 'CameraWirelessProfilesIdsArgsDict']]] = None,
                 serial: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CameraWirelessProfilesArgs.__new__(CameraWirelessProfilesArgs)

            __props__.__dict__["ids"] = ids
            if serial is None and not opts.urn:
                raise TypeError("Missing required property 'serial'")
            __props__.__dict__["serial"] = serial
        super(CameraWirelessProfiles, __self__).__init__(
            'meraki:devices/cameraWirelessProfiles:CameraWirelessProfiles',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ids: Optional[pulumi.Input[Union['CameraWirelessProfilesIdsArgs', 'CameraWirelessProfilesIdsArgsDict']]] = None,
            serial: Optional[pulumi.Input[builtins.str]] = None) -> 'CameraWirelessProfiles':
        """
        Get an existing CameraWirelessProfiles resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CameraWirelessProfilesIdsArgs', 'CameraWirelessProfilesIdsArgsDict']] ids: The ids of the wireless profile to assign to the given camera
        :param pulumi.Input[builtins.str] serial: serial path parameter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CameraWirelessProfilesState.__new__(_CameraWirelessProfilesState)

        __props__.__dict__["ids"] = ids
        __props__.__dict__["serial"] = serial
        return CameraWirelessProfiles(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def ids(self) -> pulumi.Output['outputs.CameraWirelessProfilesIds']:
        """
        The ids of the wireless profile to assign to the given camera
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def serial(self) -> pulumi.Output[builtins.str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

