# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FirmwareUpgradesStagedStagesArgs', 'FirmwareUpgradesStagedStages']

@pulumi.input_type
class FirmwareUpgradesStagedStagesArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[builtins.str],
                 jsons: Optional[pulumi.Input[Sequence[pulumi.Input['FirmwareUpgradesStagedStagesJsonArgs']]]] = None):
        """
        The set of arguments for constructing a FirmwareUpgradesStagedStages resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input['FirmwareUpgradesStagedStagesJsonArgs']]] jsons: Array of Staged Upgrade Groups
        """
        pulumi.set(__self__, "network_id", network_id)
        if jsons is not None:
            pulumi.set(__self__, "jsons", jsons)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def jsons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirmwareUpgradesStagedStagesJsonArgs']]]]:
        """
        Array of Staged Upgrade Groups
        """
        return pulumi.get(self, "jsons")

    @jsons.setter
    def jsons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirmwareUpgradesStagedStagesJsonArgs']]]]):
        pulumi.set(self, "jsons", value)


@pulumi.input_type
class _FirmwareUpgradesStagedStagesState:
    def __init__(__self__, *,
                 group: Optional[pulumi.Input['FirmwareUpgradesStagedStagesGroupArgs']] = None,
                 jsons: Optional[pulumi.Input[Sequence[pulumi.Input['FirmwareUpgradesStagedStagesJsonArgs']]]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering FirmwareUpgradesStagedStages resources.
        :param pulumi.Input['FirmwareUpgradesStagedStagesGroupArgs'] group: The Staged Upgrade Group
        :param pulumi.Input[Sequence[pulumi.Input['FirmwareUpgradesStagedStagesJsonArgs']]] jsons: Array of Staged Upgrade Groups
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        """
        if group is not None:
            pulumi.set(__self__, "group", group)
        if jsons is not None:
            pulumi.set(__self__, "jsons", jsons)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input['FirmwareUpgradesStagedStagesGroupArgs']]:
        """
        The Staged Upgrade Group
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input['FirmwareUpgradesStagedStagesGroupArgs']]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter
    def jsons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirmwareUpgradesStagedStagesJsonArgs']]]]:
        """
        Array of Staged Upgrade Groups
        """
        return pulumi.get(self, "jsons")

    @jsons.setter
    def jsons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirmwareUpgradesStagedStagesJsonArgs']]]]):
        pulumi.set(self, "jsons", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)


@pulumi.type_token("meraki:networks/firmwareUpgradesStagedStages:FirmwareUpgradesStagedStages")
class FirmwareUpgradesStagedStages(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 jsons: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirmwareUpgradesStagedStagesJsonArgs', 'FirmwareUpgradesStagedStagesJsonArgsDict']]]]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.FirmwareUpgradesStagedStages("example",
            jsons=[{
                "group": {
                    "id": "1234",
                },
            }],
            network_id="string")
        pulumi.export("merakiNetworksFirmwareUpgradesStagedStagesExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/firmwareUpgradesStagedStages:FirmwareUpgradesStagedStages example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirmwareUpgradesStagedStagesJsonArgs', 'FirmwareUpgradesStagedStagesJsonArgsDict']]]] jsons: Array of Staged Upgrade Groups
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FirmwareUpgradesStagedStagesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.FirmwareUpgradesStagedStages("example",
            jsons=[{
                "group": {
                    "id": "1234",
                },
            }],
            network_id="string")
        pulumi.export("merakiNetworksFirmwareUpgradesStagedStagesExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/firmwareUpgradesStagedStages:FirmwareUpgradesStagedStages example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param FirmwareUpgradesStagedStagesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FirmwareUpgradesStagedStagesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 jsons: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirmwareUpgradesStagedStagesJsonArgs', 'FirmwareUpgradesStagedStagesJsonArgsDict']]]]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FirmwareUpgradesStagedStagesArgs.__new__(FirmwareUpgradesStagedStagesArgs)

            __props__.__dict__["jsons"] = jsons
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["group"] = None
        super(FirmwareUpgradesStagedStages, __self__).__init__(
            'meraki:networks/firmwareUpgradesStagedStages:FirmwareUpgradesStagedStages',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group: Optional[pulumi.Input[Union['FirmwareUpgradesStagedStagesGroupArgs', 'FirmwareUpgradesStagedStagesGroupArgsDict']]] = None,
            jsons: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirmwareUpgradesStagedStagesJsonArgs', 'FirmwareUpgradesStagedStagesJsonArgsDict']]]]] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None) -> 'FirmwareUpgradesStagedStages':
        """
        Get an existing FirmwareUpgradesStagedStages resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FirmwareUpgradesStagedStagesGroupArgs', 'FirmwareUpgradesStagedStagesGroupArgsDict']] group: The Staged Upgrade Group
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirmwareUpgradesStagedStagesJsonArgs', 'FirmwareUpgradesStagedStagesJsonArgsDict']]]] jsons: Array of Staged Upgrade Groups
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FirmwareUpgradesStagedStagesState.__new__(_FirmwareUpgradesStagedStagesState)

        __props__.__dict__["group"] = group
        __props__.__dict__["jsons"] = jsons
        __props__.__dict__["network_id"] = network_id
        return FirmwareUpgradesStagedStages(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def group(self) -> pulumi.Output['outputs.FirmwareUpgradesStagedStagesGroup']:
        """
        The Staged Upgrade Group
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def jsons(self) -> pulumi.Output[Sequence['outputs.FirmwareUpgradesStagedStagesJson']]:
        """
        Array of Staged Upgrade Groups
        """
        return pulumi.get(self, "jsons")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

