# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetWirelessConnectionStatsResult',
    'AwaitableGetWirelessConnectionStatsResult',
    'get_wireless_connection_stats',
    'get_wireless_connection_stats_output',
]

@pulumi.output_type
class GetWirelessConnectionStatsResult:
    """
    A collection of values returned by getWirelessConnectionStats.
    """
    def __init__(__self__, ap_tag=None, band=None, id=None, item=None, network_id=None, ssid=None, t0=None, t1=None, timespan=None, vlan=None):
        if ap_tag and not isinstance(ap_tag, str):
            raise TypeError("Expected argument 'ap_tag' to be a str")
        pulumi.set(__self__, "ap_tag", ap_tag)
        if band and not isinstance(band, str):
            raise TypeError("Expected argument 'band' to be a str")
        pulumi.set(__self__, "band", band)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if item and not isinstance(item, dict):
            raise TypeError("Expected argument 'item' to be a dict")
        pulumi.set(__self__, "item", item)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)
        if ssid and not isinstance(ssid, int):
            raise TypeError("Expected argument 'ssid' to be a int")
        pulumi.set(__self__, "ssid", ssid)
        if t0 and not isinstance(t0, str):
            raise TypeError("Expected argument 't0' to be a str")
        pulumi.set(__self__, "t0", t0)
        if t1 and not isinstance(t1, str):
            raise TypeError("Expected argument 't1' to be a str")
        pulumi.set(__self__, "t1", t1)
        if timespan and not isinstance(timespan, float):
            raise TypeError("Expected argument 'timespan' to be a float")
        pulumi.set(__self__, "timespan", timespan)
        if vlan and not isinstance(vlan, int):
            raise TypeError("Expected argument 'vlan' to be a int")
        pulumi.set(__self__, "vlan", vlan)

    @property
    @pulumi.getter(name="apTag")
    def ap_tag(self) -> Optional[builtins.str]:
        """
        apTag query parameter. Filter results by AP Tag
        """
        return pulumi.get(self, "ap_tag")

    @property
    @pulumi.getter
    def band(self) -> Optional[builtins.str]:
        """
        band query parameter. Filter results by band (either '2.4', '5' or '6'). Note that data prior to February 2020 will not have band information.
        """
        return pulumi.get(self, "band")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def item(self) -> 'outputs.GetWirelessConnectionStatsItemResult':
        return pulumi.get(self, "item")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> builtins.str:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def ssid(self) -> Optional[builtins.int]:
        """
        ssid query parameter. Filter results by SSID
        """
        return pulumi.get(self, "ssid")

    @property
    @pulumi.getter
    def t0(self) -> Optional[builtins.str]:
        """
        t0 query parameter. The beginning of the timespan for the data. The maximum lookback period is 180 days from today.
        """
        return pulumi.get(self, "t0")

    @property
    @pulumi.getter
    def t1(self) -> Optional[builtins.str]:
        """
        t1 query parameter. The end of the timespan for the data. t1 can be a maximum of 7 days after t0.
        """
        return pulumi.get(self, "t1")

    @property
    @pulumi.getter
    def timespan(self) -> Optional[builtins.float]:
        """
        timespan query parameter. The timespan for which the information will be fetched. If specifying timespan, do not specify parameters t0 and t1. The value must be in seconds and be less than or equal to 7 days.
        """
        return pulumi.get(self, "timespan")

    @property
    @pulumi.getter
    def vlan(self) -> Optional[builtins.int]:
        """
        vlan query parameter. Filter results by VLAN
        """
        return pulumi.get(self, "vlan")


class AwaitableGetWirelessConnectionStatsResult(GetWirelessConnectionStatsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWirelessConnectionStatsResult(
            ap_tag=self.ap_tag,
            band=self.band,
            id=self.id,
            item=self.item,
            network_id=self.network_id,
            ssid=self.ssid,
            t0=self.t0,
            t1=self.t1,
            timespan=self.timespan,
            vlan=self.vlan)


def get_wireless_connection_stats(ap_tag: Optional[builtins.str] = None,
                                  band: Optional[builtins.str] = None,
                                  network_id: Optional[builtins.str] = None,
                                  ssid: Optional[builtins.int] = None,
                                  t0: Optional[builtins.str] = None,
                                  t1: Optional[builtins.str] = None,
                                  timespan: Optional[builtins.float] = None,
                                  vlan: Optional[builtins.int] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWirelessConnectionStatsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.networks.get_wireless_connection_stats(ap_tag="string",
        band="string",
        network_id="string",
        ssid=1,
        t0="string",
        t1="string",
        timespan=1,
        vlan=1)
    pulumi.export("merakiNetworksWirelessConnectionStatsExample", example.item)
    ```


    :param builtins.str ap_tag: apTag query parameter. Filter results by AP Tag
    :param builtins.str band: band query parameter. Filter results by band (either '2.4', '5' or '6'). Note that data prior to February 2020 will not have band information.
    :param builtins.str network_id: networkId path parameter. Network ID
    :param builtins.int ssid: ssid query parameter. Filter results by SSID
    :param builtins.str t0: t0 query parameter. The beginning of the timespan for the data. The maximum lookback period is 180 days from today.
    :param builtins.str t1: t1 query parameter. The end of the timespan for the data. t1 can be a maximum of 7 days after t0.
    :param builtins.float timespan: timespan query parameter. The timespan for which the information will be fetched. If specifying timespan, do not specify parameters t0 and t1. The value must be in seconds and be less than or equal to 7 days.
    :param builtins.int vlan: vlan query parameter. Filter results by VLAN
    """
    __args__ = dict()
    __args__['apTag'] = ap_tag
    __args__['band'] = band
    __args__['networkId'] = network_id
    __args__['ssid'] = ssid
    __args__['t0'] = t0
    __args__['t1'] = t1
    __args__['timespan'] = timespan
    __args__['vlan'] = vlan
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('meraki:networks/getWirelessConnectionStats:getWirelessConnectionStats', __args__, opts=opts, typ=GetWirelessConnectionStatsResult).value

    return AwaitableGetWirelessConnectionStatsResult(
        ap_tag=pulumi.get(__ret__, 'ap_tag'),
        band=pulumi.get(__ret__, 'band'),
        id=pulumi.get(__ret__, 'id'),
        item=pulumi.get(__ret__, 'item'),
        network_id=pulumi.get(__ret__, 'network_id'),
        ssid=pulumi.get(__ret__, 'ssid'),
        t0=pulumi.get(__ret__, 't0'),
        t1=pulumi.get(__ret__, 't1'),
        timespan=pulumi.get(__ret__, 'timespan'),
        vlan=pulumi.get(__ret__, 'vlan'))
def get_wireless_connection_stats_output(ap_tag: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         band: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         network_id: Optional[pulumi.Input[builtins.str]] = None,
                                         ssid: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                         t0: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         t1: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         timespan: Optional[pulumi.Input[Optional[builtins.float]]] = None,
                                         vlan: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWirelessConnectionStatsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.networks.get_wireless_connection_stats(ap_tag="string",
        band="string",
        network_id="string",
        ssid=1,
        t0="string",
        t1="string",
        timespan=1,
        vlan=1)
    pulumi.export("merakiNetworksWirelessConnectionStatsExample", example.item)
    ```


    :param builtins.str ap_tag: apTag query parameter. Filter results by AP Tag
    :param builtins.str band: band query parameter. Filter results by band (either '2.4', '5' or '6'). Note that data prior to February 2020 will not have band information.
    :param builtins.str network_id: networkId path parameter. Network ID
    :param builtins.int ssid: ssid query parameter. Filter results by SSID
    :param builtins.str t0: t0 query parameter. The beginning of the timespan for the data. The maximum lookback period is 180 days from today.
    :param builtins.str t1: t1 query parameter. The end of the timespan for the data. t1 can be a maximum of 7 days after t0.
    :param builtins.float timespan: timespan query parameter. The timespan for which the information will be fetched. If specifying timespan, do not specify parameters t0 and t1. The value must be in seconds and be less than or equal to 7 days.
    :param builtins.int vlan: vlan query parameter. Filter results by VLAN
    """
    __args__ = dict()
    __args__['apTag'] = ap_tag
    __args__['band'] = band
    __args__['networkId'] = network_id
    __args__['ssid'] = ssid
    __args__['t0'] = t0
    __args__['t1'] = t1
    __args__['timespan'] = timespan
    __args__['vlan'] = vlan
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('meraki:networks/getWirelessConnectionStats:getWirelessConnectionStats', __args__, opts=opts, typ=GetWirelessConnectionStatsResult)
    return __ret__.apply(lambda __response__: GetWirelessConnectionStatsResult(
        ap_tag=pulumi.get(__response__, 'ap_tag'),
        band=pulumi.get(__response__, 'band'),
        id=pulumi.get(__response__, 'id'),
        item=pulumi.get(__response__, 'item'),
        network_id=pulumi.get(__response__, 'network_id'),
        ssid=pulumi.get(__response__, 'ssid'),
        t0=pulumi.get(__response__, 't0'),
        t1=pulumi.get(__response__, 't1'),
        timespan=pulumi.get(__response__, 'timespan'),
        vlan=pulumi.get(__response__, 'vlan')))
