# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SwitchStormControlArgs', 'SwitchStormControl']

@pulumi.input_type
class SwitchStormControlArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[builtins.str],
                 broadcast_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 multicast_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 unknown_unicast_threshold: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a SwitchStormControl resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.int] broadcast_threshold: Broadcast threshold.
        :param pulumi.Input[builtins.int] multicast_threshold: Multicast threshold.
        :param pulumi.Input[builtins.int] unknown_unicast_threshold: Unknown Unicast threshold.
        """
        pulumi.set(__self__, "network_id", network_id)
        if broadcast_threshold is not None:
            pulumi.set(__self__, "broadcast_threshold", broadcast_threshold)
        if multicast_threshold is not None:
            pulumi.set(__self__, "multicast_threshold", multicast_threshold)
        if unknown_unicast_threshold is not None:
            pulumi.set(__self__, "unknown_unicast_threshold", unknown_unicast_threshold)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="broadcastThreshold")
    def broadcast_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Broadcast threshold.
        """
        return pulumi.get(self, "broadcast_threshold")

    @broadcast_threshold.setter
    def broadcast_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "broadcast_threshold", value)

    @property
    @pulumi.getter(name="multicastThreshold")
    def multicast_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Multicast threshold.
        """
        return pulumi.get(self, "multicast_threshold")

    @multicast_threshold.setter
    def multicast_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "multicast_threshold", value)

    @property
    @pulumi.getter(name="unknownUnicastThreshold")
    def unknown_unicast_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Unknown Unicast threshold.
        """
        return pulumi.get(self, "unknown_unicast_threshold")

    @unknown_unicast_threshold.setter
    def unknown_unicast_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "unknown_unicast_threshold", value)


@pulumi.input_type
class _SwitchStormControlState:
    def __init__(__self__, *,
                 broadcast_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 multicast_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 unknown_unicast_threshold: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering SwitchStormControl resources.
        :param pulumi.Input[builtins.int] broadcast_threshold: Broadcast threshold.
        :param pulumi.Input[builtins.int] multicast_threshold: Multicast threshold.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.int] unknown_unicast_threshold: Unknown Unicast threshold.
        """
        if broadcast_threshold is not None:
            pulumi.set(__self__, "broadcast_threshold", broadcast_threshold)
        if multicast_threshold is not None:
            pulumi.set(__self__, "multicast_threshold", multicast_threshold)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if unknown_unicast_threshold is not None:
            pulumi.set(__self__, "unknown_unicast_threshold", unknown_unicast_threshold)

    @property
    @pulumi.getter(name="broadcastThreshold")
    def broadcast_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Broadcast threshold.
        """
        return pulumi.get(self, "broadcast_threshold")

    @broadcast_threshold.setter
    def broadcast_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "broadcast_threshold", value)

    @property
    @pulumi.getter(name="multicastThreshold")
    def multicast_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Multicast threshold.
        """
        return pulumi.get(self, "multicast_threshold")

    @multicast_threshold.setter
    def multicast_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "multicast_threshold", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="unknownUnicastThreshold")
    def unknown_unicast_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Unknown Unicast threshold.
        """
        return pulumi.get(self, "unknown_unicast_threshold")

    @unknown_unicast_threshold.setter
    def unknown_unicast_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "unknown_unicast_threshold", value)


@pulumi.type_token("meraki:networks/switchStormControl:SwitchStormControl")
class SwitchStormControl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 broadcast_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 multicast_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 unknown_unicast_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.SwitchStormControl("example",
            broadcast_threshold=30,
            multicast_threshold=30,
            network_id="string",
            unknown_unicast_threshold=30)
        pulumi.export("merakiNetworksSwitchStormControlExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/switchStormControl:SwitchStormControl example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] broadcast_threshold: Broadcast threshold.
        :param pulumi.Input[builtins.int] multicast_threshold: Multicast threshold.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.int] unknown_unicast_threshold: Unknown Unicast threshold.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SwitchStormControlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.SwitchStormControl("example",
            broadcast_threshold=30,
            multicast_threshold=30,
            network_id="string",
            unknown_unicast_threshold=30)
        pulumi.export("merakiNetworksSwitchStormControlExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/switchStormControl:SwitchStormControl example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param SwitchStormControlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SwitchStormControlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 broadcast_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 multicast_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 unknown_unicast_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SwitchStormControlArgs.__new__(SwitchStormControlArgs)

            __props__.__dict__["broadcast_threshold"] = broadcast_threshold
            __props__.__dict__["multicast_threshold"] = multicast_threshold
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["unknown_unicast_threshold"] = unknown_unicast_threshold
        super(SwitchStormControl, __self__).__init__(
            'meraki:networks/switchStormControl:SwitchStormControl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            broadcast_threshold: Optional[pulumi.Input[builtins.int]] = None,
            multicast_threshold: Optional[pulumi.Input[builtins.int]] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None,
            unknown_unicast_threshold: Optional[pulumi.Input[builtins.int]] = None) -> 'SwitchStormControl':
        """
        Get an existing SwitchStormControl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] broadcast_threshold: Broadcast threshold.
        :param pulumi.Input[builtins.int] multicast_threshold: Multicast threshold.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.int] unknown_unicast_threshold: Unknown Unicast threshold.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SwitchStormControlState.__new__(_SwitchStormControlState)

        __props__.__dict__["broadcast_threshold"] = broadcast_threshold
        __props__.__dict__["multicast_threshold"] = multicast_threshold
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["unknown_unicast_threshold"] = unknown_unicast_threshold
        return SwitchStormControl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="broadcastThreshold")
    def broadcast_threshold(self) -> pulumi.Output[builtins.int]:
        """
        Broadcast threshold.
        """
        return pulumi.get(self, "broadcast_threshold")

    @property
    @pulumi.getter(name="multicastThreshold")
    def multicast_threshold(self) -> pulumi.Output[builtins.int]:
        """
        Multicast threshold.
        """
        return pulumi.get(self, "multicast_threshold")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="unknownUnicastThreshold")
    def unknown_unicast_threshold(self) -> pulumi.Output[builtins.int]:
        """
        Unknown Unicast threshold.
        """
        return pulumi.get(self, "unknown_unicast_threshold")

