# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConfigTemplatesSwitchProfilesPortsArgs', 'ConfigTemplatesSwitchProfilesPorts']

@pulumi.input_type
class ConfigTemplatesSwitchProfilesPortsArgs:
    def __init__(__self__, *,
                 config_template_id: pulumi.Input[builtins.str],
                 organization_id: pulumi.Input[builtins.str],
                 port_id: pulumi.Input[builtins.str],
                 profile_id: pulumi.Input[builtins.str],
                 access_policy_number: Optional[pulumi.Input[builtins.int]] = None,
                 access_policy_type: Optional[pulumi.Input[builtins.str]] = None,
                 allowed_vlans: Optional[pulumi.Input[builtins.str]] = None,
                 dai_trusted: Optional[pulumi.Input[builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 flexible_stacking_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 isolation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 link_negotiation: Optional[pulumi.Input[builtins.str]] = None,
                 mac_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 poe_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 port_schedule_id: Optional[pulumi.Input[builtins.str]] = None,
                 profile: Optional[pulumi.Input['ConfigTemplatesSwitchProfilesPortsProfileArgs']] = None,
                 rstp_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 sticky_mac_allow_list_limit: Optional[pulumi.Input[builtins.int]] = None,
                 sticky_mac_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 storm_control_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 stp_guard: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 udld: Optional[pulumi.Input[builtins.str]] = None,
                 vlan: Optional[pulumi.Input[builtins.int]] = None,
                 voice_vlan: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a ConfigTemplatesSwitchProfilesPorts resource.
        :param pulumi.Input[builtins.str] config_template_id: configTemplateId path parameter. Config template ID
        :param pulumi.Input[builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[builtins.str] port_id: The identifier of the switch template port.
        :param pulumi.Input[builtins.str] profile_id: profileId path parameter. Profile ID
        :param pulumi.Input[builtins.int] access_policy_number: The number of a custom access policy to configure on the switch template port. Only applicable when 'accessPolicyType' is 'Custom access policy'.
        :param pulumi.Input[builtins.str] access_policy_type: The type of the access policy of the switch template port. Only applicable to access ports. Can be one of 'Open', 'Custom access policy', 'MAC allow list' or 'Sticky MAC allow list'.
        :param pulumi.Input[builtins.str] allowed_vlans: The VLANs allowed on the switch template port. Only applicable to trunk ports.
        :param pulumi.Input[builtins.bool] dai_trusted: If true, ARP packets for this port will be considered trusted, and Dynamic ARP Inspection will allow the traffic.
        :param pulumi.Input[builtins.bool] enabled: The status of the switch template port.
        :param pulumi.Input[builtins.bool] flexible_stacking_enabled: For supported switches (e.g. MS420/MS425), whether or not the port has flexible stacking enabled.
        :param pulumi.Input[builtins.bool] isolation_enabled: The isolation status of the switch template port.
        :param pulumi.Input[builtins.str] link_negotiation: The link speed for the switch template port.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] mac_allow_lists: Only devices with MAC addresses specified in this list will have access to this port. Up to 20 MAC addresses can be defined. Only applicable when 'accessPolicyType' is 'MAC allow list'.
        :param pulumi.Input[builtins.str] name: The name of the switch template port.
        :param pulumi.Input[builtins.bool] poe_enabled: The PoE status of the switch template port.
        :param pulumi.Input[builtins.str] port_schedule_id: The ID of the port schedule. A value of null will clear the port schedule.
        :param pulumi.Input['ConfigTemplatesSwitchProfilesPortsProfileArgs'] profile: Profile attributes
        :param pulumi.Input[builtins.bool] rstp_enabled: The rapid spanning tree protocol status.
        :param pulumi.Input[builtins.int] sticky_mac_allow_list_limit: The maximum number of MAC addresses for sticky MAC allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sticky_mac_allow_lists: The initial list of MAC addresses for sticky Mac allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        :param pulumi.Input[builtins.bool] storm_control_enabled: The storm control status of the switch template port.
        :param pulumi.Input[builtins.str] stp_guard: The state of the STP guard ('disabled', 'root guard', 'bpdu guard' or 'loop guard').
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The list of tags of the switch template port.
        :param pulumi.Input[builtins.str] type: The type of the switch template port ('trunk' or 'access').
        :param pulumi.Input[builtins.str] udld: The action to take when Unidirectional Link is detected (Alert only, Enforce). Default configuration is Alert only.
        :param pulumi.Input[builtins.int] vlan: The VLAN of the switch template port. For a trunk port, this is the native VLAN. A null value will clear the value set for trunk ports.
        :param pulumi.Input[builtins.int] voice_vlan: The voice VLAN of the switch template port. Only applicable to access ports.
        """
        pulumi.set(__self__, "config_template_id", config_template_id)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "port_id", port_id)
        pulumi.set(__self__, "profile_id", profile_id)
        if access_policy_number is not None:
            pulumi.set(__self__, "access_policy_number", access_policy_number)
        if access_policy_type is not None:
            pulumi.set(__self__, "access_policy_type", access_policy_type)
        if allowed_vlans is not None:
            pulumi.set(__self__, "allowed_vlans", allowed_vlans)
        if dai_trusted is not None:
            pulumi.set(__self__, "dai_trusted", dai_trusted)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if flexible_stacking_enabled is not None:
            pulumi.set(__self__, "flexible_stacking_enabled", flexible_stacking_enabled)
        if isolation_enabled is not None:
            pulumi.set(__self__, "isolation_enabled", isolation_enabled)
        if link_negotiation is not None:
            pulumi.set(__self__, "link_negotiation", link_negotiation)
        if mac_allow_lists is not None:
            pulumi.set(__self__, "mac_allow_lists", mac_allow_lists)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if poe_enabled is not None:
            pulumi.set(__self__, "poe_enabled", poe_enabled)
        if port_schedule_id is not None:
            pulumi.set(__self__, "port_schedule_id", port_schedule_id)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if rstp_enabled is not None:
            pulumi.set(__self__, "rstp_enabled", rstp_enabled)
        if sticky_mac_allow_list_limit is not None:
            pulumi.set(__self__, "sticky_mac_allow_list_limit", sticky_mac_allow_list_limit)
        if sticky_mac_allow_lists is not None:
            pulumi.set(__self__, "sticky_mac_allow_lists", sticky_mac_allow_lists)
        if storm_control_enabled is not None:
            pulumi.set(__self__, "storm_control_enabled", storm_control_enabled)
        if stp_guard is not None:
            pulumi.set(__self__, "stp_guard", stp_guard)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if udld is not None:
            pulumi.set(__self__, "udld", udld)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)
        if voice_vlan is not None:
            pulumi.set(__self__, "voice_vlan", voice_vlan)

    @property
    @pulumi.getter(name="configTemplateId")
    def config_template_id(self) -> pulumi.Input[builtins.str]:
        """
        configTemplateId path parameter. Config template ID
        """
        return pulumi.get(self, "config_template_id")

    @config_template_id.setter
    def config_template_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "config_template_id", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[builtins.str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> pulumi.Input[builtins.str]:
        """
        The identifier of the switch template port.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "port_id", value)

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Input[builtins.str]:
        """
        profileId path parameter. Profile ID
        """
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "profile_id", value)

    @property
    @pulumi.getter(name="accessPolicyNumber")
    def access_policy_number(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of a custom access policy to configure on the switch template port. Only applicable when 'accessPolicyType' is 'Custom access policy'.
        """
        return pulumi.get(self, "access_policy_number")

    @access_policy_number.setter
    def access_policy_number(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "access_policy_number", value)

    @property
    @pulumi.getter(name="accessPolicyType")
    def access_policy_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the access policy of the switch template port. Only applicable to access ports. Can be one of 'Open', 'Custom access policy', 'MAC allow list' or 'Sticky MAC allow list'.
        """
        return pulumi.get(self, "access_policy_type")

    @access_policy_type.setter
    def access_policy_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_policy_type", value)

    @property
    @pulumi.getter(name="allowedVlans")
    def allowed_vlans(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The VLANs allowed on the switch template port. Only applicable to trunk ports.
        """
        return pulumi.get(self, "allowed_vlans")

    @allowed_vlans.setter
    def allowed_vlans(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "allowed_vlans", value)

    @property
    @pulumi.getter(name="daiTrusted")
    def dai_trusted(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, ARP packets for this port will be considered trusted, and Dynamic ARP Inspection will allow the traffic.
        """
        return pulumi.get(self, "dai_trusted")

    @dai_trusted.setter
    def dai_trusted(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "dai_trusted", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The status of the switch template port.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="flexibleStackingEnabled")
    def flexible_stacking_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        For supported switches (e.g. MS420/MS425), whether or not the port has flexible stacking enabled.
        """
        return pulumi.get(self, "flexible_stacking_enabled")

    @flexible_stacking_enabled.setter
    def flexible_stacking_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "flexible_stacking_enabled", value)

    @property
    @pulumi.getter(name="isolationEnabled")
    def isolation_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The isolation status of the switch template port.
        """
        return pulumi.get(self, "isolation_enabled")

    @isolation_enabled.setter
    def isolation_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "isolation_enabled", value)

    @property
    @pulumi.getter(name="linkNegotiation")
    def link_negotiation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The link speed for the switch template port.
        """
        return pulumi.get(self, "link_negotiation")

    @link_negotiation.setter
    def link_negotiation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "link_negotiation", value)

    @property
    @pulumi.getter(name="macAllowLists")
    def mac_allow_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Only devices with MAC addresses specified in this list will have access to this port. Up to 20 MAC addresses can be defined. Only applicable when 'accessPolicyType' is 'MAC allow list'.
        """
        return pulumi.get(self, "mac_allow_lists")

    @mac_allow_lists.setter
    def mac_allow_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "mac_allow_lists", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the switch template port.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="poeEnabled")
    def poe_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The PoE status of the switch template port.
        """
        return pulumi.get(self, "poe_enabled")

    @poe_enabled.setter
    def poe_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "poe_enabled", value)

    @property
    @pulumi.getter(name="portScheduleId")
    def port_schedule_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the port schedule. A value of null will clear the port schedule.
        """
        return pulumi.get(self, "port_schedule_id")

    @port_schedule_id.setter
    def port_schedule_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "port_schedule_id", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input['ConfigTemplatesSwitchProfilesPortsProfileArgs']]:
        """
        Profile attributes
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input['ConfigTemplatesSwitchProfilesPortsProfileArgs']]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="rstpEnabled")
    def rstp_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The rapid spanning tree protocol status.
        """
        return pulumi.get(self, "rstp_enabled")

    @rstp_enabled.setter
    def rstp_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "rstp_enabled", value)

    @property
    @pulumi.getter(name="stickyMacAllowListLimit")
    def sticky_mac_allow_list_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of MAC addresses for sticky MAC allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        """
        return pulumi.get(self, "sticky_mac_allow_list_limit")

    @sticky_mac_allow_list_limit.setter
    def sticky_mac_allow_list_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sticky_mac_allow_list_limit", value)

    @property
    @pulumi.getter(name="stickyMacAllowLists")
    def sticky_mac_allow_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The initial list of MAC addresses for sticky Mac allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        """
        return pulumi.get(self, "sticky_mac_allow_lists")

    @sticky_mac_allow_lists.setter
    def sticky_mac_allow_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "sticky_mac_allow_lists", value)

    @property
    @pulumi.getter(name="stormControlEnabled")
    def storm_control_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The storm control status of the switch template port.
        """
        return pulumi.get(self, "storm_control_enabled")

    @storm_control_enabled.setter
    def storm_control_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "storm_control_enabled", value)

    @property
    @pulumi.getter(name="stpGuard")
    def stp_guard(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of the STP guard ('disabled', 'root guard', 'bpdu guard' or 'loop guard').
        """
        return pulumi.get(self, "stp_guard")

    @stp_guard.setter
    def stp_guard(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stp_guard", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of tags of the switch template port.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the switch template port ('trunk' or 'access').
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def udld(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The action to take when Unidirectional Link is detected (Alert only, Enforce). Default configuration is Alert only.
        """
        return pulumi.get(self, "udld")

    @udld.setter
    def udld(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "udld", value)

    @property
    @pulumi.getter
    def vlan(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The VLAN of the switch template port. For a trunk port, this is the native VLAN. A null value will clear the value set for trunk ports.
        """
        return pulumi.get(self, "vlan")

    @vlan.setter
    def vlan(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vlan", value)

    @property
    @pulumi.getter(name="voiceVlan")
    def voice_vlan(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The voice VLAN of the switch template port. Only applicable to access ports.
        """
        return pulumi.get(self, "voice_vlan")

    @voice_vlan.setter
    def voice_vlan(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "voice_vlan", value)


@pulumi.input_type
class _ConfigTemplatesSwitchProfilesPortsState:
    def __init__(__self__, *,
                 access_policy_number: Optional[pulumi.Input[builtins.int]] = None,
                 access_policy_type: Optional[pulumi.Input[builtins.str]] = None,
                 allowed_vlans: Optional[pulumi.Input[builtins.str]] = None,
                 config_template_id: Optional[pulumi.Input[builtins.str]] = None,
                 dai_trusted: Optional[pulumi.Input[builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 flexible_stacking_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 isolation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 link_negotiation: Optional[pulumi.Input[builtins.str]] = None,
                 link_negotiation_capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 mac_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 mirror: Optional[pulumi.Input['ConfigTemplatesSwitchProfilesPortsMirrorArgs']] = None,
                 module: Optional[pulumi.Input['ConfigTemplatesSwitchProfilesPortsModuleArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 poe_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 port_id: Optional[pulumi.Input[builtins.str]] = None,
                 port_schedule_id: Optional[pulumi.Input[builtins.str]] = None,
                 profile: Optional[pulumi.Input['ConfigTemplatesSwitchProfilesPortsProfileArgs']] = None,
                 profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 rstp_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 sticky_mac_allow_list_limit: Optional[pulumi.Input[builtins.int]] = None,
                 sticky_mac_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 storm_control_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 stp_guard: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 udld: Optional[pulumi.Input[builtins.str]] = None,
                 vlan: Optional[pulumi.Input[builtins.int]] = None,
                 voice_vlan: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering ConfigTemplatesSwitchProfilesPorts resources.
        :param pulumi.Input[builtins.int] access_policy_number: The number of a custom access policy to configure on the switch template port. Only applicable when 'accessPolicyType' is 'Custom access policy'.
        :param pulumi.Input[builtins.str] access_policy_type: The type of the access policy of the switch template port. Only applicable to access ports. Can be one of 'Open', 'Custom access policy', 'MAC allow list' or 'Sticky MAC allow list'.
        :param pulumi.Input[builtins.str] allowed_vlans: The VLANs allowed on the switch template port. Only applicable to trunk ports.
        :param pulumi.Input[builtins.str] config_template_id: configTemplateId path parameter. Config template ID
        :param pulumi.Input[builtins.bool] dai_trusted: If true, ARP packets for this port will be considered trusted, and Dynamic ARP Inspection will allow the traffic.
        :param pulumi.Input[builtins.bool] enabled: The status of the switch template port.
        :param pulumi.Input[builtins.bool] flexible_stacking_enabled: For supported switches (e.g. MS420/MS425), whether or not the port has flexible stacking enabled.
        :param pulumi.Input[builtins.bool] isolation_enabled: The isolation status of the switch template port.
        :param pulumi.Input[builtins.str] link_negotiation: The link speed for the switch template port.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] link_negotiation_capabilities: Available link speeds for the switch template port.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] mac_allow_lists: Only devices with MAC addresses specified in this list will have access to this port. Up to 20 MAC addresses can be defined. Only applicable when 'accessPolicyType' is 'MAC allow list'.
        :param pulumi.Input['ConfigTemplatesSwitchProfilesPortsMirrorArgs'] mirror: Port mirror
        :param pulumi.Input['ConfigTemplatesSwitchProfilesPortsModuleArgs'] module: Expansion module
        :param pulumi.Input[builtins.str] name: The name of the switch template port.
        :param pulumi.Input[builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[builtins.bool] poe_enabled: The PoE status of the switch template port.
        :param pulumi.Input[builtins.str] port_id: The identifier of the switch template port.
        :param pulumi.Input[builtins.str] port_schedule_id: The ID of the port schedule. A value of null will clear the port schedule.
        :param pulumi.Input['ConfigTemplatesSwitchProfilesPortsProfileArgs'] profile: Profile attributes
        :param pulumi.Input[builtins.str] profile_id: profileId path parameter. Profile ID
        :param pulumi.Input[builtins.bool] rstp_enabled: The rapid spanning tree protocol status.
        :param pulumi.Input[builtins.int] sticky_mac_allow_list_limit: The maximum number of MAC addresses for sticky MAC allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sticky_mac_allow_lists: The initial list of MAC addresses for sticky Mac allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        :param pulumi.Input[builtins.bool] storm_control_enabled: The storm control status of the switch template port.
        :param pulumi.Input[builtins.str] stp_guard: The state of the STP guard ('disabled', 'root guard', 'bpdu guard' or 'loop guard').
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The list of tags of the switch template port.
        :param pulumi.Input[builtins.str] type: The type of the switch template port ('trunk' or 'access').
        :param pulumi.Input[builtins.str] udld: The action to take when Unidirectional Link is detected (Alert only, Enforce). Default configuration is Alert only.
        :param pulumi.Input[builtins.int] vlan: The VLAN of the switch template port. For a trunk port, this is the native VLAN. A null value will clear the value set for trunk ports.
        :param pulumi.Input[builtins.int] voice_vlan: The voice VLAN of the switch template port. Only applicable to access ports.
        """
        if access_policy_number is not None:
            pulumi.set(__self__, "access_policy_number", access_policy_number)
        if access_policy_type is not None:
            pulumi.set(__self__, "access_policy_type", access_policy_type)
        if allowed_vlans is not None:
            pulumi.set(__self__, "allowed_vlans", allowed_vlans)
        if config_template_id is not None:
            pulumi.set(__self__, "config_template_id", config_template_id)
        if dai_trusted is not None:
            pulumi.set(__self__, "dai_trusted", dai_trusted)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if flexible_stacking_enabled is not None:
            pulumi.set(__self__, "flexible_stacking_enabled", flexible_stacking_enabled)
        if isolation_enabled is not None:
            pulumi.set(__self__, "isolation_enabled", isolation_enabled)
        if link_negotiation is not None:
            pulumi.set(__self__, "link_negotiation", link_negotiation)
        if link_negotiation_capabilities is not None:
            pulumi.set(__self__, "link_negotiation_capabilities", link_negotiation_capabilities)
        if mac_allow_lists is not None:
            pulumi.set(__self__, "mac_allow_lists", mac_allow_lists)
        if mirror is not None:
            pulumi.set(__self__, "mirror", mirror)
        if module is not None:
            pulumi.set(__self__, "module", module)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if poe_enabled is not None:
            pulumi.set(__self__, "poe_enabled", poe_enabled)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)
        if port_schedule_id is not None:
            pulumi.set(__self__, "port_schedule_id", port_schedule_id)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if profile_id is not None:
            pulumi.set(__self__, "profile_id", profile_id)
        if rstp_enabled is not None:
            pulumi.set(__self__, "rstp_enabled", rstp_enabled)
        if sticky_mac_allow_list_limit is not None:
            pulumi.set(__self__, "sticky_mac_allow_list_limit", sticky_mac_allow_list_limit)
        if sticky_mac_allow_lists is not None:
            pulumi.set(__self__, "sticky_mac_allow_lists", sticky_mac_allow_lists)
        if storm_control_enabled is not None:
            pulumi.set(__self__, "storm_control_enabled", storm_control_enabled)
        if stp_guard is not None:
            pulumi.set(__self__, "stp_guard", stp_guard)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if udld is not None:
            pulumi.set(__self__, "udld", udld)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)
        if voice_vlan is not None:
            pulumi.set(__self__, "voice_vlan", voice_vlan)

    @property
    @pulumi.getter(name="accessPolicyNumber")
    def access_policy_number(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of a custom access policy to configure on the switch template port. Only applicable when 'accessPolicyType' is 'Custom access policy'.
        """
        return pulumi.get(self, "access_policy_number")

    @access_policy_number.setter
    def access_policy_number(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "access_policy_number", value)

    @property
    @pulumi.getter(name="accessPolicyType")
    def access_policy_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the access policy of the switch template port. Only applicable to access ports. Can be one of 'Open', 'Custom access policy', 'MAC allow list' or 'Sticky MAC allow list'.
        """
        return pulumi.get(self, "access_policy_type")

    @access_policy_type.setter
    def access_policy_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_policy_type", value)

    @property
    @pulumi.getter(name="allowedVlans")
    def allowed_vlans(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The VLANs allowed on the switch template port. Only applicable to trunk ports.
        """
        return pulumi.get(self, "allowed_vlans")

    @allowed_vlans.setter
    def allowed_vlans(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "allowed_vlans", value)

    @property
    @pulumi.getter(name="configTemplateId")
    def config_template_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        configTemplateId path parameter. Config template ID
        """
        return pulumi.get(self, "config_template_id")

    @config_template_id.setter
    def config_template_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "config_template_id", value)

    @property
    @pulumi.getter(name="daiTrusted")
    def dai_trusted(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, ARP packets for this port will be considered trusted, and Dynamic ARP Inspection will allow the traffic.
        """
        return pulumi.get(self, "dai_trusted")

    @dai_trusted.setter
    def dai_trusted(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "dai_trusted", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The status of the switch template port.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="flexibleStackingEnabled")
    def flexible_stacking_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        For supported switches (e.g. MS420/MS425), whether or not the port has flexible stacking enabled.
        """
        return pulumi.get(self, "flexible_stacking_enabled")

    @flexible_stacking_enabled.setter
    def flexible_stacking_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "flexible_stacking_enabled", value)

    @property
    @pulumi.getter(name="isolationEnabled")
    def isolation_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The isolation status of the switch template port.
        """
        return pulumi.get(self, "isolation_enabled")

    @isolation_enabled.setter
    def isolation_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "isolation_enabled", value)

    @property
    @pulumi.getter(name="linkNegotiation")
    def link_negotiation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The link speed for the switch template port.
        """
        return pulumi.get(self, "link_negotiation")

    @link_negotiation.setter
    def link_negotiation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "link_negotiation", value)

    @property
    @pulumi.getter(name="linkNegotiationCapabilities")
    def link_negotiation_capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Available link speeds for the switch template port.
        """
        return pulumi.get(self, "link_negotiation_capabilities")

    @link_negotiation_capabilities.setter
    def link_negotiation_capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "link_negotiation_capabilities", value)

    @property
    @pulumi.getter(name="macAllowLists")
    def mac_allow_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Only devices with MAC addresses specified in this list will have access to this port. Up to 20 MAC addresses can be defined. Only applicable when 'accessPolicyType' is 'MAC allow list'.
        """
        return pulumi.get(self, "mac_allow_lists")

    @mac_allow_lists.setter
    def mac_allow_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "mac_allow_lists", value)

    @property
    @pulumi.getter
    def mirror(self) -> Optional[pulumi.Input['ConfigTemplatesSwitchProfilesPortsMirrorArgs']]:
        """
        Port mirror
        """
        return pulumi.get(self, "mirror")

    @mirror.setter
    def mirror(self, value: Optional[pulumi.Input['ConfigTemplatesSwitchProfilesPortsMirrorArgs']]):
        pulumi.set(self, "mirror", value)

    @property
    @pulumi.getter
    def module(self) -> Optional[pulumi.Input['ConfigTemplatesSwitchProfilesPortsModuleArgs']]:
        """
        Expansion module
        """
        return pulumi.get(self, "module")

    @module.setter
    def module(self, value: Optional[pulumi.Input['ConfigTemplatesSwitchProfilesPortsModuleArgs']]):
        pulumi.set(self, "module", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the switch template port.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="poeEnabled")
    def poe_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The PoE status of the switch template port.
        """
        return pulumi.get(self, "poe_enabled")

    @poe_enabled.setter
    def poe_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "poe_enabled", value)

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the switch template port.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "port_id", value)

    @property
    @pulumi.getter(name="portScheduleId")
    def port_schedule_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the port schedule. A value of null will clear the port schedule.
        """
        return pulumi.get(self, "port_schedule_id")

    @port_schedule_id.setter
    def port_schedule_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "port_schedule_id", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input['ConfigTemplatesSwitchProfilesPortsProfileArgs']]:
        """
        Profile attributes
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input['ConfigTemplatesSwitchProfilesPortsProfileArgs']]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        profileId path parameter. Profile ID
        """
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_id", value)

    @property
    @pulumi.getter(name="rstpEnabled")
    def rstp_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The rapid spanning tree protocol status.
        """
        return pulumi.get(self, "rstp_enabled")

    @rstp_enabled.setter
    def rstp_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "rstp_enabled", value)

    @property
    @pulumi.getter(name="stickyMacAllowListLimit")
    def sticky_mac_allow_list_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of MAC addresses for sticky MAC allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        """
        return pulumi.get(self, "sticky_mac_allow_list_limit")

    @sticky_mac_allow_list_limit.setter
    def sticky_mac_allow_list_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sticky_mac_allow_list_limit", value)

    @property
    @pulumi.getter(name="stickyMacAllowLists")
    def sticky_mac_allow_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The initial list of MAC addresses for sticky Mac allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        """
        return pulumi.get(self, "sticky_mac_allow_lists")

    @sticky_mac_allow_lists.setter
    def sticky_mac_allow_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "sticky_mac_allow_lists", value)

    @property
    @pulumi.getter(name="stormControlEnabled")
    def storm_control_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The storm control status of the switch template port.
        """
        return pulumi.get(self, "storm_control_enabled")

    @storm_control_enabled.setter
    def storm_control_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "storm_control_enabled", value)

    @property
    @pulumi.getter(name="stpGuard")
    def stp_guard(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of the STP guard ('disabled', 'root guard', 'bpdu guard' or 'loop guard').
        """
        return pulumi.get(self, "stp_guard")

    @stp_guard.setter
    def stp_guard(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stp_guard", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of tags of the switch template port.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the switch template port ('trunk' or 'access').
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def udld(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The action to take when Unidirectional Link is detected (Alert only, Enforce). Default configuration is Alert only.
        """
        return pulumi.get(self, "udld")

    @udld.setter
    def udld(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "udld", value)

    @property
    @pulumi.getter
    def vlan(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The VLAN of the switch template port. For a trunk port, this is the native VLAN. A null value will clear the value set for trunk ports.
        """
        return pulumi.get(self, "vlan")

    @vlan.setter
    def vlan(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vlan", value)

    @property
    @pulumi.getter(name="voiceVlan")
    def voice_vlan(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The voice VLAN of the switch template port. Only applicable to access ports.
        """
        return pulumi.get(self, "voice_vlan")

    @voice_vlan.setter
    def voice_vlan(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "voice_vlan", value)


@pulumi.type_token("meraki:organizations/configTemplatesSwitchProfilesPorts:ConfigTemplatesSwitchProfilesPorts")
class ConfigTemplatesSwitchProfilesPorts(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policy_number: Optional[pulumi.Input[builtins.int]] = None,
                 access_policy_type: Optional[pulumi.Input[builtins.str]] = None,
                 allowed_vlans: Optional[pulumi.Input[builtins.str]] = None,
                 config_template_id: Optional[pulumi.Input[builtins.str]] = None,
                 dai_trusted: Optional[pulumi.Input[builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 flexible_stacking_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 isolation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 link_negotiation: Optional[pulumi.Input[builtins.str]] = None,
                 mac_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 poe_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 port_id: Optional[pulumi.Input[builtins.str]] = None,
                 port_schedule_id: Optional[pulumi.Input[builtins.str]] = None,
                 profile: Optional[pulumi.Input[Union['ConfigTemplatesSwitchProfilesPortsProfileArgs', 'ConfigTemplatesSwitchProfilesPortsProfileArgsDict']]] = None,
                 profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 rstp_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 sticky_mac_allow_list_limit: Optional[pulumi.Input[builtins.int]] = None,
                 sticky_mac_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 storm_control_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 stp_guard: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 udld: Optional[pulumi.Input[builtins.str]] = None,
                 vlan: Optional[pulumi.Input[builtins.int]] = None,
                 voice_vlan: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.organizations.ConfigTemplatesSwitchProfilesPorts("example",
            access_policy_number=2,
            access_policy_type="Sticky MAC allow list",
            allowed_vlans="1,3,5-10",
            config_template_id="string",
            dai_trusted=False,
            enabled=True,
            flexible_stacking_enabled=True,
            isolation_enabled=False,
            link_negotiation="Auto negotiate",
            mac_allow_lists=[
                "34:56:fe:ce:8e:b0",
                "34:56:fe:ce:8e:b1",
            ],
            name="My switch port",
            organization_id="string",
            poe_enabled=True,
            port_id="string",
            port_schedule_id="1234",
            profile={
                "enabled": False,
                "id": "1284392014819",
                "iname": "iname",
            },
            profile_id="string",
            rstp_enabled=True,
            sticky_mac_allow_lists=[
                "34:56:fe:ce:8e:b0",
                "34:56:fe:ce:8e:b1",
            ],
            sticky_mac_allow_list_limit=5,
            storm_control_enabled=True,
            stp_guard="disabled",
            tags=[
                "tag1",
                "tag2",
            ],
            type="access",
            udld="Alert only",
            vlan=10,
            voice_vlan=20)
        pulumi.export("merakiOrganizationsConfigTemplatesSwitchProfilesPortsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:organizations/configTemplatesSwitchProfilesPorts:ConfigTemplatesSwitchProfilesPorts example "config_template_id,organization_id,port_id,profile_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] access_policy_number: The number of a custom access policy to configure on the switch template port. Only applicable when 'accessPolicyType' is 'Custom access policy'.
        :param pulumi.Input[builtins.str] access_policy_type: The type of the access policy of the switch template port. Only applicable to access ports. Can be one of 'Open', 'Custom access policy', 'MAC allow list' or 'Sticky MAC allow list'.
        :param pulumi.Input[builtins.str] allowed_vlans: The VLANs allowed on the switch template port. Only applicable to trunk ports.
        :param pulumi.Input[builtins.str] config_template_id: configTemplateId path parameter. Config template ID
        :param pulumi.Input[builtins.bool] dai_trusted: If true, ARP packets for this port will be considered trusted, and Dynamic ARP Inspection will allow the traffic.
        :param pulumi.Input[builtins.bool] enabled: The status of the switch template port.
        :param pulumi.Input[builtins.bool] flexible_stacking_enabled: For supported switches (e.g. MS420/MS425), whether or not the port has flexible stacking enabled.
        :param pulumi.Input[builtins.bool] isolation_enabled: The isolation status of the switch template port.
        :param pulumi.Input[builtins.str] link_negotiation: The link speed for the switch template port.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] mac_allow_lists: Only devices with MAC addresses specified in this list will have access to this port. Up to 20 MAC addresses can be defined. Only applicable when 'accessPolicyType' is 'MAC allow list'.
        :param pulumi.Input[builtins.str] name: The name of the switch template port.
        :param pulumi.Input[builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[builtins.bool] poe_enabled: The PoE status of the switch template port.
        :param pulumi.Input[builtins.str] port_id: The identifier of the switch template port.
        :param pulumi.Input[builtins.str] port_schedule_id: The ID of the port schedule. A value of null will clear the port schedule.
        :param pulumi.Input[Union['ConfigTemplatesSwitchProfilesPortsProfileArgs', 'ConfigTemplatesSwitchProfilesPortsProfileArgsDict']] profile: Profile attributes
        :param pulumi.Input[builtins.str] profile_id: profileId path parameter. Profile ID
        :param pulumi.Input[builtins.bool] rstp_enabled: The rapid spanning tree protocol status.
        :param pulumi.Input[builtins.int] sticky_mac_allow_list_limit: The maximum number of MAC addresses for sticky MAC allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sticky_mac_allow_lists: The initial list of MAC addresses for sticky Mac allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        :param pulumi.Input[builtins.bool] storm_control_enabled: The storm control status of the switch template port.
        :param pulumi.Input[builtins.str] stp_guard: The state of the STP guard ('disabled', 'root guard', 'bpdu guard' or 'loop guard').
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The list of tags of the switch template port.
        :param pulumi.Input[builtins.str] type: The type of the switch template port ('trunk' or 'access').
        :param pulumi.Input[builtins.str] udld: The action to take when Unidirectional Link is detected (Alert only, Enforce). Default configuration is Alert only.
        :param pulumi.Input[builtins.int] vlan: The VLAN of the switch template port. For a trunk port, this is the native VLAN. A null value will clear the value set for trunk ports.
        :param pulumi.Input[builtins.int] voice_vlan: The voice VLAN of the switch template port. Only applicable to access ports.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigTemplatesSwitchProfilesPortsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.organizations.ConfigTemplatesSwitchProfilesPorts("example",
            access_policy_number=2,
            access_policy_type="Sticky MAC allow list",
            allowed_vlans="1,3,5-10",
            config_template_id="string",
            dai_trusted=False,
            enabled=True,
            flexible_stacking_enabled=True,
            isolation_enabled=False,
            link_negotiation="Auto negotiate",
            mac_allow_lists=[
                "34:56:fe:ce:8e:b0",
                "34:56:fe:ce:8e:b1",
            ],
            name="My switch port",
            organization_id="string",
            poe_enabled=True,
            port_id="string",
            port_schedule_id="1234",
            profile={
                "enabled": False,
                "id": "1284392014819",
                "iname": "iname",
            },
            profile_id="string",
            rstp_enabled=True,
            sticky_mac_allow_lists=[
                "34:56:fe:ce:8e:b0",
                "34:56:fe:ce:8e:b1",
            ],
            sticky_mac_allow_list_limit=5,
            storm_control_enabled=True,
            stp_guard="disabled",
            tags=[
                "tag1",
                "tag2",
            ],
            type="access",
            udld="Alert only",
            vlan=10,
            voice_vlan=20)
        pulumi.export("merakiOrganizationsConfigTemplatesSwitchProfilesPortsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:organizations/configTemplatesSwitchProfilesPorts:ConfigTemplatesSwitchProfilesPorts example "config_template_id,organization_id,port_id,profile_id"
        ```

        :param str resource_name: The name of the resource.
        :param ConfigTemplatesSwitchProfilesPortsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigTemplatesSwitchProfilesPortsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policy_number: Optional[pulumi.Input[builtins.int]] = None,
                 access_policy_type: Optional[pulumi.Input[builtins.str]] = None,
                 allowed_vlans: Optional[pulumi.Input[builtins.str]] = None,
                 config_template_id: Optional[pulumi.Input[builtins.str]] = None,
                 dai_trusted: Optional[pulumi.Input[builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 flexible_stacking_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 isolation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 link_negotiation: Optional[pulumi.Input[builtins.str]] = None,
                 mac_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 poe_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 port_id: Optional[pulumi.Input[builtins.str]] = None,
                 port_schedule_id: Optional[pulumi.Input[builtins.str]] = None,
                 profile: Optional[pulumi.Input[Union['ConfigTemplatesSwitchProfilesPortsProfileArgs', 'ConfigTemplatesSwitchProfilesPortsProfileArgsDict']]] = None,
                 profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 rstp_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 sticky_mac_allow_list_limit: Optional[pulumi.Input[builtins.int]] = None,
                 sticky_mac_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 storm_control_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 stp_guard: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 udld: Optional[pulumi.Input[builtins.str]] = None,
                 vlan: Optional[pulumi.Input[builtins.int]] = None,
                 voice_vlan: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigTemplatesSwitchProfilesPortsArgs.__new__(ConfigTemplatesSwitchProfilesPortsArgs)

            __props__.__dict__["access_policy_number"] = access_policy_number
            __props__.__dict__["access_policy_type"] = access_policy_type
            __props__.__dict__["allowed_vlans"] = allowed_vlans
            if config_template_id is None and not opts.urn:
                raise TypeError("Missing required property 'config_template_id'")
            __props__.__dict__["config_template_id"] = config_template_id
            __props__.__dict__["dai_trusted"] = dai_trusted
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["flexible_stacking_enabled"] = flexible_stacking_enabled
            __props__.__dict__["isolation_enabled"] = isolation_enabled
            __props__.__dict__["link_negotiation"] = link_negotiation
            __props__.__dict__["mac_allow_lists"] = mac_allow_lists
            __props__.__dict__["name"] = name
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["poe_enabled"] = poe_enabled
            if port_id is None and not opts.urn:
                raise TypeError("Missing required property 'port_id'")
            __props__.__dict__["port_id"] = port_id
            __props__.__dict__["port_schedule_id"] = port_schedule_id
            __props__.__dict__["profile"] = profile
            if profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'profile_id'")
            __props__.__dict__["profile_id"] = profile_id
            __props__.__dict__["rstp_enabled"] = rstp_enabled
            __props__.__dict__["sticky_mac_allow_list_limit"] = sticky_mac_allow_list_limit
            __props__.__dict__["sticky_mac_allow_lists"] = sticky_mac_allow_lists
            __props__.__dict__["storm_control_enabled"] = storm_control_enabled
            __props__.__dict__["stp_guard"] = stp_guard
            __props__.__dict__["tags"] = tags
            __props__.__dict__["type"] = type
            __props__.__dict__["udld"] = udld
            __props__.__dict__["vlan"] = vlan
            __props__.__dict__["voice_vlan"] = voice_vlan
            __props__.__dict__["link_negotiation_capabilities"] = None
            __props__.__dict__["mirror"] = None
            __props__.__dict__["module"] = None
        super(ConfigTemplatesSwitchProfilesPorts, __self__).__init__(
            'meraki:organizations/configTemplatesSwitchProfilesPorts:ConfigTemplatesSwitchProfilesPorts',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_policy_number: Optional[pulumi.Input[builtins.int]] = None,
            access_policy_type: Optional[pulumi.Input[builtins.str]] = None,
            allowed_vlans: Optional[pulumi.Input[builtins.str]] = None,
            config_template_id: Optional[pulumi.Input[builtins.str]] = None,
            dai_trusted: Optional[pulumi.Input[builtins.bool]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            flexible_stacking_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            isolation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            link_negotiation: Optional[pulumi.Input[builtins.str]] = None,
            link_negotiation_capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            mac_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            mirror: Optional[pulumi.Input[Union['ConfigTemplatesSwitchProfilesPortsMirrorArgs', 'ConfigTemplatesSwitchProfilesPortsMirrorArgsDict']]] = None,
            module: Optional[pulumi.Input[Union['ConfigTemplatesSwitchProfilesPortsModuleArgs', 'ConfigTemplatesSwitchProfilesPortsModuleArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            organization_id: Optional[pulumi.Input[builtins.str]] = None,
            poe_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            port_id: Optional[pulumi.Input[builtins.str]] = None,
            port_schedule_id: Optional[pulumi.Input[builtins.str]] = None,
            profile: Optional[pulumi.Input[Union['ConfigTemplatesSwitchProfilesPortsProfileArgs', 'ConfigTemplatesSwitchProfilesPortsProfileArgsDict']]] = None,
            profile_id: Optional[pulumi.Input[builtins.str]] = None,
            rstp_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            sticky_mac_allow_list_limit: Optional[pulumi.Input[builtins.int]] = None,
            sticky_mac_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            storm_control_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            stp_guard: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            udld: Optional[pulumi.Input[builtins.str]] = None,
            vlan: Optional[pulumi.Input[builtins.int]] = None,
            voice_vlan: Optional[pulumi.Input[builtins.int]] = None) -> 'ConfigTemplatesSwitchProfilesPorts':
        """
        Get an existing ConfigTemplatesSwitchProfilesPorts resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] access_policy_number: The number of a custom access policy to configure on the switch template port. Only applicable when 'accessPolicyType' is 'Custom access policy'.
        :param pulumi.Input[builtins.str] access_policy_type: The type of the access policy of the switch template port. Only applicable to access ports. Can be one of 'Open', 'Custom access policy', 'MAC allow list' or 'Sticky MAC allow list'.
        :param pulumi.Input[builtins.str] allowed_vlans: The VLANs allowed on the switch template port. Only applicable to trunk ports.
        :param pulumi.Input[builtins.str] config_template_id: configTemplateId path parameter. Config template ID
        :param pulumi.Input[builtins.bool] dai_trusted: If true, ARP packets for this port will be considered trusted, and Dynamic ARP Inspection will allow the traffic.
        :param pulumi.Input[builtins.bool] enabled: The status of the switch template port.
        :param pulumi.Input[builtins.bool] flexible_stacking_enabled: For supported switches (e.g. MS420/MS425), whether or not the port has flexible stacking enabled.
        :param pulumi.Input[builtins.bool] isolation_enabled: The isolation status of the switch template port.
        :param pulumi.Input[builtins.str] link_negotiation: The link speed for the switch template port.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] link_negotiation_capabilities: Available link speeds for the switch template port.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] mac_allow_lists: Only devices with MAC addresses specified in this list will have access to this port. Up to 20 MAC addresses can be defined. Only applicable when 'accessPolicyType' is 'MAC allow list'.
        :param pulumi.Input[Union['ConfigTemplatesSwitchProfilesPortsMirrorArgs', 'ConfigTemplatesSwitchProfilesPortsMirrorArgsDict']] mirror: Port mirror
        :param pulumi.Input[Union['ConfigTemplatesSwitchProfilesPortsModuleArgs', 'ConfigTemplatesSwitchProfilesPortsModuleArgsDict']] module: Expansion module
        :param pulumi.Input[builtins.str] name: The name of the switch template port.
        :param pulumi.Input[builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[builtins.bool] poe_enabled: The PoE status of the switch template port.
        :param pulumi.Input[builtins.str] port_id: The identifier of the switch template port.
        :param pulumi.Input[builtins.str] port_schedule_id: The ID of the port schedule. A value of null will clear the port schedule.
        :param pulumi.Input[Union['ConfigTemplatesSwitchProfilesPortsProfileArgs', 'ConfigTemplatesSwitchProfilesPortsProfileArgsDict']] profile: Profile attributes
        :param pulumi.Input[builtins.str] profile_id: profileId path parameter. Profile ID
        :param pulumi.Input[builtins.bool] rstp_enabled: The rapid spanning tree protocol status.
        :param pulumi.Input[builtins.int] sticky_mac_allow_list_limit: The maximum number of MAC addresses for sticky MAC allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sticky_mac_allow_lists: The initial list of MAC addresses for sticky Mac allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        :param pulumi.Input[builtins.bool] storm_control_enabled: The storm control status of the switch template port.
        :param pulumi.Input[builtins.str] stp_guard: The state of the STP guard ('disabled', 'root guard', 'bpdu guard' or 'loop guard').
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The list of tags of the switch template port.
        :param pulumi.Input[builtins.str] type: The type of the switch template port ('trunk' or 'access').
        :param pulumi.Input[builtins.str] udld: The action to take when Unidirectional Link is detected (Alert only, Enforce). Default configuration is Alert only.
        :param pulumi.Input[builtins.int] vlan: The VLAN of the switch template port. For a trunk port, this is the native VLAN. A null value will clear the value set for trunk ports.
        :param pulumi.Input[builtins.int] voice_vlan: The voice VLAN of the switch template port. Only applicable to access ports.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigTemplatesSwitchProfilesPortsState.__new__(_ConfigTemplatesSwitchProfilesPortsState)

        __props__.__dict__["access_policy_number"] = access_policy_number
        __props__.__dict__["access_policy_type"] = access_policy_type
        __props__.__dict__["allowed_vlans"] = allowed_vlans
        __props__.__dict__["config_template_id"] = config_template_id
        __props__.__dict__["dai_trusted"] = dai_trusted
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["flexible_stacking_enabled"] = flexible_stacking_enabled
        __props__.__dict__["isolation_enabled"] = isolation_enabled
        __props__.__dict__["link_negotiation"] = link_negotiation
        __props__.__dict__["link_negotiation_capabilities"] = link_negotiation_capabilities
        __props__.__dict__["mac_allow_lists"] = mac_allow_lists
        __props__.__dict__["mirror"] = mirror
        __props__.__dict__["module"] = module
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["poe_enabled"] = poe_enabled
        __props__.__dict__["port_id"] = port_id
        __props__.__dict__["port_schedule_id"] = port_schedule_id
        __props__.__dict__["profile"] = profile
        __props__.__dict__["profile_id"] = profile_id
        __props__.__dict__["rstp_enabled"] = rstp_enabled
        __props__.__dict__["sticky_mac_allow_list_limit"] = sticky_mac_allow_list_limit
        __props__.__dict__["sticky_mac_allow_lists"] = sticky_mac_allow_lists
        __props__.__dict__["storm_control_enabled"] = storm_control_enabled
        __props__.__dict__["stp_guard"] = stp_guard
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["udld"] = udld
        __props__.__dict__["vlan"] = vlan
        __props__.__dict__["voice_vlan"] = voice_vlan
        return ConfigTemplatesSwitchProfilesPorts(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessPolicyNumber")
    def access_policy_number(self) -> pulumi.Output[builtins.int]:
        """
        The number of a custom access policy to configure on the switch template port. Only applicable when 'accessPolicyType' is 'Custom access policy'.
        """
        return pulumi.get(self, "access_policy_number")

    @property
    @pulumi.getter(name="accessPolicyType")
    def access_policy_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the access policy of the switch template port. Only applicable to access ports. Can be one of 'Open', 'Custom access policy', 'MAC allow list' or 'Sticky MAC allow list'.
        """
        return pulumi.get(self, "access_policy_type")

    @property
    @pulumi.getter(name="allowedVlans")
    def allowed_vlans(self) -> pulumi.Output[builtins.str]:
        """
        The VLANs allowed on the switch template port. Only applicable to trunk ports.
        """
        return pulumi.get(self, "allowed_vlans")

    @property
    @pulumi.getter(name="configTemplateId")
    def config_template_id(self) -> pulumi.Output[builtins.str]:
        """
        configTemplateId path parameter. Config template ID
        """
        return pulumi.get(self, "config_template_id")

    @property
    @pulumi.getter(name="daiTrusted")
    def dai_trusted(self) -> pulumi.Output[builtins.bool]:
        """
        If true, ARP packets for this port will be considered trusted, and Dynamic ARP Inspection will allow the traffic.
        """
        return pulumi.get(self, "dai_trusted")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        The status of the switch template port.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="flexibleStackingEnabled")
    def flexible_stacking_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        For supported switches (e.g. MS420/MS425), whether or not the port has flexible stacking enabled.
        """
        return pulumi.get(self, "flexible_stacking_enabled")

    @property
    @pulumi.getter(name="isolationEnabled")
    def isolation_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        The isolation status of the switch template port.
        """
        return pulumi.get(self, "isolation_enabled")

    @property
    @pulumi.getter(name="linkNegotiation")
    def link_negotiation(self) -> pulumi.Output[builtins.str]:
        """
        The link speed for the switch template port.
        """
        return pulumi.get(self, "link_negotiation")

    @property
    @pulumi.getter(name="linkNegotiationCapabilities")
    def link_negotiation_capabilities(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Available link speeds for the switch template port.
        """
        return pulumi.get(self, "link_negotiation_capabilities")

    @property
    @pulumi.getter(name="macAllowLists")
    def mac_allow_lists(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Only devices with MAC addresses specified in this list will have access to this port. Up to 20 MAC addresses can be defined. Only applicable when 'accessPolicyType' is 'MAC allow list'.
        """
        return pulumi.get(self, "mac_allow_lists")

    @property
    @pulumi.getter
    def mirror(self) -> pulumi.Output['outputs.ConfigTemplatesSwitchProfilesPortsMirror']:
        """
        Port mirror
        """
        return pulumi.get(self, "mirror")

    @property
    @pulumi.getter
    def module(self) -> pulumi.Output['outputs.ConfigTemplatesSwitchProfilesPortsModule']:
        """
        Expansion module
        """
        return pulumi.get(self, "module")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the switch template port.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[builtins.str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="poeEnabled")
    def poe_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        The PoE status of the switch template port.
        """
        return pulumi.get(self, "poe_enabled")

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the switch template port.
        """
        return pulumi.get(self, "port_id")

    @property
    @pulumi.getter(name="portScheduleId")
    def port_schedule_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the port schedule. A value of null will clear the port schedule.
        """
        return pulumi.get(self, "port_schedule_id")

    @property
    @pulumi.getter
    def profile(self) -> pulumi.Output['outputs.ConfigTemplatesSwitchProfilesPortsProfile']:
        """
        Profile attributes
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Output[builtins.str]:
        """
        profileId path parameter. Profile ID
        """
        return pulumi.get(self, "profile_id")

    @property
    @pulumi.getter(name="rstpEnabled")
    def rstp_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        The rapid spanning tree protocol status.
        """
        return pulumi.get(self, "rstp_enabled")

    @property
    @pulumi.getter(name="stickyMacAllowListLimit")
    def sticky_mac_allow_list_limit(self) -> pulumi.Output[builtins.int]:
        """
        The maximum number of MAC addresses for sticky MAC allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        """
        return pulumi.get(self, "sticky_mac_allow_list_limit")

    @property
    @pulumi.getter(name="stickyMacAllowLists")
    def sticky_mac_allow_lists(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The initial list of MAC addresses for sticky Mac allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        """
        return pulumi.get(self, "sticky_mac_allow_lists")

    @property
    @pulumi.getter(name="stormControlEnabled")
    def storm_control_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        The storm control status of the switch template port.
        """
        return pulumi.get(self, "storm_control_enabled")

    @property
    @pulumi.getter(name="stpGuard")
    def stp_guard(self) -> pulumi.Output[builtins.str]:
        """
        The state of the STP guard ('disabled', 'root guard', 'bpdu guard' or 'loop guard').
        """
        return pulumi.get(self, "stp_guard")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The list of tags of the switch template port.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the switch template port ('trunk' or 'access').
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def udld(self) -> pulumi.Output[builtins.str]:
        """
        The action to take when Unidirectional Link is detected (Alert only, Enforce). Default configuration is Alert only.
        """
        return pulumi.get(self, "udld")

    @property
    @pulumi.getter
    def vlan(self) -> pulumi.Output[builtins.int]:
        """
        The VLAN of the switch template port. For a trunk port, this is the native VLAN. A null value will clear the value set for trunk ports.
        """
        return pulumi.get(self, "vlan")

    @property
    @pulumi.getter(name="voiceVlan")
    def voice_vlan(self) -> pulumi.Output[builtins.int]:
        """
        The voice VLAN of the switch template port. Only applicable to access ports.
        """
        return pulumi.get(self, "voice_vlan")

