# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetApiRequestsOverviewResponseCodesByIntervalResult',
    'AwaitableGetApiRequestsOverviewResponseCodesByIntervalResult',
    'get_api_requests_overview_response_codes_by_interval',
    'get_api_requests_overview_response_codes_by_interval_output',
]

@pulumi.output_type
class GetApiRequestsOverviewResponseCodesByIntervalResult:
    """
    A collection of values returned by getApiRequestsOverviewResponseCodesByInterval.
    """
    def __init__(__self__, admin_ids=None, id=None, interval=None, items=None, operation_ids=None, organization_id=None, source_ips=None, t0=None, t1=None, timespan=None, user_agent=None, version=None):
        if admin_ids and not isinstance(admin_ids, list):
            raise TypeError("Expected argument 'admin_ids' to be a list")
        pulumi.set(__self__, "admin_ids", admin_ids)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if interval and not isinstance(interval, int):
            raise TypeError("Expected argument 'interval' to be a int")
        pulumi.set(__self__, "interval", interval)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if operation_ids and not isinstance(operation_ids, list):
            raise TypeError("Expected argument 'operation_ids' to be a list")
        pulumi.set(__self__, "operation_ids", operation_ids)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if source_ips and not isinstance(source_ips, list):
            raise TypeError("Expected argument 'source_ips' to be a list")
        pulumi.set(__self__, "source_ips", source_ips)
        if t0 and not isinstance(t0, str):
            raise TypeError("Expected argument 't0' to be a str")
        pulumi.set(__self__, "t0", t0)
        if t1 and not isinstance(t1, str):
            raise TypeError("Expected argument 't1' to be a str")
        pulumi.set(__self__, "t1", t1)
        if timespan and not isinstance(timespan, float):
            raise TypeError("Expected argument 'timespan' to be a float")
        pulumi.set(__self__, "timespan", timespan)
        if user_agent and not isinstance(user_agent, str):
            raise TypeError("Expected argument 'user_agent' to be a str")
        pulumi.set(__self__, "user_agent", user_agent)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="adminIds")
    def admin_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        adminIds query parameter. Filter by admin ID of user that made the API request
        """
        return pulumi.get(self, "admin_ids")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def interval(self) -> Optional[builtins.int]:
        """
        interval query parameter. The time interval in seconds for returned data. The valid intervals are: 120, 3600, 14400, 21600. The default is 21600. Interval is calculated if time params are provided.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetApiRequestsOverviewResponseCodesByIntervalItemResult']:
        """
        Array of ResponseOrganizationsGetOrganizationApiRequestsOverviewResponseCodesByInterval
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="operationIds")
    def operation_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        operationIds query parameter. Filter by operation ID of the endpoint
        """
        return pulumi.get(self, "operation_ids")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> builtins.str:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="sourceIps")
    def source_ips(self) -> Optional[Sequence[builtins.str]]:
        """
        sourceIps query parameter. Filter by source IP that made the API request
        """
        return pulumi.get(self, "source_ips")

    @property
    @pulumi.getter
    def t0(self) -> Optional[builtins.str]:
        """
        t0 query parameter. The beginning of the timespan for the data. The maximum lookback period is 31 days from today.
        """
        return pulumi.get(self, "t0")

    @property
    @pulumi.getter
    def t1(self) -> Optional[builtins.str]:
        """
        t1 query parameter. The end of the timespan for the data. t1 can be a maximum of 31 days after t0.
        """
        return pulumi.get(self, "t1")

    @property
    @pulumi.getter
    def timespan(self) -> Optional[builtins.float]:
        """
        timespan query parameter. The timespan for which the information will be fetched. If specifying timespan, do not specify parameters t0 and t1. The value must be in seconds and be less than or equal to 31 days. The default is 31 days. If interval is provided, the timespan will be autocalculated.
        """
        return pulumi.get(self, "timespan")

    @property
    @pulumi.getter(name="userAgent")
    def user_agent(self) -> Optional[builtins.str]:
        """
        userAgent query parameter. Filter by user agent string for API request. This will filter by a complete or partial match.
        """
        return pulumi.get(self, "user_agent")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.int]:
        """
        version query parameter. Filter by API version of the endpoint. Allowable values are: [0, 1]
        """
        return pulumi.get(self, "version")


class AwaitableGetApiRequestsOverviewResponseCodesByIntervalResult(GetApiRequestsOverviewResponseCodesByIntervalResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiRequestsOverviewResponseCodesByIntervalResult(
            admin_ids=self.admin_ids,
            id=self.id,
            interval=self.interval,
            items=self.items,
            operation_ids=self.operation_ids,
            organization_id=self.organization_id,
            source_ips=self.source_ips,
            t0=self.t0,
            t1=self.t1,
            timespan=self.timespan,
            user_agent=self.user_agent,
            version=self.version)


def get_api_requests_overview_response_codes_by_interval(admin_ids: Optional[Sequence[builtins.str]] = None,
                                                         interval: Optional[builtins.int] = None,
                                                         operation_ids: Optional[Sequence[builtins.str]] = None,
                                                         organization_id: Optional[builtins.str] = None,
                                                         source_ips: Optional[Sequence[builtins.str]] = None,
                                                         t0: Optional[builtins.str] = None,
                                                         t1: Optional[builtins.str] = None,
                                                         timespan: Optional[builtins.float] = None,
                                                         user_agent: Optional[builtins.str] = None,
                                                         version: Optional[builtins.int] = None,
                                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiRequestsOverviewResponseCodesByIntervalResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.organizations.get_api_requests_overview_response_codes_by_interval(admin_ids=["string"],
        interval=1,
        operation_ids=["string"],
        organization_id="string",
        source_ips=["string"],
        t0="string",
        t1="string",
        timespan=1,
        user_agent="string",
        version=1)
    pulumi.export("merakiOrganizationsApiRequestsOverviewResponseCodesByIntervalExample", example.items)
    ```


    :param Sequence[builtins.str] admin_ids: adminIds query parameter. Filter by admin ID of user that made the API request
    :param builtins.int interval: interval query parameter. The time interval in seconds for returned data. The valid intervals are: 120, 3600, 14400, 21600. The default is 21600. Interval is calculated if time params are provided.
    :param Sequence[builtins.str] operation_ids: operationIds query parameter. Filter by operation ID of the endpoint
    :param builtins.str organization_id: organizationId path parameter. Organization ID
    :param Sequence[builtins.str] source_ips: sourceIps query parameter. Filter by source IP that made the API request
    :param builtins.str t0: t0 query parameter. The beginning of the timespan for the data. The maximum lookback period is 31 days from today.
    :param builtins.str t1: t1 query parameter. The end of the timespan for the data. t1 can be a maximum of 31 days after t0.
    :param builtins.float timespan: timespan query parameter. The timespan for which the information will be fetched. If specifying timespan, do not specify parameters t0 and t1. The value must be in seconds and be less than or equal to 31 days. The default is 31 days. If interval is provided, the timespan will be autocalculated.
    :param builtins.str user_agent: userAgent query parameter. Filter by user agent string for API request. This will filter by a complete or partial match.
    :param builtins.int version: version query parameter. Filter by API version of the endpoint. Allowable values are: [0, 1]
    """
    __args__ = dict()
    __args__['adminIds'] = admin_ids
    __args__['interval'] = interval
    __args__['operationIds'] = operation_ids
    __args__['organizationId'] = organization_id
    __args__['sourceIps'] = source_ips
    __args__['t0'] = t0
    __args__['t1'] = t1
    __args__['timespan'] = timespan
    __args__['userAgent'] = user_agent
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('meraki:organizations/getApiRequestsOverviewResponseCodesByInterval:getApiRequestsOverviewResponseCodesByInterval', __args__, opts=opts, typ=GetApiRequestsOverviewResponseCodesByIntervalResult).value

    return AwaitableGetApiRequestsOverviewResponseCodesByIntervalResult(
        admin_ids=pulumi.get(__ret__, 'admin_ids'),
        id=pulumi.get(__ret__, 'id'),
        interval=pulumi.get(__ret__, 'interval'),
        items=pulumi.get(__ret__, 'items'),
        operation_ids=pulumi.get(__ret__, 'operation_ids'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        source_ips=pulumi.get(__ret__, 'source_ips'),
        t0=pulumi.get(__ret__, 't0'),
        t1=pulumi.get(__ret__, 't1'),
        timespan=pulumi.get(__ret__, 'timespan'),
        user_agent=pulumi.get(__ret__, 'user_agent'),
        version=pulumi.get(__ret__, 'version'))
def get_api_requests_overview_response_codes_by_interval_output(admin_ids: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                                                interval: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                                                operation_ids: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                                                organization_id: Optional[pulumi.Input[builtins.str]] = None,
                                                                source_ips: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                                                t0: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                                t1: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                                timespan: Optional[pulumi.Input[Optional[builtins.float]]] = None,
                                                                user_agent: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                                version: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiRequestsOverviewResponseCodesByIntervalResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.organizations.get_api_requests_overview_response_codes_by_interval(admin_ids=["string"],
        interval=1,
        operation_ids=["string"],
        organization_id="string",
        source_ips=["string"],
        t0="string",
        t1="string",
        timespan=1,
        user_agent="string",
        version=1)
    pulumi.export("merakiOrganizationsApiRequestsOverviewResponseCodesByIntervalExample", example.items)
    ```


    :param Sequence[builtins.str] admin_ids: adminIds query parameter. Filter by admin ID of user that made the API request
    :param builtins.int interval: interval query parameter. The time interval in seconds for returned data. The valid intervals are: 120, 3600, 14400, 21600. The default is 21600. Interval is calculated if time params are provided.
    :param Sequence[builtins.str] operation_ids: operationIds query parameter. Filter by operation ID of the endpoint
    :param builtins.str organization_id: organizationId path parameter. Organization ID
    :param Sequence[builtins.str] source_ips: sourceIps query parameter. Filter by source IP that made the API request
    :param builtins.str t0: t0 query parameter. The beginning of the timespan for the data. The maximum lookback period is 31 days from today.
    :param builtins.str t1: t1 query parameter. The end of the timespan for the data. t1 can be a maximum of 31 days after t0.
    :param builtins.float timespan: timespan query parameter. The timespan for which the information will be fetched. If specifying timespan, do not specify parameters t0 and t1. The value must be in seconds and be less than or equal to 31 days. The default is 31 days. If interval is provided, the timespan will be autocalculated.
    :param builtins.str user_agent: userAgent query parameter. Filter by user agent string for API request. This will filter by a complete or partial match.
    :param builtins.int version: version query parameter. Filter by API version of the endpoint. Allowable values are: [0, 1]
    """
    __args__ = dict()
    __args__['adminIds'] = admin_ids
    __args__['interval'] = interval
    __args__['operationIds'] = operation_ids
    __args__['organizationId'] = organization_id
    __args__['sourceIps'] = source_ips
    __args__['t0'] = t0
    __args__['t1'] = t1
    __args__['timespan'] = timespan
    __args__['userAgent'] = user_agent
    __args__['version'] = version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('meraki:organizations/getApiRequestsOverviewResponseCodesByInterval:getApiRequestsOverviewResponseCodesByInterval', __args__, opts=opts, typ=GetApiRequestsOverviewResponseCodesByIntervalResult)
    return __ret__.apply(lambda __response__: GetApiRequestsOverviewResponseCodesByIntervalResult(
        admin_ids=pulumi.get(__response__, 'admin_ids'),
        id=pulumi.get(__response__, 'id'),
        interval=pulumi.get(__response__, 'interval'),
        items=pulumi.get(__response__, 'items'),
        operation_ids=pulumi.get(__response__, 'operation_ids'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        source_ips=pulumi.get(__response__, 'source_ips'),
        t0=pulumi.get(__response__, 't0'),
        t1=pulumi.get(__response__, 't1'),
        timespan=pulumi.get(__response__, 'timespan'),
        user_agent=pulumi.get(__response__, 'user_agent'),
        version=pulumi.get(__response__, 'version')))
