# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PolicyObjectsArgs', 'PolicyObjects']

@pulumi.input_type
class PolicyObjectsArgs:
    def __init__(__self__, *,
                 organization_id: pulumi.Input[builtins.str],
                 category: Optional[pulumi.Input[builtins.str]] = None,
                 cidr: Optional[pulumi.Input[builtins.str]] = None,
                 fqdn: Optional[pulumi.Input[builtins.str]] = None,
                 group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ip: Optional[pulumi.Input[builtins.str]] = None,
                 mask: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 policy_object_id: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a PolicyObjects resource.
        :param pulumi.Input[builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[builtins.str] category: Category of a policy object (one of: adaptivePolicy, network)
        :param pulumi.Input[builtins.str] cidr: CIDR Value of a policy object (e.g. 10.11.12.1/24")
        :param pulumi.Input[builtins.str] fqdn: Fully qualified domain name of policy object (e.g. "example.com")
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] group_ids: The IDs of policy object groups the policy object belongs to
        :param pulumi.Input[builtins.str] ip: IP Address of a policy object (e.g. "1.2.3.4")
        :param pulumi.Input[builtins.str] mask: Mask of a policy object (e.g. "255.255.0.0")
        :param pulumi.Input[builtins.str] name: Name of a policy object, unique within the organization (alphanumeric, space, dash, or underscore characters only)
        :param pulumi.Input[builtins.str] policy_object_id: policyObjectId path parameter. Policy object ID
        :param pulumi.Input[builtins.str] type: Type of a policy object (one of: adaptivePolicyIpv4Cidr, cidr, fqdn, ipAndMask)
        """
        pulumi.set(__self__, "organization_id", organization_id)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if group_ids is not None:
            pulumi.set(__self__, "group_ids", group_ids)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if mask is not None:
            pulumi.set(__self__, "mask", mask)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_object_id is not None:
            pulumi.set(__self__, "policy_object_id", policy_object_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[builtins.str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Category of a policy object (one of: adaptivePolicy, network)
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        CIDR Value of a policy object (e.g. 10.11.12.1/24")
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Fully qualified domain name of policy object (e.g. "example.com")
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IDs of policy object groups the policy object belongs to
        """
        return pulumi.get(self, "group_ids")

    @group_ids.setter
    def group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "group_ids", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP Address of a policy object (e.g. "1.2.3.4")
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def mask(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Mask of a policy object (e.g. "255.255.0.0")
        """
        return pulumi.get(self, "mask")

    @mask.setter
    def mask(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mask", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of a policy object, unique within the organization (alphanumeric, space, dash, or underscore characters only)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="policyObjectId")
    def policy_object_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        policyObjectId path parameter. Policy object ID
        """
        return pulumi.get(self, "policy_object_id")

    @policy_object_id.setter
    def policy_object_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_object_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of a policy object (one of: adaptivePolicyIpv4Cidr, cidr, fqdn, ipAndMask)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _PolicyObjectsState:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[builtins.str]] = None,
                 cidr: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 fqdn: Optional[pulumi.Input[builtins.str]] = None,
                 group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ip: Optional[pulumi.Input[builtins.str]] = None,
                 mask: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 policy_object_id: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering PolicyObjects resources.
        :param pulumi.Input[builtins.str] category: Category of a policy object (one of: adaptivePolicy, network)
        :param pulumi.Input[builtins.str] cidr: CIDR Value of a policy object (e.g. 10.11.12.1/24")
        :param pulumi.Input[builtins.str] fqdn: Fully qualified domain name of policy object (e.g. "example.com")
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] group_ids: The IDs of policy object groups the policy object belongs to
        :param pulumi.Input[builtins.str] ip: IP Address of a policy object (e.g. "1.2.3.4")
        :param pulumi.Input[builtins.str] mask: Mask of a policy object (e.g. "255.255.0.0")
        :param pulumi.Input[builtins.str] name: Name of a policy object, unique within the organization (alphanumeric, space, dash, or underscore characters only)
        :param pulumi.Input[builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[builtins.str] policy_object_id: policyObjectId path parameter. Policy object ID
        :param pulumi.Input[builtins.str] type: Type of a policy object (one of: adaptivePolicyIpv4Cidr, cidr, fqdn, ipAndMask)
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if group_ids is not None:
            pulumi.set(__self__, "group_ids", group_ids)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if mask is not None:
            pulumi.set(__self__, "mask", mask)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_ids is not None:
            pulumi.set(__self__, "network_ids", network_ids)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if policy_object_id is not None:
            pulumi.set(__self__, "policy_object_id", policy_object_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Category of a policy object (one of: adaptivePolicy, network)
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        CIDR Value of a policy object (e.g. 10.11.12.1/24")
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Fully qualified domain name of policy object (e.g. "example.com")
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IDs of policy object groups the policy object belongs to
        """
        return pulumi.get(self, "group_ids")

    @group_ids.setter
    def group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "group_ids", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP Address of a policy object (e.g. "1.2.3.4")
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def mask(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Mask of a policy object (e.g. "255.255.0.0")
        """
        return pulumi.get(self, "mask")

    @mask.setter
    def mask(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mask", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of a policy object, unique within the organization (alphanumeric, space, dash, or underscore characters only)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkIds")
    def network_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "network_ids")

    @network_ids.setter
    def network_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "network_ids", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="policyObjectId")
    def policy_object_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        policyObjectId path parameter. Policy object ID
        """
        return pulumi.get(self, "policy_object_id")

    @policy_object_id.setter
    def policy_object_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_object_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of a policy object (one of: adaptivePolicyIpv4Cidr, cidr, fqdn, ipAndMask)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("meraki:organizations/policyObjects:PolicyObjects")
class PolicyObjects(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[builtins.str]] = None,
                 cidr: Optional[pulumi.Input[builtins.str]] = None,
                 fqdn: Optional[pulumi.Input[builtins.str]] = None,
                 group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ip: Optional[pulumi.Input[builtins.str]] = None,
                 mask: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 policy_object_id: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.organizations.PolicyObjects("example",
            category="network",
            cidr="10.0.0.0/24",
            fqdn="example.com",
            group_ids=["8"],
            ip="1.2.3.4",
            mask="255.255.0.0",
            name="Web Servers - Datacenter 10",
            organization_id="string",
            type="cidr")
        pulumi.export("merakiOrganizationsPolicyObjectsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:organizations/policyObjects:PolicyObjects example "organization_id,policy_object_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] category: Category of a policy object (one of: adaptivePolicy, network)
        :param pulumi.Input[builtins.str] cidr: CIDR Value of a policy object (e.g. 10.11.12.1/24")
        :param pulumi.Input[builtins.str] fqdn: Fully qualified domain name of policy object (e.g. "example.com")
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] group_ids: The IDs of policy object groups the policy object belongs to
        :param pulumi.Input[builtins.str] ip: IP Address of a policy object (e.g. "1.2.3.4")
        :param pulumi.Input[builtins.str] mask: Mask of a policy object (e.g. "255.255.0.0")
        :param pulumi.Input[builtins.str] name: Name of a policy object, unique within the organization (alphanumeric, space, dash, or underscore characters only)
        :param pulumi.Input[builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[builtins.str] policy_object_id: policyObjectId path parameter. Policy object ID
        :param pulumi.Input[builtins.str] type: Type of a policy object (one of: adaptivePolicyIpv4Cidr, cidr, fqdn, ipAndMask)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyObjectsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.organizations.PolicyObjects("example",
            category="network",
            cidr="10.0.0.0/24",
            fqdn="example.com",
            group_ids=["8"],
            ip="1.2.3.4",
            mask="255.255.0.0",
            name="Web Servers - Datacenter 10",
            organization_id="string",
            type="cidr")
        pulumi.export("merakiOrganizationsPolicyObjectsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:organizations/policyObjects:PolicyObjects example "organization_id,policy_object_id"
        ```

        :param str resource_name: The name of the resource.
        :param PolicyObjectsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyObjectsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[builtins.str]] = None,
                 cidr: Optional[pulumi.Input[builtins.str]] = None,
                 fqdn: Optional[pulumi.Input[builtins.str]] = None,
                 group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ip: Optional[pulumi.Input[builtins.str]] = None,
                 mask: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 policy_object_id: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyObjectsArgs.__new__(PolicyObjectsArgs)

            __props__.__dict__["category"] = category
            __props__.__dict__["cidr"] = cidr
            __props__.__dict__["fqdn"] = fqdn
            __props__.__dict__["group_ids"] = group_ids
            __props__.__dict__["ip"] = ip
            __props__.__dict__["mask"] = mask
            __props__.__dict__["name"] = name
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["policy_object_id"] = policy_object_id
            __props__.__dict__["type"] = type
            __props__.__dict__["created_at"] = None
            __props__.__dict__["network_ids"] = None
            __props__.__dict__["updated_at"] = None
        super(PolicyObjects, __self__).__init__(
            'meraki:organizations/policyObjects:PolicyObjects',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            category: Optional[pulumi.Input[builtins.str]] = None,
            cidr: Optional[pulumi.Input[builtins.str]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            fqdn: Optional[pulumi.Input[builtins.str]] = None,
            group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            ip: Optional[pulumi.Input[builtins.str]] = None,
            mask: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            organization_id: Optional[pulumi.Input[builtins.str]] = None,
            policy_object_id: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None) -> 'PolicyObjects':
        """
        Get an existing PolicyObjects resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] category: Category of a policy object (one of: adaptivePolicy, network)
        :param pulumi.Input[builtins.str] cidr: CIDR Value of a policy object (e.g. 10.11.12.1/24")
        :param pulumi.Input[builtins.str] fqdn: Fully qualified domain name of policy object (e.g. "example.com")
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] group_ids: The IDs of policy object groups the policy object belongs to
        :param pulumi.Input[builtins.str] ip: IP Address of a policy object (e.g. "1.2.3.4")
        :param pulumi.Input[builtins.str] mask: Mask of a policy object (e.g. "255.255.0.0")
        :param pulumi.Input[builtins.str] name: Name of a policy object, unique within the organization (alphanumeric, space, dash, or underscore characters only)
        :param pulumi.Input[builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[builtins.str] policy_object_id: policyObjectId path parameter. Policy object ID
        :param pulumi.Input[builtins.str] type: Type of a policy object (one of: adaptivePolicyIpv4Cidr, cidr, fqdn, ipAndMask)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyObjectsState.__new__(_PolicyObjectsState)

        __props__.__dict__["category"] = category
        __props__.__dict__["cidr"] = cidr
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["group_ids"] = group_ids
        __props__.__dict__["ip"] = ip
        __props__.__dict__["mask"] = mask
        __props__.__dict__["name"] = name
        __props__.__dict__["network_ids"] = network_ids
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["policy_object_id"] = policy_object_id
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        return PolicyObjects(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def category(self) -> pulumi.Output[builtins.str]:
        """
        Category of a policy object (one of: adaptivePolicy, network)
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Output[builtins.str]:
        """
        CIDR Value of a policy object (e.g. 10.11.12.1/24")
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[builtins.str]:
        """
        Fully qualified domain name of policy object (e.g. "example.com")
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The IDs of policy object groups the policy object belongs to
        """
        return pulumi.get(self, "group_ids")

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Output[builtins.str]:
        """
        IP Address of a policy object (e.g. "1.2.3.4")
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def mask(self) -> pulumi.Output[builtins.str]:
        """
        Mask of a policy object (e.g. "255.255.0.0")
        """
        return pulumi.get(self, "mask")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of a policy object, unique within the organization (alphanumeric, space, dash, or underscore characters only)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkIds")
    def network_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        return pulumi.get(self, "network_ids")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[builtins.str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="policyObjectId")
    def policy_object_id(self) -> pulumi.Output[builtins.str]:
        """
        policyObjectId path parameter. Policy object ID
        """
        return pulumi.get(self, "policy_object_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Type of a policy object (one of: adaptivePolicyIpv4Cidr, cidr, fqdn, ipAndMask)
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "updated_at")

