# Pyrogram - Telegram MTProto API Client Library for Python
# Copyright (C) 2017-2019 Dan Tès <https://github.com/delivrance>
#
# This file is part of Pyrogram.
#
# Pyrogram is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Pyrogram is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with Pyrogram.  If not, see <http://www.gnu.org/licenses/>.

from io import BytesIO

from pyrogram.api.core import *


class PageBlockList(Object):
    """Attributes:
        ID: ``0xe4e88011``

    Parameters:
        items: List of either :obj:`PageListItemText <pyrogram.api.types.PageListItemText>` or :obj:`PageListItemBlocks <pyrogram.api.types.PageListItemBlocks>`
    """

    __slots__ = ["items"]

    ID = 0xe4e88011
    QUALNAME = "types.PageBlockList"

    def __init__(self, *, items: list):
        self.items = items  # Vector<PageListItem>

    @staticmethod
    def read(b: BytesIO, *args) -> "PageBlockList":
        # No flags
        
        items = Object.read(b)
        
        return PageBlockList(items=items)

    def write(self) -> bytes:
        b = BytesIO()
        b.write(Int(self.ID, False))

        # No flags
        
        b.write(Vector(self.items))
        
        return b.getvalue()
