"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)


class GetUnifiedIntegrationAuthRequestTypedDict(TypedDict):
    integration_type: str
    r"""Type of the supported integration"""
    workspace_id: str
    r"""The ID of the workspace"""
    env: NotRequired[str]
    external_xref: NotRequired[str]
    r"""Your user identifier to associate with the new Integration"""
    failure_redirect: NotRequired[str]
    r"""The URL where you want the user to be redirect to after an unsuccessful authentication. An \"error\" variable will be appended."""
    lang: NotRequired[str]
    r"""Language: en, fr, es, it, pt, zh, hi"""
    redirect: NotRequired[bool]
    scopes: NotRequired[List[str]]
    state: NotRequired[str]
    r"""Extra state to send back to your success URL"""
    subdomain: NotRequired[str]
    success_redirect: NotRequired[str]
    r"""The URL where you want the user to be redirect to after a successful authorization.  The connection ID will be appended with (id=<connectionId>) to this URL, as will the state that was provided."""


class GetUnifiedIntegrationAuthRequest(BaseModel):
    integration_type: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Type of the supported integration"""

    workspace_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The ID of the workspace"""

    env: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    external_xref: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Your user identifier to associate with the new Integration"""

    failure_redirect: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The URL where you want the user to be redirect to after an unsuccessful authentication. An \"error\" variable will be appended."""

    lang: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Language: en, fr, es, it, pt, zh, hi"""

    redirect: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    scopes: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    state: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Extra state to send back to your success URL"""

    subdomain: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    success_redirect: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The URL where you want the user to be redirect to after a successful authorization.  The connection ID will be appended with (id=<connectionId>) to this URL, as will the state that was provided."""


class GetUnifiedIntegrationAuthResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    res: NotRequired[str]
    r"""Successful"""


class GetUnifiedIntegrationAuthResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    res: Optional[str] = None
    r"""Successful"""
