"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk.models.shared import scimgroup as shared_scimgroup
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)


class ListScimGroupsRequestTypedDict(TypedDict):
    connection_id: str
    r"""ID of the connection"""
    count: NotRequired[float]
    filter_: NotRequired[str]
    sort_by: NotRequired[str]
    sort_order: NotRequired[str]
    start_index: NotRequired[float]


class ListScimGroupsRequest(BaseModel):
    connection_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the connection"""

    count: Annotated[
        Optional[float],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    filter_: Annotated[
        Optional[str],
        pydantic.Field(alias="filter"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    sort_by: Annotated[
        Optional[str],
        pydantic.Field(alias="sortBy"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    sort_order: Annotated[
        Optional[str],
        pydantic.Field(alias="sortOrder"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    start_index: Annotated[
        Optional[float],
        pydantic.Field(alias="startIndex"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None


class ListScimGroupsResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    scim_groups: NotRequired[List[shared_scimgroup.ScimGroupTypedDict]]
    r"""Successful"""


class ListScimGroupsResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    scim_groups: Optional[List[shared_scimgroup.ScimGroup]] = None
    r"""Successful"""
