"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
import httpx
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk.models.shared import apicall as shared_apicall
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import FieldMetadata, QueryParamMetadata


class ListUnifiedApicallsRequestTypedDict(TypedDict):
    connection_id: NotRequired[str]
    r"""Filter the results to just this integration"""
    env: NotRequired[str]
    error: NotRequired[bool]
    r"""Filter the results for API Calls with errors"""
    external_xref: NotRequired[str]
    r"""Filter the results to only those integrations for your user referenced by this value"""
    integration_type: NotRequired[str]
    r"""Filter the results to just this integration"""
    is_billable: NotRequired[bool]
    r"""Filter the results for only billable API Calls"""
    limit: NotRequired[float]
    offset: NotRequired[float]
    order: NotRequired[str]
    sort: NotRequired[str]
    type: NotRequired[str]
    r"""Filter the results to just this type"""
    updated_gte: NotRequired[datetime]
    r"""Return only results whose updated date is equal or greater to this value"""
    webhook_id: NotRequired[str]
    r"""Filter the results to just this webhook"""


class ListUnifiedApicallsRequest(BaseModel):
    connection_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter the results to just this integration"""

    env: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    error: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter the results for API Calls with errors"""

    external_xref: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter the results to only those integrations for your user referenced by this value"""

    integration_type: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter the results to just this integration"""

    is_billable: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter the results for only billable API Calls"""

    limit: Annotated[
        Optional[float],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    offset: Annotated[
        Optional[float],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    order: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    sort: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    type: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter the results to just this type"""

    updated_gte: Annotated[
        Optional[datetime],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Return only results whose updated date is equal or greater to this value"""

    webhook_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter the results to just this webhook"""


class ListUnifiedApicallsResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    api_calls: NotRequired[List[shared_apicall.APICallTypedDict]]
    r"""Successful"""


class ListUnifiedApicallsResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    api_calls: Optional[List[shared_apicall.APICall]] = None
    r"""Successful"""
