"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk.models.shared import kmsspace as shared_kmsspace
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)


class PatchKmsSpaceRequestTypedDict(TypedDict):
    kms_space: shared_kmsspace.KmsSpaceTypedDict
    connection_id: str
    r"""ID of the connection"""
    id: str
    r"""ID of the Space"""
    fields: NotRequired[List[str]]
    r"""Comma-delimited fields to return"""


class PatchKmsSpaceRequest(BaseModel):
    kms_space: Annotated[
        shared_kmsspace.KmsSpace,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    connection_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the connection"""

    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the Space"""

    fields: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Comma-delimited fields to return"""


class PatchKmsSpaceResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    kms_space: NotRequired[shared_kmsspace.KmsSpaceTypedDict]
    r"""Successful"""


class PatchKmsSpaceResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    kms_space: Optional[shared_kmsspace.KmsSpace] = None
    r"""Successful"""
