"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk.models.shared import lmsclass as shared_lmsclass
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)


class PatchLmsClassRequestTypedDict(TypedDict):
    lms_class: shared_lmsclass.LmsClassTypedDict
    connection_id: str
    r"""ID of the connection"""
    id: str
    r"""ID of the Class"""
    fields: NotRequired[List[str]]
    r"""Comma-delimited fields to return"""


class PatchLmsClassRequest(BaseModel):
    lms_class: Annotated[
        shared_lmsclass.LmsClass,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    connection_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the connection"""

    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the Class"""

    fields: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Comma-delimited fields to return"""


class PatchLmsClassResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    lms_class: NotRequired[shared_lmsclass.LmsClassTypedDict]
    r"""Successful"""


class PatchLmsClassResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    lms_class: Optional[shared_lmsclass.LmsClass] = None
    r"""Successful"""
