"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk.models.shared import taskproject as shared_taskproject
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)


class PatchTaskProjectRequestTypedDict(TypedDict):
    task_project: shared_taskproject.TaskProjectTypedDict
    connection_id: str
    r"""ID of the connection"""
    id: str
    r"""ID of the Project"""
    fields: NotRequired[List[str]]
    r"""Comma-delimited fields to return"""


class PatchTaskProjectRequest(BaseModel):
    task_project: Annotated[
        shared_taskproject.TaskProject,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    connection_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the connection"""

    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the Project"""

    fields: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Comma-delimited fields to return"""


class PatchTaskProjectResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    task_project: NotRequired[shared_taskproject.TaskProjectTypedDict]
    r"""Successful"""


class PatchTaskProjectResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    task_project: Optional[shared_taskproject.TaskProject] = None
    r"""Successful"""
