"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk.models.shared import (
    accountingtransaction as shared_accountingtransaction,
)
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)


class UpdateAccountingTransactionRequestTypedDict(TypedDict):
    accounting_transaction: shared_accountingtransaction.AccountingTransactionTypedDict
    connection_id: str
    r"""ID of the connection"""
    id: str
    r"""ID of the Transaction"""
    fields: NotRequired[List[str]]
    r"""Comma-delimited fields to return"""


class UpdateAccountingTransactionRequest(BaseModel):
    accounting_transaction: Annotated[
        shared_accountingtransaction.AccountingTransaction,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    connection_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the connection"""

    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the Transaction"""

    fields: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Comma-delimited fields to return"""


class UpdateAccountingTransactionResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    accounting_transaction: NotRequired[
        shared_accountingtransaction.AccountingTransactionTypedDict
    ]
    r"""Successful"""


class UpdateAccountingTransactionResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    accounting_transaction: Optional[
        shared_accountingtransaction.AccountingTransaction
    ] = None
    r"""Successful"""
