"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk.models.shared import marketingmember as shared_marketingmember
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)


class UpdateMartechMemberRequestTypedDict(TypedDict):
    marketing_member: shared_marketingmember.MarketingMemberTypedDict
    r"""A member represents a person"""
    connection_id: str
    r"""ID of the connection"""
    id: str
    r"""ID of the Member"""
    fields: NotRequired[List[str]]
    r"""Comma-delimited fields to return"""


class UpdateMartechMemberRequest(BaseModel):
    marketing_member: Annotated[
        shared_marketingmember.MarketingMember,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
    r"""A member represents a person"""

    connection_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the connection"""

    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the Member"""

    fields: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Comma-delimited fields to return"""


class UpdateMartechMemberResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    marketing_member: NotRequired[shared_marketingmember.MarketingMemberTypedDict]
    r"""Successful"""


class UpdateMartechMemberResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    marketing_member: Optional[shared_marketingmember.MarketingMember] = None
    r"""Successful"""
