"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .commerceitemmedia import CommerceItemMedia, CommerceItemMediaTypedDict
from .commercemetadata import CommerceMetadata, CommerceMetadataTypedDict
from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict
from unified_python_sdk.types import BaseModel


class CommerceCollectionType(str, Enum):
    COLLECTION = "COLLECTION"
    SAVED_SEARCH = "SAVED_SEARCH"
    CATEGORY = "CATEGORY"


class CommerceCollectionTypedDict(TypedDict):
    r"""A collection of items/products/services"""

    name: str
    created_at: NotRequired[datetime]
    description: NotRequired[str]
    id: NotRequired[str]
    is_active: NotRequired[bool]
    is_featured: NotRequired[bool]
    is_visible: NotRequired[bool]
    media: NotRequired[List[CommerceItemMediaTypedDict]]
    metadata: NotRequired[List[CommerceMetadataTypedDict]]
    parent_id: NotRequired[str]
    public_description: NotRequired[str]
    public_name: NotRequired[str]
    raw: NotRequired[Dict[str, Any]]
    tags: NotRequired[List[str]]
    type: NotRequired[CommerceCollectionType]
    updated_at: NotRequired[datetime]


class CommerceCollection(BaseModel):
    r"""A collection of items/products/services"""

    name: str

    created_at: Optional[datetime] = None

    description: Optional[str] = None

    id: Optional[str] = None

    is_active: Optional[bool] = None

    is_featured: Optional[bool] = None

    is_visible: Optional[bool] = None

    media: Optional[List[CommerceItemMedia]] = None

    metadata: Optional[List[CommerceMetadata]] = None

    parent_id: Optional[str] = None

    public_description: Optional[str] = None

    public_name: Optional[str] = None

    raw: Optional[Dict[str, Any]] = None

    tags: Optional[List[str]] = None

    type: Optional[CommerceCollectionType] = None

    updated_at: Optional[datetime] = None
