"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .integrationsupport import IntegrationSupport, IntegrationSupportTypedDict
from .property_integration_categories import PropertyIntegrationCategories
from datetime import datetime
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict
from unified_python_sdk.types import BaseModel


class IntegrationTypedDict(TypedDict):
    r"""Informational object for supported integrations."""

    categories: List[PropertyIntegrationCategories]
    r"""The categories of support solutions that this integration has"""
    name: str
    type: str
    active_healthy_connections: NotRequired[float]
    api: NotRequired[Dict[str, Any]]
    api_docs_url: NotRequired[str]
    beta: NotRequired[bool]
    color: NotRequired[str]
    created_at: NotRequired[str]
    description: NotRequired[str]
    fa_icon: NotRequired[str]
    featured: NotRequired[bool]
    in_progress: NotRequired[bool]
    is_active: NotRequired[bool]
    logo_url: NotRequired[str]
    popularity: NotRequired[float]
    rate_limit_description: NotRequired[str]
    support: NotRequired[Dict[str, IntegrationSupportTypedDict]]
    tested_at: NotRequired[datetime]
    text_color: NotRequired[str]
    token_instructions: NotRequired[List[str]]
    r"""instructions for the user on how to find the token/key"""
    token_names: NotRequired[List[str]]
    r"""if auth_types = 'token'"""
    updated_at: NotRequired[str]
    web_url: NotRequired[str]


class Integration(BaseModel):
    r"""Informational object for supported integrations."""

    categories: List[PropertyIntegrationCategories]
    r"""The categories of support solutions that this integration has"""

    name: str

    type: str

    active_healthy_connections: Optional[float] = None

    api: Optional[Dict[str, Any]] = None

    api_docs_url: Optional[str] = None

    beta: Optional[bool] = None

    color: Optional[str] = None

    created_at: Optional[str] = None

    description: Optional[str] = None

    fa_icon: Optional[str] = None

    featured: Optional[bool] = None

    in_progress: Optional[bool] = None

    is_active: Optional[bool] = None

    logo_url: Optional[str] = None

    popularity: Optional[float] = None

    rate_limit_description: Optional[str] = None

    support: Optional[Dict[str, IntegrationSupport]] = None

    tested_at: Optional[datetime] = None

    text_color: Optional[str] = None

    token_instructions: Optional[List[str]] = None
    r"""instructions for the user on how to find the token/key"""

    token_names: Optional[List[str]] = None
    r"""if auth_types = 'token'"""

    updated_at: Optional[str] = None

    web_url: Optional[str] = None
