"""
Default values and metadata for EPREM simulation parameters.

DO NOT EDIT THIS FILE. It was created via the `generate` feature of this module. Run `python </path/to/this/module> generate -h` for more information.
"""


BASETYPES_H = {
    'AU': {
        'value': 14959787070000.0,
        'info': 'One astronomical unit.',
        'unit': 'cm',
        'type': float,
    },
    'BADINT': {
        'value': 2147483647,
        'info': 'A bad (invalid) integer value.',
        'unit': None,
        'type': int,
    },
    'BADVALUE': {
        'value': 1e+33,
        'info': 'A bad (invalid) float value.',
        'unit': None,
        'type': float,
    },
    'C': {
        'value': 29979245800.0,
        'info': 'The speed of light.',
        'unit': 'cm/s',
        'type': float,
    },
    'DAY': {
        'value': 0.0057755183314369945,
        'info': 'The conversion from EPREM time steps to Julian days.',
        'unit': 'day',
        'type': float,
    },
    'EV': {
        'value': 1.6022e-12,
        'info': 'The conversion from eVs to ergs.',
        'unit': 'erg/eV',
        'type': float,
    },
    'F': {
        'value': 0,
        'info': 'False',
        'unit': None,
        'type': int,
    },
    'FCONVERT': {
        'value': 1.2379901472361203e-12,
        'info': 'The conversion from distribution to flux.',
        'unit': '1',
        'type': float,
    },
    'GEV': {
        'value': 0.0016022,
        'info': 'The conversion from GeVs to ergs.',
        'unit': 'erg/GeV',
        'type': float,
    },
    'MAX_STRING_SIZE': {
        'value': 240,
        'info': '',
        'unit': None,
        'type': int,
    },
    'MEV': {
        'value': 1.6022e-06,
        'info': 'The conversion from MeVs to ergs.',
        'unit': 'erg/MeV',
        'type': float,
    },
    'MHD_B_NORM': {
        'value': 0.038771870111656996,
        'info': 'The normalization for magnetic fields.',
        'unit': '1',
        'type': float,
    },
    'MHD_DEFAULT': {
        'value': 0,
        'info': 'Use the default MHD solver.',
        'unit': None,
        'type': int,
    },
    'MHD_DENSITY_NORM': {
        'value': 1.0,
        'info': 'The normalization factor for density.',
        'unit': '1',
        'type': float,
    },
    'MP': {
        'value': 1.6726e-24,
        'info': 'The proton mass.',
        'unit': 'g',
        'type': float,
    },
    'MZERO': {
        'value': 0.9382461065754594,
        'info': 'The proton rest-mass energy in GeV.',
        'unit': 'GeV',
        'type': float,
    },
    'OM': {
        'value': 185327.43617160583,
        'info': 'The normalization for ion gyrofrequency.',
        'unit': '1',
        'type': float,
    },
    'PI': {
        'value': 3.141592653589793,
        'info': 'The value of π.',
        'unit': None,
        'type': float,
    },
    'Q': {
        'value': 4.80320425e-10,
        'info': 'The proton charge.',
        'unit': 'statC',
        'type': float,
    },
    'RSAU': {
        'value': 0.0046524726370988385,
        'info': 'The number of solar radii per au.',
        'unit': '1',
        'type': float,
    },
    'RSUN': {
        'value': 69600000000.0,
        'info': 'The value of the solar radius.',
        'unit': 'cm',
        'type': float,
    },
    'T': {
        'value': 1,
        'info': 'True',
        'unit': None,
        'type': int,
    },
    'TAU': {
        'value': 499.0047838361564,
        'info': 'The canonical EPREM time scale.',
        'unit': 's',
        'type': float,
    },
    'THRESH': {
        'value': 0.025,
        'info': 'The threshold for perpendicular diffusion.',
        'unit': '1',
        'type': float,
    },
    'TWO_PI': {
        'value': 6.283185307179586,
        'info': 'The value of 2π.',
        'unit': None,
        'type': float,
    },
    'VERYSMALL': {
        'value': 1e-33,
        'info': 'A very small value.',
        'unit': None,
        'type': float,
    },
    'VOLT': {
        'value': 0.0033333,
        'info': 'The conversion from volts to statvolts.',
        'unit': '1',
        'type': float,
    },
}
"""Values and metadata for constants defined in `baseTypes.h`.

Each entry contains the numerical value (`'value'`), a brief description
(`'info'`), the metric unit (`'unit'`), and the built-in type (`'type'`) of each
defined constant.

Notes
-----
* A `'unit'` of `None` implies a non-physical parameter (e.g., a boolean flag or
  system path), whereas a `'unit'` of `'1'` implies a unitless physical
  parameter.

See Also
--------
`~runtime.Defaults`
    A mapping from parameter to default value, with value converted to its
    equivalent built-in type.

`~runtime.Interface`
    An aliased mapping from parameter to user-provided value, if available, or
    default value.
"""


CONFIGURATION_C = {
    'FailModeDump': {
        'type': int,
        'default': '1',
        'minimum': '0',
        'maximum': '1',
        'aliases': [],
        'unit': None,
    },
    'adiabaticChangeAlg': {
        'type': int,
        'default': '1',
        'minimum': '1',
        'maximum': '3',
        'aliases': [],
        'unit': None,
    },
    'adiabaticFocusAlg': {
        'type': int,
        'default': '1',
        'minimum': '1',
        'maximum': '3',
        'aliases': [],
        'unit': None,
    },
    'aziSunStart': {
        'type': float,
        'default': '0.0',
        'minimum': '0.0',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': 'rad',
    },
    'boundaryFunctAmplitude': {
        'type': float,
        'default': '1.0',
        'minimum': 'VERYSMALL',
        'maximum': 'BADVALUE',
        'aliases': ['J0'],
        'unit': '1 / (cm^2 * s * sr * (MeV/nuc))',
    },
    'boundaryFunctBeta': {
        'type': float,
        'default': '1.7',
        'minimum': '0.0',
        'maximum': 'BADVALUE',
        'aliases': ['beta'],
        'unit': '1',
    },
    'boundaryFunctEcutoff': {
        'type': float,
        'default': '1.0',
        'minimum': '0.0',
        'maximum': 'BADVALUE',
        'aliases': ['E0'],
        'unit': 'MeV',
    },
    'boundaryFunctGamma': {
        'type': float,
        'default': '2.0',
        'minimum': '0.0',
        'maximum': 'BADVALUE',
        'aliases': ['gamma'],
        'unit': '1',
    },
    'boundaryFunctXi': {
        'type': float,
        'default': '1.0',
        'minimum': '0.0',
        'maximum': 'BADVALUE',
        'aliases': ['xi'],
        'unit': '1',
    },
    'boundaryFunctionInitDomain': {
        'type': int,
        'default': '1',
        'minimum': '0',
        'maximum': '1',
        'aliases': [],
        'unit': None,
    },
    'charge': {
        'type': list,
        'default': '[1.0]',
        'aliases': [],
        'unit': 'e',
    },
    'checkSeedPopulation': {
        'type': int,
        'default': '1',
        'minimum': '0',
        'maximum': '1',
        'aliases': [],
        'unit': None,
    },
    'dsh_hel_min': {
        'type': float,
        'default': '2.5e-4',
        'minimum': 'VERYSMALL',
        'maximum': 'BADVALUE',
    },
    'dsh_min': {
        'type': float,
        'default': '5.0e-5',
        'minimum': 'VERYSMALL',
        'maximum': 'BADVALUE',
    },
    'dumpFreq': {
        'type': int,
        'default': '1',
        'minimum': '0',
        'maximum': '1000000',
        'aliases': [],
        'unit': None,
    },
    'dumpOnAbort': {
        'type': int,
        'default': '0',
        'minimum': '0',
        'maximum': '1',
    },
    'eMax': {
        'type': float,
        'default': '1000.0',
        'minimum': 'config.eMin',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': 'MeV/nuc',
    },
    'eMin': {
        'type': float,
        'default': '1.0',
        'minimum': 'VERYSMALL',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': 'MeV/nuc',
    },
    'epCalcStartTime': {
        'type': float,
        'default': 'config.simStartTime',
        'minimum': '0.0',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': 'day',
    },
    'epEquilibriumCalcDuration': {
        'type': float,
        'default': '0.0',
        'minimum': '0.0',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': 'day',
    },
    'epremDomain': {
        'type': int,
        'default': '0',
        'minimum': '0',
        'maximum': '1',
        'aliases': [],
        'unit': None,
    },
    'epremDomainOutputTime': {
        'type': float,
        'default': '0.0',
        'minimum': '0.0',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': 'day',
    },
    'fieldAligned': {
        'type': int,
        'default': '0',
        'minimum': '0',
        'maximum': '1',
    },
    'flowMag': {
        'type': float,
        'default': '400.0e5',
        'minimum': 'VERYSMALL',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': 'km/s',
    },
    'fluxLimiter': {
        'type': int,
        'default': '1',
        'minimum': '0',
        'maximum': '1',
        'aliases': [],
        'unit': None,
    },
    'focusingLimit': {
        'type': float,
        'default': '1.0',
        'minimum': '0.0',
        'maximum': '1.0',
    },
    'gammaEhigh': {
        'type': float,
        'default': '0.0',
        'minimum': '-1.0 * BADVALUE',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': '1',
    },
    'gammaElow': {
        'type': float,
        'default': '0.0',
        'minimum': '-1.0 * BADVALUE',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': '1',
    },
    'idealShock': {
        'type': int,
        'default': '0',
        'minimum': '0',
        'maximum': '1',
        'aliases': [],
        'unit': None,
    },
    'idealShockFalloff': {
        'type': float,
        'default': '0.0',
        'minimum': '0.0',
        'maximum': 'BADVALUE',
    },
    'idealShockInitTime': {
        'type': float,
        'default': 'config.simStartTime',
        'minimum': 'config.simStartTime',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': 'day',
    },
    'idealShockJump': {
        'type': float,
        'default': '4.0',
        'minimum': 'VERYSMALL',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': '1',
    },
    'idealShockPhi': {
        'type': float,
        'default': '0.0',
        'minimum': '0.0',
        'maximum': '2.0 * PI',
        'aliases': [],
        'unit': 'rad',
    },
    'idealShockScaleLength': {
        'type': float,
        'default': '0.0046491',
        'minimum': 'VERYSMALL',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': 'au',
    },
    'idealShockSharpness': {
        'type': float,
        'default': '1.0',
        'minimum': 'VERYSMALL',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': '1',
    },
    'idealShockSpeed': {
        'type': float,
        'default': '1500e5',
        'minimum': 'VERYSMALL',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': 'km/s',
    },
    'idealShockTheta': {
        'type': float,
        'default': '1.570796',
        'minimum': '0.0',
        'maximum': 'PI',
        'aliases': [],
        'unit': 'rad',
    },
    'idealShockWidth': {
        'type': float,
        'default': '0.0',
        'minimum': '0.0',
        'maximum': 'PI',
        'aliases': [],
        'unit': 'rad',
    },
    'idw_p': {
        'type': float,
        'default': '3.0',
        'minimum': 'VERYSMALL',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': '1',
    },
    'kperxkpar': {
        'type': float,
        'default': '0.01',
        'minimum': 'VERYSMALL',
        'maximum': 'BADVALUE',
        'aliases': ['kper_kpar', 'kper/kpar', 'kper / kpar'],
        'unit': '1',
    },
    'lamo': {
        'type': float,
        'default': '1.0',
        'minimum': 'VERYSMALL',
        'maximum': 'BADVALUE',
        'aliases': ['lam0', 'lambda0'],
        'unit': 'au',
    },
    'mass': {
        'type': list,
        'default': '[1.0]',
        'aliases': [],
        'unit': 'nucleon',
    },
    'mfpRadialPower': {
        'type': float,
        'default': '2.0',
        'minimum': '-1.0 * BADVALUE',
        'maximum': 'BADVALUE',
        'aliases': ['mfp_radial_power'],
        'unit': '1',
    },
    'mhdBAu': {
        'type': float,
        'default': '1.60e-5',
        'minimum': 'VERYSMALL',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': 'G',
    },
    'mhdDensityAu': {
        'type': float,
        'default': '8.30',
        'minimum': 'VERYSMALL',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': 'cm^-3',
    },
    'minInjectionEnergy': {
        'type': float,
        'default': '0.01',
        'minimum': 'VERYSMALL',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': 'MeV',
    },
    'numColumnsPerFace': {
        'type': int,
        'default': '2',
        'minimum': '1',
        'maximum': 'BADINT',
        'aliases': [],
        'unit': None,
    },
    'numEnergySteps': {
        'type': int,
        'default': '20',
        'minimum': '2',
        'maximum': 'BADINT',
        'aliases': [],
        'unit': None,
    },
    'numEpSteps': {
        'type': int,
        'default': '30',
        'minimum': '1',
        'maximum': 'BADINT',
        'aliases': [],
        'unit': None,
    },
    'numMuSteps': {
        'type': int,
        'default': '20',
        'minimum': '2',
        'maximum': 'BADINT',
        'aliases': [],
        'unit': None,
    },
    'numNodesPerStream': {
        'type': int,
        'default': 'N_PROCS',
        'minimum': 'N_PROCS',
        'maximum': 'BADINT',
        'aliases': [],
        'unit': None,
    },
    'numObservers': {
        'type': int,
        'default': '0',
        'minimum': '0',
        'maximum': '1000',
        'aliases': [],
        'unit': '1',
    },
    'numRowsPerFace': {
        'type': int,
        'default': '2',
        'minimum': '1',
        'maximum': 'BADINT',
        'aliases': [],
        'unit': None,
    },
    'numSpecies': {
        'type': int,
        'default': '1',
        'minimum': '0',
        'maximum': '100',
        'aliases': [],
        'unit': None,
    },
    'obsPhi': {
        'type': list,
        'default': '[0]',
        'aliases': [],
        'unit': 'rad',
    },
    'obsR': {
        'type': list,
        'default': '[0]',
        'aliases': [],
        'unit': 'au',
    },
    'obsTheta': {
        'type': list,
        'default': '[0]',
        'aliases': [],
        'unit': 'rad',
    },
    'omegaSun': {
        'type': float,
        'default': '0.001429813',
        'minimum': '0.0',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': 'rad * cm / (au * s)',
    },
    'outputFloat': {
        'type': int,
        'default': '0',
        'minimum': '0',
        'maximum': '1',
        'aliases': [],
        'unit': None,
    },
    'outputRestart': {
        'type': int,
        'default': '0',
        'minimum': '0',
        'maximum': '1000000',
    },
    'parallelFlow': {
        'type': float,
        'default': '0.0',
        'minimum': '0.0',
        'maximum': 'BADVALUE',
    },
    'pointObserverOutput': {
        'type': int,
        'default': '0',
        'minimum': '0',
        'maximum': '1',
        'aliases': [],
        'unit': None,
    },
    'pointObserverOutputTime': {
        'type': float,
        'default': '0.0',
        'minimum': '0.0',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': 'day',
    },
    'preEruptionDuration': {
        'type': float,
        'default': '0.0',
        'minimum': '0.0',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': 'day',
    },
    'rScale': {
        'type': float,
        'default': 'RSAU',
        'minimum': 'VERYSMALL',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': 'au',
    },
    'rigidityPower': {
        'type': float,
        'default': 'third',
        'minimum': 'VERYSMALL',
        'maximum': 'BADVALUE',
        'aliases': ['rigidity_power'],
        'unit': '1',
    },
    'saveRestartFile': {
        'type': int,
        'default': '0',
        'minimum': '0',
        'maximum': '1',
    },
    'seedFunctionTest': {
        'type': int,
        'default': '0',
        'minimum': '0',
        'maximum': '1',
    },
    'shockDetectPercent': {
        'type': float,
        'default': '1.0',
        'minimum': '0.0',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': '1',
    },
    'shockInjectionFactor': {
        'type': float,
        'default': '1.0',
        'minimum': '0.0',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': '1',
    },
    'shockSolver': {
        'type': int,
        'default': '0',
        'minimum': '0',
        'maximum': '1',
        'aliases': [],
        'unit': None,
    },
    'simStartTime': {
        'type': float,
        'default': '0.0',
        'minimum': '0.0',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': 'day',
    },
    'simStopTime': {
        'type': float,
        'default': 'config.simStartTime + config.tDel',
        'minimum': 'config.simStartTime',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': 'day',
    },
    'streamFluxOutput': {
        'type': int,
        'default': '0',
        'minimum': '0',
        'maximum': '1',
        'aliases': [],
        'unit': None,
    },
    'streamFluxOutputTime': {
        'type': float,
        'default': '0.0',
        'minimum': '0.0',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': 'day',
    },
    'subTimeCouple': {
        'type': int,
        'default': '0',
        'minimum': '0',
        'maximum': '1',
        'aliases': [],
        'unit': None,
    },
    'tDel': {
        'type': float,
        'default': '0.01041666666667',
        'minimum': 'VERYSMALL',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': 'day',
    },
    'unifiedOutput': {
        'type': int,
        'default': '1',
        'minimum': '0',
        'maximum': '1',
        'aliases': [],
        'unit': None,
    },
    'unifiedOutputTime': {
        'type': float,
        'default': '0.0',
        'minimum': '0.0',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': 'day',
    },
    'unstructuredDomain': {
        'type': int,
        'default': '0',
        'minimum': '0',
        'maximum': '1',
    },
    'unstructuredDomainOutputTime': {
        'type': float,
        'default': '0.0',
        'minimum': '0.0',
        'maximum': 'BADVALUE',
        'aliases': [],
        'unit': 'day',
    },
    'useAdiabaticChange': {
        'type': int,
        'default': '1',
        'minimum': '0',
        'maximum': '1',
        'aliases': [],
        'unit': None,
    },
    'useAdiabaticFocus': {
        'type': int,
        'default': '1',
        'minimum': '0',
        'maximum': '1',
        'aliases': [],
        'unit': None,
    },
    'useBoundaryFunction': {
        'type': int,
        'default': '1',
        'minimum': '0',
        'maximum': '1',
    },
    'useDrift': {
        'type': int,
        'default': '0',
        'minimum': '0',
        'maximum': '1',
        'aliases': [],
        'unit': None,
    },
    'useEPBoundary': {
        'type': int,
        'default': '1',
        'minimum': '0',
        'maximum': '1',
    },
    'useParallelDiffusion': {
        'type': int,
        'default': '1',
        'minimum': '0',
        'maximum': '1',
        'aliases': [],
        'unit': None,
    },
    'useShellDiffusion': {
        'type': int,
        'default': '0',
        'minimum': '0',
        'maximum': '1',
        'aliases': [],
        'unit': None,
    },
    'useStochastic': {
        'type': int,
        'default': '0',
        'minimum': '0',
        'maximum': '1',
    },
    'warningsFile': {
        'type': str,
        'default': 'warningsXXX.txt',
    },
}
"""Metadata for parameters defined in `configuration.c`.

Each entry contains the default value (`'default'`), the smallest acceptable
value ('`minimum`'), the largest acceptable value ('`maximum`'), as well as the
equivalent built-in type and metric unit of those values (`'type'` and
`'unit'`). Some entries also contain declared aliases for the parameter
('`aliases`').

Notes
-----
* This dictionary stores all values as strings because some values are defined
  with respect to others.
* A `'unit'` of `None` implies a non-physical parameter (e.g., a boolean flag or
  system path), whereas a `'unit'` of `'1'` implies a unitless physical
  parameter.

See Also
--------
`~runtime.Defaults`
    A mapping from parameter to default value, with value converted to its
    equivalent built-in type.

`~runtime.Interface`
    An aliased mapping from parameter to user-provided value, if available, or
    default value.
"""


