# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from asana_preview.api_client import ApiClient


class TaskTemplatesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_task_template(self, task_template_gid, opts, **kwargs):  # noqa: E501
        """Get a task template  # noqa: E501

        Returns the complete task template record for a single task template.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_template(task_template_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_template_gid: Globally unique identifier for the task template. (required)
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: TaskTemplateResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = kwargs.get("_return_http_data_only", True)
        if kwargs.get('async_req'):
            return self.get_task_template_with_http_info(task_template_gid, opts, **kwargs)  # noqa: E501
        else:
            (data) = self.get_task_template_with_http_info(task_template_gid, opts, **kwargs)  # noqa: E501
            return data

    def get_task_template_with_http_info(self, task_template_gid, opts, **kwargs):  # noqa: E501
        """Get a task template  # noqa: E501

        Returns the complete task template record for a single task template.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_template_with_http_info(task_template_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_template_gid: Globally unique identifier for the task template. (required)
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: TaskTemplateResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        all_params = []
        all_params.append('async_req')
        all_params.append('header_params')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_task_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'task_template_gid' is set
        if (task_template_gid is None):
            raise ValueError("Missing the required parameter `task_template_gid` when calling `get_task_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['task_template_gid'] = task_template_gid  # noqa: E501

        query_params = []
        if 'opt_fields' in opts:
            query_params.append(('opt_fields', opts['opt_fields']))  # noqa: E501


        header_params = kwargs.get("header_params", {})

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['personalAccessToken']  # noqa: E501

        return self.api_client.call_api(
            '/task_templates/{task_template_gid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=object,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_task_templates(self, opts, **kwargs):  # noqa: E501
        """Get multiple task templates  # noqa: E501

        Returns the compact task template records for some filtered set of task templates. You must specify a `project`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_templates(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Results per page. The number of objects to return per page. The value must be between 1 and 100.
        :param str offset: Offset token. An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results. 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
        :param str project: The project to filter task templates on.
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: TaskTemplateResponseArray
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = kwargs.get("_return_http_data_only", True)
        if kwargs.get('async_req'):
            return self.get_task_templates_with_http_info(opts, **kwargs)  # noqa: E501
        else:
            (data) = self.get_task_templates_with_http_info(opts, **kwargs)  # noqa: E501
            return data

    def get_task_templates_with_http_info(self, opts, **kwargs):  # noqa: E501
        """Get multiple task templates  # noqa: E501

        Returns the compact task template records for some filtered set of task templates. You must specify a `project`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_templates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Results per page. The number of objects to return per page. The value must be between 1 and 100.
        :param str offset: Offset token. An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results. 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
        :param str project: The project to filter task templates on.
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: TaskTemplateResponseArray
                 If the method is called asynchronously,
                 returns the request thread.
        """
        all_params = []
        all_params.append('async_req')
        all_params.append('header_params')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_task_templates" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in opts:
            query_params.append(('limit', opts['limit']))  # noqa: E501
        if 'offset' in opts:
            query_params.append(('offset', opts['offset']))  # noqa: E501
        if 'project' in opts:
            query_params.append(('project', opts['project']))  # noqa: E501
        if 'opt_fields' in opts:
            query_params.append(('opt_fields', opts['opt_fields']))  # noqa: E501


        header_params = kwargs.get("header_params", {})

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['personalAccessToken']  # noqa: E501

        return self.api_client.call_api(
            '/task_templates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=object,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def instantiate_task(self, task_template_gid, opts, **kwargs):  # noqa: E501
        """Instantiate a task from a task template  # noqa: E501

        Creates and returns a job that will asynchronously handle the task instantiation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.instantiate_task(task_template_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_template_gid: Globally unique identifier for the task template. (required)
        :param dict body: Describes the inputs used for instantiating a task - the task's name.
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: JobResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = kwargs.get("_return_http_data_only", True)
        if kwargs.get('async_req'):
            return self.instantiate_task_with_http_info(task_template_gid, opts, **kwargs)  # noqa: E501
        else:
            (data) = self.instantiate_task_with_http_info(task_template_gid, opts, **kwargs)  # noqa: E501
            return data

    def instantiate_task_with_http_info(self, task_template_gid, opts, **kwargs):  # noqa: E501
        """Instantiate a task from a task template  # noqa: E501

        Creates and returns a job that will asynchronously handle the task instantiation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.instantiate_task_with_http_info(task_template_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_template_gid: Globally unique identifier for the task template. (required)
        :param dict body: Describes the inputs used for instantiating a task - the task's name.
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: JobResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        all_params = []
        all_params.append('async_req')
        all_params.append('header_params')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method instantiate_task" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'task_template_gid' is set
        if (task_template_gid is None):
            raise ValueError("Missing the required parameter `task_template_gid` when calling `instantiate_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['task_template_gid'] = task_template_gid  # noqa: E501

        query_params = []
        if 'opt_fields' in opts:
            query_params.append(('opt_fields', opts['opt_fields']))  # noqa: E501


        header_params = kwargs.get("header_params", {})

        form_params = []
        local_var_files = {}

        body_params = opts['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['personalAccessToken']  # noqa: E501

        return self.api_client.call_api(
            '/task_templates/{task_template_gid}/instantiateTask', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=object,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
