/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.types;

import com.datapps.linkoopdb.jdbc.SessionInterface;
import com.datapps.linkoopdb.jdbc.error.Error;
import com.datapps.linkoopdb.jdbc.impl.JDBCBlobClient;
import com.datapps.linkoopdb.jdbc.types.BinaryData;
import com.datapps.linkoopdb.jdbc.types.BinaryType;
import com.datapps.linkoopdb.jdbc.types.BlobData;
import com.datapps.linkoopdb.jdbc.types.BlobDataID;
import com.datapps.linkoopdb.jdbc.types.Type;
import java.sql.Blob;

public final class BlobType
extends BinaryType {
    public static final long maxBlobPrecision = 0x10000000000L;
    public static final int defaultBlobSize = 0x40000000;
    public static final int defaultShortBlobSize = 0x1000000;

    public BlobType(long precision) {
        super(30, precision);
    }

    @Override
    public int displaySize() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    @Override
    public int getJDBCTypeCode() {
        return 2004;
    }

    @Override
    public Class getJDBCClass() {
        return Blob.class;
    }

    @Override
    public String getJDBCClassName() {
        return "java.sql.Blob";
    }

    @Override
    public String getNameString() {
        return "BLOB";
    }

    @Override
    public String getFullNameString() {
        return "BINARY LARGE OBJECT";
    }

    @Override
    public String getDefinition() {
        long factor = this.precision;
        String multiplier = null;
        if (this.precision % 0x40000000L == 0L) {
            factor = this.precision / 0x40000000L;
            multiplier = "G";
        } else if (this.precision % 0x100000L == 0L) {
            factor = this.precision / 0x100000L;
            multiplier = "M";
        } else if (this.precision % 1024L == 0L) {
            factor = this.precision / 1024L;
            multiplier = "K";
        }
        StringBuffer sb = new StringBuffer(16);
        sb.append(this.getNameString());
        sb.append('(');
        sb.append(factor);
        if (multiplier != null) {
            sb.append(multiplier);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public boolean isBinaryType() {
        return true;
    }

    @Override
    public boolean isLobType() {
        return true;
    }

    @Override
    public boolean acceptsPrecision() {
        return true;
    }

    @Override
    public long getMaxPrecision() {
        return 0x10000000000L;
    }

    @Override
    public boolean requiresPrecision() {
        return false;
    }

    @Override
    public int compare(SessionInterface session, Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return typeHelper.compare(this, session, a, b);
    }

    @Override
    public Object convertToTypeLimits(SessionInterface session, Object a) {
        return a;
    }

    @Override
    public Object castToType(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return null;
        }
        if (otherType.isCharacterType()) {
            String str = (String)a;
            byte[] b = str.getBytes();
            BlobDataID blob = session.createBlob(b.length);
            blob.setBytes(session, 0L, b, 0, b.length);
            return blob;
        }
        if (otherType.typeCode == 30) {
            BlobData b = (BlobData)a;
            long blobLength = b.length(session);
            if (blobLength > this.precision) {
                blobLength = this.precision;
                session.addWarning(Error.error(1004));
                b = b.getBlob(session, 0L, blobLength);
                return b;
            }
            return a;
        }
        if (otherType.typeCode == 60 || otherType.typeCode == 61) {
            BlobData b = (BlobData)a;
            long blobLength = b.length(session);
            if (blobLength > this.precision) {
                blobLength = this.precision;
                session.addWarning(Error.error(1004));
            }
            BlobDataID blob = session.createBlob(b.length(session));
            blob.setBytes(session, 0L, b.getBytes(), 0, (int)blobLength);
            return blob;
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        BlobData b = null;
        if (a == null) {
            return null;
        }
        if (otherType.typeCode == 30) {
            b = (BlobData)a;
            long blobLength = b.length(session);
            if (blobLength > this.precision) {
                throw Error.error(3401);
            }
            return a;
        }
        if (otherType.typeCode == 40) {
            a = Type.SQL_VARCHAR.convertToType(session, a, otherType);
            otherType = Type.SQL_VARCHAR;
        }
        if (otherType.typeCode == 12 || otherType.typeCode == 1) {
            a = session.getScanner().convertToBinary((String)a, false);
            otherType = Type.SQL_VARBINARY;
        }
        if (otherType.typeCode == 60 || otherType.typeCode == 61) {
            b = (BlobData)a;
            long blobLength = b.length(session);
            if (blobLength > this.precision) {
                throw Error.error(3401);
            }
            BlobDataID blob = session.createBlob(b.length(session));
            blob.setBytes(session, 0L, b.getBytes());
            return blob;
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof JDBCBlobClient) {
            return ((JDBCBlobClient)a).getBlob();
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertSQLToJava(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof BlobDataID) {
            BlobDataID blob = (BlobDataID)a;
            return new JDBCBlobClient(session, blob);
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertToDefaultType(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof byte[]) {
            return new BinaryData((byte[])a, false);
        }
        throw Error.error(5561);
    }

    @Override
    public String convertToString(Object a) {
        if (a == null) {
            return null;
        }
        return Long.toString(((BlobData)a).getId());
    }

    @Override
    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        return this.convertToString(a);
    }

    @Override
    public Object convertDbToWorker(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof String) {
            return ((String)a).getBytes();
        }
        return Long.toString(((BlobDataID)a).getId()).getBytes();
    }

    @Override
    public Object convertWorkerToDb(SessionInterface session, Object a, Type type) {
        if (a == null) {
            return null;
        }
        byte[] bytes = (byte[])a;
        BlobDataID blobDataID = session.createBlob(bytes.length);
        blobDataID.setBytes(session, 0L, bytes);
        return blobDataID;
    }
}

