# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCiscoLoggingFeatureTemplateResult',
    'AwaitableGetCiscoLoggingFeatureTemplateResult',
    'get_cisco_logging_feature_template',
    'get_cisco_logging_feature_template_output',
]

@pulumi.output_type
class GetCiscoLoggingFeatureTemplateResult:
    """
    A collection of values returned by getCiscoLoggingFeatureTemplate.
    """
    def __init__(__self__, description=None, device_types=None, disk_logging=None, disk_logging_variable=None, id=None, ipv4_servers=None, ipv6_servers=None, log_rotations=None, log_rotations_variable=None, max_size=None, max_size_variable=None, name=None, template_type=None, tls_profiles=None, version=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device_types and not isinstance(device_types, list):
            raise TypeError("Expected argument 'device_types' to be a list")
        pulumi.set(__self__, "device_types", device_types)
        if disk_logging and not isinstance(disk_logging, bool):
            raise TypeError("Expected argument 'disk_logging' to be a bool")
        pulumi.set(__self__, "disk_logging", disk_logging)
        if disk_logging_variable and not isinstance(disk_logging_variable, str):
            raise TypeError("Expected argument 'disk_logging_variable' to be a str")
        pulumi.set(__self__, "disk_logging_variable", disk_logging_variable)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipv4_servers and not isinstance(ipv4_servers, list):
            raise TypeError("Expected argument 'ipv4_servers' to be a list")
        pulumi.set(__self__, "ipv4_servers", ipv4_servers)
        if ipv6_servers and not isinstance(ipv6_servers, list):
            raise TypeError("Expected argument 'ipv6_servers' to be a list")
        pulumi.set(__self__, "ipv6_servers", ipv6_servers)
        if log_rotations and not isinstance(log_rotations, int):
            raise TypeError("Expected argument 'log_rotations' to be a int")
        pulumi.set(__self__, "log_rotations", log_rotations)
        if log_rotations_variable and not isinstance(log_rotations_variable, str):
            raise TypeError("Expected argument 'log_rotations_variable' to be a str")
        pulumi.set(__self__, "log_rotations_variable", log_rotations_variable)
        if max_size and not isinstance(max_size, int):
            raise TypeError("Expected argument 'max_size' to be a int")
        pulumi.set(__self__, "max_size", max_size)
        if max_size_variable and not isinstance(max_size_variable, str):
            raise TypeError("Expected argument 'max_size_variable' to be a str")
        pulumi.set(__self__, "max_size_variable", max_size_variable)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if template_type and not isinstance(template_type, str):
            raise TypeError("Expected argument 'template_type' to be a str")
        pulumi.set(__self__, "template_type", template_type)
        if tls_profiles and not isinstance(tls_profiles, list):
            raise TypeError("Expected argument 'tls_profiles' to be a list")
        pulumi.set(__self__, "tls_profiles", tls_profiles)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Sequence[_builtins.str]:
        """
        List of supported device types
        """
        return pulumi.get(self, "device_types")

    @_builtins.property
    @pulumi.getter(name="diskLogging")
    def disk_logging(self) -> _builtins.bool:
        """
        Enable logging to local disk
        """
        return pulumi.get(self, "disk_logging")

    @_builtins.property
    @pulumi.getter(name="diskLoggingVariable")
    def disk_logging_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "disk_logging_variable")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the feature template
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipv4Servers")
    def ipv4_servers(self) -> Sequence['outputs.GetCiscoLoggingFeatureTemplateIpv4ServerResult']:
        """
        Enable logging to remote server
        """
        return pulumi.get(self, "ipv4_servers")

    @_builtins.property
    @pulumi.getter(name="ipv6Servers")
    def ipv6_servers(self) -> Sequence['outputs.GetCiscoLoggingFeatureTemplateIpv6ServerResult']:
        """
        Enable logging to remote IPv6 server
        """
        return pulumi.get(self, "ipv6_servers")

    @_builtins.property
    @pulumi.getter(name="logRotations")
    def log_rotations(self) -> _builtins.int:
        """
        Set number of syslog files to create before discarding oldest files
        """
        return pulumi.get(self, "log_rotations")

    @_builtins.property
    @pulumi.getter(name="logRotationsVariable")
    def log_rotations_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "log_rotations_variable")

    @_builtins.property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> _builtins.int:
        """
        Set maximum size of file before it is rotated
        """
        return pulumi.get(self, "max_size")

    @_builtins.property
    @pulumi.getter(name="maxSizeVariable")
    def max_size_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "max_size_variable")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="templateType")
    def template_type(self) -> _builtins.str:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @_builtins.property
    @pulumi.getter(name="tlsProfiles")
    def tls_profiles(self) -> Sequence['outputs.GetCiscoLoggingFeatureTemplateTlsProfileResult']:
        """
        Configure a TLS profile
        """
        return pulumi.get(self, "tls_profiles")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.int:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")


class AwaitableGetCiscoLoggingFeatureTemplateResult(GetCiscoLoggingFeatureTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCiscoLoggingFeatureTemplateResult(
            description=self.description,
            device_types=self.device_types,
            disk_logging=self.disk_logging,
            disk_logging_variable=self.disk_logging_variable,
            id=self.id,
            ipv4_servers=self.ipv4_servers,
            ipv6_servers=self.ipv6_servers,
            log_rotations=self.log_rotations,
            log_rotations_variable=self.log_rotations_variable,
            max_size=self.max_size,
            max_size_variable=self.max_size_variable,
            name=self.name,
            template_type=self.template_type,
            tls_profiles=self.tls_profiles,
            version=self.version)


def get_cisco_logging_feature_template(id: Optional[_builtins.str] = None,
                                       name: Optional[_builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCiscoLoggingFeatureTemplateResult:
    """
    This data source can read the Cisco Logging feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_cisco_logging_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param _builtins.str id: The id of the feature template
    :param _builtins.str name: The name of the feature template
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getCiscoLoggingFeatureTemplate:getCiscoLoggingFeatureTemplate', __args__, opts=opts, typ=GetCiscoLoggingFeatureTemplateResult).value

    return AwaitableGetCiscoLoggingFeatureTemplateResult(
        description=pulumi.get(__ret__, 'description'),
        device_types=pulumi.get(__ret__, 'device_types'),
        disk_logging=pulumi.get(__ret__, 'disk_logging'),
        disk_logging_variable=pulumi.get(__ret__, 'disk_logging_variable'),
        id=pulumi.get(__ret__, 'id'),
        ipv4_servers=pulumi.get(__ret__, 'ipv4_servers'),
        ipv6_servers=pulumi.get(__ret__, 'ipv6_servers'),
        log_rotations=pulumi.get(__ret__, 'log_rotations'),
        log_rotations_variable=pulumi.get(__ret__, 'log_rotations_variable'),
        max_size=pulumi.get(__ret__, 'max_size'),
        max_size_variable=pulumi.get(__ret__, 'max_size_variable'),
        name=pulumi.get(__ret__, 'name'),
        template_type=pulumi.get(__ret__, 'template_type'),
        tls_profiles=pulumi.get(__ret__, 'tls_profiles'),
        version=pulumi.get(__ret__, 'version'))
def get_cisco_logging_feature_template_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCiscoLoggingFeatureTemplateResult]:
    """
    This data source can read the Cisco Logging feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_cisco_logging_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param _builtins.str id: The id of the feature template
    :param _builtins.str name: The name of the feature template
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sdwan:index/getCiscoLoggingFeatureTemplate:getCiscoLoggingFeatureTemplate', __args__, opts=opts, typ=GetCiscoLoggingFeatureTemplateResult)
    return __ret__.apply(lambda __response__: GetCiscoLoggingFeatureTemplateResult(
        description=pulumi.get(__response__, 'description'),
        device_types=pulumi.get(__response__, 'device_types'),
        disk_logging=pulumi.get(__response__, 'disk_logging'),
        disk_logging_variable=pulumi.get(__response__, 'disk_logging_variable'),
        id=pulumi.get(__response__, 'id'),
        ipv4_servers=pulumi.get(__response__, 'ipv4_servers'),
        ipv6_servers=pulumi.get(__response__, 'ipv6_servers'),
        log_rotations=pulumi.get(__response__, 'log_rotations'),
        log_rotations_variable=pulumi.get(__response__, 'log_rotations_variable'),
        max_size=pulumi.get(__response__, 'max_size'),
        max_size_variable=pulumi.get(__response__, 'max_size_variable'),
        name=pulumi.get(__response__, 'name'),
        template_type=pulumi.get(__response__, 'template_type'),
        tls_profiles=pulumi.get(__response__, 'tls_profiles'),
        version=pulumi.get(__response__, 'version')))
